/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.MemberData;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.exception.ConfigurationWarning;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public final class CGBridgeEndPoint {
    private static final TraceComponent tc = Tr.register((Class)CGBridgeEndPoint.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private CGBridgeConfig cgbConfig;
    private String cellName;
    private String coreGroupName;
    private String coreGroupAccessPointName;
    private InetAddress inetAddress;
    private String memberName;
    private String hostAddress = null;
    private String hostName;
    private int port;
    private boolean onLocalServer = false;
    private String chainName = null;
    private HashMap properties = null;
    private static char[] delimiters = new char[]{',', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '+', '=', '{', '}', '|', '[', ']', '`'};
    private static String MEMBER_NAME_VERSION = "602";
    static final String FIREWALL_PASSIVE_MEMBER = "FWP";
    static final String NOT_FIREWALL_PASSIVE_MEMBER = "NFWP";

    public CGBridgeEndPoint(EndPoint endPoint, CGBridgeConfig cGBridgeConfig, String string, String string2, String string3, String string4) throws ConfigurationWarning {
        this.port = endPoint.getPort();
        if (string4 != null && endPoint.getHost().equals("*")) {
            this.hostName = string4;
            this.debug(" Overriding endpoint hostname & using server scoped hostname: " + this.hostName);
        } else {
            this.hostName = endPoint.getHost();
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("hostName=" + this.hostName));
            }
            InetAddress[] inetAddressArray = InetAddress.getAllByName(this.hostName);
            TreeMap<String, InetAddress> treeMap = new TreeMap<String, InetAddress>();
            for (int i = 0; i < inetAddressArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("inet = " + inetAddressArray[i].getHostAddress()));
                }
                treeMap.put(inetAddressArray[i].getHostAddress(), inetAddressArray[i]);
            }
            Iterator iterator = treeMap.values().iterator();
            while (iterator.hasNext() && this.inetAddress == null) {
                InetAddress inetAddress = (InetAddress)iterator.next();
                if (!inetAddress.isLoopbackAddress()) {
                    this.inetAddress = inetAddress;
                    this.hostAddress = this.inetAddress.getHostAddress();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("disregarding loopback: " + inetAddress.getHostAddress()));
            }
            if (this.inetAddress == null) {
                this.inetAddress = InetAddress.getByName(this.hostName);
                this.hostAddress = this.inetAddress.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConfigurationWarning("Core Group Bridge cannot resolve End Point [" + this.hostName + "] exception:\n" + unknownHostException);
        }
        this.cgbConfig = cGBridgeConfig;
        this.cellName = string;
        this.coreGroupName = string2;
        this.coreGroupAccessPointName = string3;
        this.makeMemberName();
        this.debug(" construction complete [" + this.memberName + "]");
    }

    public CGBridgeEndPoint(MemberData memberData) throws CGBInternalErrorException {
        this.cellName = memberData.cellName;
        this.coreGroupName = memberData.coreGroupName;
        this.coreGroupAccessPointName = memberData.coreGroupAccessPointName;
        this.hostName = memberData.hostName;
        this.memberName = memberData.memberName;
        this.set602Enabled();
        this.setFWPassive(memberData.firewallPassive);
        try {
            this.port = new Integer(memberData.port);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CGBInternalErrorException("Invalid Port" + numberFormatException.getMessage());
        }
    }

    private void makeMemberName() throws ConfigurationWarning {
        this.memberName = this.hostAddress + ":" + this.port;
        if (null != this.properties && null != this.properties.get("CGB_ENABLE_602_FEATURES")) {
            String string = NOT_FIREWALL_PASSIVE_MEMBER;
            if (this.isFW_PASSIVE_MEMBER()) {
                string = FIREWALL_PASSIVE_MEMBER;
            }
            boolean bl = false;
            char c = '?';
            for (int i = 0; i < delimiters.length && !bl; ++i) {
                if (-1 != this.cellName.indexOf(delimiters[i]) || -1 != this.coreGroupName.indexOf(delimiters[i]) || -1 != this.coreGroupAccessPointName.indexOf(delimiters[i]) || -1 != this.hostName.indexOf(delimiters[i])) continue;
                bl = true;
                c = delimiters[i];
            }
            if (bl) {
                this.memberName = c + this.cellName + c + this.coreGroupName + c + this.coreGroupAccessPointName + c + this.hostName + c + this.port + c + string + c + MEMBER_NAME_VERSION;
            } else {
                throw new ConfigurationWarning("CGBridgeEndPoint unable to construct memberName.  All of available delimiters [" + new String(delimiters) + "] are used in cell name [" + this.cellName + "] or coregroup name [" + this.coreGroupName + "] or coreGroupAccessPointName [" + this.coreGroupAccessPointName + "] or hostName [" + this.hostName);
            }
        }
        this.debug("makeMemberName returning [" + this.memberName + "]");
    }

    public static MemberData extractMemberData(String string) throws CGBInternalErrorException {
        MemberData memberData = new MemberData();
        memberData.memberName = string;
        try {
            String string2 = string.substring(0, 1);
            String[] stringArray = string.split(string2);
            if (stringArray.length < 7) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("memberName:" + string + " not formatted properly"));
                }
                return null;
            }
            memberData.cellName = stringArray[1];
            memberData.coreGroupName = stringArray[2];
            memberData.coreGroupAccessPointName = stringArray[3];
            memberData.hostName = stringArray[4];
            memberData.port = stringArray[5];
            memberData.firewallPassive = stringArray[6];
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)(" extractMemberData attempted to process memberName =[" + string + "] and caught exception" + exception));
            throw new CGBInternalErrorException(" extractMemberData attempted to process memberName =[" + string + "] and caught exception" + exception);
        }
        return memberData;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            CGBridgeEndPoint cGBridgeEndPoint = (CGBridgeEndPoint)object;
            return this.memberName.equals(cGBridgeEndPoint.getMemberName());
        }
        return false;
    }

    public int hashCode() {
        return this.memberName.hashCode();
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getCoreGroupName() {
        return this.coreGroupName;
    }

    public String getCoreGroupAccessPointName() {
        return this.coreGroupAccessPointName;
    }

    public boolean isOnLocalServer() {
        return this.onLocalServer;
    }

    void setOnLocalServer(boolean bl, String string) {
        this.onLocalServer = bl;
        this.chainName = string;
    }

    public String getChainName() {
        return this.chainName;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    private void set602Enabled() {
        if (null == this.properties) {
            this.properties = new HashMap(1);
        }
        this.properties.put("CGB_ENABLE_602_FEATURES", "602_ENABLED");
    }

    void setProperties(HashMap hashMap) throws CGBInternalErrorException {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.properties.containsKey(string)) continue;
            this.properties.put(string, hashMap.get(string));
        }
        try {
            this.makeMemberName();
        }
        catch (ConfigurationWarning configurationWarning) {
            throw new CGBInternalErrorException(configurationWarning);
        }
    }

    private void setFWPassive(String string) {
        if (string.equals(FIREWALL_PASSIVE_MEMBER)) {
            if (null == this.properties) {
                this.properties = new HashMap(1);
            }
            this.properties.put("FW_PASSIVE_MEMBER", FIREWALL_PASSIVE_MEMBER);
        }
    }

    public boolean isFW_PASSIVE_MEMBER() {
        if (null != this.properties) {
            return null != this.properties.get("FW_PASSIVE_MEMBER");
        }
        return false;
    }

    private String propertiesToString() {
        String string = " properties=[]";
        if (null != this.properties) {
            string = " properties=[" + CGBridgeConfig.propertiesToString(this.properties) + "]";
        }
        return string;
    }

    public String toString() {
        return "<" + this.memberName + ">isOnLocal=" + this.isOnLocalServer() + this.propertiesToString();
    }

    private void debug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("### CGBridgeEndPoint." + string));
        }
    }
}

