/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.BridgeInterfaceImpl;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.CoreGroupAccessPointImpl;
import com.ibm.ws.cgbridge.config.BridgeInterface;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.MemberData;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.service.EndPointMgr;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;

public class CoreGroupAccessPoint {
    private static final TraceComponent tc = Tr.register((Class)CoreGroupAccessPoint.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private CGBridgeConfig cgbridgeConfig;
    private String name;
    private String coreGroupName;
    private String key;
    private Hashtable htBridgeInterfaces;
    private EndPointMgr endPointMgr;
    private HashMap properties;
    private String endPointName = null;

    public CoreGroupAccessPoint(CGBridgeConfig cGBridgeConfig, CoreGroupAccessPointImpl coreGroupAccessPointImpl, EndPointMgr endPointMgr) throws ConfigurationWarning {
        this.cgbridgeConfig = cGBridgeConfig;
        this.coreGroupName = coreGroupAccessPointImpl.getCoreGroup();
        if (null == this.coreGroupName) {
            throw new ConfigurationWarning("CoreGroupAccessPoint must have coreGroup defined.");
        }
        this.name = coreGroupAccessPointImpl.getName();
        if (null == this.name) {
            throw new ConfigurationWarning("CoreGroupAccessPoint must have name defined.");
        }
        this.key = CoreGroupAccessPoint.makeKey(this.coreGroupName, this.name);
        this.endPointMgr = endPointMgr;
        this.properties = CGBridgeConfig.loadProperties(coreGroupAccessPointImpl.getProperties());
        this.htBridgeInterfaces = new Hashtable();
        this.loadBridgeInterfaces(coreGroupAccessPointImpl.getBridgeInterfaces());
        this.setBridgeInterfaceBridgeEndPoints();
        this.debug("constructor");
    }

    private void loadBridgeInterfaces(EList eList) throws ConfigurationWarning {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            BridgeInterfaceImpl bridgeInterfaceImpl = (BridgeInterfaceImpl)iterator.next();
            BridgeInterface bridgeInterface = new BridgeInterface(this.cgbridgeConfig, this, bridgeInterfaceImpl);
            if (!this.htBridgeInterfaces.containsKey(bridgeInterface.getKey())) {
                this.htBridgeInterfaces.put(bridgeInterface.getKey(), bridgeInterface);
                continue;
            }
            throw new ConfigurationWarning("Multiple bridgeInterfaces with key [" + bridgeInterface.getKey() + "] defined in coreGroupAccessPoint [" + this.key + "].");
        }
    }

    void setBridgeInterfaceBridgeEndPoints() throws ConfigurationWarning {
        BridgeInterface bridgeInterface;
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (null != this.endPointName) {
            object = this.htBridgeInterfaces.elements();
            while (object.hasMoreElements()) {
                bridgeInterface = (BridgeInterface)object.nextElement();
                try {
                    bridgeInterface.setBridgeEndPoint(this.endPointName);
                }
                catch (ConfigurationWarning configurationWarning) {
                    linkedList.add(bridgeInterface.getKey());
                    Tr.error((TraceComponent)tc, (String)"CWRCB0201", (Object)configurationWarning.getMessage());
                    this.debug("setBridgeInterfaceBridgeEndPoint failed for bridgeInterface [" + bridgeInterface.getKey() + "].  This bridgeInterface will be removed from coreGroupaccessPoint [" + this.getKey() + "]");
                }
            }
        } else {
            this.debug("setBridgeInterfaceBridgeEndPoints endPointName==null, this node/server is not an active bridge.");
        }
        if (linkedList.size() > 0) {
            this.debug("setBridgeInterfaceBridgeEndPoint deleting " + linkedList.size() + " bridgeInterfaces from CGAP [" + this.getKey() + "]");
            object = linkedList.iterator();
            while (object.hasNext()) {
                bridgeInterface = (BridgeInterface)this.htBridgeInterfaces.remove((String)object.next());
                if (!bridgeInterface.getNodeName().equals(this.cgbridgeConfig.getNodeName()) || !bridgeInterface.getServerName().equals(this.cgbridgeConfig.getServerName())) continue;
                this.cgbridgeConfig.setEnableInterCoreGroupCommunication(false);
            }
        }
    }

    boolean containsMember(MemberData memberData) {
        boolean bl = false;
        Enumeration enumeration = this.htBridgeInterfaces.elements();
        while (enumeration.hasMoreElements()) {
            BridgeInterface bridgeInterface = (BridgeInterface)enumeration.nextElement();
            String string = bridgeInterface.getBridgeEndPoint().getMemberName();
            if (!memberData.memberName.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.debug("containsMember found [" + memberData.memberName + "] in CGAP [" + this.getName() + "]");
        }
        return bl;
    }

    void handleNewMember(MemberData memberData) throws CGBInternalErrorException {
        this.debug("handleNewMember newMemberData=[" + memberData + "]");
        BridgeInterface bridgeInterface = new BridgeInterface(this.cgbridgeConfig, this, memberData);
        if (this.htBridgeInterfaces.containsKey(bridgeInterface.getKey())) {
            throw new CGBInternalErrorException("Multiple bridgeInterfaces with key [" + bridgeInterface.getKey() + "] defined in coreGroupAccessPoint [" + this.key + "].");
        }
        this.htBridgeInterfaces.put(bridgeInterface.getKey(), bridgeInterface);
    }

    void pushDownProperties(HashMap hashMap) throws CGBInternalErrorException {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.properties.containsKey(string)) continue;
            this.properties.put(string, hashMap.get(string));
        }
        Enumeration enumeration = this.getBridgeInterfaces().elements();
        while (enumeration.hasMoreElements()) {
            ((BridgeInterface)enumeration.nextElement()).pushDownProperties(this.properties);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCoreGroupName() {
        return this.coreGroupName;
    }

    void setEndPointName(String string) {
        this.endPointName = string;
        this.debug("setEndPointName to [" + this.endPointName + "]");
    }

    public String getEndPointName() {
        return this.endPointName;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    EndPointMgr getEndPointMgr() {
        return this.endPointMgr;
    }

    CGBridgeConfig getCGBridgeConfig() {
        return this.cgbridgeConfig;
    }

    public String getKey() {
        return this.key;
    }

    static String makeKey(String string, String string2) {
        return string + ":" + string2;
    }

    public Hashtable getBridgeInterfaces() {
        return this.htBridgeInterfaces;
    }

    private String bridgeInterfacesToSting() {
        String string = "";
        Enumeration enumeration = this.htBridgeInterfaces.elements();
        while (enumeration.hasMoreElements()) {
            BridgeInterface bridgeInterface = (BridgeInterface)enumeration.nextElement();
            string = string + bridgeInterface.toString();
        }
        return string;
    }

    private void debug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("### CoreGroupAccessPoint." + string));
        }
    }

    public String toString() {
        return "    coreGroupAccessPoint:\n      name..............." + this.name + "\n" + "      coreGroup.........." + this.coreGroupName + "\n" + "      endPointName......." + this.endPointName + "\n" + "      properties........." + CGBridgeConfig.propertiesToString(this.properties) + "\n" + "      bridgeInterfaces..." + this.bridgeInterfacesToSting() + "\n";
    }
}

