/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.PeerAccessPointImpl;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.cgbridge.config.AccessPointGroup;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.CGBridgeEndPoint;
import com.ibm.ws.cgbridge.config.MemberData;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.exception.ConfigurationWarning;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PeerAccessPoint {
    private static final TraceComponent tc = Tr.register((Class)PeerAccessPoint.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private String name;
    private String cellName;
    private String coreGroupName;
    private String coreGroupAccessPointName = "UNDEFINED";
    private Vector endPoints;
    private String proxyPeerKey = null;
    private HashMap properties;
    private AccessPointGroup accessPointGroup;
    private CGBridgeConfig cgbridgeConfig;

    public PeerAccessPoint(PeerAccessPointImpl peerAccessPointImpl, CGBridgeConfig cGBridgeConfig) throws ConfigurationWarning {
        this.cgbridgeConfig = cGBridgeConfig;
        this.name = peerAccessPointImpl.getName();
        this.cellName = peerAccessPointImpl.getCell();
        this.coreGroupName = peerAccessPointImpl.getCoreGroup();
        this.coreGroupAccessPointName = peerAccessPointImpl.getCoreGroupAccessPoint();
        this.properties = CGBridgeConfig.loadProperties(peerAccessPointImpl.getProperties());
        this.endPoints = this.loadPeerEndPoints(peerAccessPointImpl);
        this.proxyPeerKey = this.loadProxyPeerKey(peerAccessPointImpl);
        if (null == this.name) {
            throw new ConfigurationWarning("PeerAccessPoint must have name defined");
        }
        if (null == this.cellName) {
            throw new ConfigurationWarning("PeerAccessPoint [" + this.name + "] must have cell defined");
        }
        if (null == this.coreGroupName) {
            throw new ConfigurationWarning("PeerAccessPoint [" + this.name + "] must have coreGroup defined");
        }
        if (null != this.proxyPeerKey && 0 != this.endPoints.size()) {
            throw new ConfigurationWarning("PeerAccessPoint [" + this.name + "] should not have both a proxyPeer and endPoints");
        }
        this.debug("constructor");
    }

    public PeerAccessPoint(MemberData memberData, CGBridgeConfig cGBridgeConfig, AccessPointGroup accessPointGroup) {
        this.cgbridgeConfig = cGBridgeConfig;
        this.cellName = memberData.cellName;
        this.coreGroupName = memberData.coreGroupName;
        this.name = "PAP_" + accessPointGroup.getName() + ":" + this.cellName + ":" + this.coreGroupName;
        this.endPoints = new Vector();
        this.properties = new HashMap();
        this.debug("PAP constructed with name=[" + this.name + "]");
    }

    private Vector loadPeerEndPoints(PeerAccessPointImpl peerAccessPointImpl) throws ConfigurationWarning {
        Iterator iterator = peerAccessPointImpl.getPeerEndPoints().iterator();
        Vector<CGBridgeEndPoint> vector = new Vector<CGBridgeEndPoint>();
        CGBridgeEndPoint cGBridgeEndPoint = null;
        while (iterator.hasNext()) {
            boolean bl = true;
            try {
                cGBridgeEndPoint = new CGBridgeEndPoint((EndPoint)iterator.next(), this.cgbridgeConfig, this.cellName, this.coreGroupName, this.coreGroupAccessPointName, null);
            }
            catch (ConfigurationWarning configurationWarning) {
                Tr.error((TraceComponent)tc, (String)"CWRCB0201", (Object)("EndPoint in PeerAccessPoint [" + this.name + "] failed configuration. " + configurationWarning.getMessage()));
                bl = false;
            }
            if (!bl) continue;
            this.debug("loadPeerEndPoint ep=[" + cGBridgeEndPoint + "]");
            if (!vector.contains(cGBridgeEndPoint)) {
                vector.addElement(cGBridgeEndPoint);
                continue;
            }
            throw new ConfigurationWarning("Multiple endPoints with same host and port defined in peerAccessPoint [" + this.name + "].");
        }
        vector.trimToSize();
        return vector;
    }

    private String loadProxyPeerKey(PeerAccessPointImpl peerAccessPointImpl) {
        String string = null;
        com.ibm.websphere.models.config.coregroupbridgeservice.PeerAccessPoint peerAccessPoint = peerAccessPointImpl.getProxyPeerAccessPointRef();
        if (null != peerAccessPoint && !peerAccessPoint.eIsProxy()) {
            string = peerAccessPoint.getName();
        }
        return string;
    }

    void pushDownProperties(HashMap hashMap) throws CGBInternalErrorException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.properties.containsKey(string)) continue;
            this.properties.put(string, hashMap.get(string));
        }
        for (int i = 0; i < this.endPoints.size(); ++i) {
            ((CGBridgeEndPoint)this.endPoints.elementAt(i)).setProperties(this.properties);
        }
    }

    boolean containsMember(MemberData memberData) {
        boolean bl = false;
        int n = this.endPoints.size();
        for (int i = 0; i < n; ++i) {
            CGBridgeEndPoint cGBridgeEndPoint = (CGBridgeEndPoint)this.endPoints.elementAt(i);
            if (!cGBridgeEndPoint.getMemberName().equals(memberData.memberName)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.debug("containsMember found [" + memberData.memberName + "] in PAP [" + this.name + "]");
        }
        return bl;
    }

    void handleNewMember(MemberData memberData) throws CGBInternalErrorException {
        this.debug("handleNewMember [" + memberData + "] in PAP [" + this.name + "]");
        this.endPoints.add(new CGBridgeEndPoint(memberData));
    }

    public String getKey() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getCellname() {
        return this.cellName;
    }

    public String getCoreGroupName() {
        return this.coreGroupName;
    }

    public String getCoreGroupAccessPointName() {
        return this.coreGroupAccessPointName;
    }

    public boolean hasEndPoint(String string) {
        CGBridgeEndPoint cGBridgeEndPoint;
        boolean bl = false;
        int n = 0;
        if (n < this.endPoints.size() && (cGBridgeEndPoint = (CGBridgeEndPoint)this.endPoints.get(n)).getMemberName().equals(string)) {
            bl = true;
        }
        return bl;
    }

    public Vector getEndPoints() {
        return this.endPoints;
    }

    public PeerAccessPoint getProxyPeer() {
        PeerAccessPoint peerAccessPoint = null;
        if (null != this.proxyPeerKey) {
            peerAccessPoint = (PeerAccessPoint)this.cgbridgeConfig.getPeerAccessPoints().get(this.proxyPeerKey);
        }
        return peerAccessPoint;
    }

    void setAccessPointGroup(AccessPointGroup accessPointGroup) {
        this.accessPointGroup = accessPointGroup;
    }

    public AccessPointGroup getAccessPointGroup() {
        return this.accessPointGroup;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    private String accessPointGroupToString() {
        String string = "";
        AccessPointGroup accessPointGroup = this.getAccessPointGroup();
        if (null != accessPointGroup) {
            string = string + accessPointGroup.getName();
        }
        return string;
    }

    private String proxyPeerToString() {
        String string = "";
        PeerAccessPoint peerAccessPoint = this.getProxyPeer();
        if (null != peerAccessPoint) {
            string = string + peerAccessPoint.getName() + ":" + peerAccessPoint.getCellname() + ":" + peerAccessPoint.getCoreGroupAccessPointName();
        }
        return string;
    }

    String endPointsToString() {
        String string = "";
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            CGBridgeEndPoint cGBridgeEndPoint = (CGBridgeEndPoint)iterator.next();
            string = string + cGBridgeEndPoint.getMemberName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string;
    }

    public String toString() {
        return "    peerAccessPoint\n      name..................... [" + this.name + "]\n" + "      cellName................. [" + this.cellName + "]\n" + "      coreGroupName........... .[" + this.coreGroupName + "]\n" + "      coreGroupAccessPointName..[" + this.coreGroupAccessPointName + "]\n" + "      proxyPeerKey..............[" + this.proxyPeerKey + "]\n" + "      proxyPeer.................[" + this.proxyPeerToString() + "]\n" + "      accessPointGroup..........[" + this.accessPointGroupToString() + "]\n" + "      properties................[" + CGBridgeConfig.propertiesToString(this.properties) + "]\n" + "      endPoints.................[" + this.endPointsToString() + "]\n";
    }

    private void debug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("### PeerAccessPoint." + string));
        }
    }
}

