/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cgbridge.core.BridgeServerUpdateRegistryCallback;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.msg.CGBridgeRemoteData;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.util.HashSet;
import java.util.Set;

class BridgeServerUpdateRegistry
implements AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)BridgeServerUpdateRegistry.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    String fullyQualifiedServerName;
    Set expectedUpdates;
    int bridgeViewChangeID;
    GroupMemberId bridgeWaitingForUpdates;
    Alarm alarm;
    long waitTime;
    BridgeServerUpdateRegistryCallback callback;
    boolean isActiveForProcessing;
    String originCG;
    String debugServerName;

    public BridgeServerUpdateRegistry(String string, int n, long l, BridgeServerUpdateRegistryCallback bridgeServerUpdateRegistryCallback, String string2) {
        this.fullyQualifiedServerName = string;
        this.expectedUpdates = new HashSet();
        this.bridgeViewChangeID = n;
        this.waitTime = l;
        this.callback = bridgeServerUpdateRegistryCallback;
        this.isActiveForProcessing = true;
        this.originCG = string2;
        this.debugServerName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAlarmTimer() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("starting timer for the update registry of: " + this.debugServerName + " to wait for " + this.waitTime + " milliseconds."));
        }
        Set set = this.expectedUpdates;
        synchronized (set) {
            this.alarm = AlarmManager.createNonDeferrable((long)this.waitTime, (AlarmListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInactive() {
        Set set = this.expectedUpdates;
        synchronized (set) {
            this.isActiveForProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForUpdateTracking(CGBridgeRemoteData cGBridgeRemoteData, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerForUpdateTracking-" + this.debugServerName), (Object)new Object[]{cGBridgeRemoteData, cGBridgeBulletinBoardScopeData});
        }
        Set set = this.expectedUpdates;
        synchronized (set) {
            if (this.isActiveForProcessing) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("scopeData cell name=" + cGBridgeBulletinBoardScopeData.getCellName()));
                }
                Integer n = CGBridgeUtils.getCellScopedLookUpKey(cGBridgeRemoteData, cGBridgeBulletinBoardScopeData);
                this.expectedUpdates.add(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.debugServerName + " now waiting for trace from the following key: " + n));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("registerForUpdateTracking-" + this.debugServerName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateReceived(CGBridgeRemoteData cGBridgeRemoteData, byte by, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateReceived-" + this.debugServerName), (Object)new Object[]{cGBridgeRemoteData, new Byte(by), string});
        }
        Set set = this.expectedUpdates;
        synchronized (set) {
            boolean bl = false;
            if (this.isActiveForProcessing) {
                if (this.expectedUpdates.remove(CGBridgeUtils.getLookUpKey(cGBridgeRemoteData, by, string)) && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.debugServerName + " subjects with remaining updates: (" + this.expectedUpdates.size() + ") " + CGBridgeUtils.getSubset(this.expectedUpdates, 5)));
                }
                bl = this.isComplete();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"not active");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("updateReceived-" + this.debugServerName), (Object)new Boolean(bl));
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUpdateTracking(CGBridgeRemoteData cGBridgeRemoteData, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeUpdateTracking-" + this.debugServerName), (Object)new Object[]{cGBridgeRemoteData, cGBridgeBulletinBoardScopeData});
        }
        Set set = this.expectedUpdates;
        synchronized (set) {
            if (this.isActiveForProcessing) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("scopeData cell name=" + cGBridgeBulletinBoardScopeData.getCellName()));
                }
                Integer n = CGBridgeUtils.getCellScopedLookUpKey(cGBridgeRemoteData, cGBridgeBulletinBoardScopeData);
                boolean bl2 = this.expectedUpdates.remove(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.debugServerName + " is element removed = " + bl2));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.expectedUpdates.size() + " elements remain for " + this.debugServerName));
                }
                bl = this.isComplete();
            } else {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeUpdateTracking-" + this.debugServerName + "-" + bl));
        }
        return bl;
    }

    private boolean isComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isComplete-" + this.debugServerName));
        }
        boolean bl = false;
        if (this.expectedUpdates.size() == 0) {
            this.cancelAlarm();
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isComplete-" + this.debugServerName + "-" + bl));
        }
        return bl;
    }

    public int getBridgeViewChangeID() {
        return this.bridgeViewChangeID;
    }

    public GroupMemberId getBridgeWaitingForUpdates() {
        return this.bridgeWaitingForUpdates;
    }

    public void setBridgeWaitingForUpdates(GroupMemberId groupMemberId) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bridgeWaitingForUpdates=" + CGBridgeUtils.getFullServerName(groupMemberId)));
        }
        this.bridgeWaitingForUpdates = groupMemberId;
    }

    public String getFullyQualifiedServerName() {
        return this.fullyQualifiedServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        Set set = this.expectedUpdates;
        synchronized (set) {
            if (!this.isComplete()) {
                this.callback.bridgeUpdateTimerExpired(this.fullyQualifiedServerName, this.bridgeViewChangeID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAlarm() {
        Set set = this.expectedUpdates;
        synchronized (set) {
            if (this.alarm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cancelled alarm-" + this.debugServerName));
                }
                this.alarm.cancel();
                this.alarm = null;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("alarm already cancelled-" + this.debugServerName));
            }
        }
    }

    boolean isActiveForProcessing() {
        return this.isActiveForProcessing;
    }

    public Set getExpectedUpdates() {
        return this.expectedUpdates;
    }

    public String getOriginCG() {
        return this.originCG;
    }
}

