/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cgbridge.core.BridgeViewChangeRegisterCallback;
import com.ibm.ws.cgbridge.core.impl.BridgeServerUpdateRegistry;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BridgeViewChangeRegister
implements AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)BridgeViewChangeRegister.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    public static final int UNDEFINED_ID = 0;
    Map coreGroupMap;
    Set availableCoreGroups;
    Map bridgeViewChangeIDMap;
    int bridgeViewChangeID;
    boolean initialized;
    long waitTime;
    Alarm alarm;
    boolean isTerminated;
    BridgeViewChangeRegisterCallback callback;
    String fqServerName;
    BridgeServerUpdateRegistry owningUpdateRegistry;
    Map originalCGMap;

    BridgeViewChangeRegister(int n, long l, BridgeViewChangeRegisterCallback bridgeViewChangeRegisterCallback, String string) {
        this.bridgeViewChangeID = n;
        this.waitTime = l;
        this.callback = bridgeViewChangeRegisterCallback;
        this.fqServerName = string;
        this.availableCoreGroups = new HashSet();
        this.coreGroupMap = new HashMap();
        this.originalCGMap = new HashMap();
        this.bridgeViewChangeIDMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startTimer");
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            this.alarm = AlarmManager.createNonDeferrable((long)this.waitTime, (AlarmListener)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBridgeRegistrationInitialized() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBridgeRegistrationInitialized");
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            this.initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBridgeRegistrationInitialized");
        }
    }

    public void addBridges(String string, GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addBridges", (Object)new Object[]{string, groupMemberIdArray});
        }
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            this.addBridge(string, CGBridgeUtils.getFullServerName(groupMemberIdArray[i]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addBridges");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBridge(String string, String string2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addBridge-" + string), (Object)new Object[]{string2, new Integer(n)});
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            if (this.isTerminated) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addBridge - terminated");
                }
                return;
            }
            HashSet<String> hashSet = (HashSet<String>)this.coreGroupMap.get(string);
            HashSet<String> hashSet2 = (HashSet<String>)this.originalCGMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashSet2 = new HashSet<String>();
                this.coreGroupMap.put(string, hashSet);
                this.originalCGMap.put(string, hashSet2);
                this.availableCoreGroups.add(string);
            }
            hashSet.add(string2);
            hashSet2.add(string2);
            this.bridgeViewChangeIDMap.put(string2, new Integer(n));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cg servers=" + hashSet));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("orig servers=" + hashSet2));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("added " + string2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addBridge");
        }
    }

    public void addBridge(String string, String string2) {
        this.addBridge(string, string2, this.bridgeViewChangeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsBridge(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"containsBridge", (Object)new Object[]{string, string2});
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isTerminated=" + this.isTerminated + ", is contains cg=" + this.coreGroupMap.containsKey(string)));
            }
            if (this.coreGroupMap.containsKey(string)) {
                Set set;
                if (this.isTerminated) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"containsBridge - terminated");
                    }
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("core groups = " + this.coreGroupMap.keySet()));
                }
                if ((set = (Set)this.coreGroupMap.get(string)) != null && set.contains(string2)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"containsBridge", (Object)Boolean.TRUE);
                    }
                    return true;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("containsBridge-" + Boolean.FALSE));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconcileBridges(String string, GroupMemberId[] groupMemberIdArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("reconcileBridges-" + string), (Object)new Object[]{groupMemberIdArray, new Integer(n)});
        }
        boolean bl = false;
        Map map = this.coreGroupMap;
        synchronized (map) {
            if (!this.isTerminated && groupMemberIdArray != null && groupMemberIdArray.length > 0) {
                if (!this.coreGroupMap.containsKey(string)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("reconcileBridges-core group state already satisfied for " + string + " :false"));
                    }
                    return bl;
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    hashSet.add(CGBridgeUtils.getFullServerName(groupMemberIdArray[i]));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("activeBridges=" + hashSet));
                }
                Set set = (Set)this.originalCGMap.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("originalCGServers=" + set));
                }
                if (!(set == null || set.size() == hashSet.size() && set.containsAll(hashSet))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"reconciling active bridges");
                    }
                    this.originalCGMap.put(string, new HashSet(hashSet));
                    this.coreGroupMap.put(string, new HashSet(hashSet));
                    Iterator iterator = hashSet.iterator();
                    Integer n2 = new Integer(n);
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        this.bridgeViewChangeIDMap.put(string2, n2);
                    }
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("reconcileBridges-" + bl));
        }
        return bl;
    }

    private void removeBridge(Set set, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeBridge", (Object)new Object[]{set, string, string2});
        }
        if (set.remove(string2) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removed " + string2));
        }
        if (set.size() == 0) {
            this.removeCoreGroup(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeBridge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCoreGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeCoreGroup-" + string));
        }
        boolean bl = false;
        Map map = this.coreGroupMap;
        synchronized (map) {
            if (!this.isTerminated) {
                if (this.coreGroupMap.remove(string) != null) {
                    bl = true;
                }
                if (this.isComplete()) {
                    this.setTerminated();
                    this.allRegisteredBridgeStateReceived();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeCoreGroup-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateCompleteReceived(String string, String string2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stateCompleteReceived", (Object)new Object[]{string, string2, new Integer(n)});
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("expected version id = " + this.bridgeViewChangeIDMap + "isTerminated=" + this.isTerminated));
            }
            if (this.isTerminated) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stateCompleteReceived - terminated");
                }
                return;
            }
            Integer n2 = (Integer)this.bridgeViewChangeIDMap.get(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("id=" + n2));
            }
            if (n2 != null && n == n2) {
                Set set;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("core groups = " + this.coreGroupMap.keySet()));
                }
                if ((set = (Set)this.coreGroupMap.get(string)) != null) {
                    this.removeBridge(set, string, string2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Wrong version.  Expected version=" + this.bridgeViewChangeIDMap + ", received version=" + n));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("remaining servers=" + this.coreGroupMap));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("origin servers=" + this.originalCGMap));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stateCompleteReceived");
        }
    }

    private boolean isComplete() {
        return this.coreGroupMap.size() == 0 && this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAlarm() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object)this);
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            block8: {
                try {
                    if (this.alarm != null) {
                        this.alarm.cancel();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("problems canceling alarm: " + exception.getMessage()));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelAlarm");
        }
    }

    public void allRegisteredBridgeStateReceived() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"allRegisteredBridgeStateReceived");
        }
        if (this.alarm != null) {
            this.alarm.cancel();
        }
        this.callback.bridgeViewChangeProcessingComplete(this.bridgeViewChangeID, this.fqServerName, this.availableCoreGroups);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allRegisteredBridgeStateReceived");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        Map map = this.coreGroupMap;
        synchronized (map) {
            if (!this.isTerminated) {
                this.setTerminated();
                HashSet hashSet = new HashSet(this.availableCoreGroups);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("remainingCoreGroups=" + hashSet));
                }
                hashSet.removeAll(this.coreGroupMap.keySet());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("remainingCoreGroups=" + hashSet));
                }
                this.callback.bridgeViewChangeProcessingTimedOut(this.bridgeViewChangeID, this.coreGroupMap, this.fqServerName, hashSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminated() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTerminated");
        }
        Map map = this.coreGroupMap;
        synchronized (map) {
            this.isTerminated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTerminated");
        }
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public int getBridgeViewChangeIDMap() {
        return this.bridgeViewChangeID;
    }

    public String getFqServerName() {
        return this.fqServerName;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public Map getCoreGroupMap() {
        return this.coreGroupMap;
    }

    BridgeServerUpdateRegistry getOwningUpdateRegistry() {
        return this.owningUpdateRegistry;
    }

    void setOwningUpdateRegistry(BridgeServerUpdateRegistry bridgeServerUpdateRegistry) {
        this.owningUpdateRegistry = bridgeServerUpdateRegistry;
    }

    public Set getAvailableCoreGroups() {
        return this.availableCoreGroups;
    }
}

