/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cgbridge.config.AccessPointGroup;
import com.ibm.ws.cgbridge.config.AccessPointGroupTopology;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.PeerAccessPoint;
import com.ibm.ws.cgbridge.core.BridgeViewChangeRegisterCallback;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.CGBridgeCallback;
import com.ibm.ws.cgbridge.core.impl.BridgeViewChangeRegister;
import com.ibm.ws.cgbridge.core.impl.CGBSubjectPost;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBBEventsHandler;
import com.ibm.ws.cgbridge.core.impl.CGBridgeCallbackImpl;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.GSRSubscriptionAction;
import com.ibm.ws.cgbridge.core.impl.InterBridgeCoreGroup;
import com.ibm.ws.cgbridge.core.impl.InterCGBridgePMGEvents;
import com.ibm.ws.cgbridge.core.impl.LocalBridgeServerUpdateRegistry;
import com.ibm.ws.cgbridge.core.impl.StoredGSRSub;
import com.ibm.ws.cgbridge.core.impl.SubjectPostCache;
import com.ibm.ws.cgbridge.core.impl.SubscriptionOrganizer;
import com.ibm.ws.cgbridge.core.impl.SubscriptionTracker;
import com.ibm.ws.cgbridge.core.impl.SynchronizedCoreGroups;
import com.ibm.ws.cgbridge.core.impl.UpdateRoutingRecord;
import com.ibm.ws.cgbridge.core.impl.UpdateRoutingTable;
import com.ibm.ws.cgbridge.exception.CGBException;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.msg.CGBridgeBBPostMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRLocalStateMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRStateRequestMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.cgbridge.util.EnumType;
import com.ibm.ws.cgbridge.util.LocalGroupMemberIdComparator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.cgbridge.AvailableCoreGroupListener;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectProxySubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import com.ibm.wsspi.hamanager.corestack.CoreStackFactory;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupCallback;
import com.ibm.wsspi.hamanager.partitionedmanager.MemberStateEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CGBridge
implements SubjectSubscriptionEvents,
ManagedGroupCallback,
AlarmListener,
AvailableCoreGroupListener,
BridgeViewChangeRegisterCallback {
    static final TraceComponent tc2 = Tr.register((Class)AvailableCoreGroups.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    static final TraceComponent tc = Tr.register((Class)CGBridge.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    static final EnumType PROCESS_GSR_STATE_COMPLETE = new EnumType("COMPLETE", 0);
    static final EnumType PROCESS_GSR_STATE_UNSTABLE = new EnumType("UNSTABLE", 10);
    static final EnumType PROCESS_GSR_STATE_NO_STATE_TO_WAIT_FOR = new EnumType("NO STATE TO WAIT FOR", 15);
    static final EnumType PROCESS_GSR_STATE_NO_STATE = new EnumType("NO STATE TO PROCESS", 20);
    static final EnumType PROCESS_GSR_STATE_WAITING_FOR_STATE_COMPLETE_MSGS = new EnumType("WAITING FOR STATE COMPLETE MSG", 30);
    static final EnumType PROCESS_GSR_STATE_PROCESSING = new EnumType("Processing", 40);
    static final EnumType PROCESS_GSR_STATE_WAITING_FOR_GSR_STATE = new EnumType("Waiting for GSR state", 100);
    static final EnumType PROCESS_GSR_STATE_NOT_UNSYNCHRONIZED = new EnumType("Not unsynchronized", 110);
    static final EnumType PROCESS_GSR_STATE_NO_SUBSCRIPTIONS = new EnumType("No subscriptions", 120);
    static final EnumType PROCESS_GSR_STATE_DID_NOT_PROCESS_NEW_SERVERS_ONLINE = new EnumType("Did not process new servers online", 130);
    static final EnumType PROCESS_GSR_STATE_DID_NOT_REMOVE_ANY_DEAD_COORDINATORS = new EnumType("No servers removed", 140);
    static final EnumType PROCESS_GSR_STATE_NO_ACTIVE_COORDINATORS_SPECIFIED = new EnumType("No active coordinators specified", 150);
    static final EnumType CACHED_LOCAL_STATE_BRIDGE_VIEW_CHANGE = new EnumType("New bridge view change", 10);
    static final EnumType CACHED_LOCAL_STATE_UPDATE_FOR_GSR_SERVER = new EnumType("Update for a coordinator", 20);
    static final EnumType CACHED_LOCAL_STATE_FOR_NEW_SERVERS_ONLINE = new EnumType("new server(s) online", 30);
    static final EnumType CACHED_LOCAL_STATE_REMOVE_COORDINATORS = new EnumType("remove coordinator(s)", 40);
    static final EnumType CACHED_LOCAL_STATE_STABILIZED = new EnumType("stabilized", 60);
    static final EnumType CACHED_LOCAL_STATE_NONE = new EnumType("No state provided", 100);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String NO_BRIDGES = "NO BRIDGES";
    BulletinBoardFactory bbf;
    CGBridgeConfig config;
    String localCellName;
    CGBridgeCallbackImpl cgbCallback;
    HashMap interCGBridgeCoreGroups = null;
    CGBridgeBBEventsHandler cgbEventsHandler;
    private CGBridgeService cgbridgeService;
    private String slocalCoreGroup;
    UpdateRoutingTable updateRoutingtbl = new UpdateRoutingTable();
    SubscriptionTracker subscriptionTracker;
    SubjectPostCache subjectPostCache;
    CoreStackFactory csfactory;
    GroupMemberId bridgeLocalGmid;
    GroupMemberId[] intraCellManagers;
    GroupMemberId[] oldIntraCellManagers;
    private int intraCellCurrentIndex = -1;
    Object currentIndexLock = new Object();
    Map cgbPostTracker;
    String haFullProcessName;
    Map apgNameToAPGStatusMap = new HashMap();
    AccessPointGroupTopology apgTopology;
    Map cachedGSRReceivedLocalState;
    int gsrViewChangeIdentifier = 1;
    BridgeViewChangeRegister bridgeViewChangeRegister;
    long viewChangeRebuildWaitTime;
    SynchronizedCoreGroups synchronizedCoreGroups;
    Alarm alarm;
    Set currentSetOfSubsOwned;
    Set oldSetOfSubsOwned;
    Set subsReceivedWhileWaitingToProcessLocalState;
    Set unSubsReceivedWhileWaitingToProcessLocalState;
    int maxCoreGroupPostMsgSize;
    AvailableCoreGroups reachableCoreGroups;
    long startTime;
    List storedLocalUpdateRegistries;
    EnumType localGSRProcessingState;
    Object localGSRProcessingStateLock = new Object();
    private boolean isUseCounterAsPostID;
    Map storedGSRSubMsgs;
    Map coordinatorsWithIncompleteState;
    boolean isAddSubToCurrent;
    boolean isLocalPMGStable;
    Set activeCoordinators;
    Map localBridgesAndCoordinatorsMap;
    Set rebuildSubscriptionsToRemove;
    boolean isReconcilingSubjects;
    Object reconcilingSubjectsLock = new Object();
    boolean isSeamlessCompatibility;
    Set nonLocalSubsToPotentiallyExpectPostsFor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CGBridge(BulletinBoardFactory bulletinBoardFactory, CGBridgeService cGBridgeService, String string, CGBridgeConfig cGBridgeConfig, CoreStackFactory coreStackFactory) throws CGBInternalErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CGBridge");
        }
        this.isReconcilingSubjects = false;
        this.startTime = QuickApproxTime.getRef().getApproxTime();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startTime=" + this.startTime));
        }
        this.nonLocalSubsToPotentiallyExpectPostsFor = new HashSet();
        this.rebuildSubscriptionsToRemove = new HashSet();
        this.localBridgesAndCoordinatorsMap = new HashMap();
        this.isLocalPMGStable = true;
        this.isAddSubToCurrent = true;
        this.localGSRProcessingState = PROCESS_GSR_STATE_UNSTABLE;
        this.subsReceivedWhileWaitingToProcessLocalState = new HashSet();
        this.unSubsReceivedWhileWaitingToProcessLocalState = new HashSet();
        this.cachedGSRReceivedLocalState = new HashMap();
        this.coordinatorsWithIncompleteState = new HashMap();
        this.storedGSRSubMsgs = new HashMap();
        this.storedLocalUpdateRegistries = new LinkedList();
        this.reachableCoreGroups = new AvailableCoreGroups();
        this.intraCellManagers = new GroupMemberId[0];
        this.oldIntraCellManagers = this.intraCellManagers;
        this.csfactory = coreStackFactory;
        this.config = cGBridgeConfig;
        this.cgbridgeService = cGBridgeService;
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.localCellName = adminService.getCellName();
        this.haFullProcessName = CGBridgeService.getInstance().getLocalServerName();
        this.slocalCoreGroup = string;
        this.apgTopology = this.determineAPGBehavior();
        this.isSeamlessCompatibility = this.getSeamlessCompatCustomPropValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isSeamlessCompatibility" + this.isSeamlessCompatibility));
        }
        this.cgbCallback = new CGBridgeCallbackImpl(this);
        this.currentSetOfSubsOwned = new HashSet();
        this.oldSetOfSubsOwned = new HashSet();
        this.bbf = bulletinBoardFactory;
        this.isUseCounterAsPostID = this.determinePostIDValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isUseCounterAsPostID=" + this.isUseCounterAsPostID));
        }
        if (this.apgTopology.isSendLocalProxiedPosts()) {
            this.maxCoreGroupPostMsgSize = this.calculateMaxCoreGroupPostsMsgSize();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("maxCoreGroupPostMsgSize set to: " + this.maxCoreGroupPostMsgSize));
            }
        }
        if (this.bbf == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CGBridge unable to start, no reference to the bulletinboard factory");
            }
            throw new CGBInternalErrorException("Bulletinboard factory unavailable, cannot start Core Group Bridge");
        }
        this.interCGBridgeCoreGroups = new HashMap();
        this.synchronizedCoreGroups = new SynchronizedCoreGroups(this);
        this.cgbPostTracker = new HashMap();
        this.subscriptionTracker = new SubscriptionTracker(this.config, this);
        this.subjectPostCache = new SubjectPostCache(this.config, this);
        this.cgbEventsHandler = new CGBridgeBBEventsHandler(this.bbf, string, this.localCellName, this, this.cgbridgeService, this.subscriptionTracker);
        Iterator iterator = this.config.getAccessPointGroupIterator4Me();
        this.viewChangeRebuildWaitTime = this.getRebuildWaitTime(iterator);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("viewChangeRebuildWaitTime=" + this.viewChangeRebuildWaitTime));
        }
        this.interCGBridgeCoreGroups = new HashMap();
        iterator = this.config.getAccessPointGroupIterator4Me();
        HashMap hashMap = this.interCGBridgeCoreGroups;
        synchronized (hashMap) {
            while (iterator.hasNext()) {
                AccessPointGroup accessPointGroup = (AccessPointGroup)iterator.next();
                InterBridgeCoreGroup interBridgeCoreGroup = new InterBridgeCoreGroup(this.cgbridgeService, this.config, string, this, accessPointGroup, this.csfactory, this.cgbEventsHandler);
                this.interCGBridgeCoreGroups.put(accessPointGroup.getName(), interBridgeCoreGroup);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Hash key For this Cell/Coregroup: " + accessPointGroup.getName()));
            }
        }
        this.alarm = AlarmManager.createNonDeferrable((long)this.getAvailableCoreGroupListenerStartupTimeout(), (AlarmListener)this);
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0105");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CGBridge");
        }
    }

    private boolean getSeamlessCompatCustomPropValue() {
        String string = CGBridgeUtils.getCaseInsensitiveCustomProperty(this.config.getProperties(), "cgb.compatibility");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cgb.compatibility=" + string));
        }
        boolean bl = false;
        if (string != null) {
            if (string.equalsIgnoreCase(Boolean.TRUE.toString())) {
                bl = true;
            } else if (string.equalsIgnoreCase(Boolean.FALSE.toString())) {
                bl = false;
            }
        }
        return bl;
    }

    boolean determinePostIDValue() {
        String string = CGBridgeUtils.getCaseInsensitiveCustomProperty(this.config.getProperties(), "cgb.postID");
        if (string == null) {
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("val=" + string + ", countVal=" + "counter"));
        }
        return string.trim().equalsIgnoreCase("counter");
    }

    void cancelAvailableCoreGroupAlarm() {
        if (this.alarm != null) {
            this.alarm.cancel();
        }
    }

    private long calculateRebuildWaitTime(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            AccessPointGroup accessPointGroup = (AccessPointGroup)iterator.next();
            n += accessPointGroup.getCoreGroupAccessPoints().size() - 1;
            n += accessPointGroup.getPeerAcessPoints().size();
        }
        long l = (long)n * 40000L + 30000L;
        if (l <= 0L) {
            l = 40000L;
        } else if (l > 720000L) {
            l = 720000L;
        }
        return l;
    }

    private int calculateMaxCoreGroupPostsMsgSize() {
        int n;
        block4: {
            String string = CGBridgeUtils.getCaseInsensitiveCustomProperty(this.config.getProperties(), "cgb.coreGroupPosts.size");
            if (string == null) {
                n = 256000;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n = 256000;
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("problems with format of max core group post msg size: " + exception.getMessage()));
                }
            }
        }
        return n;
    }

    private long getRebuildWaitTime(Iterator iterator) {
        long l;
        String string = CGBridgeUtils.getCaseInsensitiveCustomProperty(this.config.getProperties(), "cgb.rebuild.waitTime");
        if (string == null) {
            l = 720000L;
        } else {
            try {
                l = Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("problems with format of wait time: " + numberFormatException.getMessage()));
                }
                l = 720000L;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.getRebuildWaitTime", (String)"1232", (Object)this);
            }
        }
        return l;
    }

    private long getAvailableCoreGroupListenerStartupTimeout() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAvailableCoreGroupListenerStartupTimeout");
            }
            Iterator iterator = this.config.getProperties().keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase("cgb.startUpTimeout")) continue;
                string = (String)this.config.getProperties().get(string2);
            }
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n > 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("getAvailableCoreGroupListenerStartupTimeout = " + n * 1000));
                        }
                        return n * 1000;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("Problem processing value" + string));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAvailableCoreGroupListenerStartupTimeout - default");
        }
        return 300000L;
    }

    private AccessPointGroupTopology determineAPGBehavior() {
        Object v = this.config.getCGNameToCGAPGsMap().get(this.slocalCoreGroup);
        if (v != null) {
            LinkedList linkedList = (LinkedList)v;
            if (linkedList.size() == 1) {
                return AccessPointGroupTopology.RING;
            }
            if (linkedList.size() > 1) {
                return AccessPointGroupTopology.CHAIN;
            }
        }
        return AccessPointGroupTopology.DEFAULT;
    }

    public AccessPointGroupTopology getAPGTopology() {
        return this.apgTopology;
    }

    protected CGBridgeCallback getCGBridgeCallback() {
        return this.cgbCallback;
    }

    CGBridgeService getCGBridgeService() {
        return this.cgbridgeService;
    }

    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CGBridge.updated called erroneously");
        }
    }

    public void memberMayActivate(GroupName groupName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"memberMayActivate");
        }
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"memberMayActivateCancelled");
        }
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"memberIsActivated");
        }
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"memberDeactivated");
        }
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"membershipChanged", (Object)new Object[]{groupName, groupMemberIdArray});
        }
        HashMap<String, GroupMemberId> hashMap = new HashMap<String, GroupMemberId>();
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            hashMap.put(groupMemberIdArray[i].getServerName(), groupMemberIdArray[i]);
        }
        this.localBridgesAndCoordinatorsMap = hashMap;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"membershipChanged");
        }
    }

    public boolean isAlive(GroupName groupName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isAlive");
        }
        return true;
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onMessage");
        }
    }

    protected boolean processCGBridgeMsg(CGBridgeMsg cGBridgeMsg, String string, GroupMemberId groupMemberId, AccessPointGroupTopology accessPointGroupTopology, Map map, boolean bl, String string2, Set set, boolean bl2) {
        return this.processCGBridgeMsg(cGBridgeMsg, string, groupMemberId, accessPointGroupTopology, map, bl, string2, set, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCGBridgeMsg(CGBridgeMsg cGBridgeMsg, String string, GroupMemberId groupMemberId, AccessPointGroupTopology accessPointGroupTopology, Map map, boolean bl, String string2, Set set, boolean bl2, InterBridgeCoreGroup.StoredValues storedValues) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processCGBridgeMsg");
        }
        AccessPointGroupTopology accessPointGroupTopology2 = accessPointGroupTopology == null ? this.getAPGTopology() : accessPointGroupTopology;
        boolean bl3 = false;
        block7 : switch (cGBridgeMsg.getMessageType()) {
            case 1: {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)cGBridgeMsg;
                if (this.config.isFilterSubscriptions() && !this.config.getAllowedBBNames().contains(cGBridgeBBRemoteSubscriptionMsg.getBBName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("BB name " + cGBridgeBBRemoteSubscriptionMsg.getBBName() + " not allowed"));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"processCGBridgeMsg - filtered bb");
                    }
                    return bl3;
                }
                BulletinBoard bulletinBoard = null;
                try {
                    bulletinBoard = this.bbf.findBulletinBoard(cGBridgeBBRemoteSubscriptionMsg.getBBName());
                }
                catch (HAParameterRejectedException hAParameterRejectedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to find BB: " + (Object)((Object)hAParameterRejectedException)));
                    }
                    FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.processCGBridgeMsg", (String)"50", (Object)this);
                }
                BulletinBoardScope bulletinBoardScope = cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCGBridgeScopeType() == 2 ? this.cgbridgeService.getPrivateScope() : this.cgbridgeService.getPublicScope();
                SubjectInfo subjectInfo = null;
                try {
                    subjectInfo = bulletinBoard.createSubject(bulletinBoardScope, cGBridgeBBRemoteSubscriptionMsg.getSubject());
                }
                catch (HAParameterRejectedException hAParameterRejectedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to create SubjectInfo: " + (Object)((Object)hAParameterRejectedException)));
                    }
                    FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.processCGBridgeMsg", (String)"60", (Object)this);
                }
                if (this.getAPGTopology().isSetAdjacentCoreGroupsInSubMsg() && string == null) {
                    cGBridgeBBRemoteSubscriptionMsg.setAdjacentCoreGroups(this.cgbridgeService.getAllCoreGroups());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processCGBridgeMsg bulletinboard/subscription for core group " + string2 + " and server " + CGBridgeUtils.getFullServerName(groupMemberId) + "  " + cGBridgeBBRemoteSubscriptionMsg.getBBName() + " / " + cGBridgeBBRemoteSubscriptionMsg.getSubject() + "APG=" + string + ", isRemoveAllSubscribedBridges=" + bl + ", excludeCoreGroups=" + set));
                }
                byte by = cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCGBridgeScopeType();
                if (!(!this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled() || cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup().equals(this.config.getFullCoreGroupName()) || by == 3 && cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName().equals(this.localCellName))) {
                    if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                        Set set2 = this.currentSetOfSubsOwned;
                        synchronized (set2) {
                            if (this.nonLocalSubsToPotentiallyExpectPostsFor.add(cGBridgeBBRemoteSubscriptionMsg) && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Adding sub to potentially expect posts for");
                            }
                        }
                    }
                    Set set3 = this.currentSetOfSubsOwned;
                    synchronized (set3) {
                        if (this.nonLocalSubsToPotentiallyExpectPostsFor.remove(cGBridgeBBRemoteSubscriptionMsg) && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Removing sub to expect posts for");
                        }
                    }
                }
                switch (by) {
                    case 3: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Remote Scoped Subscription, CellName on message: " + cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData() + " local: " + this.localCellName));
                        }
                        if (cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName().equals(this.localCellName)) {
                            if (storedValues != null) {
                                storedValues.si = subjectInfo;
                            }
                            bl3 = this.forwardLocal(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, accessPointGroupTopology2, bulletinBoard, subjectInfo, map, bl, string2, bl2);
                            break block7;
                        }
                        bl3 = this.forwardRemote(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, map, accessPointGroupTopology2, bulletinBoard, string2);
                        break block7;
                    }
                    case 2: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Private scope subscription forwarding local");
                        }
                        if (storedValues != null) {
                            storedValues.si = subjectInfo;
                        }
                        bl3 = this.forwardLocal(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, accessPointGroupTopology2, bulletinBoard, subjectInfo, map, bl, string2, bl2);
                        break block7;
                    }
                    case 1: {
                        if (storedValues != null) {
                            storedValues.si = subjectInfo;
                        }
                        bl3 = this.forwardLocal(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, accessPointGroupTopology2, bulletinBoard, subjectInfo, map, bl, string2, bl2);
                        break block7;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to determine scope and forward subscription");
                }
                FFDCFilter.processException((Throwable)new CGBInternalErrorException("unable to determine scope type"), (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.updated", (String)"10", (Object)this);
                break;
            }
            case 2: {
                CGBridgeBBPostMsg cGBridgeBBPostMsg = (CGBridgeBBPostMsg)cGBridgeMsg;
                if (this.config.isFilterSubscriptions() && !this.config.getAllowedBBNames().contains(cGBridgeBBPostMsg.getBBName())) {
                    bl3 = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("BB name " + cGBridgeBBPostMsg.getBBName() + " not allowed"));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"processCGBridgeMsg - filtered bb");
                    }
                    return bl3;
                }
                try {
                    bl3 = this.handlePost(cGBridgeBBPostMsg.getValues(), cGBridgeBBPostMsg, groupMemberId, string);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems executing handlePost: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".processCGBridgeMsg()"), (String)"919", (Object)this);
                }
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Did not process unknowm msg type: " + cGBridgeMsg.getMessageType()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processCGBridgeMsg-" + bl3));
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardLocalSubToLocalCellIBCGs(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, Map map) {
        Iterator iterator;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forwardLocalSubToLocalCellIBCGs");
        }
        if (map == null) {
            HashMap hashMap = this.interCGBridgeCoreGroups;
            synchronized (hashMap) {
                object = new HashMap(this.interCGBridgeCoreGroups);
            }
            iterator = object.values().iterator();
        } else {
            iterator = map.values().iterator();
        }
        if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
            this.addLocalRoute(cGBridgeBBRemoteSubscriptionMsg);
        } else {
            this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, false);
        }
        while (iterator.hasNext()) {
            object = (InterBridgeCoreGroup)iterator.next();
            if (((InterBridgeCoreGroup)object).isCrossCell()) continue;
            ((InterBridgeCoreGroup)object).findCGBridgeAndSendMessage(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), cGBridgeBBRemoteSubscriptionMsg, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forwardLocalSubToLocalCellIBCGs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardReceivedSubToLocalCellIBCGs(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, AccessPointGroupTopology accessPointGroupTopology, Map map, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("forwardReceivedSubToLocalCellIBCGs-" + accessPointGroupTopology));
        }
        boolean bl = false;
        if (CGBridgeUtils.getCellName(cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup()).equals(this.config.getCellName())) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isFromLocalCell=" + bl));
            }
        }
        if (string == null || accessPointGroupTopology.isIntraCellSubscriptionsForwarded() && bl || accessPointGroupTopology.isInterCellSubscriptionsForwarded() && !bl) {
            Iterator iterator;
            if (map == null) {
                HashMap hashMap;
                HashMap hashMap2 = this.interCGBridgeCoreGroups;
                synchronized (hashMap2) {
                    hashMap = new HashMap(this.interCGBridgeCoreGroups);
                }
                iterator = hashMap.values().iterator();
            } else {
                iterator = map.values().iterator();
            }
            while (iterator.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)iterator.next();
                if (interBridgeCoreGroup.isCrossCell() || interBridgeCoreGroup.getAccessPointGroupName().equals(string)) continue;
                interBridgeCoreGroup.findCGBridgeAndSendMessage(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), cGBridgeBBRemoteSubscriptionMsg, false);
            }
        } else if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Did not forward subscription to local coregroups, Subject: " + cGBridgeBBRemoteSubscriptionMsg + ", coregroup: " + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendLocalPosts(String string, GroupMemberId groupMemberId, SubjectInfo subjectInfo, Set set) {
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendLocalPosts excludeCoreGroups=" + set));
        }
        if (set != null) {
            InterBridgeCoreGroup interBridgeCoreGroup;
            HashMap hashMap = this.interCGBridgeCoreGroups;
            synchronized (hashMap) {
                interBridgeCoreGroup = (InterBridgeCoreGroup)this.interCGBridgeCoreGroups.get(string);
            }
            if (interBridgeCoreGroup != null && interBridgeCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                bl = this.subjectPostCache.sendAllLocalPosts(subjectInfo, set, CGBridgeUtils.getFullCoregroupName(groupMemberId), interBridgeCoreGroup);
            } else if (tc.isDebugEnabled()) {
                if (interBridgeCoreGroup != null) {
                    Tr.debug((TraceComponent)tc, (String)("isSeamlessFailoverEnabled=" + interBridgeCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()));
                } else {
                    Tr.debug((TraceComponent)tc, (String)"ibcg == null");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set calculateCoreGroupsToExcludeFromLocalState(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, String string2) {
        HashSet<String> hashSet = cGBridgeBBRemoteSubscriptionMsg.getAdjacentCoreGroups();
        if (hashSet == null || hashSet.size() == 0) {
            InterBridgeCoreGroup interBridgeCoreGroup;
            HashMap hashMap = this.interCGBridgeCoreGroups;
            synchronized (hashMap) {
                interBridgeCoreGroup = (InterBridgeCoreGroup)this.interCGBridgeCoreGroups.get(string);
            }
            if (interBridgeCoreGroup == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ibcg==null...looking for core groups");
                }
                hashSet = new HashSet<String>();
                hashSet.add(string2);
            } else {
                hashSet = interBridgeCoreGroup.getAccessPointGroup().getCoreGroups();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("calculateCoreGroupsToExcludeFromLocalState-" + hashSet));
        }
        return hashSet;
    }

    private boolean forwardLocal(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, GroupMemberId groupMemberId, AccessPointGroupTopology accessPointGroupTopology, BulletinBoard bulletinBoard, SubjectInfo subjectInfo, Map map, boolean bl, String string2, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forwardLocal", (Object)new Object[]{string2});
        }
        boolean bl3 = false;
        if (string == null) {
            this.forwardLocalSubToLocalCellIBCGs(cGBridgeBBRemoteSubscriptionMsg, map);
        } else {
            boolean bl4 = this.subscriptionTracker.containsSubscription(groupMemberId, subjectInfo, cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isGSRMsgSub=" + bl2 + ", isSubInSubTracker=" + bl4 + ", isSubscribe=" + cGBridgeBBRemoteSubscriptionMsg.isSubscribe()));
            }
            if (bl2 || cGBridgeBBRemoteSubscriptionMsg.isSubscribe() && !bl4 || !cGBridgeBBRemoteSubscriptionMsg.isSubscribe() && bl4) {
                boolean bl5;
                if (tc.isDebugEnabled() && cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName() != null && !cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName().equals("null")) {
                    Tr.debug((TraceComponent)tc, (String)("target cell of sub cell=" + cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName()));
                    Tr.debug((TraceComponent)tc, (String)("peer access point name=" + cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getPeerAccessPointName()));
                }
                if (cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName() == "null") {
                    bl5 = false;
                    this.updateRoutingTable(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, string2, null);
                } else {
                    bl5 = true;
                    this.updateRoutingTable(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, string2, (CGBridgeBulletinBoardScopeData)subjectInfo.getScope().getData());
                }
                boolean bl6 = false;
                if (bl2 && !cGBridgeBBRemoteSubscriptionMsg.getPostingCoreGroups().contains(this.config.getFullCoreGroupName())) {
                    bl6 = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"force initial update for GSR sub");
                    }
                }
                bl3 = this.handleSubscriptionLocally(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, bulletinBoard, subjectInfo, bl, bl5, bl6);
                if (bl6) {
                    cGBridgeBBRemoteSubscriptionMsg.setPostingCoreGroups(CGBridgeBBRemoteSubscriptionMsg.EMPTY_SET);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isSendLocalProxiedPosts=" + accessPointGroupTopology.isSendLocalProxiedPosts()));
                }
                if (accessPointGroupTopology.isSendLocalProxiedPosts() && cGBridgeBBRemoteSubscriptionMsg.isSubscribe() && bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("origin cg= " + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup() + ", sending cg=" + string2));
                    }
                    if (cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup().equals(string2)) {
                        Set set = this.calculateCoreGroupsToExcludeFromLocalState(cGBridgeBBRemoteSubscriptionMsg, string, string2);
                        this.sendLocalPosts(string, groupMemberId, subjectInfo, set);
                    }
                }
                this.forwardReceivedSubToLocalCellIBCGs(cGBridgeBBRemoteSubscriptionMsg, accessPointGroupTopology, map, string);
            } else {
                block28: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sendingCoreGroup=" + string2 + ", sub origin cg=" + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup()));
                    }
                    if (!cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup().equals(string2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"always send current state when subscription is from a proxy core group");
                        }
                        try {
                            this.cgbEventsHandler.sendCurrentState((SubjectProxySubscription)this.subscriptionTracker.getSubscription(subjectInfo), string2, groupMemberId, string);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block28;
                            Tr.debug((TraceComponent)tc, (String)("Unable to send current state: " + exception.getMessage()));
                        }
                    }
                }
                if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                    this.updateRoutingtbl.addRoute(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isGSRMsgSub=" + bl2));
                }
                if (bl2 && cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("rc=" + bl3));
                    }
                    if (!bl3 && !this.subscriptionTracker.isUpdatedCallbackFired(subjectInfo)) {
                        bl3 = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting return code to true...waiting for update for gsr sub");
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("forwardLocal-" + bl3));
        }
        return bl3;
    }

    boolean handleSubscriptionLocally(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, GroupMemberId groupMemberId, BulletinBoard bulletinBoard, SubjectInfo subjectInfo, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
            bl4 = this.subscribeLocal(cGBridgeBBRemoteSubscriptionMsg, groupMemberId, string, bulletinBoard, subjectInfo, bl3);
            if (bl2 && bl4) {
                this.storeLocalSubForRemoteSubscription(cGBridgeBBRemoteSubscriptionMsg);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unsbuscribing locally - isRemoveAllSubscribedBridges=" + bl));
            }
            if (bl) {
                this.removeSubject(cGBridgeBBRemoteSubscriptionMsg, subjectInfo, true);
                bl4 = true;
            } else {
                bl4 = this.unsubscribeLocal(cGBridgeBBRemoteSubscriptionMsg, groupMemberId, bulletinBoard, subjectInfo);
            }
            if (bl2) {
                this.removeLocalSubForRemoteSubscription(cGBridgeBBRemoteSubscriptionMsg);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleSubscriptionLocally-" + bl4));
        }
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileNonLocalSubsToPotentiallyExpectPostsFor() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconcileNonLocalSubsToPotentiallyExpectPostsFor");
        }
        Set set = this.currentSetOfSubsOwned;
        synchronized (set) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("nonLocalSubsToPotentiallyExpectPostsFor size=" + this.nonLocalSubsToPotentiallyExpectPostsFor.size()));
            }
            Iterator iterator = this.nonLocalSubsToPotentiallyExpectPostsFor.iterator();
            if (this.intraCellManagers.length > 1) {
                while (iterator.hasNext()) {
                    CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                    int n = CGBridgeUtils.determineMembertoSend(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), this.intraCellManagers.length);
                    if (n == this.intraCellCurrentIndex) continue;
                    iterator.remove();
                    if (!this.rebuildSubscriptionsToRemove.add(cGBridgeBBRemoteSubscriptionMsg) || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("adding non-local sub to remove: " + cGBridgeBBRemoteSubscriptionMsg));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("nonLocalSubsToPotentiallyExpectPostsFor size=" + this.nonLocalSubsToPotentiallyExpectPostsFor.size()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconcileNonLocalSubsToPotentiallyExpectPostsFor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalSubForRemoteSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg2 = new CGBridgeBBRemoteSubscriptionMsg(cGBridgeBBRemoteSubscriptionMsg.getBBName(), cGBridgeBBRemoteSubscriptionMsg.getSubject(), cGBridgeBBRemoteSubscriptionMsg.isSubscribe(), (CGBridgeBulletinBoardScopeData)this.cgbridgeService.getPublicScope().getData(), this.config.getFullCoreGroupName());
        Set set = this.currentSetOfSubsOwned;
        synchronized (set) {
            if (this.nonLocalSubsToPotentiallyExpectPostsFor.remove(cGBridgeBBRemoteSubscriptionMsg2) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removed stored local sub:" + cGBridgeBBRemoteSubscriptionMsg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean storeLocalSubForRemoteSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        boolean bl = false;
        Set set = this.currentSetOfSubsOwned;
        synchronized (set) {
            bl = this.nonLocalSubsToPotentiallyExpectPostsFor.add(new CGBridgeBBRemoteSubscriptionMsg(cGBridgeBBRemoteSubscriptionMsg.getBBName(), cGBridgeBBRemoteSubscriptionMsg.getSubject(), cGBridgeBBRemoteSubscriptionMsg.isSubscribe(), (CGBridgeBulletinBoardScopeData)this.cgbridgeService.getPublicScope().getData(), this.config.getFullCoreGroupName()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stored local sub for remote sub: " + cGBridgeBBRemoteSubscriptionMsg));
        }
        return bl;
    }

    boolean addLocalRoute(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        boolean bl = false;
        if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
            bl = this.updateRoutingtbl.putRouteEntry(cGBridgeBBRemoteSubscriptionMsg.getBBName(), cGBridgeBBRemoteSubscriptionMsg.getSubject(), this.config.getFullCoreGroupName(), null, null, cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData(), null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addLocalRoute-" + bl));
        }
        return bl;
    }

    boolean updateRoutingTable(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, GroupMemberId groupMemberId, String string2, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData) {
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isUpdateRoutingEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRoutingTable");
        }
        boolean bl = false;
        if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
            if (cGBridgeBulletinBoardScopeData == null) {
                bl = this.updateRoutingtbl.addRoute(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, string2);
                if (!bl && this.getAPGTopology().isIntraCellUpdatesForwarded() && this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                    bl = this.updateRoutingtbl.putRouteEntry(cGBridgeBBRemoteSubscriptionMsg.getBBName(), cGBridgeBBRemoteSubscriptionMsg.getSubject(), string2, string, groupMemberId, cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData(), string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("enable special route for: " + cGBridgeBBRemoteSubscriptionMsg));
                    }
                }
            } else {
                bl = this.updateRoutingtbl.putRouteEntry(cGBridgeBBRemoteSubscriptionMsg.getBBName(), cGBridgeBBRemoteSubscriptionMsg.getSubject(), cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup(), string, groupMemberId, cGBridgeBulletinBoardScopeData, string2);
            }
        } else {
            bl = cGBridgeBulletinBoardScopeData == null ? this.updateRoutingtbl.removeRouteEntry(cGBridgeBBRemoteSubscriptionMsg, string, null) : this.updateRoutingtbl.removeRouteEntry(cGBridgeBBRemoteSubscriptionMsg, string, cGBridgeBulletinBoardScopeData);
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isUpdateRoutingEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateRoutingTable-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCoreGroupPostTracker(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeCoreGroupPostTracker", (Object)new Object[]{string});
        }
        Map map = this.cgbPostTracker;
        synchronized (map) {
            if (this.cgbPostTracker.remove(string) != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removed entries for core group: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCoreGroupPostTracker");
        }
    }

    public boolean storeCGBPost(CGBridgeBBPostMsg cGBridgeBBPostMsg, GroupMemberId groupMemberId) {
        return this.handlesNewCGBPost(cGBridgeBBPostMsg, groupMemberId, true);
    }

    public boolean isNewCGBPost(CGBridgeBBPostMsg cGBridgeBBPostMsg, GroupMemberId groupMemberId) {
        return this.handlesNewCGBPost(cGBridgeBBPostMsg, groupMemberId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlesNewCGBPost(CGBridgeBBPostMsg cGBridgeBBPostMsg, GroupMemberId groupMemberId, boolean bl) {
        boolean bl2 = true;
        Integer n = new Integer(cGBridgeBBPostMsg.getSubjectHashCode() + cGBridgeBBPostMsg.getCGBScopeData().hashCode());
        Map map = this.cgbPostTracker;
        synchronized (map) {
            LastPost lastPost;
            String string = null;
            long l = -1L;
            SubjectValue[] subjectValueArray = cGBridgeBBPostMsg.getValues();
            if (subjectValueArray != null && subjectValueArray.length > 0) {
                string = subjectValueArray[0].getServerName();
                l = subjectValueArray[0].getVersion();
            }
            if (cGBridgeBBPostMsg.getMsgVersion().getVersion() > CGBridgeMsgVersion.VERSION2.getVersion()) {
                lastPost = new LastPost(cGBridgeBBPostMsg.getCGBPostIdentifier(), l, cGBridgeBBPostMsg.getOriginServer(), string);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"post from bridge using old post msg version");
                }
                lastPost = new LastPost(cGBridgeBBPostMsg.getCGBPostIdentifier(), l, CGBridgeUtils.getFullServerName(groupMemberId), string);
            }
            LastPost lastPost2 = null;
            String string2 = CGBridgeUtils.generateCGKey(cGBridgeBBPostMsg.getCellName(), cGBridgeBBPostMsg.getCoreGroupName());
            HashMap<Integer, LastPost> hashMap = (HashMap<Integer, LastPost>)this.cgbPostTracker.get(string2);
            if (hashMap != null) {
                lastPost2 = (LastPost)hashMap.get(n);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("new post=" + lastPost));
                if (lastPost2 != null) {
                    Tr.debug((TraceComponent)tc, (String)("last post =" + lastPost2));
                }
            }
            if (lastPost2 == null || lastPost2.isNewer(lastPost, cGBridgeBBPostMsg, string2)) {
                if (bl) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, LastPost>();
                        this.cgbPostTracker.put(string2, hashMap);
                    }
                    hashMap.put(n, lastPost);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"storing new post");
                    }
                }
            } else {
                bl2 = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received old post from " + cGBridgeBBPostMsg.getCellName() + ":" + cGBridgeBBPostMsg.getCoreGroupName() + " for " + cGBridgeBBPostMsg.getBBName() + ":" + cGBridgeBBPostMsg.getSubject()));
                }
            }
        }
        return bl2;
    }

    void sendGSRSubscriptionsToIBCGs(SubscriptionOrganizer subscriptionOrganizer, String string, int n, Map map, BridgeViewChangeRegister bridgeViewChangeRegister) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendGSRSubscriptionsToIBCGs", (Object)new Object[]{string, new Integer(n), map});
        }
        try {
            byte[] byArray = new CGBridgeGSRSubscriptionMsg(this.getFullProcessName(), subscriptionOrganizer.getNonRemoteSubscriptions(), subscriptionOrganizer.getRemoteSubscriptions(), n, this.config.getCellName(), this.config.getCoreGroupName(), bridgeViewChangeRegister.getWaitTime(), this.cgbridgeService.getAllCoreGroups(), this.startTime).marshallData();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)iterator.next();
                interBridgeCoreGroup.sendGSRMessages(n, byArray, bridgeViewChangeRegister);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CGBridge.forwardMessage(...) - Unable to marshall data. e=" + exception));
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.forwardMessage", (String)"751", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendGSRSubscriptionsToIBCGs");
        }
    }

    void storeGSRSubscriptionsInIBCGs(SubscriptionOrganizer subscriptionOrganizer, Map map, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeGSRSubscriptionsInIBCGs");
        }
        try {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)iterator.next();
                if (!interBridgeCoreGroup.isCrossCell()) {
                    interBridgeCoreGroup.addGSRPeerSubscriptions(subscriptionOrganizer.getNonRemoteSubscriptions(), null, n);
                }
                if (subscriptionOrganizer.getRemoteSubscriptions().isEmpty()) continue;
                Iterator iterator2 = subscriptionOrganizer.getRemoteSubscriptions().keySet().iterator();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("storing subs in ibcg: " + interBridgeCoreGroup.getAccessPointGroupName()));
                }
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    PeerAccessPoint peerAccessPoint = this.config.getPeerAccessPoint4Cell(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("pap cellName=" + string));
                    }
                    if (peerAccessPoint != null) {
                        Set set = subscriptionOrganizer.getRemoteSubscriptions(string);
                        interBridgeCoreGroup.addGSRPeerSubscriptions(set, peerAccessPoint.getCoreGroupName(), n);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("This apg (" + interBridgeCoreGroup.getAccessPointGroupName() + ") does not handle the cell " + string));
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problem removing gsr subs: " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.storeGSRSubscriptions", (String)"3820", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeGSRSubscriptionsInIBCGs");
        }
    }

    void removeGSRSubscriptionsFromIBCGs(Collection collection, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeGSRSubscriptions", (Object)new Object[]{collection});
        }
        try {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)iterator.next();
                interBridgeCoreGroup.removePeerSubscriptions(collection);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problem removing gsr subs: " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.removeGSRSubscriptions", (String)"3820", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeGSRSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardMessage(CGBridgeMsg cGBridgeMsg, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forwardMessage", (Object)new Object[]{cGBridgeMsg, string, string2});
        }
        try {
            HashMap hashMap;
            byte[] byArray = cGBridgeMsg.marshallData();
            Object object = this.interCGBridgeCoreGroups;
            synchronized (object) {
                hashMap = new HashMap(this.interCGBridgeCoreGroups);
            }
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)object.next();
                if (!interBridgeCoreGroup.getAccessPointGroupName().equals(string)) {
                    interBridgeCoreGroup.sendMessageToAllCoreGroups(byArray, string2, true);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Not sending msg InterBridgeCoreGroup " + string));
            }
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CGBridge.forwardMessage(...) - Unable to marshall data. e=" + iOException));
            }
            FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + "forwardMessage"), (String)"751", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forwardMessage");
        }
    }

    boolean removePeerCoregroupState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removePeerCoregroupState-" + string));
        }
        boolean bl = false;
        if (this.subscriptionTracker.removeCoreGroup(string)) {
            bl = true;
        }
        if (this.updateRoutingtbl.removeCoreGroup(string)) {
            bl = true;
        }
        if (this.subjectPostCache.removeCoreGroupServers(string)) {
            bl = true;
        }
        this.removeCoreGroupPostTracker(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removePeerCoregroupState-" + bl));
        }
        return bl;
    }

    boolean forwardRemote(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, GroupMemberId groupMemberId, Map map, AccessPointGroupTopology accessPointGroupTopology, BulletinBoard bulletinBoard, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forwardRemote", (Object)new Object[]{cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId});
        }
        boolean bl = false;
        if (string != null) {
            if (accessPointGroupTopology.isInterCellSubscriptionsForwarded()) {
                if (this.updateRoutingTable(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, string2, null)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("isSendLocalProxiedPosts=" + accessPointGroupTopology.isSendLocalProxiedPosts()));
                    }
                    if (accessPointGroupTopology.isSendLocalProxiedPosts() && cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("origin cg= " + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup() + ", sending cg=" + string2));
                        }
                        if (cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup().equals(string2)) {
                            try {
                                SubjectInfo subjectInfo = this.createSubjectInfo(bulletinBoard, cGBridgeBBRemoteSubscriptionMsg.getSubject(), this.determineScope(cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData()));
                                Set set = this.calculateCoreGroupsToExcludeFromLocalState(cGBridgeBBRemoteSubscriptionMsg, string, string2);
                                bl = this.sendLocalPosts(string, groupMemberId, subjectInfo, set);
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("unable to send local posts for: " + cGBridgeBBRemoteSubscriptionMsg));
                                }
                                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".forwardRemote"), (String)"222", (Object)this);
                            }
                        }
                    }
                    if (!this.forwardReceivedSubToPAPIBCG(cGBridgeBBRemoteSubscriptionMsg, string, map, string2, groupMemberId)) {
                        this.addLocalRoute(cGBridgeBBRemoteSubscriptionMsg);
                        this.forwardReceivedSubToLocalCellIBCGs(cGBridgeBBRemoteSubscriptionMsg, accessPointGroupTopology, map, string);
                    }
                    if (!cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                        this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, true);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"received sub targeted for a remote cell that this bridge can not process");
            }
        } else {
            if (!this.forwardReceivedSubToPAPIBCG(cGBridgeBBRemoteSubscriptionMsg, string, map, string2, groupMemberId)) {
                this.addLocalRoute(cGBridgeBBRemoteSubscriptionMsg);
                this.forwardReceivedSubToLocalCellIBCGs(cGBridgeBBRemoteSubscriptionMsg, accessPointGroupTopology, map, string);
            }
            if (!cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("forwardRemote-" + bl));
        }
        return bl;
    }

    boolean forwardReceivedSubToPAPIBCG(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, Map map, String string2, GroupMemberId groupMemberId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forwardReceivedSubToPAPIBCG", (Object)new Object[]{cGBridgeBBRemoteSubscriptionMsg, string, map, string2});
        }
        boolean bl = false;
        InterBridgeCoreGroup interBridgeCoreGroup = null;
        String string3 = cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName();
        PeerAccessPoint peerAccessPoint = this.config.getPeerAccessPoint4Cell(string3);
        if (null != peerAccessPoint) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("forwardRemote: subscription for cell [" + string3 + "] forwarded to peerAccessPoint [" + peerAccessPoint.getAccessPointGroup().getName() + "]"));
            }
            if (null != (interBridgeCoreGroup = map == null ? (InterBridgeCoreGroup)this.interCGBridgeCoreGroups.get(peerAccessPoint.getAccessPointGroup().getName()) : (InterBridgeCoreGroup)map.get(peerAccessPoint.getAccessPointGroup().getName()))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("InboundaccesspointGroup: " + string + " localcoregroup: " + interBridgeCoreGroup.getAccessPointGroupName()));
                }
                bl = true;
                if (!interBridgeCoreGroup.getAccessPointGroupName().equals(string)) {
                    if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                        this.addLocalRoute(cGBridgeBBRemoteSubscriptionMsg);
                    }
                    if (string != null) {
                        this.updateRoutingTable(cGBridgeBBRemoteSubscriptionMsg, string, groupMemberId, string2, null);
                    }
                    interBridgeCoreGroup.findCGBridgeAndSendMessage(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint, false);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("forwardReceivedSubToPAPIBCG-" + bl));
        }
        return bl;
    }

    private boolean subscribeLocal(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, String string, BulletinBoard bulletinBoard, SubjectInfo subjectInfo, boolean bl) {
        boolean bl2;
        block2: {
            bl2 = false;
            try {
                bl2 = this.cgbEventsHandler.addListener(cGBridgeBBRemoteSubscriptionMsg, groupMemberId, string, bulletinBoard, subjectInfo, bl);
            }
            catch (CGBInternalErrorException cGBInternalErrorException) {
                FFDCFilter.processException((Throwable)cGBInternalErrorException, (String)"com.ibm.ws.cbridge.core.impl.CGBridge.subscribeLocal", (String)"20", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Unable to add listener on subscribeLocal ");
            }
        }
        return bl2;
    }

    void reinitializeSubscriptions(GroupMemberId[] groupMemberIdArray, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reinitializeSubscriptions", (Object)new Object[]{string, string2});
        }
        if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reinitializeSubscriptions - gmIDs==null || gmIDs.length==0");
            }
            return;
        }
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            Set set = this.subscriptionTracker.getSubscriptions(groupMemberIdArray[i], string);
            if (set == null) continue;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SubjectSubscription subjectSubscription = (SubjectSubscription)iterator.next();
                try {
                    BulletinBoard bulletinBoard = this.createBulletinBoard(subjectSubscription.getSubject().getBoardName());
                    this.cgbEventsHandler.addListener(string, groupMemberIdArray[i], string2, bulletinBoard, subjectSubscription.getSubject(), true);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to reinitialize subscription for bridge " + groupMemberIdArray[i].getServerName() + " because of " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.coregroupbridge.CGBridge.reinitializeSubscriptions", (String)"849", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reinitializeSubscriptions");
        }
    }

    BulletinBoard createBulletinBoard(String string) throws CGBInternalErrorException {
        BulletinBoard bulletinBoard;
        try {
            bulletinBoard = this.bbf.findBulletinBoard(string);
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unable to create  bulletinboard: " + hAParameterRejectedException.getMessage()));
            }
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.coregroupbridge.CGBridge.postLocal", (String)"1187", (Object)this);
            throw new CGBInternalErrorException("could not obtain bulletinboard reference", hAParameterRejectedException);
        }
        return bulletinBoard;
    }

    boolean unsubscribeLocal(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, BulletinBoard bulletinBoard, SubjectInfo subjectInfo) {
        boolean bl;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"unsubscribeLocal", (Object)new Object[]{cGBridgeBBRemoteSubscriptionMsg, groupMemberId, this});
            }
            bl = false;
            try {
                bl = this.cgbEventsHandler.removeListener(cGBridgeBBRemoteSubscriptionMsg, groupMemberId, bulletinBoard, subjectInfo);
            }
            catch (CGBInternalErrorException cGBInternalErrorException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Problems removing listener on unsubscribeLocal " + cGBInternalErrorException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unsubscribeLocal-" + bl));
        }
        return bl;
    }

    protected void unsubscribeLocal(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId) {
        SubjectInfo subjectInfo;
        BulletinBoard bulletinBoard;
        block2: {
            bulletinBoard = null;
            subjectInfo = null;
            try {
                bulletinBoard = this.bbf.findBulletinBoard(cGBridgeBBRemoteSubscriptionMsg.getBBName());
                subjectInfo = bulletinBoard.createSubject(this.cgbridgeService.getPublicScope(), cGBridgeBBRemoteSubscriptionMsg.getSubject());
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Problems in unsubscribeLocal");
            }
        }
        this.unsubscribeLocal(cGBridgeBBRemoteSubscriptionMsg, groupMemberId, bulletinBoard, subjectInfo);
    }

    void removeSubscrSubjectPost(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSubscrSubjectPost", (Object)new Object[]{new Integer(n), new Integer(n2)});
        }
        try {
            this.subjectPostCache.closeSubjectPosts(n, n2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.coregroupbridge.CGBridge.removeSubscrSubjectPost", (String)"949", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSubscrSubjectPost");
        }
    }

    void handleInitialUpdate(CGBridgeBBPostMsg cGBridgeBBPostMsg, GroupMemberId groupMemberId, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleInitialUpdate");
        }
        try {
            if (!this.forwardUpdate(string2, groupMemberId, string, cGBridgeBBPostMsg, null, cGBridgeBBPostMsg.marshallData()) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initial update was not successfully sent");
            }
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problems serialzing message for post: " + cGBridgeBBPostMsg));
            }
            FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".handleInitialUpdate"), (String)"92929", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleInitialUpdate");
        }
    }

    BulletinBoardScope getScope(CGBridgeBBPostMsg cGBridgeBBPostMsg) throws Exception {
        BulletinBoardScope bulletinBoardScope;
        if (cGBridgeBBPostMsg.getMsgVersion().getVersion() >= 3) {
            bulletinBoardScope = this.determineScope(cGBridgeBBPostMsg.getCGBScopeData());
        } else {
            bulletinBoardScope = this.determineScope(cGBridgeBBPostMsg.getCGBScopeData());
            if (bulletinBoardScope == this.cgbridgeService.getPrivateScope()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"older versions treated public and private the same..set to public");
                }
                bulletinBoardScope = this.cgbridgeService.getPublicScope();
            }
        }
        return bulletinBoardScope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handlePost(SubjectValue[] subjectValueArray, CGBridgeBBPostMsg cGBridgeBBPostMsg, GroupMemberId groupMemberId, String string) throws Exception {
        block26: {
            boolean bl;
            block29: {
                String string2;
                String string3;
                UpdateRoutingRecord[] updateRoutingRecordArray;
                BulletinBoardScope bulletinBoardScope;
                block28: {
                    if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("handlePost-" + string));
                    }
                    bl = false;
                    bulletinBoardScope = this.getScope(cGBridgeBBPostMsg);
                    updateRoutingRecordArray = this.updateRoutingtbl.getUpdateRecords(cGBridgeBBPostMsg.getBBName(), cGBridgeBBPostMsg.getSubject(), (CGBridgeBulletinBoardScopeData)bulletinBoardScope.getData());
                    string3 = this.config.getFullCoreGroupName();
                    string2 = CGBridgeUtils.generateCGKey(cGBridgeBBPostMsg.getCellName(), cGBridgeBBPostMsg.getCoreGroupName());
                    if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("handlePost localcgkey: " + string3));
                    }
                    if (updateRoutingRecordArray != null && (string2.equals(string3) && groupMemberId == null || !string2.equals(string3) && groupMemberId != null)) break block28;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ROUTE: no routable updatefor bb/subscription");
                    }
                    break block29;
                }
                LinkedList<String> linkedList = new LinkedList<String>();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                byte[] byArray = null;
                for (int i = 0; !bl3 && i < updateRoutingRecordArray.length; ++i) {
                    block30: {
                        String string4;
                        block31: {
                            block32: {
                                block33: {
                                    int n;
                                    block27: {
                                        bl3 = false;
                                        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("origincoregroup: " + updateRoutingRecordArray[i].getOriginCoreGroup() + " sendingCGKey " + string2));
                                        }
                                        if (cGBridgeBBPostMsg == null) break block26;
                                        if (groupMemberId != null) {
                                            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("scopetype: route: " + updateRoutingRecordArray[i].getBulletinBoardScopeData().getCGBridgeScopeType() + " message:  " + cGBridgeBBPostMsg.getCGBScopeData().getCGBridgeScopeType()));
                                            }
                                            if (updateRoutingRecordArray[i].getOriginCoreGroup() == null && !string3.equals(string2) || updateRoutingRecordArray[i].getOriginCoreGroup().equals(string3) && updateRoutingRecordArray[i].getPreviousCGBridge() == null && !cGBridgeBBPostMsg.getCoreGroupName().equals(string3) || !updateRoutingRecordArray[i].getOriginCoreGroup().equals(string3) && updateRoutingRecordArray[i].getBulletinBoardScopeData().getCGBridgeScopeType() != 3) {
                                                try {
                                                    if (!bl2) {
                                                        bl2 = true;
                                                        if (this.postLocal(cGBridgeBBPostMsg, cGBridgeBBPostMsg.getCGBScopeData(), groupMemberId, string2, bulletinBoardScope)) {
                                                            bl = true;
                                                        }
                                                        break block27;
                                                    }
                                                    if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) break block27;
                                                    Tr.debug((TraceComponent)tc, (String)"already posted locally");
                                                }
                                                catch (CGBInternalErrorException cGBInternalErrorException) {
                                                    bl3 = true;
                                                    if (!tc.isDebugEnabled()) break block27;
                                                    Tr.debug((TraceComponent)tc, (String)("isError=true; Experienced problems while posting to local bulletinboard " + cGBInternalErrorException.getMessage()));
                                                    Tr.debug((TraceComponent)tc, (String)"Print routing records for this BB/subj");
                                                    for (n = 0; n < updateRoutingRecordArray.length; ++n) {
                                                        Tr.debug((TraceComponent)tc, (String)updateRoutingRecordArray[n].toString());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    bl4 = InterCGBridgePMGEvents.getAdjacentCoregroups().contains(updateRoutingRecordArray[i].getTargetCoreGroup());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("u.pcgb=" + CGBridgeUtils.getFullServerName(updateRoutingRecordArray[i].getPreviousCGBridge()) + " inboundGmid=" + CGBridgeUtils.getFullServerName(groupMemberId) + " isError=" + bl3 + " u.ocg=" + updateRoutingRecordArray[i].getOriginCoreGroup() + " u.tcg=" + updateRoutingRecordArray[i].getTargetCoreGroup() + " isAdjacentCoregroup=" + bl4 + " isInitialUpdate=" + cGBridgeBBPostMsg.isInitialUpdate()));
                                    }
                                    if (updateRoutingRecordArray[i].getPreviousCGBridge() == null || updateRoutingRecordArray[i].getPreviousCGBridge().equals(groupMemberId) || bl3 && !cGBridgeBBPostMsg.isInitialUpdate() || !bl4) break block30;
                                    string4 = CGBridgeUtils.generateCGKey(cGBridgeBBPostMsg.getCellName(), cGBridgeBBPostMsg.getCoreGroupName());
                                    if (updateRoutingRecordArray[i].getTargetCoreGroup().equals(string4)) break block31;
                                    if (string != null && (string == null || string.equals(updateRoutingRecordArray[i].getInboundAPG()))) break block32;
                                    if (linkedList.contains(updateRoutingRecordArray[i].getTargetCoreGroup())) break block33;
                                    if (byArray == null) {
                                        try {
                                            byArray = cGBridgeBBPostMsg.marshallData();
                                        }
                                        catch (IOException iOException) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("problems serialzing message for post: " + cGBridgeBBPostMsg));
                                            }
                                            FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".handlePost"), (String)"3445", (Object)this);
                                        }
                                    }
                                    if ((n = (int)(this.forwardUpdate(updateRoutingRecordArray[i].getInboundAPG(), null, updateRoutingRecordArray[i].getTargetCoreGroup(), cGBridgeBBPostMsg, string, byArray) ? 1 : 0)) == 0) {
                                        this.updateRoutingtbl.putRouteEntry(cGBridgeBBPostMsg.getBBName(), cGBridgeBBPostMsg.getSubject(), updateRoutingRecordArray[i].getOriginCoreGroup(), updateRoutingRecordArray[i].getInboundAPG(), null, updateRoutingRecordArray[i].getBulletinBoardScopeData(), updateRoutingRecordArray[i].getTargetCoreGroup());
                                        break block30;
                                    } else {
                                        linkedList.add(updateRoutingRecordArray[i].getTargetCoreGroup());
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Forwarding Update along to apg: " + updateRoutingRecordArray[i].getInboundAPG() + " to core group bridge " + CGBridgeUtils.getFullServerName(updateRoutingRecordArray[i].getPreviousCGBridge())));
                                        }
                                    }
                                    break block30;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("update already sent to " + updateRoutingRecordArray[i].getTargetCoreGroup()));
                                }
                                break block30;
                            }
                            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Wrong inboundAPG:" + string + " to forward update to. uroute[i].getInboundAPG()=" + updateRoutingRecordArray[i].getInboundAPG()));
                            }
                            break block30;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("uroute orgin coregroup equals cell/CG of post msg - postmsgCellCGKey=" + string4));
                        }
                    }
                    if (!tc.isEntryEnabled() || !CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("ROUTE: handlePost routing table entry: " + updateRoutingRecordArray[i].getTargetCoreGroup() + "/" + CGBridgeUtils.getFullServerName(updateRoutingRecordArray[i].getPreviousCGBridge())));
                }
            }
            if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("handlePost-" + bl));
            }
            return bl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Error with routing update, info. from postmessage could not be obtained");
        }
        return false;
    }

    private boolean forwardUpdate(String string, GroupMemberId groupMemberId, String string2, CGBridgeBBPostMsg cGBridgeBBPostMsg, String string3, byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("forwardUpdate-" + string));
        }
        InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)this.interCGBridgeCoreGroups.get(string);
        boolean bl = false;
        if (interBridgeCoreGroup != null) {
            bl = interBridgeCoreGroup.forwardUpdateDirectly(cGBridgeBBPostMsg, groupMemberId, string2, this.localCellName.compareTo(cGBridgeBBPostMsg.getCellName()) == 0, string3, false, byArray);
            if (tc.isDebugEnabled()) {
                SubjectValue[] subjectValueArray = cGBridgeBBPostMsg.getValues();
                for (int i = 0; i < subjectValueArray.length; ++i) {
                    String string4 = subjectValueArray[i].getServerName();
                    Tr.debug((TraceComponent)tc, (String)("forwardUpdate message being sent from: " + string4));
                }
            }
        }
        return bl;
    }

    SubjectInfo createSubjectInfo(BulletinBoard bulletinBoard, String string, BulletinBoardScope bulletinBoardScope) throws CGBInternalErrorException {
        try {
            return bulletinBoard.createSubject(bulletinBoardScope, string);
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unable to create subject: " + hAParameterRejectedException.getMessage()));
            }
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.coregroupbridge.CGBridge.postLocal", (String)"333", (Object)this);
            throw new CGBInternalErrorException("could not obtain subjectInfo reference", hAParameterRejectedException);
        }
    }

    BulletinBoardScope determineScope(CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData) throws CGBInternalErrorException {
        if (!cGBridgeBulletinBoardScopeData.getCellName().equals("null") && !cGBridgeBulletinBoardScopeData.getCellName().equals(this.localCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remote scope type");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("cellName", cGBridgeBulletinBoardScopeData.getCellName());
            try {
                return this.cgbridgeService.getRemoteScope(hashMap);
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"could not obtain remote scope");
                }
                FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.coregroupbridge.CGBridge.determineScope", (String)"5440", (Object)this);
                throw new CGBInternalErrorException("could not obtain remote scope", hAParameterRejectedException);
            }
        }
        if (cGBridgeBulletinBoardScopeData.getCGBridgeScopeType() == 1) {
            return this.cgbridgeService.getPublicScope();
        }
        if (cGBridgeBulletinBoardScopeData.getCGBridgeScopeType() == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"private scope type");
            }
            return this.cgbridgeService.getPrivateScope();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to determine scope");
        }
        throw new CGBInternalErrorException("unable to determine scope");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postLocalCoreGroup(Set set, GroupMemberId groupMemberId, BulletinBoard bulletinBoard, SubjectInfo subjectInfo, String string, BulletinBoardScope bulletinBoardScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postLocalCoreGroup", (Object)new Object[]{CGBridgeUtils.getFullServerName(groupMemberId), bulletinBoard, subjectInfo, string});
        }
        if (set != null && set.size() > 0) {
            Iterator iterator = set.iterator();
            if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled() && !this.isSeamlessCompatibility && this.updateRoutingtbl.getRouteEntry(subjectInfo.getBoardName(), subjectInfo.getSubjectName(), this.config.getFullCoreGroupName(), (CGBridgeBulletinBoardScopeData)bulletinBoardScope.getData()) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("postLocalCoreGroup: " + subjectInfo));
                }
                return;
            }
            SubjectPostCache subjectPostCache = this.subjectPostCache;
            synchronized (subjectPostCache) {
                if (!this.subjectPostCache.containsSubject(string, subjectInfo)) {
                    while (iterator.hasNext()) {
                        CGBSubjectPost cGBSubjectPost = (CGBSubjectPost)iterator.next();
                        try {
                            this.postServerData(subjectInfo, groupMemberId, string, cGBSubjectPost.getSubjectValue(), bulletinBoard);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("caught execption posting data: " + exception.getMessage()));
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("subject post cache already contains entries for the core group: " + string));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postLocalCoreGroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postLocal(CGBridgeBBPostMsg cGBridgeBBPostMsg, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData, GroupMemberId groupMemberId, String string, BulletinBoardScope bulletinBoardScope) throws CGBInternalErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postLocal");
        }
        String string2 = cGBridgeBBPostMsg.getBBName();
        String string3 = cGBridgeBBPostMsg.getSubject();
        SubjectValue[] subjectValueArray = cGBridgeBBPostMsg.getValues();
        boolean bl = false;
        boolean bl2 = false;
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("inbound post with cellname/scope from routing table " + cGBridgeBulletinBoardScopeData.getCellName() + "/" + cGBridgeBulletinBoardScopeData.getCGBridgeScopeType()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bbeventshandler bbs: " + bulletinBoardScope.getData().toString()));
        }
        BulletinBoard bulletinBoard = this.createBulletinBoard(string2);
        SubjectInfo subjectInfo = this.createSubjectInfo(bulletinBoard, string3, bulletinBoardScope);
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled() && !this.isSeamlessCompatibility && this.updateRoutingtbl.getRouteEntry(string2, string3, this.config.getFullCoreGroupName(), (CGBridgeBulletinBoardScopeData)bulletinBoardScope.getData()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("postLocal: " + cGBridgeBBPostMsg));
            }
            return false;
        }
        if (cGBridgeBBPostMsg.isInitialUpdate()) {
            this.subjectPostCache.setStale(subjectInfo, groupMemberId, string);
            this.subjectPostCache.addCoreGroupMember(groupMemberId, string);
        }
        Object object = this.subjectPostCache;
        synchronized (object) {
            for (int i = 0; i < subjectValueArray.length; ++i) {
                try {
                    if (!this.postServerData(subjectInfo, groupMemberId, string, subjectValueArray[i], bulletinBoard)) continue;
                    bl2 = true;
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
        }
        if (cGBridgeBBPostMsg.isInitialUpdate() && this.subjectPostCache.removeStale(subjectInfo, groupMemberId, string)) {
            bl2 = true;
        }
        if (!cGBridgeBBPostMsg.getRemovedServers().isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"closed post set contains entries");
            }
            Iterator iterator = cGBridgeBBPostMsg.getRemovedServers().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!this.subjectPostCache.remove(subjectInfo, groupMemberId, (String)object, string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sp: removed and closed " + subjectInfo + " for server " + (String)object));
                }
                bl2 = true;
            }
        } else if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled() && !cGBridgeBBPostMsg.isInitialUpdate() && cGBridgeBBPostMsg.getValues().length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"post with no servers to remove");
            }
            if (this.subjectPostCache.remove(subjectInfo, groupMemberId, string)) {
                bl2 = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postLocal-" + bl2));
        }
        if (bl) {
            throw new CGBInternalErrorException("Exception(s) generated while updating bulletinboard");
        }
        return bl2;
    }

    boolean postServerData(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string, SubjectValue subjectValue, BulletinBoard bulletinBoard) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postServerData", (Object)new Object[]{subjectInfo, CGBridgeUtils.getFullServerName(groupMemberId), string, subjectValue, bulletinBoard});
        }
        boolean bl = false;
        try {
            CGBSubjectPost cGBSubjectPost;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Subscription being posted to bulletinboard:" + subjectInfo.getBoardName() + " subjectName: " + subjectInfo.getSubjectName() + " servername: " + subjectValue.getServerName()));
            }
            if ((cGBSubjectPost = this.subjectPostCache.get(subjectInfo, groupMemberId, subjectValue.getServerName(), string)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found cached subscription, reusing subval from: " + subjectValue.getServerName()));
                }
                CGBSubjectPost cGBSubjectPost2 = cGBSubjectPost;
                if (subjectValue.getVersion() > cGBSubjectPost2.getSubjectValue().getVersion()) {
                    cGBSubjectPost2.setSubjectValue(subjectValue);
                    cGBSubjectPost2.getSubjectPost().updateProxyPost(subjectValue.getValues(), subjectValue.getVersion());
                    bl = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"old version...not posting");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No cached subscription, creating new post subval from: " + subjectValue.getServerName()));
                }
                SubjectPost subjectPost = bulletinBoard.createPost(subjectInfo, subjectValue);
                CGBSubjectPost cGBSubjectPost3 = new CGBSubjectPost(subjectPost, subjectValue);
                cGBSubjectPost3.setStale(false);
                this.subjectPostCache.put(subjectInfo, groupMemberId, subjectValue.getServerName(), cGBSubjectPost3, string);
                bl = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unable to update bulletinboard with saved scope: " + exception.getMessage()));
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postServerData-" + bl));
        }
        return bl;
    }

    private void removeSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, boolean bl) {
        SubjectInfo subjectInfo = null;
        try {
            subjectInfo = this.createSubjectInfo(cGBridgeBBRemoteSubscriptionMsg);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"problem creating subjectInfo to remove bulletin board");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.coregroupbridge.CGBridge.processGSRSubscription", (String)"3983", (Object)this);
        }
        this.removeSubject(cGBridgeBBRemoteSubscriptionMsg, subjectInfo, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubject(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, SubjectInfo subjectInfo, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeSubject-" + cGBridgeBBRemoteSubscriptionMsg));
        }
        if (cGBridgeBBRemoteSubscriptionMsg != null) {
            HashMap hashMap;
            if (bl) {
                this.updateRoutingtbl.removeAllRouteEntries(cGBridgeBBRemoteSubscriptionMsg);
            } else {
                this.updateRoutingtbl.removeRouteEntry(cGBridgeBBRemoteSubscriptionMsg, null, cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData());
            }
            Object object = this.interCGBridgeCoreGroups;
            synchronized (object) {
                hashMap = new HashMap(this.interCGBridgeCoreGroups);
            }
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)object.next();
                interBridgeCoreGroup.removePeerSubscription(cGBridgeBBRemoteSubscriptionMsg);
            }
        }
        if (subjectInfo != null) {
            if (bl) {
                this.subscriptionTracker.unsubscribe(subjectInfo, false);
            }
            this.subjectPostCache.remove(subjectInfo);
        }
    }

    void unsubscribe(GroupMemberId[] groupMemberIdArray, InterBridgeCoreGroup interBridgeCoreGroup) {
        this.subjectPostCache.remove(groupMemberIdArray, interBridgeCoreGroup);
        this.subscriptionTracker.removeSubscriptions(groupMemberIdArray);
    }

    public void removeDeadServers(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeDeadServers");
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            this.processRebuildState(false, CACHED_LOCAL_STATE_REMOVE_COORDINATORS, null, null, groupMemberIdArray, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDeadServers");
        }
    }

    public void electedAsManagerBegin() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"electedAsManagerBegin");
        }
    }

    public void notElectedAsManager(GroupMemberId[] groupMemberIdArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"notElectedAsManager");
        }
    }

    private void removeRebuildSubscriptions(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRebuildSubscriptions");
        }
        if (this.rebuildSubscriptionsToRemove.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("rebuildSubscriptionsToRemove size=" + this.rebuildSubscriptionsToRemove.size()));
            }
            Iterator iterator = this.rebuildSubscriptionsToRemove.iterator();
            while (iterator.hasNext()) {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                if (collection.contains(cGBridgeBBRemoteSubscriptionMsg)) continue;
                if (this.isMessageForLocalPMG(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode())) {
                    this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, false);
                    continue;
                }
                this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, true);
            }
            this.rebuildSubscriptionsToRemove = new HashSet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRebuildSubscriptions");
        }
    }

    GSRSubscriptionAction processGSRSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        GSRSubscriptionAction gSRSubscriptionAction;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("processGSRSubscription-" + cGBridgeBBRemoteSubscriptionMsg));
            }
            int n = CGBridgeUtils.determineMembertoSend(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), this.intraCellManagers.length);
            gSRSubscriptionAction = GSRSubscriptionAction.NO_SUBSCRIPTION_ACTION;
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("local index versus chosenserver: " + this.intraCellCurrentIndex + " " + n));
            }
            if (n == this.intraCellCurrentIndex) {
                gSRSubscriptionAction = GSRSubscriptionAction.PROCESS_SUBSCRIPTION;
                this.updateRoutingtbl.addRoute(cGBridgeBBRemoteSubscriptionMsg, null, null, null);
                try {
                    Set set = this.subjectPostCache.getPostingCoreGroups(this.createSubjectInfo(cGBridgeBBRemoteSubscriptionMsg));
                    if (set != null) {
                        cGBridgeBBRemoteSubscriptionMsg.setPostingCoreGroups(set);
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems creating subject info: " + exception.getMessage()));
                    }
                    break block8;
                }
            }
            gSRSubscriptionAction = GSRSubscriptionAction.REMOVE_SUBSCRIPTION;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processGSRSubscription-" + gSRSubscriptionAction));
        }
        return gSRSubscriptionAction;
    }

    private String formatCoreGroups(Set set) {
        if (set == null || set.size() == 0) {
            return " ";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        Iterator iterator = set.iterator();
        stringBuffer.append(NEW_LINE);
        int n = 0;
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append(' ');
            if (++n % 3 != 0) continue;
            stringBuffer.append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    SubjectInfo createSubjectInfo(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) throws Exception {
        return this.createSubjectInfo(this.createBulletinBoard(cGBridgeBBRemoteSubscriptionMsg.getBBName()), cGBridgeBBRemoteSubscriptionMsg.getSubject(), this.determineScope(cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData()));
    }

    Set getSubjectInfoSet(Set set) {
        HashSet<SubjectInfo> hashSet = new HashSet<SubjectInfo>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
            try {
                hashSet.add(this.createSubjectInfo(cGBridgeBBRemoteSubscriptionMsg));
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("problems creating subjectInfo for: " + cGBridgeBBRemoteSubscriptionMsg));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("# sub info set members = " + hashSet.size()));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeViewChangeProcessingComplete(int n, String string, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bridgeViewChangeProcessingComplete", (Object)new Object[]{new Integer(n)});
        }
        Set set2 = this.currentSetOfSubsOwned;
        synchronized (set2) {
            if (this.bridgeViewChangeRegister != null && this.bridgeViewChangeRegister.getBridgeViewChangeIDMap() == n) {
                try {
                    this.reconcileRebuildSubjects();
                    this.reconcileNonLocalSubsToPotentiallyExpectPostsFor();
                    this.removeRebuildSubscriptions(this.currentSetOfSubsOwned);
                    Set set3 = this.getSubjectInfoSet(this.currentSetOfSubsOwned);
                    set3.addAll(this.getSubjectInfoSet(this.nonLocalSubsToPotentiallyExpectPostsFor));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("complete: currently owned subscription keys: " + set3));
                    }
                    this.cgbridgeService.bridgeSynchronized(set3);
                    this.oldSetOfSubsOwned = new HashSet(this.currentSetOfSubsOwned);
                    this.setLocalGSRProcessingState(PROCESS_GSR_STATE_COMPLETE);
                    if (tc.isInfoEnabled()) {
                        Tr.info((TraceComponent)tc, (String)"CWRCB0121", (Object)new Object[]{this.config.getFullCoreGroupName(), this.formatCoreGroups(set)});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"foreign state rebuild complete");
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems calling bridgeStateSynchronized: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.coregroupbridge.CGBridge.bridgeViewChangeProcessingComplete", (String)"459", (Object)this);
                }
            }
        }
        this.processStoredState();
        this.synchronizedCoreGroups.printPostCacheSize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeViewChangeProcessingComplete");
        }
    }

    private String getFormattedTimedOutServers(Map map) {
        Iterator iterator = map.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append(NEW_LINE).append(string).append(":").append(string2);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileRebuildSubjects() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconcileRebuildSubjects");
        }
        this.setReconcilingSubjects(true);
        try {
            Set set = this.currentSetOfSubsOwned;
            synchronized (set) {
                Iterator iterator = this.oldSetOfSubsOwned.iterator();
                while (iterator.hasNext()) {
                    CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                    if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("reconcile sub=" + cGBridgeBBRemoteSubscriptionMsg));
                    }
                    if (this.currentSetOfSubsOwned.contains(cGBridgeBBRemoteSubscriptionMsg)) continue;
                    if (this.isMessageForLocalPMG(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode())) {
                        this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, false);
                        continue;
                    }
                    this.removeSubscription(cGBridgeBBRemoteSubscriptionMsg, true);
                }
            }
        }
        catch (Exception exception) {
            this.setReconcilingSubjects(false);
            throw exception;
        }
        this.setReconcilingSubjects(false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconcileRebuildSubjects");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeViewChangeProcessingTimedOut(int n, Map map, String string, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bridgeViewChangeProcessingTimedOut", (Object)new Object[]{new Integer(n), map, set});
        }
        Set set2 = this.currentSetOfSubsOwned;
        synchronized (set2) {
            if (this.bridgeViewChangeRegister != null && this.bridgeViewChangeRegister.getBridgeViewChangeIDMap() == n) {
                try {
                    Set set3;
                    boolean bl = false;
                    if (this.isStateIncompleteFromCoordinators()) {
                        if (this.cachedGSRReceivedLocalState != null) {
                            bl = true;
                        }
                        this.resetCoordinatorsWithIncompleteState();
                    }
                    if (bl) {
                        set3 = this.extractSubscriptions(this.cachedGSRReceivedLocalState, false);
                        this.resetCachedLocalState();
                        this.processNewGSRSubscriptions(set3, true, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Updates for these subs may not be back in time for foreign state rebuild: " + set3));
                        }
                        CGBException cGBException = new CGBException("TimedOut: Updates for subs may not be back in time for foreign state rebuild to complete");
                        FFDCFilter.processException((Throwable)cGBException, (String)(this.getClass().getName() + ".bridgeViewChangeProcessingTimedOut"), (String)"4044", (Object)this);
                    }
                    this.reconcileNonLocalSubsToPotentiallyExpectPostsFor();
                    this.removeRebuildSubscriptions(this.currentSetOfSubsOwned);
                    set3 = this.getSubjectInfoSet(this.currentSetOfSubsOwned);
                    set3.addAll(this.getSubjectInfoSet(this.nonLocalSubsToPotentiallyExpectPostsFor));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("timedout: currently owned subscription keys: " + set3));
                    }
                    this.cgbridgeService.bridgeSynchronized(set3);
                    this.oldSetOfSubsOwned = new HashSet(this.currentSetOfSubsOwned);
                    this.setLocalGSRProcessingState(PROCESS_GSR_STATE_COMPLETE);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems calling bridgeStateSynchronized: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".bridgeViewChangeProcessingTimedOut"), (String)"4059", (Object)this);
                }
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"CWRCB0122", (Object)new Object[]{new Long(this.getViewChangeRebuildWaitTime() / 1000L), this.formatCoreGroups(set)});
                }
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"CWRCB0123", (Object)this.getFormattedTimedOutServers(map));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"foreign state rebuild complete");
                }
            }
        }
        this.processStoredState();
        this.synchronizedCoreGroups.printPostCacheSize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeViewChangeProcessingTimedOut");
        }
    }

    EnumType processRebuildState(boolean bl, EnumType enumType, Map map, CGBridgeGSRLocalStateMsg cGBridgeGSRLocalStateMsg, GroupMemberId[] groupMemberIdArray, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processRebuildState");
        }
        EnumType enumType2 = this.processGSRSubscriptions(bl, enumType, map, cGBridgeGSRLocalStateMsg, groupMemberIdArray, set);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("type=" + enumType2 + ", isQueueSubscriptionCache=" + this.getAPGTopology().isQueueLocalStateProcessing()));
        }
        if (!this.getAPGTopology().isQueueLocalStateProcessing() || this.getAPGTopology().isQueueLocalStateProcessing() && this.isBridgeRebuildStable()) {
            this.processStoredLocalUpdateRegistries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processRebuildState", (Object)enumType2);
        }
        return enumType2;
    }

    void resetCachedLocalState() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset cached local state");
        }
        this.cachedGSRReceivedLocalState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateCurrentSetOfSubs(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateCurrentSetOfSubs-" + cGBridgeBBRemoteSubscriptionMsg));
        }
        boolean bl = true;
        Set set = this.currentSetOfSubsOwned;
        synchronized (set) {
            if (this.isAddSubToCurrent) {
                if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                    if (this.currentSetOfSubsOwned.add(cGBridgeBBRemoteSubscriptionMsg) && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"successfully added sub");
                    }
                } else if (this.currentSetOfSubsOwned.remove(cGBridgeBBRemoteSubscriptionMsg) && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"successfully removed sub");
                }
            } else {
                bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"is unsync cache sub for later processing");
                }
                if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                    if (this.subsReceivedWhileWaitingToProcessLocalState.add(cGBridgeBBRemoteSubscriptionMsg) && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"successfully added stored sub");
                    }
                } else if (this.unSubsReceivedWhileWaitingToProcessLocalState.add(cGBridgeBBRemoteSubscriptionMsg) && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"successfully added unsubscribe stored sub");
                }
            }
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateCurrentSetOfSubs-" + bl));
        }
        return bl;
    }

    void updateActiveCoordinators(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateActiveCoordinators", (Object)new Object[]{set});
        }
        this.processRebuildState(false, CACHED_LOCAL_STATE_NONE, null, null, null, set);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateActiveCoordinators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private EnumType processGSRSubscriptions(boolean bl, EnumType enumType, Map map, CGBridgeGSRLocalStateMsg cGBridgeGSRLocalStateMsg, GroupMemberId[] groupMemberIdArray, Set set) {
        EnumType enumType2;
        Set set2;
        HashMap hashMap;
        block84: {
            block86: {
                Iterator iterator;
                SubscriptionOrganizer subscriptionOrganizer;
                Iterator iterator2;
                Object object;
                HashMap hashMap2;
                block87: {
                    block85: {
                        block80: {
                            block83: {
                                block82: {
                                    block81: {
                                        hashMap2 = null;
                                        hashMap = null;
                                        set2 = null;
                                        enumType2 = PROCESS_GSR_STATE_WAITING_FOR_STATE_COMPLETE_MSGS;
                                        Set set3 = this.currentSetOfSubsOwned;
                                        // MONITORENTER : set3
                                        if (tc.isEntryEnabled()) {
                                            Tr.entry((TraceComponent)tc, (String)"processGSRSubscriptions", (Object)new Object[]{new Boolean(bl), enumType, map, cGBridgeGSRLocalStateMsg, groupMemberIdArray});
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("activeCoordinators=" + this.activeCoordinators));
                                        }
                                        if (set != null) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("Received updated set of coordinators: " + set));
                                            }
                                            this.activeCoordinators = set;
                                            this.resetCoordinatorsWithIncompleteState();
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("cached local state=" + this.cachedGSRReceivedLocalState));
                                        }
                                        if (enumType != CACHED_LOCAL_STATE_STABILIZED) break block81;
                                        this.isLocalPMGStable = true;
                                        break block80;
                                    }
                                    if (enumType != CACHED_LOCAL_STATE_BRIDGE_VIEW_CHANGE) break block82;
                                    this.cachedGSRReceivedLocalState = this.convertMapPMGStateToUseServerNameAsKey(map);
                                    this.isLocalPMGStable = false;
                                    this.resetCoordinatorsWithIncompleteState();
                                    break block80;
                                }
                                if (enumType != CACHED_LOCAL_STATE_UPDATE_FOR_GSR_SERVER || cGBridgeGSRLocalStateMsg == null) break block83;
                                if (this.cachedGSRReceivedLocalState != null) {
                                    this.cachedGSRReceivedLocalState.put(cGBridgeGSRLocalStateMsg.getFullServerName(), cGBridgeGSRLocalStateMsg.getSerializedState());
                                    this.removeCoordinatorWithIncompleteState(cGBridgeGSRLocalStateMsg.getFullServerName());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("updated cached local state for " + cGBridgeGSRLocalStateMsg.getFullServerName()));
                                    }
                                }
                                break block80;
                            }
                            if (enumType == CACHED_LOCAL_STATE_FOR_NEW_SERVERS_ONLINE) {
                                if (this.cachedGSRReceivedLocalState != null) {
                                    Map map2 = this.convertMapPMGStateToUseServerNameAsKey(map);
                                    this.cachedGSRReceivedLocalState.putAll(map2);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"remove all new servers online as coordinators w/ incomplete state");
                                    }
                                    object = map2.keySet().iterator();
                                    while (object.hasNext()) {
                                        this.removeCoordinatorWithIncompleteState((String)object.next());
                                    }
                                    break block80;
                                } else {
                                    enumType2 = PROCESS_GSR_STATE_DID_NOT_PROCESS_NEW_SERVERS_ONLINE;
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                    }
                                    // MONITOREXIT : set3
                                    return enumType2;
                                }
                            }
                            if (enumType == CACHED_LOCAL_STATE_REMOVE_COORDINATORS) {
                                boolean bl2 = false;
                                if (this.cachedGSRReceivedLocalState != null && groupMemberIdArray != null) {
                                    for (int i = 0; i < groupMemberIdArray.length; ++i) {
                                        if (this.cachedGSRReceivedLocalState.remove(groupMemberIdArray[i].getServerName()) != null) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("removed state for: " + groupMemberIdArray[i].getServerName()));
                                            }
                                            bl2 = true;
                                        }
                                        this.removeCoordinatorWithIncompleteState(groupMemberIdArray[i].getServerName());
                                    }
                                }
                                if (!bl2) {
                                    enumType2 = PROCESS_GSR_STATE_DID_NOT_REMOVE_ANY_DEAD_COORDINATORS;
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                    }
                                    // MONITOREXIT : set3
                                    return enumType2;
                                }
                            }
                        }
                        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                            if (bl) {
                                if (this.bridgeViewChangeRegister != null) {
                                    this.bridgeViewChangeRegister.setTerminated();
                                    this.bridgeViewChangeRegister.cancelAlarm();
                                }
                                this.isAddSubToCurrent = false;
                                this.setBridgeUnstable();
                                ++this.gsrViewChangeIdentifier;
                                if (tc.isInfoEnabled()) {
                                    Tr.info((TraceComponent)tc, (String)"CWRCB0120", (Object)this.config.getFullCoreGroupName());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("view ID =" + this.gsrViewChangeIdentifier));
                                }
                                this.bridgeViewChangeRegister = new BridgeViewChangeRegister(this.gsrViewChangeIdentifier, this.viewChangeRebuildWaitTime, this, this.config.getServerName());
                                this.bridgeViewChangeRegister.startTimer();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("isLocalPMGStable=" + this.isLocalPMGStable));
                            }
                            if (!this.isLocalPMGStable || !this.isGSRAndBridgeViewsStable()) {
                                enumType2 = PROCESS_GSR_STATE_UNSTABLE;
                                this.setLocalGSRProcessingState(PROCESS_GSR_STATE_UNSTABLE);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                }
                                // MONITOREXIT : set3
                                return enumType2;
                            }
                        }
                        boolean bl3 = false;
                        if (this.cachedGSRReceivedLocalState == null || this.cachedGSRReceivedLocalState.size() == 0) {
                            bl3 = true;
                        }
                        Map map3 = this.cachedGSRReceivedLocalState;
                        if (bl3) {
                            enumType2 = PROCESS_GSR_STATE_NO_STATE;
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                            }
                            this.setLocalGSRProcessingState(PROCESS_GSR_STATE_COMPLETE);
                            this.processStoredState();
                            // MONITOREXIT : set3
                            return enumType2;
                        }
                        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                            if (!this.cgbridgeService.isUnsynchronized()) {
                                enumType2 = PROCESS_GSR_STATE_NOT_UNSYNCHRONIZED;
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                }
                                this.setLocalGSRProcessingState(PROCESS_GSR_STATE_COMPLETE);
                                this.processStoredState();
                                // MONITOREXIT : set3
                                return enumType2;
                            }
                            if (this.isStateIncompleteFromCoordinators()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"waiting for state from coordinators");
                                }
                                enumType2 = PROCESS_GSR_STATE_WAITING_FOR_GSR_STATE;
                                this.setLocalGSRProcessingState(enumType2);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                }
                                // MONITOREXIT : set3
                                return enumType2;
                            }
                            if (this.activeCoordinators == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"no active coordinators defined");
                                }
                                enumType2 = PROCESS_GSR_STATE_NO_ACTIVE_COORDINATORS_SPECIFIED;
                                this.setLocalGSRProcessingState(enumType2);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                }
                                // MONITOREXIT : set3
                                return enumType2;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"local cg managers");
                            for (int i = 0; i < this.intraCellManagers.length; ++i) {
                                Tr.debug((TraceComponent)tc, (String)this.intraCellManagers[i].getServerName());
                            }
                            Tr.debug((TraceComponent)tc, (String)("received map size: " + map3.size()));
                        }
                        set2 = this.extractSubscriptions(map3, true);
                        if (!this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) break block84;
                        this.setLocalGSRProcessingState(PROCESS_GSR_STATE_PROCESSING);
                        if (this.isStateIncompleteFromCoordinators()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"waiting for state from coordinators and/or bridges");
                            }
                            this.sendStateRequestMsgToCoordinatorsWithIncompleteState();
                            enumType2 = PROCESS_GSR_STATE_WAITING_FOR_GSR_STATE;
                            this.setLocalGSRProcessingState(PROCESS_GSR_STATE_WAITING_FOR_GSR_STATE);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                            }
                            // MONITOREXIT : set3
                            return enumType2;
                        }
                        this.resetCachedLocalState();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("unSubsReceivedWhileWaitingToProcessLocalState=" + this.unSubsReceivedWhileWaitingToProcessLocalState.size()));
                        }
                        if (this.unSubsReceivedWhileWaitingToProcessLocalState.size() > 0) {
                            set2.removeAll(this.unSubsReceivedWhileWaitingToProcessLocalState);
                            this.unSubsReceivedWhileWaitingToProcessLocalState = new HashSet();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("subsReceivedWhileWaitingToProcessLocalState=" + this.subsReceivedWhileWaitingToProcessLocalState.size()));
                        }
                        if (this.subsReceivedWhileWaitingToProcessLocalState.size() > 0) {
                            set2.addAll(this.subsReceivedWhileWaitingToProcessLocalState);
                            this.subsReceivedWhileWaitingToProcessLocalState = new HashSet();
                        }
                        this.isAddSubToCurrent = true;
                        if (set2.size() == 0) {
                            if (tc.isDebugEnabled()) {
                                if (this.oldSetOfSubsOwned == null) {
                                    Tr.debug((TraceComponent)tc, (String)"oldSetOfSubsOwned==null");
                                } else {
                                    Tr.debug((TraceComponent)tc, (String)("oldSetOfSubsOwned.size()=" + this.oldSetOfSubsOwned.size()));
                                }
                            }
                            if (this.oldSetOfSubsOwned == null || this.oldSetOfSubsOwned.size() == 0) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"old set is empty so proceed w/ call foreign state sync ");
                                }
                            } else {
                                enumType2 = PROCESS_GSR_STATE_NO_SUBSCRIPTIONS;
                                this.setLocalGSRProcessingState(PROCESS_GSR_STATE_NO_SUBSCRIPTIONS);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions - " + enumType2));
                                }
                                // MONITOREXIT : set3
                                return enumType2;
                            }
                        }
                        iterator2 = this.interCGBridgeCoreGroups;
                        // MONITORENTER : iterator2
                        HashMap hashMap3 = new HashMap(this.interCGBridgeCoreGroups);
                        // MONITOREXIT : iterator2
                        iterator2 = hashMap3.entrySet().iterator();
                        hashMap2 = new HashMap();
                        hashMap = new HashMap();
                        while (iterator2.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator2.next();
                            InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)entry.getValue();
                            if (interBridgeCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                                hashMap2.put(entry.getKey(), interBridgeCoreGroup);
                                continue;
                            }
                            hashMap.put(entry.getKey(), interBridgeCoreGroup);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("optimized ibcgs=" + hashMap2));
                            Tr.debug((TraceComponent)tc, (String)("unoptimized ibcgs=" + hashMap));
                        }
                        if (hashMap2.size() <= 0) break block85;
                        if (this.oldSetOfSubsOwned == null) {
                            this.oldSetOfSubsOwned = new HashSet(this.currentSetOfSubsOwned);
                        } else {
                            this.oldSetOfSubsOwned.addAll(this.currentSetOfSubsOwned);
                        }
                        this.currentSetOfSubsOwned.clear();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("receivedSubscriptionSet.size()=" + set2.size()));
                        }
                        this.rebuildSubscriptionsToRemove = new HashSet();
                        if (set2.size() <= 0) break block86;
                        subscriptionOrganizer = new SubscriptionOrganizer();
                        iterator = set2.iterator();
                        break block87;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no optimized ibcgs to communicate with");
                    }
                    if (this.cgbridgeService.isUnsynchronized()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Not expecting updates from any peer bridges");
                        }
                        enumType2 = PROCESS_GSR_STATE_NO_STATE_TO_WAIT_FOR;
                        this.bridgeViewChangeRegister.cancelAlarm();
                        this.bridgeViewChangeRegister.setTerminated();
                        this.bridgeViewChangeProcessingComplete(this.bridgeViewChangeRegister.getBridgeViewChangeIDMap(), this.bridgeViewChangeRegister.getFqServerName(), this.bridgeViewChangeRegister.getAvailableCoreGroups());
                    }
                    break block84;
                }
                while (iterator.hasNext()) {
                    object = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                    GSRSubscriptionAction gSRSubscriptionAction = this.processGSRSubscription((CGBridgeBBRemoteSubscriptionMsg)object);
                    if (gSRSubscriptionAction == GSRSubscriptionAction.PROCESS_SUBSCRIPTION) {
                        subscriptionOrganizer.addSubscription((CGBridgeBBRemoteSubscriptionMsg)object);
                        continue;
                    }
                    if (gSRSubscriptionAction != GSRSubscriptionAction.REMOVE_SUBSCRIPTION) continue;
                    this.rebuildSubscriptionsToRemove.add(object);
                }
                HashSet hashSet = new HashSet();
                hashSet.addAll(subscriptionOrganizer.getNonRemoteSubscriptions());
                if (subscriptionOrganizer.getRemoteSubscriptions().size() > 0) {
                    iterator2 = subscriptionOrganizer.getRemoteSubscriptions().values().iterator();
                    while (iterator2.hasNext()) {
                        hashSet.addAll((Set)iterator2.next());
                    }
                }
                if (hashSet.size() > 0) {
                    this.currentSetOfSubsOwned.addAll(hashSet);
                }
                if (!this.rebuildSubscriptionsToRemove.isEmpty()) {
                    this.removeGSRSubscriptionsFromIBCGs(this.rebuildSubscriptionsToRemove, hashMap2);
                }
                this.storeGSRSubscriptionsInIBCGs(subscriptionOrganizer, hashMap2, this.gsrViewChangeIdentifier);
                this.sendGSRSubscriptionsToIBCGs(subscriptionOrganizer, this.config.getFullCoreGroupName(), this.gsrViewChangeIdentifier, hashMap2, this.bridgeViewChangeRegister);
            }
            if (this.bridgeViewChangeRegister.getCoreGroupMap().size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not expecting updates from any peer bridges");
                }
                enumType2 = PROCESS_GSR_STATE_NO_STATE_TO_WAIT_FOR;
                this.bridgeViewChangeRegister.cancelAlarm();
                this.bridgeViewChangeRegister.setTerminated();
                this.bridgeViewChangeProcessingComplete(this.bridgeViewChangeRegister.getBridgeViewChangeIDMap(), this.bridgeViewChangeRegister.getFqServerName(), this.bridgeViewChangeRegister.getAvailableCoreGroups());
            } else {
                this.bridgeViewChangeRegister.setBridgeRegistrationInitialized();
            }
        }
        // MONITOREXIT : set3
        if (hashMap == null || hashMap.size() > 0) {
            this.processNewGSRSubscriptions(set2, false, false);
        }
        if (!tc.isEntryEnabled()) return enumType2;
        Tr.exit((TraceComponent)tc, (String)("processGSRSubscriptions-" + enumType2));
        return enumType2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCoordinatorsWithIncompleteState() {
        Map map = this.coordinatorsWithIncompleteState;
        synchronized (map) {
            this.coordinatorsWithIncompleteState.clear();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset coordinatorsWithIncompleteState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStateIncompleteFromCoordinators() {
        Map map = this.coordinatorsWithIncompleteState;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("coordinatorsWithIncompleteState=" + this.coordinatorsWithIncompleteState));
            }
            return this.coordinatorsWithIncompleteState.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCoordinatorNeedingState(String string, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add coordinatorsWithIncompleteState: " + string + ", isSendRequestforState=" + bl));
        }
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        Map map = this.coordinatorsWithIncompleteState;
        synchronized (map) {
            if (this.coordinatorsWithIncompleteState.containsKey(string)) {
                if (bl2.booleanValue()) {
                    this.coordinatorsWithIncompleteState.put(string, bl2);
                }
            } else {
                this.coordinatorsWithIncompleteState.put(string, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCoordinatorWithIncompleteState(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("remove coordinatorsWithIncompleteState: " + string));
        }
        Map map = this.coordinatorsWithIncompleteState;
        synchronized (map) {
            if (this.coordinatorsWithIncompleteState.remove(string) != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("successfully removed coordinator w/ incomplete state: " + string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateRequestMsgToCoordinatorsWithIncompleteState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendStateRequestMsgToCoordinatorsWithIncompleteState");
        }
        Map map = this.coordinatorsWithIncompleteState;
        synchronized (map) {
            if (this.coordinatorsWithIncompleteState.size() > 0) {
                byte[] byArray;
                CGBridgeGSRStateRequestMsg cGBridgeGSRStateRequestMsg = new CGBridgeGSRStateRequestMsg(this.config.getFullServerName(), this.activeCoordinators);
                try {
                    byArray = cGBridgeGSRStateRequestMsg.marshallData();
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems serialzing state request msg: " + iOException.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".sendStateRequestMsgToCoordinatorsWithIncompleteState"), (String)"7311", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"sendStateRequestMsgToCoordinatorsWithIncompleteState");
                    }
                    return;
                }
                Iterator iterator = this.coordinatorsWithIncompleteState.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Boolean bl = (Boolean)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("serverName=" + string + ", val=" + bl));
                    }
                    if (!bl.booleanValue()) continue;
                    GroupMemberId groupMemberId = (GroupMemberId)this.localBridgesAndCoordinatorsMap.get(string);
                    if (groupMemberId == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("SHOULD not occur: no gmid available for: " + string));
                        }
                        FFDCFilter.processException((Throwable)new IllegalStateException("A GroupMemberId should exist for coordinator"), (String)(this.getClass().getName() + ".sendStateRequestMsgToCoordinatorsWithIncompleteState"), (String)"7365", (Object)this);
                        continue;
                    }
                    this.cgbridgeService.getCGBSubscriptionRouter().sendStateRequstMsgForBridge(groupMemberId, byArray);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendStateRequestMsgToCoordinatorsWithIncompleteState");
        }
    }

    private Set extractSubscriptions(Map map, boolean bl) {
        Object object;
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractSubscriptions", (Object)new Object[]{map, new Boolean(bl)});
        }
        HashSet hashSet = new HashSet();
        if (map == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"extractSubscriptions-null state");
            }
            return hashSet;
        }
        Iterator iterator2 = map.keySet().iterator();
        Set set = this.activeCoordinators;
        HashSet<String> hashSet2 = new HashSet<String>();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("expectedCoordinators=" + set));
        }
        while (iterator2.hasNext()) {
            try {
                String string = (String)iterator2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Parsing map from server: " + string));
                }
                List list = this.getSubscriptions(map.get(string));
                if (!this.localBridgesAndCoordinatorsMap.containsKey(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remove state:  no gmid exists for: " + string));
                    }
                    iterator2.remove();
                    continue;
                }
                if (list == null) continue;
                if (list.size() > 0 && (iterator = list.get(0)) != null && iterator instanceof Map) {
                    object = (Map)((Object)iterator);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("first object is Map: " + object));
                    }
                    list.remove(0);
                    if (bl) {
                        boolean bl2 = false;
                        Set set2 = (Set)object.get("Active Coordinators");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("coordinator/bridge has the following active coordinators: " + set2));
                        }
                        if (set2 != null) {
                            hashSet2.add(string);
                            if (set2.size() != set.size() || !set.containsAll(set2)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(string + ": The received set of coordinators does not match the expected"));
                                }
                                bl2 = true;
                            }
                        } else if (set2 == null && set.contains(string)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("coordinatorActiveCoordinators==null: " + string));
                            }
                            bl2 = true;
                        }
                        if (bl2) {
                            this.addCoordinatorNeedingState(string, true);
                        }
                        if (object.containsKey("Subs unavailable")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("incomplete state sent by: " + string));
                            }
                            this.addCoordinatorNeedingState(string, true);
                        }
                    }
                }
                hashSet.addAll(list);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("problem serializing subscriptions " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".extractSubscriptions"), (String)"8565", (Object)this);
            }
        }
        if (bl) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (hashSet2.contains(object)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Did not receive state from: " + (String)object));
                }
                this.addCoordinatorNeedingState((String)object, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractSubscriptions");
        }
        return hashSet;
    }

    private void processNewGSRSubscriptions(Set set, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processNewGSRSubscriptions", (Object)new Object[]{set, new Boolean(bl), new Boolean(bl2)});
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                int n = CGBridgeUtils.determineMembertoSend(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), this.intraCellManagers.length);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("hashid/memberlength: " + cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode() + "/ " + this.intraCellManagers.length));
                    Tr.debug((TraceComponent)tc, (String)("local index versus chosenserver: " + this.intraCellCurrentIndex + " " + n));
                }
                if (n == this.intraCellCurrentIndex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Received subscription & re processing message (subscribe) " + cGBridgeBBRemoteSubscriptionMsg.getBBName() + "/" + cGBridgeBBRemoteSubscriptionMsg.getSubject()));
                    }
                    if (bl) {
                        this.updateCurrentSetOfSubs(cGBridgeBBRemoteSubscriptionMsg);
                    }
                    this.processCGBridgeMsg(cGBridgeBBRemoteSubscriptionMsg, null, null, null, null, false, null, null, false);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received subscription & re processing message (UNsubscribe)" + cGBridgeBBRemoteSubscriptionMsg.getBBName() + "/" + cGBridgeBBRemoteSubscriptionMsg.getSubject()));
                }
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg2 = new CGBridgeBBRemoteSubscriptionMsg(cGBridgeBBRemoteSubscriptionMsg, false);
                this.processCGBridgeMsg(cGBridgeBBRemoteSubscriptionMsg2, null, null, null, null, bl2, null, null, false);
                if (!bl) continue;
                this.updateCurrentSetOfSubs(cGBridgeBBRemoteSubscriptionMsg);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("problems processing subscriptions: " + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processNewGSRSubscriptions");
        }
    }

    private void setBridgeUnstable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBridgeUnstable");
        }
        try {
            Set<String> set;
            if (this.intraCellManagers == null || this.intraCellManagers.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"using config server name");
                }
                set = new HashSet();
                set.add(CGBridgeService.getInstance().getLocalServerName());
            } else {
                set = CGBridgeUtils.getServerNames(this.intraCellManagers);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("active bridges = " + set));
            }
            CGBridgeService.getInstance().bridgeUnsynchronized(set);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problems calling bridgeStateUnsychronized: " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "setBridgeUnstable"), (String)"60", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBridgeUnstable");
        }
    }

    private List getSubscriptions(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubscriptions");
        }
        ArrayList arrayList = null;
        byte[] byArray = (byte[])object;
        if (byArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("value.length=" + byArray.length));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            arrayList = (ArrayList)objectInputStream.readObject();
            byteArrayInputStream.close();
            objectInputStream.close();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"value == null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubscriptions", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isGSRAndBridgeViewsStable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGSRAndBridgeViewsStable");
        }
        HashMap hashMap = this.interCGBridgeCoreGroups;
        synchronized (hashMap) {
            Iterator iterator = this.interCGBridgeCoreGroups.values().iterator();
            while (iterator.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)iterator.next();
                boolean bl = interBridgeCoreGroup.isPrimaryMgdGroupStable();
                if (bl && interBridgeCoreGroup.isGroupMembersEqual(this.intraCellManagers)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(interBridgeCoreGroup.getAccessPointGroupName() + " isPrimaryMgdGroupStable()=" + bl));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"isGSRAndBridgeViewsStable-false");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isGSRAndBridgeViewsStable-true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyIBCGSAboutActiveBridges() {
        HashMap hashMap;
        Object object = this.interCGBridgeCoreGroups;
        synchronized (object) {
            hashMap = new HashMap(this.interCGBridgeCoreGroups);
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)object.next();
            if (!interBridgeCoreGroup.updateInterAndLocalPMGBridgesMatched(this.intraCellManagers)) continue;
            interBridgeCoreGroup.processCachedNotifySubscriptions(null);
        }
    }

    Map convertMapPMGStateToUseServerNameAsKey(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertMapPMGStateToUseServerNameAsKey", (Object)new Object[]{map});
        }
        if (map == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"convertMapPMGStateToUseServerNameAsKey-null");
            }
            return null;
        }
        Iterator iterator = map.keySet().iterator();
        HashMap hashMap = new HashMap(4);
        while (iterator.hasNext()) {
            GroupMemberId groupMemberId = (GroupMemberId)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("state server name: " + groupMemberId.getServerName()));
            }
            hashMap.put(groupMemberId.getServerName(), map.get(groupMemberId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertMapPMGStateToUseServerNameAsKey", hashMap);
        }
        return hashMap;
    }

    void processCoordinatorState(CGBridgeGSRLocalStateMsg cGBridgeGSRLocalStateMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processCoordinatorState", (Object)new Object[]{cGBridgeGSRLocalStateMsg});
        }
        this.processRebuildState(false, CACHED_LOCAL_STATE_UPDATE_FOR_GSR_SERVER, null, cGBridgeGSRLocalStateMsg, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processCoordinatorState");
        }
    }

    public void processNewCoordinatorState(Map map, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processNewCoordinatorState-" + bl), (Object)map);
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            if (bl) {
                this.processRebuildState(true, CACHED_LOCAL_STATE_BRIDGE_VIEW_CHANGE, map, null, null, null);
            } else if (this.processRebuildState(false, CACHED_LOCAL_STATE_FOR_NEW_SERVERS_ONLINE, map, null, null, null) == PROCESS_GSR_STATE_DID_NOT_PROCESS_NEW_SERVERS_ONLINE) {
                Set set = this.extractSubscriptions(this.convertMapPMGStateToUseServerNameAsKey(map), false);
                this.processNewGSRSubscriptions(set, true, true);
            }
        } else {
            block9: {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("problems sleeping" + exception.getMessage()));
                }
            }
            Set set = this.extractSubscriptions(this.convertMapPMGStateToUseServerNameAsKey(map), false);
            this.processNewGSRSubscriptions(set, false, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processNewCoordinatorState");
        }
    }

    public void electedAsManagerEnd(Map map) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMessageForLocalPMG(int n) {
        Object object = this.currentIndexLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("local gmid length=" + this.intraCellManagers.length));
            }
            return this.intraCellCurrentIndex == CGBridgeUtils.determineMembertoSend(n, this.intraCellManagers.length == 0 ? 1 : this.intraCellManagers.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getLocalState(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalState");
        }
        this.oldIntraCellManagers = this.intraCellManagers;
        GroupMemberId[] groupMemberIdArray2 = new GroupMemberId[groupMemberIdArray.length];
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            groupMemberIdArray2[i] = groupMemberIdArray[i];
        }
        Arrays.sort(groupMemberIdArray2, LocalGroupMemberIdComparator.getInstance());
        Object object = this.currentIndexLock;
        synchronized (object) {
            this.intraCellManagers = groupMemberIdArray2;
            for (int i = 0; i < this.intraCellManagers.length; ++i) {
                if (!this.intraCellManagers[i].getServerName().equals(this.bridgeLocalGmid.getServerName())) continue;
                this.intraCellCurrentIndex = i;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Current local index is now: " + this.intraCellCurrentIndex));
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalState");
        }
        object = new byte[groupMemberIdArray.length][];
        return object;
    }

    public void newServersOnline(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"newServersOnline");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"newServersOnline");
        }
    }

    public void waitingForNewServers() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"waitingForNewServers");
        }
    }

    protected String getLocalCellName() {
        return this.localCellName;
    }

    String getFullProcessName() {
        return this.haFullProcessName;
    }

    protected void setLocalGroupMember(GroupMemberId groupMemberId) {
        this.bridgeLocalGmid = groupMemberId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownBridge() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"shutting down bridge(s)");
        }
        HashMap hashMap = this.interCGBridgeCoreGroups;
        synchronized (hashMap) {
            Iterator iterator = this.interCGBridgeCoreGroups.values().iterator();
            while (iterator.hasNext()) {
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)iterator.next();
                if (interBridgeCoreGroup == null) continue;
                interBridgeCoreGroup.shutDownCoreStack();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"core group bridge(s) shutdown");
        }
    }

    GroupMemberId[] getIntraCellManagers() {
        return this.intraCellManagers;
    }

    public void mayUnstabilize() {
    }

    public void stabilized(MemberStateEnum memberStateEnum) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CGBridge stabilized");
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            this.notifyIBCGSAboutActiveBridges();
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            this.processRebuildState(false, CACHED_LOCAL_STATE_STABILIZED, null, null, null, null);
        }
    }

    public void forcedToLeaveHAGroup(String string, String string2, Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Set getAvailableCoreGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAvailableCoreGroups");
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.apgNameToAPGStatusMap.values().iterator();
        Map map = this.apgNameToAPGStatusMap;
        // MONITORENTER : map
        block2: while (true) {
            if (!iterator.hasNext()) {
                // MONITOREXIT : map
                if (!tc.isEntryEnabled()) return hashSet;
                Tr.exit((TraceComponent)tc, (String)"getAvailableCoreGroups", hashSet);
                return hashSet;
            }
            APGStatus aPGStatus = (APGStatus)iterator.next();
            if (aPGStatus.isLocalAPGStable()) {
                Iterator iterator2 = aPGStatus.getCgToGMIDMap().entrySet().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block2;
                    Map.Entry entry = iterator2.next();
                    GroupMemberId[] groupMemberIdArray = (GroupMemberId[])entry.getValue();
                    if (groupMemberIdArray == null || groupMemberIdArray.length <= 0) continue;
                    hashSet.add(entry.getKey());
                }
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("apg " + aPGStatus.getAPGName() + " is not stable"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAPGStatus(String string, String string2, Map map, boolean bl) {
        Map map2 = this.apgNameToAPGStatusMap;
        synchronized (map2) {
            this.apgNameToAPGStatusMap.put(string2, new APGStatus(string, string2, map, bl));
            this.printAPGStatus(string);
        }
    }

    private void printAPGStatus(String string) {
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0106", (Object)new Object[]{this.haFullProcessName, string});
            Iterator iterator = this.apgNameToAPGStatusMap.values().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (iterator.hasNext()) {
                APGStatus aPGStatus = (APGStatus)iterator.next();
                if (aPGStatus.isLocalAPGStable()) {
                    Iterator iterator2 = aPGStatus.getCgToGMIDMap().entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        this.createAvailableCGBridgesString(stringBuffer, aPGStatus.getAPGName(), (String)entry.getKey(), (GroupMemberId[])entry.getValue());
                    }
                    continue;
                }
                stringBuffer2.append(aPGStatus.getAPGName()).append(' ');
            }
            if (stringBuffer.length() > 0) {
                Tr.info((TraceComponent)tc, (String)"CWRCB0107", (Object)stringBuffer.toString());
            }
            if (stringBuffer2.length() > 0) {
                Tr.info((TraceComponent)tc, (String)"CWRCB0108", (Object)stringBuffer2.toString());
            }
        }
    }

    private StringBuffer createAvailableCGBridgesString(StringBuffer stringBuffer, String string, String string2, GroupMemberId[] groupMemberIdArray) {
        stringBuffer.append(NEW_LINE).append(string).append(' ').append(string2).append(' ');
        if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
            stringBuffer.append(NO_BRIDGES);
            return stringBuffer;
        }
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            stringBuffer.append(CGBridgeUtils.getFullServerName(groupMemberIdArray[i])).append(" (").append(groupMemberIdArray[i].getServerName()).append(")");
            if (i >= groupMemberIdArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer;
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{object});
        }
        this.synchronizedCoreGroups.notifyListeners(true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public void availableCoreGroupsChanged(Set set, Set set2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"availableCoreGroupsChanged", (Object)new Object[]{set, set2, new Boolean(bl)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"availableCoreGroupsChanged");
        }
    }

    BridgeViewChangeRegister getBridgeViewChangeRegister() {
        return this.bridgeViewChangeRegister;
    }

    public long getViewChangeRebuildWaitTime() {
        return this.viewChangeRebuildWaitTime;
    }

    SubscriptionTracker getSubscriptionTracker() {
        return this.subscriptionTracker;
    }

    SubjectPostCache getSubjectPostCache() {
        return this.subjectPostCache;
    }

    public SynchronizedCoreGroups getSynchronizedCoreGroups() {
        return this.synchronizedCoreGroups;
    }

    Map getInterCGBridgeCoreGroups() {
        return this.interCGBridgeCoreGroups;
    }

    boolean isBridgeViewChange() {
        if (this.oldIntraCellManagers == this.intraCellManagers) {
            return false;
        }
        if (this.oldIntraCellManagers.length != this.intraCellManagers.length) {
            return true;
        }
        if (this.oldIntraCellManagers.length == this.intraCellManagers.length) {
            for (int i = 0; i < this.intraCellManagers.length; ++i) {
                if (this.intraCellManagers[i].getServerName().equals(this.oldIntraCellManagers[i].getServerName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    GroupMemberId getBridgeLocalGmid() {
        return this.bridgeLocalGmid;
    }

    public int getMaxCoreGroupPostMsgSize() {
        return this.maxCoreGroupPostMsgSize;
    }

    void processStoredState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStoredState");
        }
        this.processStoredLocalUpdateRegistries();
        this.processStoredGSRSubsMsgs();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStoredState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStoredLocalUpdateRegistries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStoredLocalUpdateRegistries");
        }
        List list = null;
        Object object = this.storedLocalUpdateRegistries;
        synchronized (object) {
            if (this.storedLocalUpdateRegistries.size() > 0) {
                list = this.storedLocalUpdateRegistries;
                this.storedLocalUpdateRegistries = new LinkedList();
            }
        }
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry = (LocalBridgeServerUpdateRegistry)object.next();
                if (localBridgeServerUpdateRegistry.processSubCache()) continue;
                this.addStoredLocalUpdateRegistry(localBridgeServerUpdateRegistry);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no localUpdateRegistries to process");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStoredLocalUpdateRegistries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStoredLocalUpdateRegistry(LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        List list = this.storedLocalUpdateRegistries;
        synchronized (list) {
            this.storedLocalUpdateRegistries.add(localBridgeServerUpdateRegistry);
        }
    }

    AvailableCoreGroups getReachableCoreGroups() {
        return this.reachableCoreGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStoredGSRSubsMsgs() {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStoredGSRSubsMsgs");
        }
        Object object = this.localGSRProcessingStateLock;
        synchronized (object) {
            map = this.storedGSRSubMsgs;
            this.storedGSRSubMsgs = new HashMap();
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object = (Map)iterator.next();
            Iterator iterator2 = object.values().iterator();
            while (iterator2.hasNext()) {
                StoredGSRSub storedGSRSub = (StoredGSRSub)iterator2.next();
                storedGSRSub.process();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStoredGSRSubsMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoreGSRSubsMsgs(InterBridgeCoreGroup interBridgeCoreGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeStoreGSRSubsMsgs-" + interBridgeCoreGroup.getAccessPointGroupName()));
        }
        Object object = this.localGSRProcessingStateLock;
        synchronized (object) {
            this.storedGSRSubMsgs.remove(interBridgeCoreGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeStoreGSRSubsMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBridgeRebuildStable() {
        Object object = this.localGSRProcessingStateLock;
        synchronized (object) {
            return this.localGSRProcessingState != PROCESS_GSR_STATE_PROCESSING && this.localGSRProcessingState != PROCESS_GSR_STATE_UNSTABLE && this.localGSRProcessingState != PROCESS_GSR_STATE_WAITING_FOR_STATE_COMPLETE_MSGS && this.localGSRProcessingState != PROCESS_GSR_STATE_WAITING_FOR_GSR_STATE && this.localGSRProcessingState != PROCESS_GSR_STATE_NO_SUBSCRIPTIONS;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeGSRSubMsg(InterBridgeCoreGroup interBridgeCoreGroup, CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg, GroupMemberId groupMemberId, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("storeGSRSubMsg-" + cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName()), (Object)new Object[]{CGBridgeUtils.getFullServerName(groupMemberId), string});
        }
        boolean bl = false;
        Object object = this.localGSRProcessingStateLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("localGSRProcessingState=" + this.localGSRProcessingState));
            }
            if (!this.isBridgeRebuildStable()) {
                HashMap<String, StoredGSRSub> hashMap = (HashMap<String, StoredGSRSub>)this.storedGSRSubMsgs.get(interBridgeCoreGroup);
                if (hashMap == null) {
                    hashMap = new HashMap<String, StoredGSRSub>();
                    this.storedGSRSubMsgs.put(interBridgeCoreGroup, hashMap);
                }
                if (hashMap.put(cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName(), new StoredGSRSub(interBridgeCoreGroup, cGBridgeGSRSubscriptionMsg, groupMemberId, string)) != null && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removed previously stored gsrsub msg for this server: " + cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName()));
                }
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("storeGSRSubMsg-" + cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName() + "-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumType getLocalGSRProcessingState() {
        Object object = this.localGSRProcessingStateLock;
        synchronized (object) {
            return this.localGSRProcessingState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalGSRProcessingState(EnumType enumType) {
        Object object = this.localGSRProcessingStateLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("old gsr processing state=" + this.localGSRProcessingState));
            }
            this.localGSRProcessingState = enumType;
        }
    }

    public boolean isUseCounterAsPostID() {
        return this.isUseCounterAsPostID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReconcilingSubjects() {
        Object object = this.reconcilingSubjectsLock;
        synchronized (object) {
            return this.isReconcilingSubjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReconcilingSubjects(boolean bl) {
        Object object = this.reconcilingSubjectsLock;
        synchronized (object) {
            this.isReconcilingSubjects = bl;
        }
    }

    class AvailableCoreGroups {
        Map coreGroups = new HashMap();

        AvailableCoreGroups() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addCoreGroup(String string, String string2, String string3) {
            boolean bl = false;
            if (tc2.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc2, (String)("addCoreGroup-" + string), (Object)new Object[]{string2, string3});
            }
            Map map = this.coreGroups;
            synchronized (map) {
                CoreGroup coreGroup = (CoreGroup)this.coreGroups.get(string);
                if (coreGroup == null) {
                    coreGroup = new CoreGroup(string);
                    this.coreGroups.put(string, coreGroup);
                }
                if (string3 == null) {
                    bl = coreGroup.getSendingCoreGroups().add(string2);
                } else if (!coreGroup.getProxyOriginCoreGroups().contains(string3)) {
                    coreGroup.getProxyOriginCoreGroups().add(string3);
                    bl = coreGroup.getSendingCoreGroups().add(string2);
                    if (tc2.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc2, (String)("proxy origin core groups=" + coreGroup.getProxyOriginCoreGroups()));
                    }
                }
                if (tc2.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc2, (String)("sending core groups=" + coreGroup.getSendingCoreGroups()));
                }
            }
            if (tc2.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc2, (String)("addCoreGroup-" + bl));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set removeCoreGroup(String string) {
            if (tc2.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc2, (String)("removeCoreGroup-" + string));
            }
            HashSet<String> hashSet = new HashSet<String>();
            Map map = this.coreGroups;
            synchronized (map) {
                Iterator iterator = this.coreGroups.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string2 = (String)entry.getKey();
                    CoreGroup coreGroup = (CoreGroup)entry.getValue();
                    if (tc2.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc2, (String)("coreGroup=" + string2));
                    }
                    if (tc2.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc2, (String)("sending core groups=" + coreGroup.getSendingCoreGroups()));
                    }
                    coreGroup.getSendingCoreGroups().remove(string);
                    if (!string2.equals(string) && coreGroup.getSendingCoreGroups().size() != 0) continue;
                    hashSet.add(string2);
                    if (tc2.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc2, (String)("The following core group is no longer reachable: " + string2));
                    }
                    iterator.remove();
                }
            }
            if (tc2.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc2, (String)"removeCoreGroup", hashSet);
            }
            return hashSet;
        }

        class CoreGroup {
            String originCGName;
            Set sendingCoreGroups;
            Set proxyOriginCoreGroups;

            CoreGroup(String string) {
                this.originCGName = string;
                this.sendingCoreGroups = new HashSet(3);
                this.proxyOriginCoreGroups = new HashSet(2);
            }

            public String getName() {
                return this.originCGName;
            }

            public Set getSendingCoreGroups() {
                return this.sendingCoreGroups;
            }

            public String toString() {
                return this.originCGName;
            }

            public Set getProxyOriginCoreGroups() {
                return this.proxyOriginCoreGroups;
            }
        }
    }

    class LastPost {
        private long identifier;
        private long version;
        private String postingServer;
        private String serverName;

        LastPost(long l, long l2, String string, String string2) {
            this.identifier = l;
            this.version = l2;
            this.postingServer = string;
            this.serverName = string2;
        }

        long getIdentifier() {
            return this.identifier;
        }

        long getVersion() {
            return this.version;
        }

        boolean isNewer(LastPost lastPost, CGBridgeBBPostMsg cGBridgeBBPostMsg, String string) {
            boolean bl = false;
            if (!lastPost.getPostingServer().equals(this.postingServer)) {
                bl = true;
            } else if (lastPost.getIdentifier() > this.identifier) {
                bl = true;
            } else if (lastPost.getIdentifier() == this.identifier && (lastPost.getVersion() != this.version || lastPost.getServerName() == null && this.serverName != null || lastPost.getServerName() != null && !lastPost.getServerName().equals(this.serverName))) {
                if (cGBridgeBBPostMsg.getValues().length > 0 || cGBridgeBBPostMsg.getRemovedServers().size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"comparing received posts to locally posted values");
                    }
                    try {
                        BulletinBoardScope bulletinBoardScope = CGBridge.this.getScope(cGBridgeBBPostMsg);
                        BulletinBoard bulletinBoard = CGBridge.this.createBulletinBoard(cGBridgeBBPostMsg.getBBName());
                        SubjectInfo subjectInfo = CGBridge.this.createSubjectInfo(bulletinBoard, cGBridgeBBPostMsg.getSubject(), bulletinBoardScope);
                        for (int i = 0; i < cGBridgeBBPostMsg.getValues().length; ++i) {
                            CGBSubjectPost cGBSubjectPost;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("retreiving post for: " + cGBridgeBBPostMsg.getValues()[i].getServerName()));
                            }
                            if ((cGBSubjectPost = CGBridge.this.subjectPostCache.get(subjectInfo, null, cGBridgeBBPostMsg.getValues()[i].getServerName(), string)) == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("subPost==null for: " + cGBridgeBBPostMsg.getValues()[i].getServerName()));
                                }
                                bl = true;
                                break;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("current version=" + cGBSubjectPost.getSubjectValue().getVersion() + "," + "new version=" + cGBSubjectPost.getSubjectValue().getVersion()));
                            }
                            if (cGBridgeBBPostMsg.getValues()[i].getVersion() <= cGBSubjectPost.getSubjectValue().getVersion()) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(cGBridgeBBPostMsg.getValues()[i].getVersion() + " higher version " + cGBSubjectPost.getSubjectValue().getVersion()));
                            }
                            bl = true;
                            break;
                        }
                        if (cGBridgeBBPostMsg.getRemovedServers().size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("servers to be removed: " + cGBridgeBBPostMsg.getRemovedServers().size()));
                            }
                            Iterator iterator = cGBridgeBBPostMsg.getRemovedServers().iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                if (CGBridge.this.subjectPostCache.get(subjectInfo, null, string2, string) == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Removed server:" + string2 + " still exists in cache "));
                                }
                                bl = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("problems processing subjectInfo: " + exception.getMessage()));
                        }
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("id=").append(this.identifier).append(" version=").append(this.version).append(" subj val serverName=").append(this.serverName).append(" postOriginator=").append(this.postingServer);
            return stringBuffer.toString();
        }

        String getPostingServer() {
            return this.postingServer;
        }

        String getServerName() {
            return this.serverName;
        }
    }

    class APGStatus {
        private String localPMGMemberName;
        private String apgName;
        private Map cgToGMIDMap;
        private boolean isLocalAPGStable;

        APGStatus(String string, String string2, Map map, boolean bl) {
            this.localPMGMemberName = string;
            this.apgName = string2;
            this.cgToGMIDMap = map;
            this.isLocalAPGStable = bl;
        }

        public String getAPGName() {
            return this.apgName;
        }

        public Map getCgToGMIDMap() {
            return this.cgToGMIDMap;
        }

        public boolean isLocalAPGStable() {
            return this.isLocalAPGStable;
        }

        public String getLocalPMGMemberName() {
            return this.localPMGMemberName;
        }
    }
}

