/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.InitialSubjectSubscriptionEventCallback;
import com.ibm.ws.cgbridge.core.impl.SubscribeStatus;
import com.ibm.ws.cgbridge.core.impl.SubscriptionTracker;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.msg.CGBridgeBBPostMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.util.CGBGroupMemberIdLookUpTable;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectProxySubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionProxyEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.util.HashSet;
import java.util.Set;

public class CGBridgeBBEventsHandler
implements SubjectSubscriptionProxyEvents {
    private static final TraceComponent tc = Tr.register((Class)CGBridgeBBEventsHandler.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private static final String NAME = "CGBridgeBBEventsHandler";
    private static final Set EMPTY_SET = new HashSet();
    private CGBGroupMemberIdLookUpTable gmidLookupTable = new CGBGroupMemberIdLookUpTable("CGBridgeBBEventsHandler");
    SubscriptionTracker subscriptionTracker;
    private BulletinBoardFactory bbf;
    private String localCoreGroupname;
    private String localCellName;
    CGBridge cgb;
    private CGBridgeService cgbService;

    public CGBridgeBBEventsHandler(BulletinBoardFactory bulletinBoardFactory, String string, String string2, CGBridge cGBridge, CGBridgeService cGBridgeService, SubscriptionTracker subscriptionTracker) {
        this.cgbService = cGBridgeService;
        this.cgb = cGBridge;
        this.bbf = bulletinBoardFactory;
        this.localCoreGroupname = string;
        this.localCellName = string2;
        this.subscriptionTracker = subscriptionTracker;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)NAME);
        }
    }

    CGBridgeBBPostMsg processUpdate(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray, Set set, boolean bl) {
        SubjectInfo subjectInfo = null;
        try {
            subjectInfo = subjectSubscription.getSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updated for: " + subjectInfo.getBoardName() + " " + subjectInfo.getSubjectName()));
            }
        }
        catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Problem access subscription");
            }
            FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.processUpdate", (String)"10", (Object)this);
        }
        if (subjectInfo != null) {
            try {
                if (subjectValueArray != null) {
                    CGBridgeBBPostMsg cGBridgeBBPostMsg = this.createCGBPost(subjectSubscription, subjectValueArray, set, bl);
                    return cGBridgeBBPostMsg;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No subvalues returned on subscription");
                }
            }
            catch (CGBInternalErrorException cGBInternalErrorException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Update Core Group Bridge internal error " + cGBInternalErrorException));
                }
                FFDCFilter.processException((Throwable)cGBInternalErrorException, (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.updated", (String)"20", (Object)this);
            }
            catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Update failed subscription closed exception " + (Object)((Object)subjectSubscriptionClosedException)));
                }
                FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.updated", (String)"30", (Object)this);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Update failed with an exception " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.updated", (String)"40", (Object)this);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Local post received for a subject we have unsubscribed to");
        }
        return null;
    }

    CGBridgeBBPostMsg createCGBPost(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray, Set set, boolean bl) throws Exception {
        CGBridgeBBPostMsg cGBridgeBBPostMsg = new CGBridgeBBPostMsg(this.localCellName, this.localCoreGroupname, subjectSubscription, subjectValueArray, set, bl, this.cgb.isUseCounterAsPostID());
        cGBridgeBBPostMsg.setSubInfo(subjectSubscription.getSubject());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" CGBPostId=" + cGBridgeBBPostMsg.getCGBPostIdentifier()));
            for (int i = 0; i < subjectValueArray.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("postmsg: " + subjectValueArray[i].getServerName() + " " + subjectValueArray[i].getVersion()));
            }
            Tr.debug((TraceComponent)tc, (String)("servers to remove =" + set));
        }
        return cGBridgeBBPostMsg;
    }

    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray, Set set) {
        this.updated(subjectSubscription, subjectValueArray, set, false);
    }

    void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray, Set set, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isInitialUpdate=" + bl));
        }
        if (!CGBridgeService.getInstance().isServiceRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updated-service stopped");
            }
            return;
        }
        CGBridgeBBPostMsg cGBridgeBBPostMsg = this.processUpdate(subjectSubscription, subjectValueArray, set, bl);
        if (cGBridgeBBPostMsg != null) {
            try {
                this.cgb.handlePost(subjectValueArray, cGBridgeBBPostMsg, null, null);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("problems executing handlePost: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".updated()"), (String)"717", (Object)this);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"cgBridgePostMsg ==null");
        }
    }

    public boolean removeListener(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, BulletinBoard bulletinBoard, SubjectInfo subjectInfo) throws CGBInternalErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeListener");
        }
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing Listener: " + subjectInfo.getBoardName() + " subject: " + subjectInfo.getSubjectName()));
        }
        bl = this.subscriptionTracker.removeListener(subjectInfo, groupMemberId, cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeListener");
        }
        return bl;
    }

    public void sendCurrentState(SubjectProxySubscription subjectProxySubscription, String string, GroupMemberId groupMemberId, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendCurrentState");
        }
        CGBridgeBBPostMsg cGBridgeBBPostMsg = this.createCGBPost((SubjectSubscription)subjectProxySubscription, subjectProxySubscription.requestCurrentState(), EMPTY_SET, true);
        this.cgb.handleInitialUpdate(cGBridgeBBPostMsg, groupMemberId, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendCurrentState");
        }
    }

    public boolean addListener(String string, GroupMemberId groupMemberId, String string2, BulletinBoard bulletinBoard, SubjectInfo subjectInfo, boolean bl) throws CGBInternalErrorException {
        boolean bl2 = false;
        try {
            if (this.cgbService.getCGBridgeConfig().getLocalBridgeCGBVersion().isOptimizedSubscriptionHandling()) {
                SubscribeStatus subscribeStatus = this.subscriptionTracker.subscribeWithPerformance(bulletinBoard, subjectInfo, this, groupMemberId, string, string2, bl);
                if (subscribeStatus == SubscribeStatus.FIRST_SUBSCRIPTION) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("a1) First subscription to this subj is made by " + CGBridgeUtils.getFullServerName(groupMemberId)));
                    }
                    bl2 = true;
                } else if (subscribeStatus.getOrdinal() == SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID_NEED_CURRENT_STATE.getOrdinal()) {
                    SubjectProxySubscription subjectProxySubscription = subscribeStatus.getSubjectProxySubscription();
                    this.sendCurrentState(subjectProxySubscription, string, groupMemberId, string2);
                    bl2 = true;
                } else if (subscribeStatus == SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID_WAIT_FOR_UPDATED_CALLBACK) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"waiting for updated callback");
                    }
                    bl2 = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("rc=false  status val=" + subscribeStatus.toString()));
                }
            } else {
                SubscribeStatus subscribeStatus = this.subscriptionTracker.subscribe(bulletinBoard, subjectInfo, this, groupMemberId, string);
                if (subscribeStatus.equals(SubscribeStatus.FIRST_SUBSCRIPTION)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("a2) First subscription to this subj is made by " + CGBridgeUtils.getFullServerName(groupMemberId)));
                    }
                    bl2 = true;
                } else if (subscribeStatus.equals(SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID) || bl) {
                    InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = new InitialSubjectSubscriptionEventCallback(string2, string, this.gmidLookupTable.lookupGroupMemberId(groupMemberId), this);
                    SubjectSubscription subjectSubscription = this.subscriptionTracker.subscribeInitial(bulletinBoard, subjectInfo, initialSubjectSubscriptionEventCallback, groupMemberId);
                    if (subjectSubscription != null) {
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("c) Initial update forced by " + groupMemberId.getServerName() + " for this subj " + subjectInfo));
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("b) First subscription from " + groupMemberId.getServerName() + " to this subj " + subjectInfo));
                            }
                        }
                        bl2 = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Unable to subscribe initial");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)subscribeStatus.toString());
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problems subscribing: " + exception.getMessage()));
            }
            throw new CGBInternalErrorException("Unable to subscribe on behalf of client ", exception);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addListener-" + bl2));
        }
        return bl2;
    }

    public boolean addListener(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, String string, BulletinBoard bulletinBoard, SubjectInfo subjectInfo, boolean bl) throws CGBInternalErrorException {
        return this.addListener(cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup(), groupMemberId, string, bulletinBoard, subjectInfo, bl);
    }

    public void addListener(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, String string, boolean bl) throws CGBInternalErrorException {
        BulletinBoard bulletinBoard = null;
        try {
            bulletinBoard = this.bbf.findBulletinBoard(cGBridgeBBRemoteSubscriptionMsg.getBBName());
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.updated", (String)"50", (Object)this);
        }
        BulletinBoardScope bulletinBoardScope = this.cgbService.getPublicScope();
        SubjectInfo subjectInfo = null;
        try {
            subjectInfo = bulletinBoard.createSubject(bulletinBoardScope, cGBridgeBBRemoteSubscriptionMsg.getSubject());
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.cbridge.core.impl.CGBridgeBBEventsHandler.updated", (String)"60", (Object)this);
        }
        this.addListener(cGBridgeBBRemoteSubscriptionMsg, groupMemberId, string, bulletinBoard, subjectInfo, bl);
    }

    public boolean isSubjectExists(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        boolean bl;
        SubjectInfo subjectInfo;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isSubjectExists");
            }
            subjectInfo = null;
            bl = false;
            try {
                BulletinBoard bulletinBoard = this.bbf.findBulletinBoard(cGBridgeBBRemoteSubscriptionMsg.getBBName());
                subjectInfo = bulletinBoard.createSubject(this.cgbService.getPublicScope(), cGBridgeBBRemoteSubscriptionMsg.getSubject());
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"isSubjectExists: Error finding bulletinboardmessage from subscribed list");
            }
        }
        if (subjectInfo != null) {
            boolean bl2 = bl = this.subscriptionTracker.getSubscription(subjectInfo) != null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RC subjectexists: " + bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSubjectExists");
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NAME).append("/").append(this.localCellName).append("/").append(this.localCoreGroupname);
        return stringBuffer.toString();
    }
}

