/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeService;
import com.ibm.ws.cgbridge.config.AccessPointGroup;
import com.ibm.ws.cgbridge.config.BridgeInterface;
import com.ibm.ws.cgbridge.config.CGBVersion;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.CGBridgeEndPoint;
import com.ibm.ws.cgbridge.config.CoreGroupAccessPoint;
import com.ibm.ws.cgbridge.core.CGBRemoteScopeNames;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBulletinBoardScopeDataImpl;
import com.ibm.ws.cgbridge.core.impl.CGBridgeSubscriptionRouter;
import com.ibm.ws.cgbridge.core.impl.WorkDispatcher;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.ffdc.CGBridgeDiagnosticModule;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.cgbridge.util.TraceDebugFilter;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.wsspi.cgbridge.AvailableCoreGroupListener;
import com.ibm.wsspi.cgbridge.CoreGroupBridge;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardListener;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopeData;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.hamanager.bboard.CoreGroupBridgeUtilities;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.hamanager.corestack.CoreStackFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CGBridgeService
extends ComponentImpl
implements BulletinBoardScopes,
SubjectSubscriptionEvents,
CoreGroupBridge,
CoreGroupBridgeUtilities {
    private static final TraceComponent tc = Tr.register((Class)CGBridgeService.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private CGBridgeSubscriptionRouter csr;
    private String localServerName;
    private CGBridge cgbridge;
    private GroupManager groupManager;
    private CGBridgeConfig cgbridgeConfig;
    public static final String RESERVED_STRING = "null";
    private static BulletinBoardScope PUBLIC_SCOPE = null;
    private static BulletinBoardScope PRIVATE_SCOPE = null;
    static BulletinBoardScope DUMMY_REMOTE_SCOPE = null;
    static String DUMMY_REMOTE_SCOPE_STRING = "dummyTextForRemoteScope";
    private static boolean initError = false;
    private boolean bConfigLoadFailed = false;
    private boolean bSeviceIsEnabled = true;
    private CoreStack coreStack;
    private boolean serviceAdded = false;
    private boolean componentDisabled = false;
    private static CGBridgeService instance;
    private static HAParameterRejectedException initException;
    private static CGBridgeDiagnosticModule ffdcModule;
    List availableCoreGroupListeners;
    Set currentAvailableCoreGroups;
    boolean isBridge;
    String localCoreGroup;
    private boolean isStartUpTimerFired;
    Set allCoreGroups;
    Set localCoreGroupBridges;
    boolean isServiceRunning = true;
    boolean isUnsynchronized;
    Object unSyncLock = new Object();
    ThreadPool cgbThreadPool;
    TraceDebugFilter traceFilter;
    WorkDispatcher workDispatcher;
    Hashtable htPeerNameToCellName = new Hashtable();
    Hashtable htCellNameToPeerName = new Hashtable();
    Map peerAccessPointsMap = new HashMap();
    Integer remoteScopeSynchObj = new Integer(1);

    public CGBridgeService() {
        instance = this;
        this.isUnsynchronized = false;
        this.availableCoreGroupListeners = new LinkedList();
        this.currentAvailableCoreGroups = new HashSet();
        this.localCoreGroupBridges = new HashSet();
        this.traceFilter = new TraceDebugFilter();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The Core Group Bridge Service has been created.");
        }
    }

    public static CGBridgeService getInstance() {
        if (instance == null) {
            instance = new CGBridgeService();
        }
        return instance;
    }

    public Object getCGBService(Class clazz) throws Exception {
        return this.getService(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        EndPointMgr endPointMgr = (EndPointMgr)this.getService(EndPointMgr.class);
        Repository repository = (Repository)this.getService(Repository.class);
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initialize");
            }
            if (initError) {
                Tr.error((TraceComponent)tc, (String)"Error during initialization");
                this.componentDisabled = true;
                throw new ComponentDisabledException((Throwable)initException);
            }
            if (((CoreGroupBridgeService)object).isEnable()) {
                Object object2;
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = adminService.getProcessType();
                if (string.equals("UnManagedProcess")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not Starting Bridge Service, standalone mode");
                    }
                    this.componentDisabled = true;
                    throw new ComponentDisabledException("The Core Group Bridge may not execute with a stand-alone server configuration.");
                }
                this.cgbridgeConfig = new CGBridgeConfig(repository.getServerName(), repository.getNodeName());
                try {
                    object2 = this.remoteScopeSynchObj;
                    synchronized (object2) {
                        this.cgbridgeConfig.loadBridgeServiceConfig(object, repository, endPointMgr);
                    }
                    this.traceFilter.setFilterSettings((String)this.cgbridgeConfig.getProperties().get("cgb.trace.filter"));
                    this.loadRemoteScopeTables();
                }
                catch (Exception exception) {
                    this.bConfigLoadFailed = true;
                    Tr.error((TraceComponent)tc, (String)"CWRCB0201", (Object)exception.getMessage());
                    throw new ConfigurationWarning("CGBridgeService has configuration errors. " + exception);
                }
                if (this.cgbridgeConfig.getEnableInterCoreGroupCommunication()) {
                    this.isBridge = true;
                }
                this.localCoreGroup = CGBridgeUtils.generateCGKey(adminService.getCellName(), this.cgbridgeConfig.getCoreGroupName());
                if (this.cgbridgeConfig.getEnableInterCoreGroupCommunication() && !this.cgbridgeConfig.isBridgeInConfiguredCoregroup()) {
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"CWRCB0206", (Object)new Object[]{this.cgbridgeConfig.getLocalCGBEndpoint().getCoreGroupName(), this.cgbridgeConfig.getCoreGroupName()});
                    }
                    object2 = "This server is configured to be a core group bridge for core group " + this.cgbridgeConfig.getLocalCGBEndpoint().getCoreGroupName() + " but is located in core group " + this.cgbridgeConfig.getCoreGroupName() + ".";
                    try {
                        if (this.cgbridgeConfig.getServerName().equals("nodeagent") || this.cgbridgeConfig.getServerName().equals("dmgr")) {
                            throw new ComponentDisabledException((String)object2);
                        }
                        throw new ConfigurationError((String)object2);
                    }
                    catch (ComponentDisabledException componentDisabledException) {
                        FFDCFilter.processException((Throwable)componentDisabledException, (String)(this.getClass().getName() + ".initialize()"), (String)"333", (Object)this);
                        throw componentDisabledException;
                    }
                    catch (ConfigurationError configurationError) {
                        FFDCFilter.processException((Throwable)configurationError, (String)(this.getClass().getName() + ".initialize()"), (String)"334", (Object)this);
                        throw configurationError;
                    }
                }
                this.initializeAvailableCoreGroups();
                this.addService(CoreGroupBridge.class);
            } else {
                this.bSeviceIsEnabled = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"initialize, enable==false, CGBridgeService not loading config");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize");
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.releaseService(repository);
            this.releaseService(endPointMgr);
            this.addService(BulletinBoardScopes.class);
            this.addService(CoreGroupBridgeUtilities.class);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)",adding BulletinboardScopes service in initialize.finally");
            }
            throw throwable;
        }
        this.releaseService(repository);
        this.releaseService(endPointMgr);
        this.addService(BulletinBoardScopes.class);
        this.addService(CoreGroupBridgeUtilities.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)",adding BulletinboardScopes service in initialize.finally");
        }
    }

    private void initializeAvailableCoreGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeAvailableCoreGroups");
        }
        Iterator iterator = this.cgbridgeConfig.getAccessPointGroupIterator4Me();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            AccessPointGroup accessPointGroup = (AccessPointGroup)iterator.next();
            Iterator iterator2 = accessPointGroup.getAllEndPoints().iterator();
            while (iterator2.hasNext()) {
                CGBridgeEndPoint cGBridgeEndPoint = (CGBridgeEndPoint)iterator2.next();
                hashSet.add(CGBridgeUtils.generateCGKey(cGBridgeEndPoint.getCellName(), cGBridgeEndPoint.getCoreGroupName()));
            }
        }
        this.allCoreGroups = Collections.unmodifiableSet(hashSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeAvailableCoreGroups");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        CGBridgeUtils.seedUniqueIdentifier(QuickApproxTime.getRef().getApproxTime());
        if (!this.bSeviceIsEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"start, enable==false, CGBridgeService not loading config");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            return;
        }
        if (this.bConfigLoadFailed) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            this.bSeviceIsEnabled = false;
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start bSeviceIsEnabled=" + this.bSeviceIsEnabled + " bConfigLoadFailed=" + this.bConfigLoadFailed));
        }
        this.coreStack = (CoreStack)this.getService(CoreStack.class);
        if (this.coreStack == null) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0202");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not reference Core Stack");
            }
            this.bSeviceIsEnabled = false;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            return;
        }
        try {
            if (this.coreStack.transparentBridgeFailoverEnabled()) {
                this.cgbridgeConfig.setLocalBridgeCGBVersion(CGBVersion.VERSION2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set version to: " + CGBVersion.VERSION2));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set following as local bridges: " + this.localCoreGroupBridges));
                }
            }
            this.localCoreGroupBridges = this.getConfiguredBridges(this.cgbridgeConfig.getCoreGroupName());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"problems reading coreStack.transparentBridgeFailoverEnabled()");
            }
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".start()"), (String)"3943-", (Object)this);
        }
        BulletinBoardFactory bulletinBoardFactory = this.coreStack.getBulletinboardFactory();
        if (bulletinBoardFactory == null) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0202");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not reference BulletinBoardFactory");
            }
            this.releaseService(this.coreStack);
            this.bSeviceIsEnabled = false;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            return;
        }
        this.cgbridgeConfig.setBulletinBoardFactory(bulletinBoardFactory);
        this.subscribeToBridgeInfoBB(bulletinBoardFactory);
        CoreStackFactory coreStackFactory = this.coreStack.getCoreStackFactory();
        this.groupManager = this.coreStack.getGroupManager();
        if (this.groupManager == null) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0202");
            this.releaseService(this.coreStack);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not reference GroupManager");
            }
            this.bSeviceIsEnabled = false;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            return;
        }
        this.localServerName = this.groupManager.getServerName();
        this.createThreadPool();
        this.workDispatcher = new WorkDispatcher(this.cgbThreadPool);
        this.cgbThreadPool.addThreadPoolListener((ThreadPoolListener)this.workDispatcher);
        if (this.cgbridgeConfig.getEnableInterCoreGroupCommunication()) {
            try {
                this.cgbridge = new CGBridge(bulletinBoardFactory, this, this.cgbridgeConfig.getCoreGroupName(), this.cgbridgeConfig, coreStackFactory);
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"CWRCB0101");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"adding AvailableCoreGroupListener");
                    this.addAvailableCoreGroupListener(this.cgbridge);
                }
            }
            catch (CGBInternalErrorException cGBInternalErrorException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to start Core Group Bridge" + cGBInternalErrorException));
                }
                this.bSeviceIsEnabled = false;
                this.releaseService(this.coreStack);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"start");
                }
                return;
            }
            this.cgbridgeConfig.postBridgeInfo();
        }
        if (0 < this.cgbridgeConfig.getNumBridges()) {
            try {
                this.csr = new CGBridgeSubscriptionRouter(this.groupManager, this.cgbridge, this.cgbridgeConfig, this.coreStack);
            }
            catch (HAException hAException) {
                this.bSeviceIsEnabled = false;
                this.releaseService(this.coreStack);
                FFDCFilter.processException((Throwable)hAException, (String)(this.getClass().getName() + ".start()"), (String)"2", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The core group name could not be constructed: " + hAException.getMessage()));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"start");
                }
                return;
            }
        } else {
            this.bSeviceIsEnabled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"numBridges==0, not constructing CGBridgeSubscriptionRouter");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            return;
        }
        this.coreStack.addBulletinBoardListener((BulletinBoardListener)this.csr);
        this.handleDebugSubject(bulletinBoardFactory);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    void createThreadPool() {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createThreadPool");
            }
            try {
                int n;
                block13: {
                    n = 20;
                    String string = CGBridgeUtils.getCaseInsensitiveCustomProperty(this.cgbridgeConfig.getProperties(), "cgb.threadPool.max");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("val=" + string));
                    }
                    if (string != null) {
                        try {
                            n = Integer.parseInt(string);
                            if (tc.isInfoEnabled()) {
                                Tr.info((TraceComponent)tc, (String)"CWRCB0112", (Object)new Object[]{"cgb.threadPool.max", string});
                            }
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block13;
                            Tr.debug((TraceComponent)tc, (String)("problems parsing thread pool max. " + exception.getMessage()));
                        }
                    }
                }
                if (this.cgbThreadPool == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"creating cgb thread pool");
                    }
                    this.cgbThreadPool = new ThreadPool("CGB Thread Pool", 0, n, null);
                    this.cgbThreadPool.setKeepAliveTime(300000L);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"thread pool already exists");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)("problems creating thread pool" + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createThreadPool");
        }
    }

    private void handleDebugSubject(BulletinBoardFactory bulletinBoardFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleDebugSubject");
        }
        try {
            BulletinBoard bulletinBoard = bulletinBoardFactory.findBulletinBoard("CGB");
            SubjectInfo subjectInfo = bulletinBoard.createSubject(this.getPublicScope(), "DEBUGSUBJECT");
            SubjectPost subjectPost = bulletinBoard.createPost(subjectInfo);
            String string = System.getProperty("file.separator");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.cgbridgeConfig.getCellName()).append(string).append(this.cgbridgeConfig.getCoreGroupName());
            subjectPost.updatePost(stringBuffer.toString().getBytes());
            if (this.cgbridgeConfig.getEnableInterCoreGroupCommunication()) {
                SubjectInfo subjectInfo2 = bulletinBoard.createSubject(this.getPublicScope(), "IS_BRIDGE");
                bulletinBoard.createPost(subjectInfo2).updatePost("a".getBytes());
                bulletinBoard.subscribe(subjectInfo, (SubjectSubscriptionEvents)this);
                Map map = this.getPeerAccessPointsMap();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("pap=" + k));
                    }
                    HashMap hashMap = new HashMap();
                    hashMap.put("peerName", k);
                    subjectInfo = bulletinBoard.createSubject(this.getRemoteScope(hashMap), "DEBUGSUBJECT");
                    bulletinBoard.subscribe(subjectInfo, (SubjectSubscriptionEvents)this);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Problem creating debug subject");
            }
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".handleDebugSubject()"), (String)"22", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleDebugSubject");
        }
    }

    public void stop() {
        this.isServiceRunning = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (!this.bSeviceIsEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stop");
            }
            return;
        }
        if (this.coreStack != null) {
            this.coreStack.removeBulletinBoardListener((BulletinBoardListener)this.csr);
        }
        if (this.csr != null) {
            this.csr.shutdown();
        }
        if (this.cgbridge != null) {
            this.cgbridge.shutdownBridge();
        }
        this.releaseService(CoreStack.class);
        this.releaseService(BulletinBoardFactory.class);
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0103");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    private void subscribeToBridgeInfoBB(BulletinBoardFactory bulletinBoardFactory) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"subscribeToBridgeInfoBB");
        }
        try {
            BulletinBoard bulletinBoard = bulletinBoardFactory.findBulletinBoard("com.ibm.ws.cgbridge.bridgeInfoBB");
            SubjectInfo subjectInfo = bulletinBoard.createSubject(BulletinBoardScope.getDefault(), "PeerAccessPoints");
            SubjectSubscription subjectSubscription = bulletinBoard.subscribe(subjectInfo, (SubjectSubscriptionEvents)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("subscribeToBridgeInfoBB subInfo=[" + subjectInfo + "]"));
            }
            SubjectInfo subjectInfo2 = bulletinBoard.createSubject(BulletinBoardScope.getDefault(), "NumBridges");
            SubjectSubscription subjectSubscription2 = bulletinBoard.subscribe(subjectInfo2, (SubjectSubscriptionEvents)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("subscribeToBridgeInfoBB subInfo=[" + subjectInfo2 + "]"));
            }
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(", subscribeToBridgeInfoBB caught" + (Object)((Object)hAParameterRejectedException)));
            }
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"CGBridgeService<subscribeToBridgeInfoBB>", (String)"113", (Object)"CGBridgeService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRemoteScopeTables() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadRemoteScopeTables");
        }
        Integer n = this.remoteScopeSynchObj;
        synchronized (n) {
            if (null != this.cgbridgeConfig) {
                this.peerAccessPointsMap = this.cgbridgeConfig.getPeerAccessPointsMap();
                Iterator iterator = this.peerAccessPointsMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.htPeerNameToCellName.put(string, (String)this.peerAccessPointsMap.get(string));
                    this.htCellNameToPeerName.put((String)this.peerAccessPointsMap.get(string), string);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("loadRemoteScopeTables peername [" + string + "] mapped to cellName[" + (String)this.peerAccessPointsMap.get(string) + "]"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadRemoteScopeTables");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        Integer n = this.remoteScopeSynchObj;
        synchronized (n) {
            try {
                SubjectInfo subjectInfo = subjectSubscription.getSubject();
                String string = subjectInfo.getSubjectName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updated BridgeInfoBB subject=[" + string + "]"));
                }
                if (string.equals("NumBridges")) {
                    if (null != subjectValueArray && subjectValueArray.length > 0) {
                        for (int i = 0; i < subjectValueArray.length; ++i) {
                            Integer n2 = new Integer(new String(subjectValueArray[i].getValues()));
                            if (null == this.csr) continue;
                            this.csr.handleNewBridge(n2);
                        }
                    }
                } else if (string.equals("PeerAccessPoints")) {
                    if (null != subjectValueArray && subjectValueArray.length > 0) {
                        for (int i = 0; i < subjectValueArray.length; ++i) {
                            CGBRemoteScopeNames cGBRemoteScopeNames = new CGBRemoteScopeNames();
                            cGBRemoteScopeNames.loadNamesFromByteArray(subjectValueArray[i].getValues());
                            Vector vector = cGBRemoteScopeNames.getPeerNames();
                            Vector vector2 = cGBRemoteScopeNames.getCellNames();
                            for (int j = 0; j < vector.size(); ++j) {
                                this.htPeerNameToCellName.put((String)vector.elementAt(j), (String)vector2.elementAt(j));
                                this.htCellNameToPeerName.put((String)vector2.elementAt(j), (String)vector.elementAt(j));
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("   values[" + i + "] serverName[" + subjectValueArray[i].getServerName() + "] value=[" + cGBRemoteScopeNames + "]"));
                        }
                    }
                    this.peerAccessPointsMap = new HashMap(this.htPeerNameToCellName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("peerAccessPointsMap now=[" + this.peerAccessPointsMap + "]"));
                    }
                } else if (tc.isDebugEnabled() && string.equals("DEBUGSUBJECT") && null != subjectValueArray && subjectValueArray.length > 0) {
                    String string2 = System.getProperty("line.separator");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Bridge can communicate with the following servers:").append(string2);
                    for (int i = 0; i < subjectValueArray.length; ++i) {
                        String string3 = new String(subjectValueArray[i].getValues());
                        stringBuffer.append(subjectValueArray[i].getServerName());
                        if (string3.length() > 3) {
                            stringBuffer.append("  ").append(string3);
                        }
                        stringBuffer.append(string2);
                    }
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
            }
            catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(", The subscriptionn has been closed" + (Object)((Object)subjectSubscriptionClosedException)));
                }
                FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, (String)"CGBridgeService<updated>", (String)"110", (Object)"CGBridgeService");
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(", updated caught ioe" + iOException));
                }
                FFDCFilter.processException((Throwable)iOException, (String)"CGBridgeService<updated>", (String)"111", (Object)"CGBridgeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(", updated caught ioe" + classNotFoundException));
                }
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"CGBridgeService<updated>", (String)"112", (Object)"CGBridgeService");
            }
        }
    }

    public String getLocalServerName() {
        return this.localServerName;
    }

    public BulletinBoardScope getPrivateScope() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getprivatescope always returns privateScope");
        }
        return PRIVATE_SCOPE;
    }

    public BulletinBoardScope getPublicScope() {
        return PUBLIC_SCOPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulletinBoardScope getRemoteScope(Map map) throws HAParameterRejectedException {
        String string = (String)map.get("peerName");
        String string2 = (String)map.get("cellName");
        String string3 = null;
        String string4 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRemoteScope for map=[" + map + "]"));
        }
        Integer n = this.remoteScopeSynchObj;
        synchronized (n) {
            if (null != string) {
                string4 = (String)this.htPeerNameToCellName.get(string);
                string3 = string;
            }
            if (null == string4 && null != string2) {
                string3 = (String)this.htCellNameToPeerName.get(string2);
                string4 = string2;
            }
        }
        if (null == string3 || null == string4) {
            throw new HAParameterRejectedException("No PeerAccessPoint with route to peer [" + string + "] or cell [" + string2 + "] found");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRemoteScope retrievedPeerName=[" + string3 + "] retrievedCellName=[" + string4 + "]"));
        }
        return new BulletinBoardScope(-2, (BulletinBoardScopeData)new CGBridgeBulletinBoardScopeDataImpl(string3, string4, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPeerAccessPointsMap() {
        Integer n = this.remoteScopeSynchObj;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getPeerAccessPointsMap returning[" + this.peerAccessPointsMap + "]"));
            }
            return this.peerAccessPointsMap;
        }
    }

    public CGBridge getCGBridge() {
        return this.cgbridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAvailableCoreGroupListeners(Set set, Set set2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyAvailableCoreGroupListeners", (Object)new Object[]{set, set2, new Boolean(bl)});
        }
        if (!this.isServiceRunning()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"notifyAvailableCoreGroupListeners - service stopped");
            }
            return;
        }
        List list = this.availableCoreGroupListeners;
        synchronized (list) {
            this.currentAvailableCoreGroups = set;
            if (bl && this.isStartUpTimerFired && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"alarm callback already fired or was canceled");
            }
            if (bl) {
                this.isStartUpTimerFired = true;
            } else if (!this.isStartUpTimerFired && !bl && set.size() == set2.size()) {
                this.isStartUpTimerFired = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Do not fire alarm callback if all core groups stabalize beforehand...cancel alarm");
                }
                this.cgbridge.cancelAvailableCoreGroupAlarm();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isStartUpTimerFired=" + this.isStartUpTimerFired + ", availableCoreGroups size=" + set.size() + ", allCoreGroups size=" + set2.size()));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"notify listeners");
            }
            for (int i = 0; i < this.availableCoreGroupListeners.size(); ++i) {
                AvailableCoreGroupListener availableCoreGroupListener = (AvailableCoreGroupListener)this.availableCoreGroupListeners.get(i);
                try {
                    availableCoreGroupListener.availableCoreGroupsChanged(set, set2, bl);
                    continue;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("listener threw following exception: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".notifyAvailableCoreGroupListeners()"), (String)"343", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyAvailableCoreGroupListeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAvailableCoreGroupListener(AvailableCoreGroupListener availableCoreGroupListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAvailableCoreGroupListener", (Object)new Object[]{availableCoreGroupListener});
        }
        boolean bl = false;
        if (availableCoreGroupListener != null && this.isLocalServerBridge()) {
            List list = this.availableCoreGroupListeners;
            synchronized (list) {
                this.availableCoreGroupListeners.add(availableCoreGroupListener);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAvailableCoreGroupListener", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getLocalCoreGroupName() {
        return this.localCoreGroup;
    }

    public boolean isLocalServerBridge() {
        return this.isBridge;
    }

    List getAvailableCoreGroupListeners() {
        return this.availableCoreGroupListeners;
    }

    public Set getAllCoreGroups() {
        return this.allCoreGroups;
    }

    public CGBridgeConfig getCGBridgeConfig() {
        return this.cgbridgeConfig;
    }

    public Set getAvailableCoreGroups() {
        return new HashSet(this.currentAvailableCoreGroups);
    }

    public CoreStack getCoreStack() {
        return this.coreStack;
    }

    public Set getLocalCoreGroupBridges() {
        return this.localCoreGroupBridges;
    }

    public Set getConfiguredBridges(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfiguredBridges", (Object)new Object[]{string});
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (this.cgbridgeConfig != null) {
            Iterator iterator = this.cgbridgeConfig.getCoreGroupAccessPoints().values().iterator();
            while (iterator.hasNext()) {
                CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)iterator.next();
                if (!coreGroupAccessPoint.getCoreGroupName().equals(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found cgap for specified core group: " + coreGroupAccessPoint.getName()));
                }
                Iterator iterator2 = coreGroupAccessPoint.getBridgeInterfaces().values().iterator();
                while (iterator2.hasNext()) {
                    BridgeInterface bridgeInterface = (BridgeInterface)iterator2.next();
                    hashSet.add(CGBridgeUtils.getFullServerName(this.cgbridgeConfig.getCellName(), bridgeInterface.getNodeName(), bridgeInterface.getServerName()));
                }
                break block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfiguredBridges", hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bridgeUnsynchronized(Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bridgeUnsynchronized", (Object)new Object[]{set});
        }
        Object object = this.unSyncLock;
        synchronized (object) {
            this.coreStack.bridgeStateUnsychronized(set);
            this.isUnsynchronized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeUnsynchronized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsynchronized() {
        Object object = this.unSyncLock;
        synchronized (object) {
            return this.isUnsynchronized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bridgeSynchronized(Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bridgeSynchronized", (Object)new Object[]{CGBridgeUtils.getSubset(set, 5)});
        }
        Object object = this.unSyncLock;
        synchronized (object) {
            this.coreStack.bridgeStateSynchronized(set);
            this.isUnsynchronized = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeSynchronized");
        }
    }

    public boolean isServiceRunning() {
        return this.isServiceRunning;
    }

    CGBridgeSubscriptionRouter getCGBSubscriptionRouter() {
        return this.csr;
    }

    public TraceDebugFilter getTraceFilter() {
        return this.traceFilter;
    }

    public WorkDispatcher getWorkDispatcher() {
        return this.workDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCellNameToPAPNameMap() {
        Integer n = this.remoteScopeSynchObj;
        synchronized (n) {
            return new HashMap(this.htCellNameToPeerName);
        }
    }

    static {
        if (ffdcModule == null) {
            ffdcModule = new CGBridgeDiagnosticModule();
            boolean bl = ffdcModule.register();
            if (tc.isDebugEnabled()) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"CGBridgeDiagnosticModule has been registered with the FFDC facility.");
                } else {
                    Tr.debug((TraceComponent)tc, (String)"CGBridgeDiagnosticModule could not be registered with the FFDC facility.");
                }
            }
        }
        try {
            PUBLIC_SCOPE = new BulletinBoardScope(-2, (BulletinBoardScopeData)new CGBridgeBulletinBoardScopeDataImpl(RESERVED_STRING, RESERVED_STRING, 1));
            PRIVATE_SCOPE = new BulletinBoardScope(-2, (BulletinBoardScopeData)new CGBridgeBulletinBoardScopeDataImpl(RESERVED_STRING, RESERVED_STRING, 2));
            DUMMY_REMOTE_SCOPE = new BulletinBoardScope(-2, (BulletinBoardScopeData)new CGBridgeBulletinBoardScopeDataImpl(DUMMY_REMOTE_SCOPE_STRING, DUMMY_REMOTE_SCOPE_STRING, 3));
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"CGBridgeService<init>", (String)"101", (Object)"CGBridgeService");
            initError = true;
            initException = hAParameterRejectedException;
        }
    }
}

