/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.CGBridgeCallback;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.Work;
import com.ibm.ws.cgbridge.core.impl.WorkType;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.msg.CGBridgeBBMsgHandler;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRLocalStateMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRStateRequestMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.util.CGBMessageReprocessorCallback;
import com.ibm.ws.cgbridge.util.CGBMesssageReprocessor;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.cgbridge.util.CachedMsg;
import com.ibm.ws.cgbridge.util.LocalGroupMemberIdComparator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.bboard.BridgeFailoverEnablementListener;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.hamanager.datastack.DataStackCongestionException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupCallback;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupData;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupDataFactory;
import com.ibm.wsspi.hamanager.partitionedmanager.MemberStateEnum;
import com.ibm.wsspi.hamanager.partitionedmanager.PartitionedManagerGroup;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CGBridgeSubscriptionRouter
implements BridgeFailoverEnablementListener,
ManagedGroupCallback,
CGBMessageReprocessorCallback {
    static final TraceComponent tc = Tr.register((Class)CGBridgeSubscriptionRouter.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    static final WorkType CGB_STABILIZED_WORK = new WorkType("CGB_STABILIZED_WORK");
    static final WorkType CGB_PROCESS_NEW_COORDINATOR_WORK = new WorkType("CGB_PROCESS_NEW_COORDINATOR_STATE");
    static final WorkType CGB_REMOVE_DEAD_SERVERS_WORK = new WorkType("CGB_REMOVE_DEAD_SERVERS");
    static final WorkType ON_MESSAGE_WORK = new WorkType("GSR_ON_MESSAGE_WORK");
    static final WorkType STABILIZED_WORK = new WorkType("STABILIZED_WORK");
    static final WorkType STABILIZED_PREREQ_WORK = new WorkType("STABILIZED_PREREQ_WORK");
    static final WorkType[] CGB_STABILIZED_PREREQ_WORK_TYPES = new WorkType[]{CGB_STABILIZED_WORK, CGB_PROCESS_NEW_COORDINATOR_WORK, CGB_REMOVE_DEAD_SERVERS_WORK};
    static final WorkType[] CGB_PROCESS_NEW_COORDINATOR_PREREQ_WORK_TYPES = new WorkType[]{CGB_STABILIZED_WORK, CGB_PROCESS_NEW_COORDINATOR_WORK, CGB_REMOVE_DEAD_SERVERS_WORK};
    public static final String STATE_KEY_SUBS_UNAVAILABLE = "Subs unavailable";
    public static final String STATE_NOT_ELECTED = "Not elected coordinator";
    public static final String STATE_ACTIVE_COORDINATORS = "Active Coordinators";
    public static final long SEND_MESSAGE_FAIL_ERROR = 500L;
    private GroupName g_groupName;
    private PartitionedManagerGroup group;
    private ManagedGroupData groupManagedData;
    private GroupManager groupManager;
    CGBridgeCallback bridgeListener;
    GroupMemberId[] activeBridges;
    Object activeBridgesLock = new Object();
    private GroupMemberId localId;
    private boolean joined;
    boolean isBridgeEnabled = false;
    private Set storedLocalStateSubs = new HashSet();
    Set tmp_subsTable = new LinkedHashSet();
    CGBridge cgbridge;
    private String slocalCoreGroup;
    private Map groupNameProperties;
    private Map memberProperties;
    private int numManagers;
    private boolean elected;
    private static final String pmgDataStackName = "GSRDS";
    private static CoreStack cstackglobal;
    private Object startup_Mutex = new Object();
    boolean isPMGStable;
    Object isPMGStableLock = new Object();
    Set pmgActiveBridges;
    Set localCoreGroupActiveBridges;
    CGBridgeConfig config;
    boolean isBridgeWaitingForSubscriptions = false;
    Object isBridgeWaitingforSubsLock = new Object();
    Map unsentLocalState;
    Map unsentStateRequests;
    Set activeCoordinators;
    Map bridgesRequestingState;
    List msgCache = new LinkedList();
    CGBMesssageReprocessor messageProcessor = new CGBMesssageReprocessor(this);
    boolean isActiveCoordinatorChange = false;

    public CGBridgeSubscriptionRouter(GroupManager groupManager, CGBridge cGBridge, CGBridgeConfig cGBridgeConfig, CoreStack coreStack) throws HAException {
        this.bridgesRequestingState = new HashMap();
        this.activeCoordinators = new HashSet();
        this.unsentLocalState = new HashMap();
        this.unsentStateRequests = new HashMap();
        this.activeBridges = new GroupMemberId[0];
        cstackglobal = coreStack;
        this.localCoreGroupActiveBridges = new HashSet();
        this.pmgActiveBridges = new HashSet();
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.slocalCoreGroup = CGBridgeUtils.generateCGKey(adminService.getCellName(), cGBridgeConfig.getCoreGroupName());
        this.numManagers = cGBridgeConfig.getNumBridges();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("numManagers=" + this.numManagers));
        }
        if (this.numManagers == 0 && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"CWRCB0301", (Object)new Object[]{cGBridgeConfig.getCoreGroupName()});
        }
        this.config = cGBridgeConfig;
        this.groupManager = groupManager;
        this.cgbridge = cGBridge;
        if (this.cgbridge != null) {
            this.bridgeListener = this.cgbridge.getCGBridgeCallback();
            this.isBridgeEnabled = true;
        } else {
            this.isBridgeEnabled = false;
        }
        this.groupNameProperties = new HashMap(2);
        this.groupNameProperties.put("policy", "DefaultNOOPPolicy");
        this.groupNameProperties.put("Core_Group_Application_Binding", "WebSphere_Core_Group_Bridge_BulletinBoard_Plug-in");
        this.memberProperties = new HashMap(1);
        this.memberProperties.put("Core_Group_Bridge_BulletinBoard_Plug-In_Instance", cGBridgeConfig.getNodeName() + "\\" + cGBridgeConfig.getServerName());
        this.g_groupName = this.groupManager.createGroupName(this.groupNameProperties);
        if (this.cgbridge != null) {
            this.joinGroup();
        }
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0102");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The BulletinBoard Plug-in has been created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBridgesRequestingState() {
        Map map = this.bridgesRequestingState;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"reset bridges waiting for state");
            }
            this.bridgesRequestingState.clear();
        }
    }

    private void printBridgesWaitingforState() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("servers waiting for state: " + this.bridgesRequestingState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBridgeRequestingState(String string, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addBridgeRequestingState-" + string), (Object)new Object[]{set});
        }
        Map map = this.bridgesRequestingState;
        synchronized (map) {
            this.bridgesRequestingState.put(string, set);
            this.printBridgesWaitingforState();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addBridgeRequestingState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBridgeRequestingState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeBridgeRequestingState-" + string));
        }
        Map map = this.bridgesRequestingState;
        synchronized (map) {
            this.bridgesRequestingState.remove(string);
            this.printBridgesWaitingforState();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeBridgeRequestingState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendStateToWaitingBridges() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendStateToWaitingBridges");
        }
        Map map = this.bridgesRequestingState;
        synchronized (map) {
            if (this.bridgesRequestingState.size() > 0) {
                this.printBridgesWaitingforState();
                byte[] byArray = this.getSerializedState(true);
                if (byArray != null) {
                    Iterator iterator = this.bridgesRequestingState.entrySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl = false;
                        Map.Entry entry = iterator.next();
                        Set set = (Set)entry.getValue();
                        String string = (String)entry.getKey();
                        if (this.isActiveCoordinatorsMatched(set)) {
                            bl = true;
                            GroupMemberId groupMemberId = this.getBridgeGMID(string);
                            if (groupMemberId != null) {
                                this.sendLocalStateToServer(groupMemberId, byArray);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"gmid==null...remove since bridge no longer exists");
                            }
                        }
                        if (!bl) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"removed bridge");
                        }
                        iterator.remove();
                        this.printBridgesWaitingforState();
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"data==null");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendStateToWaitingBridges");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupMemberId getBridgeGMID(String string) {
        Object object = this.activeBridgesLock;
        synchronized (object) {
            for (int i = 0; i < this.activeBridges.length; ++i) {
                if (!this.activeBridges[i].getServerName().equals(string)) continue;
                return this.activeBridges[i];
            }
            return null;
        }
    }

    public void handleNewBridge(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleNewBridge numBridges=" + n + " numManagers=" + this.numManagers + " bridgeEnabled=" + this.isBridgeEnabled + " elected=" + this.elected));
        }
        if (n > this.numManagers && (this.isBridgeEnabled || this.elected)) {
            this.unjoinGroup();
            this.numManagers = n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleNewBridge calling joinGroup numManagers now=" + this.numManagers));
            }
            this.joinGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPMGBridges() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPMGBridges");
        }
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.activeBridgesLock;
        synchronized (object) {
            for (int i = 0; i < this.activeBridges.length; ++i) {
                hashSet.add(this.activeBridges[i].getServerName());
            }
        }
        this.pmgActiveBridges = hashSet;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setPMGBridges-" + this.pmgActiveBridges));
        }
    }

    public synchronized void shutdown() {
        this.unjoinGroup();
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"CWRCB0104");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getSerializedState(boolean bl) {
        try {
            CGBridgeGSRLocalStateMsg cGBridgeGSRLocalStateMsg;
            Object object = this.activeBridgesLock;
            synchronized (object) {
                cGBridgeGSRLocalStateMsg = new CGBridgeGSRLocalStateMsg(this.pmgActiveBridges, this.extractLocalState(this.activeBridges, false)[0], this.config.getFullServerName(), bl);
            }
            return cGBridgeGSRLocalStateMsg.marshallData();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("failed to serialize gsrLocalState: " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".getSerializedState"), (String)"11", (Object)this);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendLocalState() {
        boolean bl;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sendLocalState");
            }
            bl = false;
            if (this.isBridgeWaitingForSubscriptions() && this.isLocalAndPMGBridgesMatched()) {
                GroupMemberId[] groupMemberIdArray;
                this.resetBridgesRequestingState();
                this.setBridgeWaitingForSubscriptions(false);
                Object object = this.activeBridgesLock;
                synchronized (object) {
                    groupMemberIdArray = this.activeBridges;
                }
                bl = true;
                if (groupMemberIdArray.length > 0) {
                    try {
                        object = this.getSerializedState(false);
                        if (object != null) {
                            Map map = this.unsentLocalState;
                            synchronized (map) {
                                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                                    this.sendLocalStateToServer(groupMemberIdArray[i], (byte[])object);
                                }
                                break block16;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"data==null");
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("failed to send state: " + exception.getMessage()));
                        }
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".sendLocalState"), (String)"1", (Object)this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendLocalState-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendLocalStateToServer(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendLocalStateToServer", (Object)new Object[]{groupMemberId, byArray});
        }
        Map map = this.unsentLocalState;
        synchronized (map) {
            block13: {
                try {
                    if (this.isPMGStable()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sending local state to: " + groupMemberId.getServerName()));
                        }
                        this.groupManagedData.sendMessage(groupMemberId, byArray);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"unstable, so store local state");
                        }
                        this.unsentLocalState.put(groupMemberId, byArray);
                    }
                }
                catch (DataStackCongestionException dataStackCongestionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("GSR DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                    }
                    this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                }
                catch (Exception exception) {
                    this.unsentLocalState.put(groupMemberId, byArray);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)("failed to send gsrLocalState: " + exception.getMessage()));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendLocalStateToServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendStateRequstMsgForBridge(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendStateRequstMsgForBridge");
        }
        Map map = this.unsentStateRequests;
        synchronized (map) {
            block13: {
                try {
                    if (this.isPMGStable()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sending state request to: " + groupMemberId.getServerName()));
                        }
                        this.groupManagedData.sendMessage(groupMemberId, byArray);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"unstable, so state request");
                        }
                        this.unsentStateRequests.put(groupMemberId, byArray);
                    }
                }
                catch (DataStackCongestionException dataStackCongestionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("GSR DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                    }
                    this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                }
                catch (Exception exception) {
                    this.unsentStateRequests.put(groupMemberId, byArray);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)("failed to send state request: " + exception.getMessage()));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendStateRequstMsgForBridge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resendStateRequestMsgs() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resendStateRequestMsgs");
        }
        Map map = this.unsentStateRequests;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsentStateRequests=" + this.unsentStateRequests));
            }
            if (this.unsentStateRequests.size() > 0) {
                Iterator iterator = this.unsentStateRequests.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    GroupMemberId groupMemberId = (GroupMemberId)entry.getKey();
                    if (this.isServerActivePMGBridge(groupMemberId.getServerName())) {
                        byte[] byArray = (byte[])entry.getValue();
                        try {
                            this.groupManagedData.sendMessage(groupMemberId, byArray);
                            iterator.remove();
                        }
                        catch (DataStackCongestionException dataStackCongestionException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("GSR DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                            }
                            this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("problems resending state request to: " + groupMemberId));
                        }
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remove state requst entry for failed bridge: " + groupMemberId));
                    }
                    iterator.remove();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resendStateRequestMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resendLocalGSRStateMsgs() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resendLocalGSRStateMsgs");
        }
        Map map = this.unsentLocalState;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsentLocalState=" + this.unsentLocalState));
            }
            if (this.unsentLocalState.size() > 0) {
                Iterator iterator = this.unsentLocalState.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    GroupMemberId groupMemberId = (GroupMemberId)entry.getKey();
                    if (this.isServerActivePMGBridge(groupMemberId.getServerName())) {
                        byte[] byArray = (byte[])entry.getValue();
                        try {
                            this.groupManagedData.sendMessage(groupMemberId, byArray);
                            iterator.remove();
                        }
                        catch (DataStackCongestionException dataStackCongestionException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("GSR DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                            }
                            this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                            iterator.remove();
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("problems resending data to: " + groupMemberId));
                        }
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remove entry for failed bridge: " + groupMemberId));
                    }
                    iterator.remove();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resendLocalGSRStateMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerActivePMGBridge(String string) {
        Object object = this.startup_Mutex;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("fullHAServerName=" + string));
            }
            return this.pmgActiveBridges.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocalAndPMGBridgesMatched() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isLocalAndPMGBridgesMatched");
        }
        boolean bl = false;
        Object object = this.startup_Mutex;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("pmgActiveBridges=" + this.pmgActiveBridges));
                Tr.debug((TraceComponent)tc, (String)("localCoreGroupActiveBridges=" + this.localCoreGroupActiveBridges));
            }
            if (this.pmgActiveBridges.size() == this.localCoreGroupActiveBridges.size() && this.pmgActiveBridges.containsAll(this.localCoreGroupActiveBridges)) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isLocalAndPMGBridgesMatched-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"joinGroup");
        }
        Object object = this.startup_Mutex;
        synchronized (object) {
            try {
                ManagedGroupDataFactory managedGroupDataFactory = cstackglobal.getManagedGroupDataFactory();
                ManagedGroupData[] managedGroupDataArray = new ManagedGroupData[1];
                if (tc.isDebugEnabled()) {
                    String string = System.getProperty("line.separator");
                    StringBuffer stringBuffer = new StringBuffer(string + "Variable ManagerGroupData Parameters:" + string);
                    stringBuffer.append("   PMG DataStackName: GSRDS" + string);
                    stringBuffer.append("   This machine is a bridge (bridgeEnabled): " + this.isBridgeEnabled + string);
                    stringBuffer.append("   Number of managers (numManagers): " + this.numManagers + string);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                managedGroupDataArray[0] = managedGroupDataFactory.createManagedGroupData(pmgDataStackName, this.isBridgeEnabled, true, false, this.numManagers, new String[0], (ManagedGroupCallback)this);
                this.groupManagedData = managedGroupDataArray[0];
                this.group = this.groupManager.createPartitionedManagerGroup(this.g_groupName, this.memberProperties, managedGroupDataArray);
                this.localId = this.group.getMemberName();
                if (this.cgbridge != null) {
                    this.cgbridge.setLocalGroupMember(this.localId);
                }
            }
            catch (HAException hAException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to Join Group for local cell");
                }
                FFDCFilter.processException((Throwable)hAException, (String)(this.getClass().getName() + ".joinGroup"), (String)"1", (Object)this);
            }
            this.joined = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"joinGroup");
        }
    }

    private void unjoinGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unjoinGroup");
        }
        if (this.group == null) {
            return;
        }
        try {
            this.group.stop();
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, (String)(this.getClass().getName() + ".unjoinGroup"), (String)"2", (Object)this);
        }
        this.joined = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unjoinGroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean proxySubscription(SubjectInfo subjectInfo, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"proxySubscription", (Object)new Object[]{subjectInfo, new Boolean(bl)});
        }
        BulletinBoardScope bulletinBoardScope = subjectInfo.getScope();
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("scope type proxy subscription : " + bulletinBoardScope));
        }
        if (this.config.isFilterSubscriptions() && !this.config.getAllowedBBNames().contains(subjectInfo.getBoardName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BB name " + subjectInfo.getBoardName() + " not allowed"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"proxySubscription - filter bb");
            }
            return true;
        }
        if (bulletinBoardScope.getType() == -2) {
            GroupMemberId[] groupMemberIdArray;
            Object object = this.activeBridgesLock;
            synchronized (object) {
                groupMemberIdArray = this.activeBridges;
            }
            if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
                return false;
            }
            CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData = (CGBridgeBulletinBoardScopeData)bulletinBoardScope.getData();
            if (cGBridgeBulletinBoardScopeData.getCGBridgeScopeType() < 0 && tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("gbbsd: " + cGBridgeBulletinBoardScopeData.getCGBridgeScopeType()));
            }
            int n = CGBridgeMsg.generateHashCode(CGBridgeBBMsgHandler.createSubjectKey(subjectInfo.getBoardName(), subjectInfo.getSubjectName()));
            int n2 = CGBridgeUtils.determineMembertoSend(n, groupMemberIdArray.length);
            GroupMemberId groupMemberId = groupMemberIdArray[n2];
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("proxy to targetbridge: " + groupMemberId + "with hashcode, nummembers " + subjectInfo.hashCode() + ", " + groupMemberIdArray.length));
            }
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sending submsg with scope=" + cGBridgeBulletinBoardScopeData.getCGBridgeScopeType()));
            }
            if (groupMemberId.equals(this.localId)) {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = new CGBridgeBBRemoteSubscriptionMsg(subjectInfo, bl, this.localId.hashCode(), cGBridgeBulletinBoardScopeData, this.slocalCoreGroup);
                this.bridgeListener.cgbMessageReceived(cGBridgeBBRemoteSubscriptionMsg);
            } else {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = new CGBridgeBBRemoteSubscriptionMsg(subjectInfo, bl, groupMemberId.hashCode(), cGBridgeBulletinBoardScopeData, this.slocalCoreGroup);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Sending data to non-collocated core group bridge service: " + CGBridgeUtils.getFullServerName(groupMemberId)));
                }
                byte[] byArray = null;
                try {
                    byArray = ((CGBridgeMsg)cGBridgeBBRemoteSubscriptionMsg).marshallData();
                    this.groupManagedData.sendMessage(groupMemberId, byArray);
                }
                catch (DataStackCongestionException dataStackCongestionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("GSR DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                    }
                    this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                }
                catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("HA exception indicating view is about to be unstable: " + dataStackMembershipChangingException.getMessage()));
                    }
                    this.setPMGStable(false);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"proxySubscription - datastack error");
                    }
                    return false;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems sending serialized subscription...exception=" + exception.getMessage()));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"proxySubscription - error");
                    }
                    return false;
                }
            }
        } else if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BulletinBoardScope is not intended for the core group bridge service: " + bulletinBoardScope));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"proxySubscription", (Object)Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proxySubscriptions(SubjectInfo[] subjectInfoArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"proxySubscriptions");
        }
        if (subjectInfoArray == null || subjectInfoArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"proxySubscriptions subs=0");
            }
            return false;
        }
        SubjectInfo subjectInfo = null;
        try {
            for (int i = 0; i < subjectInfoArray.length; ++i) {
                if (!this.isPMGStable()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"GSR PMG is not stable...store unprocessed subs and return so that subscriptions can be processed after view is rebuilt");
                    }
                    this.savePendingNewSubscriptions(subjectInfoArray, i, bl);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"proxySubscriptions - not stable");
                    }
                    return false;
                }
                subjectInfo = subjectInfoArray[i];
                if (this.proxySubscription(subjectInfo, bl)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subscription could not be sent...storing in temp table");
                }
                Set set = this.tmp_subsTable;
                synchronized (set) {
                    this.tmp_subsTable.add(new CGBSubjectInfo(subjectInfo, bl));
                    this.printTempStorageSize();
                    continue;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".proxySubscriptions"), (String)"4", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("exception on proxy, proxySubs false" + exception));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"proxySubscriptions - exception", (Object)Boolean.FALSE);
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"proxySubscriptions");
        }
        return true;
    }

    void printTempStorageSize() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("temp table size=" + this.tmp_subsTable.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubsToLocalState(SubjectInfo[] subjectInfoArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addSubsToLocalState", (Object)new Object[]{subjectInfoArray});
        }
        if (subjectInfoArray == null || subjectInfoArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addSubsToLocalState-empty subs");
            }
            return;
        }
        Set set = this.storedLocalStateSubs;
        synchronized (set) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("currentSubscriptions size= " + subjectInfoArray.length));
            }
            for (int i = 0; i < subjectInfoArray.length; ++i) {
                if (subjectInfoArray[i].getScope().getType() == -2) {
                    if (this.storedLocalStateSubs.add(subjectInfoArray[i]) || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("gsr already had sub stored: " + subjectInfoArray[i]));
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("wrong scope: " + subjectInfoArray[i]));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("total # stored subs=" + this.storedLocalStateSubs.size()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addSubsToLocalState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubsFromLocalState(SubjectInfo[] subjectInfoArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSubsFromLocalState");
        }
        if (subjectInfoArray == null || subjectInfoArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeSubsFromLocalState-no subs to remove");
            }
            return;
        }
        Set set = this.storedLocalStateSubs;
        synchronized (set) {
            for (int i = 0; i < subjectInfoArray.length; ++i) {
                if (subjectInfoArray[i].getScope().getType() != -2 || this.storedLocalStateSubs.remove(subjectInfoArray[i]) || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("sub was not stored to be removed: " + subjectInfoArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSubsFromLocalState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePendingNewSubscriptions(SubjectInfo[] subjectInfoArray, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"savePendingNewSubscriptions", (Object)new Object[]{subjectInfoArray, new Integer(n), new Boolean(bl)});
        }
        if (tc.isDebugEnabled() && subjectInfoArray != null) {
            Tr.debug((TraceComponent)tc, (String)("Saving " + (subjectInfoArray.length - n) + " subs in temp storage"));
        }
        Set set = this.tmp_subsTable;
        synchronized (set) {
            for (int i = n; i < subjectInfoArray.length; ++i) {
                this.tmp_subsTable.add(new CGBSubjectInfo(subjectInfoArray[i], bl));
            }
            this.printTempStorageSize();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"savePendingNewSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void elected(SubjectInfo[] subjectInfoArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"elected");
        }
        this.elected = true;
        this.addSubsToLocalState(subjectInfoArray);
        if (!this.joined) {
            this.joinGroup();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The Core Group Bridge has joined a group after being elected.");
            }
        }
        if (this.isBridgeEnabled) {
            this.setBridgeWaitingForSubscriptions(true);
        }
        if (subjectInfoArray != null && subjectInfoArray.length != 0) {
            GroupMemberId[] groupMemberIdArray;
            Object object = this.activeBridgesLock;
            synchronized (object) {
                groupMemberIdArray = this.activeBridges;
            }
            if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
                this.savePendingNewSubscriptions(subjectInfoArray, 0, true);
            } else {
                this.proxySubscriptions(subjectInfoArray, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"elected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unelected() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unelected");
        }
        this.elected = false;
        this.setBridgeWaitingForSubscriptions(false);
        this.setPMGStable(false);
        Object object = this.activeCoordinators;
        synchronized (object) {
            this.isActiveCoordinatorChange = false;
        }
        object = this.unsentLocalState;
        synchronized (object) {
            this.unsentLocalState.clear();
        }
        object = this.unsentStateRequests;
        synchronized (object) {
            this.unsentStateRequests.clear();
        }
        this.resetBridgesRequestingState();
        if (this.joined && this.cgbridge == null) {
            this.unjoinGroup();
            this.joined = false;
            object = this.activeBridgesLock;
            synchronized (object) {
                this.activeBridges = new GroupMemberId[0];
            }
            object = this.storedLocalStateSubs;
            synchronized (object) {
                this.storedLocalStateSubs.clear();
            }
            object = this.tmp_subsTable;
            synchronized (object) {
                this.tmp_subsTable.clear();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unelected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriptionsChanged(SubjectInfo[] subjectInfoArray, SubjectInfo[] subjectInfoArray2) {
        GroupMemberId[] groupMemberIdArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"subscriptionsChanged");
        }
        if (!this.elected) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The core group bridge subscription router has not been elected.");
            }
            FFDCFilter.processException((Throwable)new CGBInternalErrorException("The core group bridge subscription router had not been elected when a subscription needed to be processesd."), (String)(this.getClass().getName() + ".subscriptionsChanged"), (String)"5", (Object)this);
            return;
        }
        this.addSubsToLocalState(subjectInfoArray);
        this.removeSubsFromLocalState(subjectInfoArray2);
        Object object = this.activeBridgesLock;
        synchronized (object) {
            groupMemberIdArray = this.activeBridges;
        }
        if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sortedMembers == null - saving list");
            }
            if (subjectInfoArray.length != 0) {
                this.savePendingNewSubscriptions(subjectInfoArray, 0, true);
            }
            if (subjectInfoArray2.length != 0) {
                this.savePendingNewSubscriptions(subjectInfoArray2, 0, false);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sortedMembers != null - proxying Subscriptions");
            }
            this.proxySubscriptions(subjectInfoArray, true);
            this.proxySubscriptions(subjectInfoArray2, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"subscriptionsChanged");
        }
    }

    public void memberMayActivate(GroupName groupName) {
    }

    public void memberMayActivateCancelled(GroupName groupName) {
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"membershipChanged");
        }
        if (this.isBridgeEnabled) {
            this.cgbridge.membershipChanged(groupName, groupMemberIdArray);
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("NewMemberList: " + groupMemberIdArray[i].getServerName()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"membershipChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPMGStable() {
        Object object = this.isPMGStableLock;
        synchronized (object) {
            return this.isPMGStable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPMGStable(boolean bl) {
        Object object = this.isPMGStableLock;
        synchronized (object) {
            this.isPMGStable = bl;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isPMGStable=" + bl));
            }
        }
    }

    public boolean isAlive(GroupName groupName) {
        return true;
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            OnMessageWork onMessageWork = new OnMessageWork(groupMemberId, byArray);
            CGBridgeService.getInstance().getWorkDispatcher().addWork(onMessageWork);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"onMessage", (Object)new Object[]{groupMemberId, byArray});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("GroupMemberID(sending server) is: " + groupMemberId.getServerName()));
            }
            try {
                CGBridgeMsg cGBridgeMsg = CGBridgeBBMsgHandler.processCGBridgeMsg(byArray);
                if (cGBridgeMsg.getMessageType() == 13) {
                    CGBridgeGSRStateRequestMsg cGBridgeGSRStateRequestMsg;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Processing msg for GSR");
                    }
                    if (this.isActiveCoordinatorsMatched((cGBridgeGSRStateRequestMsg = (CGBridgeGSRStateRequestMsg)cGBridgeMsg).getActiveCoordinators())) {
                        byte[] byArray2 = this.getSerializedState(true);
                        if (byArray2 != null) {
                            this.sendLocalStateToServer(groupMemberId, byArray2);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"data==null");
                        }
                    } else {
                        this.addBridgeRequestingState(groupMemberId.getServerName(), cGBridgeGSRStateRequestMsg.getActiveCoordinators());
                    }
                } else if (this.isBridgeEnabled) {
                    this.bridgeListener.cgbMessageReceived(cGBridgeMsg);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("byte [] could not be processed: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".onMessage"), (String)"7676", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onMessage");
            }
        }
    }

    public void removeDeadServers(GroupMemberId[] groupMemberIdArray) {
        if (this.isBridgeEnabled) {
            if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                CGBridgeService.getInstance().getWorkDispatcher().addWork(new CGBRemoveDeadServers(groupMemberIdArray));
            } else {
                this.cgbridge.removeDeadServers(groupMemberIdArray);
            }
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("removeDeadServers: " + groupMemberIdArray[i].getServerName()));
            }
        }
    }

    public void electedAsManagerBegin() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"electedAsManagerBegin");
        }
    }

    public void notElectedAsManager(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                Tr.exit((TraceComponent)tc, (String)("notElectedAsmanager serverlist entry: " + groupMemberIdArray[i].getServerName()));
            }
        }
    }

    public void electedAsManagerEnd(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"electedAsManagerEnd");
        }
        if (this.cgbridge != null) {
            if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                CGBridgeService.getInstance().getWorkDispatcher().addWorkWithPrereqwork(new CGBProcessNewCoordinatorStateWork(map, true), CGB_PROCESS_NEW_COORDINATOR_PREREQ_WORK_TYPES);
            } else {
                this.cgbridge.processNewCoordinatorState(map, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"electedAsManagerEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getLocalState(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalState");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getLocalState synching on startup_Mutex, managers.length=" + groupMemberIdArray.length));
        }
        this.resetBridgesRequestingState();
        Object object = this.startup_Mutex;
        synchronized (object) {
            if (this.isBridgeEnabled) {
                this.cgbridge.getLocalState(groupMemberIdArray);
            }
            GroupMemberId[] groupMemberIdArray2 = groupMemberIdArray;
            Arrays.sort(groupMemberIdArray2, LocalGroupMemberIdComparator.getInstance());
            Object object2 = this.activeBridgesLock;
            synchronized (object2) {
                this.activeBridges = groupMemberIdArray2;
            }
            this.setPMGBridges();
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < groupMemberIdArray2.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("getLocalState sortedMembers[" + i + "].serverName=[" + groupMemberIdArray2[i].getServerName() + "]"));
                }
            }
            byte[][] byArray = this.extractLocalState(groupMemberIdArray, true);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getLocalState", (Object)byArray);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[][] extractLocalState(GroupMemberId[] groupMemberIdArray, boolean bl) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractLocalState", (Object)new Object[]{groupMemberIdArray, new Boolean(bl)});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = this.storedLocalStateSubs;
        synchronized (object3) {
            if (this.storedLocalStateSubs != null) {
                object2 = this.storedLocalStateSubs.iterator();
                try {
                    while (object2.hasNext()) {
                        object = (SubjectInfo)object2.next();
                        CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData = (CGBridgeBulletinBoardScopeData)object.getScope().getData();
                        CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = new CGBridgeBBRemoteSubscriptionMsg((SubjectInfo)object, true, this.localId.hashCode(), cGBridgeBulletinBoardScopeData, this.slocalCoreGroup);
                        arrayList.add(cGBridgeBBRemoteSubscriptionMsg);
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems processing subs: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".extractLocalState"), (String)"6", (Object)this);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("elected=" + this.elected));
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            object3 = new HashMap(4);
            if (this.elected) {
                if (bl) {
                    if (!this.isLocalAndPMGBridgesMatched()) {
                        object3.put(STATE_KEY_SUBS_UNAVAILABLE, null);
                        this.setBridgeWaitingForSubscriptions(true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"set state to wait for subs");
                        }
                    } else {
                        this.setBridgeWaitingForSubscriptions(false);
                    }
                }
                object3.put(STATE_ACTIVE_COORDINATORS, this.getActiveCoordinators());
            } else {
                object3.put(STATE_NOT_ELECTED, null);
            }
            arrayList.add(0, object3);
        }
        byte[][] byArrayArray = new byte[groupMemberIdArray.length][];
        try {
            object3 = new ByteArrayOutputStream();
            object2 = new ObjectOutputStream((OutputStream)object3);
            ((ObjectOutputStream)object2).writeObject(arrayList);
            ((ObjectOutputStream)object2).close();
            ((ByteArrayOutputStream)object3).close();
            object = ((ByteArrayOutputStream)object3).toByteArray();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("local state length=" + ((SubjectInfo)object).length));
            }
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                byArrayArray[i] = (byte[])object;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problems serializing ArrayList: " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".extractLocalState"), (String)"7", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractLocalState");
        }
        return byArrayArray;
    }

    public void newServersOnline(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"newServersOnline");
        }
        if (this.cgbridge != null) {
            if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                CGBridgeService.getInstance().getWorkDispatcher().addWorkWithPrereqwork(new CGBProcessNewCoordinatorStateWork(map, false), CGB_PROCESS_NEW_COORDINATOR_PREREQ_WORK_TYPES);
            } else {
                this.cgbridge.processNewCoordinatorState(map, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"newServersOnline");
        }
    }

    public void waitingForNewServers() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"waitingForNewServers");
        }
    }

    public void mayUnstabilize() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"mayUnstabilize");
        }
        this.setPMGStable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stabilized(MemberStateEnum memberStateEnum) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stabilized");
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            StabilizedPrereqWork stabilizedPrereqWork = new StabilizedPrereqWork();
            CGBridgeService.getInstance().getWorkDispatcher().addWorkWithPrereqwork(new CGBStabilizedWork(memberStateEnum), CGB_STABILIZED_PREREQ_WORK_TYPES);
            HashSet<StabilizedPrereqWork> hashSet = new HashSet<StabilizedPrereqWork>();
            hashSet.add(stabilizedPrereqWork);
            StabilizedWork stabilizedWork = new StabilizedWork();
            stabilizedWork.setPrereqWork(hashSet);
            CGBridgeService.getInstance().getWorkDispatcher().addWork(stabilizedWork);
            this.setPMGStable(true);
            stabilizedPrereqWork.setWorkComplete();
        } else {
            this.setPMGStable(true);
            Set set = this.tmp_subsTable;
            synchronized (set) {
                if (this.activeBridges == null || this.activeBridges.length == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The group membership changed, but no elgible core group bridges could be found.");
                    }
                } else if (this.tmp_subsTable != null && !this.tmp_subsTable.isEmpty()) {
                    CGBSubjectInfo[] cGBSubjectInfoArray = new CGBSubjectInfo[this.tmp_subsTable.size()];
                    this.tmp_subsTable.toArray(cGBSubjectInfoArray);
                    LinkedHashSet<CGBSubjectInfo> linkedHashSet = new LinkedHashSet<CGBSubjectInfo>();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("subs.length=" + cGBSubjectInfoArray.length));
                    }
                    for (int i = 0; i < cGBSubjectInfoArray.length; ++i) {
                        CGBSubjectInfo cGBSubjectInfo = cGBSubjectInfoArray[i];
                        if (this.proxySubscription(cGBSubjectInfo.getSubjectInfo(), cGBSubjectInfo.isSubscribe())) continue;
                        linkedHashSet.add(cGBSubjectInfo);
                    }
                    this.tmp_subsTable = linkedHashSet;
                }
                this.printTempStorageSize();
            }
            this.sendCachedMsgs();
        }
    }

    public void forcedToLeaveHAGroup(String string, String string2, Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBridgeWaitingForSubscriptions() {
        Object object = this.isBridgeWaitingforSubsLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isBridgeWaitingForSubscriptions=" + this.isBridgeWaitingForSubscriptions));
            }
            return this.isBridgeWaitingForSubscriptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBridgeWaitingForSubscriptions(boolean bl) {
        Object object = this.isBridgeWaitingforSubsLock;
        synchronized (object) {
            this.isBridgeWaitingForSubscriptions = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getActiveCoordinators() {
        Set set = this.activeCoordinators;
        synchronized (set) {
            return new HashSet(this.activeCoordinators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveCoordinatorsMatched(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isActiveCoordinatorsMatched", (Object)new Object[]{set});
        }
        boolean bl = false;
        Set set2 = this.activeCoordinators;
        synchronized (set2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activeCoordinators=" + this.activeCoordinators));
            }
            if (set.size() == this.activeCoordinators.size() && this.activeCoordinators.containsAll(set)) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isActiveCoordinatorsMatched-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeCoordinatorChange(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activeCoordinatorChange", (Object)new Object[]{set});
        }
        Set set2 = this.activeCoordinators;
        synchronized (set2) {
            this.isActiveCoordinatorChange = true;
            this.activeCoordinators.clear();
            this.activeCoordinators.addAll(set);
        }
        if (this.isBridgeEnabled && this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            this.cgbridge.updateActiveCoordinators(set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activeCoordinatorChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeMembershipChange(Set set) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bridgeMembershipChange bridgesInView=" + set));
        }
        Object object = this.startup_Mutex;
        synchronized (object) {
            this.localCoreGroupActiveBridges = set;
        }
        if (this.isActiveCoordinatorChange) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Waiting for demarcate callback to send state to bridges");
            }
        } else if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attempting to send local state from bridgeMembershipChange");
            }
            if (!this.sendLocalState()) {
                this.sendStateToWaitingBridges();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeMembershipChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void demarcateSubscriptionChangedCallbacks(SubjectInfo[] subjectInfoArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"demarcateSubscriptionChangedCallbacks");
        }
        HashSet<SubjectInfo> hashSet = new HashSet<SubjectInfo>();
        if (subjectInfoArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fullSetOfSubscribedSubjects=null");
            }
        } else {
            for (int i = 0; i < subjectInfoArray.length; ++i) {
                if (subjectInfoArray[i].getScope().getType() != -2) continue;
                hashSet.add(subjectInfoArray[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("fullSetOfSubscribedSubjects.length=" + subjectInfoArray.length));
            }
        }
        if (n == 0 || n == 1) {
            Set set = this.storedLocalStateSubs;
            synchronized (set) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("replacing existing subs. size=" + this.storedLocalStateSubs.size()));
                }
                this.storedLocalStateSubs.clear();
                this.storedLocalStateSubs.addAll(hashSet);
            }
        }
        if (this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled() && !this.sendLocalState()) {
            this.sendStateToWaitingBridges();
        }
        Set set = this.activeCoordinators;
        synchronized (set) {
            this.isActiveCoordinatorChange = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"demarcateSubscriptionChangedCallbacks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCachedMsgs() {
        LinkedList linkedList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendCachedMsgs", (Object)this);
        }
        Object object = this.msgCache;
        synchronized (object) {
            if (!this.msgCache.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Sending gsr cached msg(s) - size=" + this.msgCache.size()));
                }
                linkedList = new LinkedList(this.msgCache);
                this.msgCache.clear();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("gsr msgCache size=" + this.msgCache.size()));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"gsr msgCache is empty");
                }
                return;
            }
        }
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (CachedMsg)iterator.next();
                this.sendMessage(((CachedMsg)object).getGmId(), ((CachedMsg)object).getData());
            }
            linkedList = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendCachedMsgs");
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean sendMessage(GroupMemberId var1_1, byte[] var2_2) {
        if (CGBridgeSubscriptionRouter.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)"sendMessage", (Object)new Object[]{CGBridgeUtils.getFullServerName(var1_1), var2_2});
        }
        if (this.isPMGStable()) {
            try {
                this.groupManagedData.sendMessage(var1_1, var2_2);
                if (CGBridgeSubscriptionRouter.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)"sendMessage", (Object)Boolean.TRUE);
                }
                return true;
            }
            catch (DataStackCongestionException var3_3) {
                if (CGBridgeSubscriptionRouter.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)("GSR DataStackCongestionException: " + var3_3.getMessage()));
                }
                this.messageProcessor.addMessageToResend(var1_1, var2_2, null, null);
                if (CGBridgeSubscriptionRouter.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)"sendMessage", (Object)Boolean.TRUE);
                }
                return true;
            }
            catch (Exception var3_4) {
                this.storeMessage(var1_1, var2_2);
                if (!CGBridgeSubscriptionRouter.tc.isDebugEnabled()) ** GOTO lbl24
                Tr.debug((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)("sendMessage: exception sending msg: " + var3_4.getMessage()));
            }
        } else {
            this.storeMessage(var1_1, var2_2);
            if (CGBridgeSubscriptionRouter.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)"Not ready to send msg, pmg unstable for GSR");
            }
        }
lbl24:
        // 5 sources

        if (CGBridgeSubscriptionRouter.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)CGBridgeSubscriptionRouter.tc, (String)"sendMessage", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeMessage", (Object)new Object[]{groupMemberId, byArray});
        }
        List list = this.msgCache;
        synchronized (list) {
            this.msgCache.add(new CachedMsg(byArray, groupMemberId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeMessage");
        }
    }

    public void resendMessages(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resendMessages");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("# msgs = " + list.size()));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                CachedMsg cachedMsg = (CachedMsg)iterator.next();
                this.sendMessage(cachedMsg.getGmId(), cachedMsg.getData());
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("problems resending gsr msg: " + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resendMessages");
        }
    }

    class StabilizedPrereqWork
    extends Work {
        public StabilizedPrereqWork() throws IllegalArgumentException {
            super(1, false, STABILIZED_PREREQ_WORK);
        }

        public void doWork() {
        }
    }

    class StabilizedWork
    extends Work {
        public StabilizedWork() throws IllegalArgumentException {
            super(6, true, STABILIZED_WORK);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWork() {
            GroupMemberId[] groupMemberIdArray;
            Object object = CGBridgeSubscriptionRouter.this.activeBridgesLock;
            synchronized (object) {
                groupMemberIdArray = CGBridgeSubscriptionRouter.this.activeBridges;
            }
            object = CGBridgeSubscriptionRouter.this.tmp_subsTable;
            synchronized (object) {
                if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The group membership changed, but no elgible core group bridges could be found.");
                    }
                } else if (CGBridgeSubscriptionRouter.this.tmp_subsTable != null && !CGBridgeSubscriptionRouter.this.tmp_subsTable.isEmpty()) {
                    CGBSubjectInfo[] cGBSubjectInfoArray = new CGBSubjectInfo[CGBridgeSubscriptionRouter.this.tmp_subsTable.size()];
                    CGBridgeSubscriptionRouter.this.tmp_subsTable.toArray(cGBSubjectInfoArray);
                    LinkedHashSet<CGBSubjectInfo> linkedHashSet = new LinkedHashSet<CGBSubjectInfo>();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("subs.length=" + cGBSubjectInfoArray.length));
                    }
                    for (int i = 0; i < cGBSubjectInfoArray.length; ++i) {
                        CGBSubjectInfo cGBSubjectInfo = cGBSubjectInfoArray[i];
                        if (CGBridgeSubscriptionRouter.this.proxySubscription(cGBSubjectInfo.getSubjectInfo(), cGBSubjectInfo.isSubscribe())) continue;
                        linkedHashSet.add(cGBSubjectInfo);
                    }
                    CGBridgeSubscriptionRouter.this.tmp_subsTable = linkedHashSet;
                }
                CGBridgeSubscriptionRouter.this.printTempStorageSize();
            }
            if (CGBridgeSubscriptionRouter.this.config.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
                CGBridgeSubscriptionRouter.this.resendStateRequestMsgs();
                CGBridgeSubscriptionRouter.this.resendLocalGSRStateMsgs();
                CGBridgeSubscriptionRouter.this.sendLocalState();
            }
            CGBridgeSubscriptionRouter.this.sendCachedMsgs();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stabilized");
            }
        }
    }

    class CGBStabilizedWork
    extends Work {
        private MemberStateEnum members;

        public CGBStabilizedWork(MemberStateEnum memberStateEnum) throws IllegalArgumentException {
            super(10, true, CGB_STABILIZED_WORK);
            this.members = memberStateEnum;
        }

        public void doWork() {
            if (CGBridgeSubscriptionRouter.this.isBridgeEnabled) {
                CGBridgeSubscriptionRouter.this.cgbridge.stabilized(this.members);
            }
        }
    }

    class CGBRemoveDeadServers
    extends Work {
        GroupMemberId[] members;

        public CGBRemoveDeadServers(GroupMemberId[] groupMemberIdArray) throws IllegalArgumentException {
            super(10, true, CGB_REMOVE_DEAD_SERVERS_WORK);
            this.members = groupMemberIdArray;
        }

        public void doWork() {
            if (CGBridgeSubscriptionRouter.this.isBridgeEnabled) {
                CGBridgeSubscriptionRouter.this.cgbridge.removeDeadServers(this.members);
            }
        }
    }

    class OnMessageWork
    extends Work {
        GroupMemberId sender;
        byte[] msg;

        public OnMessageWork(GroupMemberId groupMemberId, byte[] byArray) throws IllegalArgumentException {
            super(5, true, ON_MESSAGE_WORK);
            this.sender = groupMemberId;
            this.msg = byArray;
        }

        public void doWork() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"onMessage", (Object)new Object[]{this.sender, this.msg});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("GroupMemberID(sending server) is: " + this.sender.getServerName()));
            }
            try {
                CGBridgeMsg cGBridgeMsg = CGBridgeBBMsgHandler.processCGBridgeMsg(this.msg);
                if (cGBridgeMsg.getMessageType() == 13) {
                    CGBridgeGSRStateRequestMsg cGBridgeGSRStateRequestMsg;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Processing msg for GSR");
                    }
                    if (CGBridgeSubscriptionRouter.this.isActiveCoordinatorsMatched((cGBridgeGSRStateRequestMsg = (CGBridgeGSRStateRequestMsg)cGBridgeMsg).getActiveCoordinators())) {
                        byte[] byArray = CGBridgeSubscriptionRouter.this.getSerializedState(true);
                        if (byArray != null) {
                            CGBridgeSubscriptionRouter.this.sendLocalStateToServer(this.sender, byArray);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"data==null");
                        }
                    } else {
                        CGBridgeSubscriptionRouter.this.addBridgeRequestingState(this.sender.getServerName(), cGBridgeGSRStateRequestMsg.getActiveCoordinators());
                    }
                } else if (CGBridgeSubscriptionRouter.this.isBridgeEnabled) {
                    CGBridgeSubscriptionRouter.this.bridgeListener.cgbMessageReceived(cGBridgeMsg);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("byte [] could not be processed: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".onMessage"), (String)"7676", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"onMessage");
            }
        }
    }

    class CGBProcessNewCoordinatorStateWork
    extends Work {
        private Map newServerLocalState;
        boolean isNewBridgesOnline;

        public CGBProcessNewCoordinatorStateWork(Map map, boolean bl) throws IllegalArgumentException {
            super(10, true, CGB_PROCESS_NEW_COORDINATOR_WORK);
            this.newServerLocalState = map;
            this.isNewBridgesOnline = bl;
        }

        public void doWork() {
            if (CGBridgeSubscriptionRouter.this.cgbridge != null) {
                CGBridgeSubscriptionRouter.this.cgbridge.processNewCoordinatorState(this.newServerLocalState, this.isNewBridgesOnline);
            }
        }
    }

    class CGBSubjectInfo {
        SubjectInfo si;
        boolean isSubscribe;

        public CGBSubjectInfo(SubjectInfo subjectInfo, boolean bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("si=" + subjectInfo + "isSubscribe=" + bl));
            }
            this.si = subjectInfo;
            this.isSubscribe = bl;
        }

        boolean isSubscribe() {
            return this.isSubscribe;
        }

        SubjectInfo getSubjectInfo() {
            return this.si;
        }
    }
}

