/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBBEventsHandler;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.msg.CGBridgeBBPostMsg;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionProxyEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.util.Set;

public final class InitialSubjectSubscriptionEventCallback
implements SubjectSubscriptionProxyEvents {
    private static final TraceComponent tc = Tr.register((Class)InitialSubjectSubscriptionEventCallback.class, null, null);
    private static final String NAME = "InitialSubjectSubscriptionEventCallback";
    private String originCoreGroupName;
    private String apgName;
    private GroupMemberId gmid;
    private boolean isInitialUpdateCalled;
    private Boolean isSubscribed;
    private String callbackName = "InitialSubjectSubscriptionEventCallback";
    boolean isTransferUpdateCallback;
    CGBridgeBBEventsHandler handler;

    InitialSubjectSubscriptionEventCallback(String string, String string2, GroupMemberId groupMemberId, CGBridgeBBEventsHandler cGBridgeBBEventsHandler) {
        this(string, string2, groupMemberId, cGBridgeBBEventsHandler, false);
    }

    InitialSubjectSubscriptionEventCallback(String string, String string2, GroupMemberId groupMemberId, CGBridgeBBEventsHandler cGBridgeBBEventsHandler, boolean bl) {
        this.originCoreGroupName = string2;
        this.gmid = groupMemberId;
        this.apgName = string;
        this.handler = cGBridgeBBEventsHandler;
        this.isTransferUpdateCallback = bl;
        this.isInitialUpdateCalled = false;
        this.isSubscribed = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray, Set set) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updated initial " + this.originCoreGroupName));
        }
        if (!CGBridgeService.getInstance().isServiceRunning()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updated-service stopped");
            }
            return;
        }
        if (this.isTransferUpdateCallback) {
            boolean bl = false;
            InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = this;
            synchronized (initialSubjectSubscriptionEventCallback) {
                if (!this.isInitialUpdateCalled) {
                    this.isInitialUpdateCalled = true;
                    bl = true;
                }
            }
            if (bl) {
                this.handler.updated(subjectSubscription, subjectValueArray, set, true);
            } else {
                this.handler.updated(subjectSubscription, subjectValueArray, set, false);
            }
        } else {
            InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = this;
            synchronized (initialSubjectSubscriptionEventCallback) {
                if (this.isInitialUpdateCalled) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updated initial - initial update already sent");
                    }
                    this.unsubscribe(subjectSubscription);
                    return;
                }
                CGBridgeBBPostMsg cGBridgeBBPostMsg = this.handler.processUpdate(subjectSubscription, subjectValueArray, set, true);
                this.handler.cgb.handleInitialUpdate(cGBridgeBBPostMsg, this.gmid, this.originCoreGroupName, this.apgName);
                this.isInitialUpdateCalled = true;
                this.unsubscribe(subjectSubscription);
            }
        }
    }

    private void unsubscribe(SubjectSubscription subjectSubscription) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsubscribe");
        }
        if (this.isSubscribed.equals(Boolean.TRUE)) {
            block8: {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("unsubscribing to " + subjectSubscription.getSubject()));
                    }
                    this.handler.subscriptionTracker.unsubscribeInitial(subjectSubscription, this.gmid);
                }
                catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"subjSubscript already closed");
                }
            }
            this.isSubscribed = Boolean.FALSE;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsubscribed already");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsubscribe");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.callbackName).append("/").append(" originCoreGroupName=").append(this.originCoreGroupName).append(" apgName=").append(this.apgName).append(" isInitialUpdateSent=").append(this.isInitialUpdateCalled).append(" isSubscribed=").append(this.isSubscribed);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialUpdateCalled() {
        InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = this;
        synchronized (initialSubjectSubscriptionEventCallback) {
            return this.isInitialUpdateCalled;
        }
    }
}

