/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cgbridge.config.AccessPointGroup;
import com.ibm.ws.cgbridge.config.AccessPointGroupTopology;
import com.ibm.ws.cgbridge.config.CGBVersion;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.CGBridgeEndPoint;
import com.ibm.ws.cgbridge.config.MemberData;
import com.ibm.ws.cgbridge.config.PeerAccessPoint;
import com.ibm.ws.cgbridge.core.BridgeServerUpdateRegistryCallback;
import com.ibm.ws.cgbridge.core.CGBridgeBBPost;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.CachedSubscription;
import com.ibm.ws.cgbridge.core.impl.BridgeServerUpdateRegistry;
import com.ibm.ws.cgbridge.core.impl.BridgeViewChangeRegister;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBBEventsHandler;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.CGBridgeStoredSubscription;
import com.ibm.ws.cgbridge.core.impl.IBCGCachedSubscription;
import com.ibm.ws.cgbridge.core.impl.InterCGBridgePMGEvents;
import com.ibm.ws.cgbridge.core.impl.LocalBridgeServerUpdateRegistry;
import com.ibm.ws.cgbridge.core.impl.StoredGSRSub;
import com.ibm.ws.cgbridge.core.impl.SubscriptionCache;
import com.ibm.ws.cgbridge.core.impl.Work;
import com.ibm.ws.cgbridge.core.impl.WorkType;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.exception.CGBInvalidParameterException;
import com.ibm.ws.cgbridge.msg.CGBridgeBBPostMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeBBSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeHAStateMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeStateCompleteMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeStatusMsg;
import com.ibm.ws.cgbridge.msg.CoreGroupPostsMsg;
import com.ibm.ws.cgbridge.util.CGBMessageReprocessorCallback;
import com.ibm.ws.cgbridge.util.CGBMesssageReprocessor;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.cgbridge.util.CachedMsg;
import com.ibm.ws.cgbridge.util.EnumType;
import com.ibm.ws.cgbridge.util.InterBridgeGroupMemberIdComparator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.hamanager.corestack.CoreStackFactory;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStackListener;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackCongestionException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupCallback;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupData;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupDataFactory;
import com.ibm.wsspi.hamanager.partitionedmanager.PartitionedManagerGroup;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class InterBridgeCoreGroup
implements CoreStackListener,
BridgeServerUpdateRegistryCallback,
CGBMessageReprocessorCallback,
AlarmListener {
    static final TraceComponent tc = Tr.register((Class)InterBridgeCoreGroup.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    public static final EnumType SEND_MESSAGE_SUCCESS = new EnumType("Success", 0);
    public static final EnumType SEND_MESSAGE_FAILURE = new EnumType("Failure", 1);
    public static final EnumType SEND_MESSAGE_FAILURE_DCS_CONGESTION = new EnumType("DCS Congestion", 2);
    private static final long LAST_SUB_PROCESSING_DELAY = 5000L;
    private static final long CACHED_MESSAGES_SEND_DELAY = 60000L;
    private static EnumType MSG_PROCESSOR_FORWARD_UPDATE_DIRECTLY = new EnumType("ForwardUpdateDirectly", 1);
    private static final int UNSET_VIEW_CHANGE_ID = -1;
    private static final int LOCK_RESEND_MSG_LIMIT = 100;
    private String cellNameLocal;
    private String nodeName;
    private String processType;
    private String processName;
    String accessPointGroupName;
    private String coreGroupNameLocal;
    private String myGroupName;
    private boolean bCrossCell;
    private GroupName interCGBGroupName;
    private HashMap peerSubscriptions = new HashMap();
    private int postCacheSize;
    private int msgCacheSize;
    private List postMsgCache;
    private boolean isPostMsgCacheEnabled;
    private List msgCache;
    private boolean isMsgCacheEnabled;
    private boolean isCachedMsgsSent = true;
    private boolean isCachedPostsSent = true;
    private boolean isCachedSubscriptionsSent = true;
    private boolean isPMGSubsProcessed = true;
    private CoreStack interCGBCoreStack;
    private GroupManager interCGBGroupManager;
    private ManagedGroupData primaryManagedGroup;
    private PartitionedManagerGroup pmg;
    private boolean isPrimaryMgdGroupStable = true;
    private ArrayList localCoregroupMembers = new ArrayList();
    private ArrayList remoteCellMembers = new ArrayList();
    private ArrayList coreGroupList = new ArrayList();
    private String localPMGServerName;
    private GroupMemberId localGroupMember;
    CGBridgeService cgbridgeService;
    private HashMap remoteCellCoreGroupMembers = new HashMap();
    private CGBridgeConfig cgbConfig;
    private AccessPointGroup apgrouplocal;
    private AccessPointGroupTopology localAPGTopology;
    CGBridge cgb;
    private CoreStackFactory csFactory;
    private InterCGBridgePMGEvents localPMGEvents;
    private Map availableCGBServersMap = new HashMap();
    boolean isLocalAPGAvailable;
    private CGBridgeBBEventsHandler gwbbehglobal;
    private Map storedSubsTable = new LinkedHashMap();
    private static final String PMG_GROUP_NAME = "CGBG";
    static final WorkType CACHED_SUBSCRIPTION_WORK = new WorkType("CACHED_SUBSCRIPTION_WORK");
    protected Object pmgStabilityLock = new Object();
    private boolean reInitCoreGroup = false;
    CGBVersion version;
    Map updateRegisterMap;
    LocalBridgeServerUpdateRegistry localUpdateRegistry;
    int localViewChangeCount;
    CachedGSRSubMsg cachedGSRSubMsg;
    Map gsrSubProcessorMap;
    int getPeerSubscriptionsStoredIndex = -2;
    Set nonSeamlessBridges;
    CGBMesssageReprocessor messageProcessor;
    Map mgdLookUp;
    boolean isInterAndLocalPMGBridgesMatched = false;
    Object isInterAndLocalPMGBridgesMatchedLock = new Object();
    Set cachedSubscriptions;
    Map storedReceivedSubscriptions;
    final WorkType gsrSubMsgSubscriptionWork = new WorkType("GSR_SUB_MSG_SUBSCRIPTION_WORK");
    final WorkType subscribeSubscriptionRebuildWork = new WorkType("SUBSCRIBE_SUBSCRIPTION_REBUILD_WORK");
    final WorkType unsubscribeSubscriptionRebuildWork = new WorkType("UNSUBSCRIBE_SUBSCRIPTION_REBUILD_WORK");
    final WorkType[] lastSubscribePrereqWork = new WorkType[]{this.subscribeSubscriptionRebuildWork};

    public InterBridgeCoreGroup(CGBridgeService cGBridgeService, CGBridgeConfig cGBridgeConfig, String string, CGBridge cGBridge, AccessPointGroup accessPointGroup, CoreStackFactory coreStackFactory, CGBridgeBBEventsHandler cGBridgeBBEventsHandler) {
        this.storedReceivedSubscriptions = new LinkedHashMap();
        this.cachedSubscriptions = new LinkedHashSet();
        this.mgdLookUp = new HashMap();
        this.messageProcessor = new CGBMesssageReprocessor(this);
        this.cgbConfig = cGBridgeConfig;
        this.cgb = cGBridge;
        this.coreGroupNameLocal = string;
        this.bCrossCell = accessPointGroup.isInterCell();
        this.cgbridgeService = cGBridgeService;
        this.cachedGSRSubMsg = new CachedGSRSubMsg();
        this.gsrSubProcessorMap = new HashMap();
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.createLocalUpdateRegistry();
        this.accessPointGroupName = accessPointGroup.getName();
        this.apgrouplocal = accessPointGroup;
        this.gwbbehglobal = cGBridgeBBEventsHandler;
        this.nonSeamlessBridges = new HashSet();
        this.cellNameLocal = adminService.getCellName();
        this.nodeName = adminService.getNodeName();
        this.processType = adminService.getProcessType();
        this.processName = adminService.getProcessName();
        this.csFactory = coreStackFactory;
        this.postMsgCache = new LinkedList();
        this.msgCache = new LinkedList();
        this.myGroupName = CGBridgeUtils.generateCGKey(this.cellNameLocal, this.coreGroupNameLocal);
        this.updateRegisterMap = new HashMap();
        this.version = cGBridgeConfig.getLocalBridgeCGBVersion();
        this.initPostCacheSize();
        this.initMsgCacheSize();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("postCacheSize=" + this.postCacheSize + " isPostMsgCacheEnabled=" + this.isPostMsgCacheEnabled));
            Tr.debug((TraceComponent)tc, (String)("msgCacheSize=" + this.msgCacheSize + " isMsgCacheEnabled=" + this.isMsgCacheEnabled));
        }
        this.localAPGTopology = this.determineInterBridgeCoreGroupAPGTopology();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("local APG Topology=" + this.localAPGTopology.getName()));
        }
        try {
            this.initCoreGroup();
        }
        catch (CGBInternalErrorException cGBInternalErrorException) {
            String string2 = " unable to initialize coregroup for access point group " + this.accessPointGroupName + " " + cGBInternalErrorException;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)string2);
            }
            FFDCFilter.processException((Throwable)cGBInternalErrorException, (String)string2, (String)"40", (Object)this);
        }
        AlarmManager.createNonDeferrable((long)60000L, (AlarmListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNonSeamlessBridge(String string) {
        Set set = this.nonSeamlessBridges;
        synchronized (set) {
            this.nonSeamlessBridges.add(string);
        }
    }

    private Object[] initCache(String string, int n) {
        int n2;
        boolean bl;
        block11: {
            String string2 = (String)this.apgrouplocal.getProperties().get(string);
            bl = true;
            n2 = n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("strPostCacheSize=" + string2));
            }
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)("Unable to parse custom prop: " + string + "...will use default value: " + n));
                }
            }
        }
        if (n2 < 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cache size is UNLIMITED");
            }
            n2 = Integer.MAX_VALUE;
        } else if (n2 == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No cache");
            }
            bl = false;
            n2 = 0;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cache size is " + n2));
        }
        return new Object[]{new Integer(n2), new Boolean(bl)};
    }

    private void initMsgCacheSize() {
        Object[] objectArray = this.initCache("cgb.msgCache.size", -1);
        this.msgCacheSize = (Integer)objectArray[0];
        this.isMsgCacheEnabled = (Boolean)objectArray[1];
    }

    private void initPostCacheSize() {
        Object[] objectArray = this.initCache("cgb.postCache.size", 200000);
        this.postCacheSize = (Integer)objectArray[0];
        this.isPostMsgCacheEnabled = (Boolean)objectArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InterCGBridgePMGEvents getInterCGBridgePMGEvents(String string) {
        Map map = this.mgdLookUp;
        synchronized (map) {
            return (InterCGBridgePMGEvents)this.mgdLookUp.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateInterAndLocalPMGBridgesMatched(GroupMemberId[] groupMemberIdArray) {
        Object object = this.isInterAndLocalPMGBridgesMatchedLock;
        synchronized (object) {
            this.isInterAndLocalPMGBridgesMatched = this.isGroupMembersEqual(groupMemberIdArray);
            return this.isInterAndLocalPMGBridgesMatched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInterAndLocalPMGBridgesMatched() {
        Object object = this.isInterAndLocalPMGBridgesMatchedLock;
        synchronized (object) {
            return this.isInterAndLocalPMGBridgesMatched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void initCoreGroup() throws CGBInternalErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initCoreGroup");
        }
        String string = this.accessPointGroupName;
        try {
            Object object = this.pmgStabilityLock;
            // MONITORENTER : object
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initCoreGroup synched on startUp_Mutex");
            }
            try {
                this.interCGBCoreStack = this.createICGBCoreStack(this.csFactory, string);
            }
            catch (CGBInternalErrorException cGBInternalErrorException) {
                throw new CGBInternalErrorException("Error creating cross bridge corestack " + cGBInternalErrorException);
            }
            if (tc.isDebugEnabled()) {
                this.debugLocalCoregroupMembers();
                this.debugRemoteCellMembers();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("NODENAME", this.nodeName);
            hashMap.put("PROCESS_TYPE", this.processType);
            hashMap.put("serverid", this.processName);
            hashMap.put("CELLNAME", this.cellNameLocal);
            hashMap.put("COREGROUPNAME", this.coreGroupNameLocal);
            ManagedGroupDataFactory managedGroupDataFactory = this.interCGBCoreStack.getManagedGroupDataFactory();
            ManagedGroupData[] managedGroupDataArray = new ManagedGroupData[this.coreGroupList.size()];
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("GroupName", PMG_GROUP_NAME);
            hashMap2.put("policy", "DefaultNOOPPolicy");
            this.interCGBGroupManager = this.interCGBCoreStack.getGroupManager();
            this.interCGBGroupName = this.interCGBGroupManager.createGroupName(hashMap2);
            for (int i = 0; i < this.coreGroupList.size(); ++i) {
                int n;
                String string2 = (String)this.coreGroupList.get(i);
                int n2 = string2.indexOf(":");
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1, string2.length());
                boolean bl = string3.equals(this.cellNameLocal) && string4.equals(this.coreGroupNameLocal);
                InterCGBridgePMGEvents interCGBridgePMGEvents = new InterCGBridgePMGEvents(this, string2, bl);
                String[] stringArray = this.mgdLookUp;
                // MONITORENTER : this.mgdLookUp
                this.mgdLookUp.put(string2, interCGBridgePMGEvents);
                // MONITOREXIT : stringArray
                if (bl) {
                    this.localPMGEvents = interCGBridgePMGEvents;
                    interCGBridgePMGEvents.setManagerNames(new HashSet(this.localCoregroupMembers));
                    stringArray = this.localCoregroupMembers.toArray(new String[this.localCoregroupMembers.size()]);
                    managedGroupDataArray[i] = managedGroupDataFactory.createManagedGroupData(string2, true, true, true, stringArray.length, stringArray, (ManagedGroupCallback)interCGBridgePMGEvents);
                    if (tc.isDebugEnabled()) {
                        if (managedGroupDataArray[i] == null) {
                            Tr.debug((TraceComponent)tc, (String)"(primary group) factory returned null for managedgroupdata");
                        }
                        for (n = 0; n < stringArray.length; ++n) {
                            Tr.debug((TraceComponent)tc, (String)("managed group constructed with preferredmanagers: " + n + " server: " + stringArray[n]));
                        }
                    }
                    this.primaryManagedGroup = managedGroupDataArray[i];
                    continue;
                }
                stringArray = this.filterForCG(string3, string4);
                managedGroupDataArray[i] = managedGroupDataFactory.createManagedGroupData(string2, true, true, true, stringArray.length, stringArray, (ManagedGroupCallback)interCGBridgePMGEvents);
                if (!tc.isDebugEnabled()) continue;
                if (managedGroupDataArray[i] == null) {
                    Tr.debug((TraceComponent)tc, (String)"(secondarygroup) factory returned null for managedgroupdata");
                }
                for (n = 0; n < stringArray.length; ++n) {
                    Tr.debug((TraceComponent)tc, (String)("alternate group constructed with preferredmanagers: " + n + " server: " + stringArray[n]));
                }
            }
            this.pmg = this.interCGBGroupManager.createPartitionedManagerGroup(this.interCGBGroupName, hashMap, managedGroupDataArray);
            this.localGroupMember = this.pmg.getMemberName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Local member set: " + this.localGroupMember.getServerName()));
            }
            // MONITOREXIT : object
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, (String)(this.getClass().getName() + ".initCoreGroup"), (String)"10", (Object)this);
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)(this.getClass().getName() + ".initCoreGroup"), (String)"20", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Inter Bridge Core Stack successfully started");
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"initCoreGroup");
    }

    private AccessPointGroupTopology determineInterBridgeCoreGroupAPGTopology() {
        if (this.apgrouplocal.isTopologySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using APG topology" + this.apgrouplocal.getTopology().getName()));
            }
            return this.apgrouplocal.getTopology();
        }
        return this.cgb.getAPGTopology();
    }

    private void debugLocalCoregroupMembers() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.localCoregroupMembers.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)this.localCoregroupMembers.get(i) + " ");
        }
        Tr.debug((TraceComponent)tc, (String)("LocalCoregroupMembers=[" + new String(stringBuffer) + "]"));
    }

    private void debugRemoteCellMembers() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.remoteCellMembers.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)this.remoteCellMembers.get(i) + " ");
        }
        Tr.debug((TraceComponent)tc, (String)("RemoteCellMembers=[" + new String(stringBuffer) + "]"));
    }

    void reinitializeManagerSubscriptions(GroupMemberId[] groupMemberIdArray) {
        this.cgb.reinitializeSubscriptions(groupMemberIdArray, this.myGroupName, this.accessPointGroupName);
    }

    boolean isMessageForThisBridge(int n) {
        return this.localPMGEvents.isMessageForThisBridge(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCoreGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeCoreGroup", (Object)new Object[]{string});
        }
        HashMap hashMap = this.remoteCellCoreGroupMembers;
        synchronized (hashMap) {
            this.remoteCellCoreGroupMembers.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCoreGroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMemberList(String string, GroupMemberId[] groupMemberIdArray) {
        if (!string.equals(this.myGroupName)) {
            HashMap hashMap = this.remoteCellCoreGroupMembers;
            synchronized (hashMap) {
                this.remoteCellCoreGroupMembers.put(string, this.filterlocalCGBridges(groupMemberIdArray));
            }
        }
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isUpdateRoutingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateMemberList remoteCellCoreGroupMembers now: " + this.remoteCellCoreGroupMembersToString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String remoteCellCoreGroupMembersToString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        if (null != this.remoteCellCoreGroupMembers) {
            HashMap hashMap = this.remoteCellCoreGroupMembers;
            synchronized (hashMap) {
                Iterator iterator = this.remoteCellCoreGroupMembers.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    GroupMemberId[] groupMemberIdArray = (GroupMemberId[])this.remoteCellCoreGroupMembers.get(string);
                    stringBuffer.append("   groupName=[" + string + "] numValues=" + groupMemberIdArray.length + "\n");
                    for (int i = 0; i < groupMemberIdArray.length; ++i) {
                        stringBuffer.append("      " + groupMemberIdArray[i].getServerName() + "\n");
                    }
                }
            }
        }
        return new String(stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean resendSubscriptions() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resendSubscriptions");
        }
        LinkedHashMap linkedHashMap = null;
        boolean bl = false;
        boolean bl2 = false;
        ProcessedCacheEntryResult processedCacheEntryResult = null;
        while (!bl) {
            Map map = this.storedSubsTable;
            synchronized (map) {
                if (!this.storedSubsTable.isEmpty()) {
                    if (processedCacheEntryResult != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("resendSubscriptions: pcer.remainingEntries=" + processedCacheEntryResult.numRemainingEntries));
                        }
                        if (processedCacheEntryResult.numRemainingEntries == this.storedSubsTable.size()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"resendSubscriptions: same # of entries that failed to process..exiting");
                            }
                            break;
                        }
                    }
                    linkedHashMap = new LinkedHashMap(this.storedSubsTable);
                    this.storedSubsTable.clear();
                    if (linkedHashMap.size() >= 100) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("processing " + linkedHashMap.size() + " subs outside lock"));
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("processing " + linkedHashMap.size() + " subs inside lock"));
                        }
                        bl = true;
                        processedCacheEntryResult = this.processCachedSubscriptions(linkedHashMap);
                        if (!processedCacheEntryResult.rc) {
                            return false;
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"storedSubsTable is empty");
                    }
                    bl = true;
                }
            }
            if (!bl) {
                processedCacheEntryResult = this.processCachedSubscriptions(linkedHashMap);
                if (processedCacheEntryResult.rc) continue;
                return false;
            }
            if (bl2) continue;
            bl2 = true;
            this.setCachedSubscriptionsSent(true);
            bl = false;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resendSubscriptions");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessedCacheEntryResult processCachedSubscriptions(Map map) {
        if (map != null && !map.isEmpty()) {
            Map.Entry entry;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sending out " + map.size() + " stored subscriptions"));
            }
            Iterator iterator = map.entrySet().iterator();
            boolean bl = true;
            while (iterator.hasNext() && bl) {
                entry = iterator.next();
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)entry.getKey();
                PeerAccessPoint peerAccessPoint = (PeerAccessPoint)entry.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resending cached subscription: " + cGBridgeBBRemoteSubscriptionMsg));
                }
                if (!this.getBridgeVersion().isSeamlessFailoverEnabled() || this.cgb.isMessageForLocalPMG(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode())) {
                    if (null != peerAccessPoint) {
                        bl = this.findCGBridgeAndSendMessage(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint, true);
                        if (bl) {
                            iterator.remove();
                            continue;
                        }
                        if (!this.isPrimaryMgdGroupStable()) continue;
                        bl = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"pap: pmg still stable...continue processing");
                        continue;
                    }
                    bl = this.findCGBridgeAndSendMessage(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), cGBridgeBBRemoteSubscriptionMsg, true);
                    if (bl) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.isPrimaryMgdGroupStable()) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"pmg still stable...continue processing");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(cGBridgeBBRemoteSubscriptionMsg.getBBName() + ":" + cGBridgeBBRemoteSubscriptionMsg.getSubject() + " sub no longer hashes to this bridge, so it will not be resent"));
                }
                iterator.remove();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("storedSubs.size()=" + map.size()));
            }
            if (!map.isEmpty()) {
                Map map2 = this.storedSubsTable;
                synchronized (map2) {
                    iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        if (this.storedSubsTable.containsKey(entry.getKey())) continue;
                        this.storedSubsTable.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processCachedSubscriptions: stopped processing subs due to pmg not being stable: " + this.getAccessPointGroupName()));
                }
                return new ProcessedCacheEntryResult(false, map.size());
            }
        }
        return new ProcessedCacheEntryResult(true, map == null ? 0 : map.size());
    }

    protected void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"shutting down corestack");
        }
        this.interCGBCoreStack.shutdown();
    }

    void forwardMessage(CGBridgeMsg cGBridgeMsg, String string) {
        this.cgb.forwardMessage(cGBridgeMsg, this.getAccessPointGroupName(), string);
    }

    boolean sendCoreGroupPostsMsg(CoreGroupPostsMsg coreGroupPostsMsg, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendCoreGroupPostsMsg", (Object)new Object[]{coreGroupPostsMsg, string});
        }
        boolean bl = false;
        try {
            bl = this.forwardUpdateDirectly(coreGroupPostsMsg, null, string, this.getCellName().compareTo(coreGroupPostsMsg.getPostCellName()) == 0, null, false, coreGroupPostsMsg.marshallData());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("likely problem serialzing CoreGroupPostsMsg: " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".sendCoreGroupPostsMsg"), (String)"48489", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendCoreGroupPostsMsg-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean forwardUpdateDirectly(CGBridgeBBPost cGBridgeBBPost, GroupMemberId groupMemberId, String string, boolean bl, String string2, boolean bl2, byte[] byArray) {
        Object object;
        boolean bl3;
        GroupMemberId groupMemberId2;
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"forwardUpdateDirectly", (Object)new Object[]{bl});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sending post: core group=" + string + ", bb=" + cGBridgeBBPost.getBBName() + ", subj=" + cGBridgeBBPost.getSubject() + ", targetserver=" + CGBridgeUtils.getFullServerName(groupMemberId) + ", isCachedSend=" + bl2 + ", inboundAPG=" + string2));
            }
            if (!this.getLocalAPGTopology().isIntraCellUpdatesForwarded() && bl && string2 != null || !this.getLocalAPGTopology().isInterCellUpdatesForwarded() && !bl && string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configured not to forward post.");
                }
                return true;
            }
            groupMemberId2 = groupMemberId;
            bl3 = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isStable=" + this.isPrimaryMgdGroupStable()));
            }
            if (this.isPrimaryMgdGroupStable() && (this.isCachedPostsSent() || bl2)) {
                try {
                    if (groupMemberId2 == null) {
                        object = (GroupMemberId[])this.remoteCellCoreGroupMembers.get(string);
                        if (null != object && ((GroupMemberId[])object).length > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(" length= " + ((GroupMemberId[])object).length));
                            }
                            int n = CGBridgeUtils.determineMembertoSend(cGBridgeBBPost.getSubjectHashCode(), ((GroupMemberId[])object).length);
                            groupMemberId2 = object[n];
                            this.primaryManagedGroup.sendMessage(groupMemberId2, byArray);
                            this.markPostSent(cGBridgeBBPost, string);
                            this.modifyUpdateRegistry(cGBridgeBBPost, groupMemberId2, string, false);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No bridge available to send update to for coregroup " + string));
                        }
                    } else {
                        this.primaryManagedGroup.sendMessage(groupMemberId2, byArray);
                        this.markPostSent(cGBridgeBBPost, string);
                        this.modifyUpdateRegistry(cGBridgeBBPost, groupMemberId2, string, false);
                    }
                    bl3 = true;
                }
                catch (DataStackCongestionException dataStackCongestionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("forwardupdatedirectly DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                    }
                    this.messageProcessor.addMessageToResend(groupMemberId2, byArray, MSG_PROCESSOR_FORWARD_UPDATE_DIRECTLY, new Object[]{cGBridgeBBPost, string, bl, string2});
                    bl3 = true;
                }
                catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("HA exception indicating view is about to be unstable: " + dataStackMembershipChangingException.getMessage()));
                    }
                    break block29;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)(this.getClass().getName() + ".forwardUpdateDirectly"), (String)"35", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("exception in forwardUpdateDirectly,  " + throwable.getMessage()));
                    }
                    break block29;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not ready to forward update, pmg unstable to " + string));
            }
        }
        if (!bl3 && !bl2) {
            bl3 = true;
            if (this.isPostMsgCacheEnabled) {
                object = this.postMsgCache;
                synchronized (object) {
                    if (this.postMsgCache.size() >= this.postCacheSize) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Cache too big...removing 1st entry");
                        }
                        this.postMsgCache.remove(0);
                        FFDCFilter.processException((Throwable)new CGBInternalErrorException("Too many cached posts: " + this.postMsgCache.size() + "...entry being removed"), (String)(this.getClass().getName() + ".forwardUpdateDirectly"), (String)"7774", (Object)this);
                    }
                    this.postMsgCache.add(new CachedPost(cGBridgeBBPost, groupMemberId2, string, bl, string2));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"msg was not sent so caching");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("forwardUpdateDirectly-" + bl3));
        }
        return bl3;
    }

    private void markPostSent(CGBridgeBBPost cGBridgeBBPost, String string) {
        if (this.getBridgeVersion().isSeamlessFailoverEnabled() && cGBridgeBBPost.isInitialUpdate() && cGBridgeBBPost.getSubject() != null) {
            this.getCGBridge().getSubscriptionTracker().setUpdateSent(cGBridgeBBPost.getSubInfo(), string);
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean sendMessage(GroupMemberId var1_1, byte[] var2_2, boolean var3_3, boolean var4_4) {
        if (InterBridgeCoreGroup.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)InterBridgeCoreGroup.tc, (String)"sendMessage", (Object)new Object[]{CGBridgeUtils.getFullServerName(var1_1), var2_2});
        }
        var5_5 = this.isCachedMsgsSent();
        if (this.isPrimaryMgdGroupStable() && (var4_4 || var5_5)) {
            try {
                this.primaryManagedGroup.sendMessage(var1_1, var2_2);
                if (InterBridgeCoreGroup.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)InterBridgeCoreGroup.tc, (String)"sendMessage", (Object)Boolean.TRUE);
                }
                return true;
            }
            catch (DataStackCongestionException var6_6) {
                if (InterBridgeCoreGroup.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)InterBridgeCoreGroup.tc, (String)("sendMessage DataStackCongestionException: " + var6_6.getMessage()));
                }
                this.messageProcessor.addMessageToResend(var1_1, var2_2, null, null);
                if (InterBridgeCoreGroup.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)InterBridgeCoreGroup.tc, (String)"sendMessage-datastackException");
                }
                return true;
            }
            catch (Exception var6_7) {
                if (var3_3) {
                    this.storeMessage(var1_1, var2_2);
                }
                if (!InterBridgeCoreGroup.tc.isDebugEnabled()) ** GOTO lbl27
                Tr.debug((TraceComponent)InterBridgeCoreGroup.tc, (String)("sendMessage: exception sending to cgbridge " + var6_7.getMessage()));
            }
        } else {
            if (var3_3 && !var4_4) {
                this.storeMessage(var1_1, var2_2);
            }
            if (InterBridgeCoreGroup.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)InterBridgeCoreGroup.tc, (String)("Not ready to send msg for " + this.getAccessPointGroupName() + ", isCachedMsg=" + var4_4 + ", isCachedMessagesSent=" + var5_5));
            }
        }
lbl27:
        // 5 sources

        if (InterBridgeCoreGroup.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)InterBridgeCoreGroup.tc, (String)"sendMessage", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStoredMessages(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeStoredMessage", (Object)new Object[]{groupMemberIdArray});
        }
        if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
            Iterator iterator = this.postMsgCache.iterator();
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                GSRSubProcessor gSRSubProcessor;
                String string = CGBridgeUtils.getFullServerName(groupMemberIdArray[i]);
                Object object = this.postMsgCache;
                synchronized (object) {
                    if (!this.postMsgCache.isEmpty()) {
                        iterator = this.postMsgCache.iterator();
                        while (iterator.hasNext()) {
                            CachedPost cachedPost = (CachedPost)iterator.next();
                            if (cachedPost.getGmidtosend() == null || !cachedPost.getGmidtosend().getServerName().equals(groupMemberIdArray[i].getServerName())) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("removing cached post to " + string + " for BB and Subj: " + cachedPost.getCgbPost().getBBName() + ":" + cachedPost.getCgbPost().getSubject()));
                            }
                            iterator.remove();
                        }
                    }
                }
                object = this.gsrSubProcessorMap;
                synchronized (object) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removed current gsr sub for down server: " + string));
                    }
                    gSRSubProcessor = (GSRSubProcessor)this.gsrSubProcessorMap.remove(string);
                }
                if (gSRSubProcessor != null && !gSRSubProcessor.isCanceled()) {
                    gSRSubProcessor.cancelProcessing();
                }
                this.removeCachedGSRSubFromServer(string);
                object = this.cachedGSRSubMsg;
                synchronized (object) {
                    if (this.cachedGSRSubMsg.getStoredGSRSubMsgRebuildID() != -1) {
                        this.cachedGSRSubMsg.getTargetGSRSubMsgGMIDs().remove(groupMemberIdArray[i]);
                        if (this.cachedGSRSubMsg.getTargetGSRSubMsgGMIDs().size() == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"no more target gmids...reset cached gsr sub");
                            }
                            this.cachedGSRSubMsg.reset();
                        }
                    }
                }
                if (this.isMsgCacheEnabled) {
                    object = this.msgCache;
                    synchronized (object) {
                        Iterator iterator2 = this.msgCache.iterator();
                        while (iterator2.hasNext()) {
                            CachedMsg cachedMsg = (CachedMsg)iterator2.next();
                            if (!cachedMsg.getGmId().equals(groupMemberIdArray[i])) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("removing cached msg for " + string));
                            }
                            iterator2.remove();
                        }
                    }
                }
                this.removeStoredOnMessageWorkSubs(groupMemberIdArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeStoredMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (this.isMsgCacheEnabled) {
            List list = this.msgCache;
            synchronized (list) {
                if (this.msgCache.size() >= this.msgCacheSize) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cache too big...removing 1st (oldest) entry");
                    }
                    this.msgCache.remove(0);
                }
                this.msgCache.add(new CachedMsg(byArray, groupMemberId));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("msgCache size=" + this.msgCache.size()));
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"cached disabled");
        }
    }

    Set getBridgesAvailableInLocalCoreGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBridgesAvailableInLocalCoreGroup");
        }
        HashSet<String> hashSet = new HashSet<String>();
        GroupMemberId[] groupMemberIdArray = this.localPMGEvents.getGmidsCurrent();
        if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                hashSet.add(CGBridgeUtils.getFullServerName(groupMemberIdArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBridgesAvailableInLocalCoreGroup", hashSet);
        }
        return hashSet;
    }

    void sendLocalViewChangeStateCompleteMsgs(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendLocalViewChangeStateCompleteMsgs", (Object)new Object[]{string, new Integer(n)});
        }
        try {
            CGBridgeStateCompleteMsg cGBridgeStateCompleteMsg = new CGBridgeStateCompleteMsg(string, n, true, this.getBridgesAvailableInLocalCoreGroup());
            cGBridgeStateCompleteMsg.setBridgeStateIDs(this.getLocalPMGEvents().getBridgeStateIDMap());
            byte[] byArray = cGBridgeStateCompleteMsg.marshallData();
            this.sendMessageToAllCoreGroups(byArray, this.localPMGEvents.getCellAndCGName(), true);
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problems serializing/sending CGBridgeStateCompleteMsg: " + iOException.getMessage()));
            }
            FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + "sendLocalViewChangeStateCompleteMsgs"), (String)"87998", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendLocalViewChangeStateCompleteMsgs");
        }
    }

    void sendStateCompleteMsg(GroupMemberId groupMemberId, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendStateCompleteMsg", (Object)new Object[]{CGBridgeUtils.getFullServerName(groupMemberId), new Integer(n), new Boolean(bl)});
        }
        try {
            byte[] byArray = new CGBridgeStateCompleteMsg(this.cgbConfig.getFullServerName(), n, bl, null).marshallData();
            this.sendMessage(groupMemberId, byArray, true, false);
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("problems serializing CGBridgeStateCompleteMsg: " + iOException.getMessage()));
            }
            FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + "sendStateCompleteMsg"), (String)"87998", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendStateCompleteMsg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendGSRMessages(int n, byte[] byArray, BridgeViewChangeRegister bridgeViewChangeRegister) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendGSRMessages", (Object)new Object[]{new Integer(n)});
        }
        Iterator iterator = this.cachedGSRSubMsg;
        synchronized (iterator) {
            if (this.cachedGSRSubMsg.getStoredGSRSubMsgRebuildID() != -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"reseting cached gsr sub");
                }
                this.cachedGSRSubMsg.reset();
            }
        }
        iterator = this.remoteCellCoreGroupMembers;
        synchronized (iterator) {
            hashMap = new HashMap(this.remoteCellCoreGroupMembers);
        }
        if (hashMap.size() > 0) {
            iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                GroupMemberId[] groupMemberIdArray = null;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                InterCGBridgePMGEvents interCGBridgePMGEvents = this.getInterCGBridgePMGEvents(string);
                if (interCGBridgePMGEvents != null) {
                    groupMemberIdArray = interCGBridgePMGEvents.getGmidsCurrent();
                }
                if (groupMemberIdArray == null || groupMemberIdArray.length <= 0) continue;
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    try {
                        String string2 = CGBridgeUtils.getFullServerName(groupMemberIdArray[i]);
                        if (bridgeViewChangeRegister.containsBridge(string, string2)) continue;
                        bridgeViewChangeRegister.addBridge(string, string2);
                        if (this.sendMessage(groupMemberIdArray[i], byArray, true, false) || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Failed to send GSR sub to : " + CGBridgeUtils.getFullServerName(groupMemberIdArray[i])));
                        continue;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("problems sending subscription msg: " + exception.getMessage()));
                        }
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".sendGSRMessages"), (String)"3938", (Object)this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendGSRMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessageToAllCoreGroups(byte[] byArray, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sendMessageToAllCoreGroups-" + this.accessPointGroupName));
        }
        HashMap hashMap = null;
        Object object = this.remoteCellCoreGroupMembers;
        synchronized (object) {
            hashMap = new HashMap(this.remoteCellCoreGroupMembers);
        }
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("entry.key=" + entry.getKey()));
            }
            if (!entry.getKey().equals(string)) {
                GroupMemberId[] groupMemberIdArray = (GroupMemberId[])entry.getValue();
                if (groupMemberIdArray == null || groupMemberIdArray.length <= 0) continue;
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    this.sendMessage(groupMemberIdArray[i], byArray, bl, false);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Not sending msg to originCG -" + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendMessageToAllCoreGroups-" + this.accessPointGroupName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findCGBridgeAndSendMessage(int n, CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findCGBridgeAndSendMessage(no PAP)");
        }
        if (bl) {
            if (this.getBridgeVersion().isOptimizedSubscriptionHandling() && !this.isPrimaryMgdGroupStable()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findCGBridgeAndSendMessage", (Object)Boolean.FALSE);
                }
                return false;
            }
        } else if (!(!this.getBridgeVersion().isOptimizedSubscriptionHandling() || this.isPrimaryMgdGroupStable() && this.isCachedSubscriptionsSent())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"pmg not stable so store subscription to send later");
            }
            this.storeSubscription(cGBridgeBBRemoteSubscriptionMsg, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findCGBridgeAndSendMessage", (Object)Boolean.FALSE);
            }
            return false;
        }
        boolean bl2 = false;
        byte[] byArray = null;
        HashMap hashMap = this.remoteCellCoreGroupMembers;
        synchronized (hashMap) {
            Iterator iterator = this.remoteCellCoreGroupMembers.keySet().iterator();
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("remoteCellCoreGroupMembers=" + this.remoteCellCoreGroupMembersToString()));
            }
            if (iterator != null) {
                block34: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"itSubGroup != null");
                    }
                    try {
                        byArray = cGBridgeBBRemoteSubscriptionMsg.marshallData();
                    }
                    catch (IOException iOException) {
                        if (!tc.isDebugEnabled()) break block34;
                        Tr.debug((TraceComponent)tc, (String)("exception serializing msg" + iOException.getMessage()));
                    }
                }
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("myGroupName=" + this.myGroupName + ", groupName=" + string + ", ocg=" + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup()));
                    }
                    if (!string.equals(this.myGroupName) && !string.equals(cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup())) {
                        GroupMemberId[] groupMemberIdArray = (GroupMemberId[])this.remoteCellCoreGroupMembers.get(string);
                        if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
                            int n2;
                            GroupMemberId groupMemberId;
                            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("gmidSubSet length: " + groupMemberIdArray.length));
                            }
                            if ((groupMemberId = groupMemberIdArray[n2 = CGBridgeUtils.determineMembertoSend(n, groupMemberIdArray.length)]) != null) {
                                block35: {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("findGatewayAndSendMessage sending to " + CGBridgeUtils.getFullServerName(groupMemberId)));
                                    }
                                    try {
                                        this.primaryManagedGroup.sendMessage(groupMemberId, byArray);
                                        bl2 = true;
                                    }
                                    catch (DataStackCongestionException dataStackCongestionException) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("findGatewayAndSendMessage DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                                        }
                                        this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                                        bl2 = true;
                                    }
                                    catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("HA exception indicating view is about to be unstable: " + dataStackMembershipChangingException.getMessage()));
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (!tc.isDebugEnabled()) break block35;
                                        Tr.debug((TraceComponent)tc, (String)("exception sending to cgbridge " + exception.getMessage()));
                                    }
                                }
                                if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                                    this.addPeerSubscription(cGBridgeBBRemoteSubscriptionMsg, null);
                                    continue;
                                }
                                this.removePeerSubscription(cGBridgeBBRemoteSubscriptionMsg);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"Unable to send message, no available core group bridges to send message to");
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"No bridge available to send to, will store until one available");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Subscription should not be sent to it's ocg");
                    }
                    bl2 = true;
                }
            } else {
                Tr.debug((TraceComponent)tc, (String)"No remote CGBridge available to send to");
            }
        }
        if (!bl2 && !bl) {
            this.storeSubscription(cGBridgeBBRemoteSubscriptionMsg, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findCGBridgeAndSendMessage success=" + bl2));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, PeerAccessPoint peerAccessPoint) {
        Map map = this.storedSubsTable;
        synchronized (map) {
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Storing Subscription Message for later resend " + cGBridgeBBRemoteSubscriptionMsg + " hash code=" + cGBridgeBBRemoteSubscriptionMsg.hashCode() + "  # cached subscriptions ==" + this.storedSubsTable.size()));
            }
            this.storedSubsTable.remove(cGBridgeBBRemoteSubscriptionMsg);
            PeerAccessPoint peerAccessPoint2 = this.storedSubsTable.put(cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint);
            if (tc.isDebugEnabled()) {
                if (peerAccessPoint2 != null) {
                    Tr.debug((TraceComponent)tc, (String)("Replaced duplicate subscription; pap=" + peerAccessPoint2));
                }
                if (CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("# cached subscriptions == " + this.storedSubsTable.size()));
                }
            }
        }
    }

    protected boolean findCGBridgeAndSendMessage(int n, CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, PeerAccessPoint peerAccessPoint, boolean bl) {
        boolean bl2 = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findCGBridgeAndSendMessage", (Object)new Object[]{peerAccessPoint});
        }
        String string = CGBridgeUtils.generateCGKey(peerAccessPoint.getCellname(), peerAccessPoint.getCoreGroupName());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findCGBridgeAndSendMessage send subscription to cellName_coreGroupName [" + string + "]"));
        }
        GroupMemberId[] groupMemberIdArray = (GroupMemberId[])this.remoteCellCoreGroupMembers.get(string);
        if (string.equals(cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Subscription msg's dest cg: " + string + " equals its origin cg: " + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup() + ", so do not send...return true"));
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isStable=" + this.isPrimaryMgdGroupStable() + ", isCachedSubscriptionsSent=" + this.isCachedSubscriptionsSent()));
        }
        if (bl) {
            if (this.getBridgeVersion().isOptimizedSubscriptionHandling() && !this.isPrimaryMgdGroupStable()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findCGBridgeAndSendMessage", (Object)Boolean.FALSE);
                }
                return false;
            }
        } else if (!(!this.getBridgeVersion().isOptimizedSubscriptionHandling() || this.isPrimaryMgdGroupStable() && this.isCachedSubscriptionsSent())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"pmg not stable so store subscription to send later");
            }
            this.storeSubscription(cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findCGBridgeAndSendMessage", (Object)Boolean.FALSE);
            }
            return false;
        }
        if (null != groupMemberIdArray && groupMemberIdArray.length > 0) {
            int n2;
            GroupMemberId groupMemberId;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Message Key: " + n + " length: " + groupMemberIdArray.length));
            }
            if ((groupMemberId = groupMemberIdArray[n2 = CGBridgeUtils.determineMembertoSend(n, groupMemberIdArray.length)]) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("findCGBridgeAndSendMessage sending to " + groupMemberId.getServerName()));
                }
                byte[] byArray = null;
                try {
                    byArray = cGBridgeBBRemoteSubscriptionMsg.marshallData();
                    this.primaryManagedGroup.sendMessage(groupMemberId, byArray);
                    bl2 = true;
                }
                catch (DataStackCongestionException dataStackCongestionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("findGatewayAndSendMessage remove DataStackCongestionException: " + dataStackCongestionException.getMessage()));
                    }
                    this.messageProcessor.addMessageToResend(groupMemberId, byArray, null, null);
                    bl2 = true;
                }
                catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("HA exception indicating view is about to be unstable: " + dataStackMembershipChangingException.getMessage()));
                    }
                }
                catch (Exception exception) {
                    this.storeSubscription(cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("exception sending to cgbridge " + exception));
                    }
                    return false;
                }
                if (cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
                    this.addPeerSubscription(cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint.getCoreGroupName());
                } else {
                    this.removePeerSubscription(cGBridgeBBRemoteSubscriptionMsg);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to send message, no Core Group Bridges available in cell/coregroup " + string));
            }
        } else {
            if (!bl2 && !bl) {
                this.storeSubscription(cGBridgeBBRemoteSubscriptionMsg, peerAccessPoint);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Remote Core Group Bridges available within coregroup, storing subscription");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findCGBridgeAndSendMessage");
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsPeerSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"containsPeerSubscription", (Object)new Object[]{cGBridgeBBRemoteSubscriptionMsg});
        }
        HashMap hashMap = this.peerSubscriptions;
        synchronized (hashMap) {
            boolean bl = this.peerSubscriptions.containsKey(cGBridgeBBRemoteSubscriptionMsg);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("containsPeerSubscription-" + bl));
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CGBridgeBBRemoteSubscriptionMsg getPeerSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        HashMap hashMap = this.peerSubscriptions;
        synchronized (hashMap) {
            return (CGBridgeBBRemoteSubscriptionMsg)this.peerSubscriptions.get(cGBridgeBBRemoteSubscriptionMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addPeerSubscription-" + cGBridgeBBRemoteSubscriptionMsg));
        }
        String string2 = cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName();
        CGBridgeStoredSubscription cGBridgeStoredSubscription = new CGBridgeStoredSubscription(cGBridgeBBRemoteSubscriptionMsg, string2, string);
        Integer n = new Integer(cGBridgeBBRemoteSubscriptionMsg.hashCode());
        HashMap hashMap = this.peerSubscriptions;
        synchronized (hashMap) {
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled() && this.peerSubscriptions.containsKey(n)) {
                Tr.debug((TraceComponent)tc, (String)("addPeerSubscription collision on " + cGBridgeBBRemoteSubscriptionMsg));
            }
            this.peerSubscriptions.put(n, cGBridgeStoredSubscription);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.apgrouplocal.getName() + ": addPeerSubscription peerSubscriptions.size now: " + this.peerSubscriptions.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGSRPeerSubscriptions(Set set, String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addGSRPeerSubscriptions-" + this.getAccessPointGroupName() + "-" + n), (Object)new Object[]{string});
        }
        Iterator iterator = set.iterator();
        HashMap hashMap = this.peerSubscriptions;
        synchronized (hashMap) {
            while (iterator.hasNext()) {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                String string2 = cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData().getCellName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addGSRPeerSubscriptions for " + cGBridgeBBRemoteSubscriptionMsg));
                }
                CGBridgeStoredSubscription cGBridgeStoredSubscription = new CGBridgeStoredSubscription(cGBridgeBBRemoteSubscriptionMsg, string2, string);
                Integer n2 = new Integer(cGBridgeBBRemoteSubscriptionMsg.hashCode());
                if (tc.isDebugEnabled() && this.peerSubscriptions.containsKey(n2)) {
                    Tr.debug((TraceComponent)tc, (String)("addGSRPeerSubscriptions collision on cgbMsg.hashCode()=[" + n2 + "]"));
                }
                this.peerSubscriptions.put(n2, cGBridgeStoredSubscription);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("peerSubscriptions.size now: " + this.peerSubscriptions.size()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addGSRPeerSubscriptions-" + this.getAccessPointGroupName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerSubscription(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removePeerSubscription-" + cGBridgeBBRemoteSubscriptionMsg));
        }
        Integer n = new Integer(cGBridgeBBRemoteSubscriptionMsg.hashCode());
        HashMap hashMap = this.peerSubscriptions;
        synchronized (hashMap) {
            this.peerSubscriptions.remove(n);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.apgrouplocal.getName() + ": peerSubscriptions.size now: " + this.peerSubscriptions.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePeerSubscriptions(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removePeerSubscriptions");
        }
        Iterator iterator = collection.iterator();
        HashMap hashMap = this.peerSubscriptions;
        synchronized (hashMap) {
            while (iterator.hasNext()) {
                CGBridgeBBSubscriptionMsg cGBridgeBBSubscriptionMsg = (CGBridgeBBSubscriptionMsg)iterator.next();
                Integer n = new Integer(cGBridgeBBSubscriptionMsg.hashCode());
                this.peerSubscriptions.remove(n);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removedPeerSubscriptions peerSubscriptions.size now: " + this.peerSubscriptions.size()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removePeerSubscriptions");
        }
    }

    List getSubscriptionsScopedForThisCoreGroup(CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubscriptionsScopedForThisCoreGroup", (Object)new Object[]{cGBridgeGSRSubscriptionMsg});
        }
        LinkedList linkedList = new LinkedList();
        if (cGBridgeGSRSubscriptionMsg.getOriginCellName().equals(this.cellNameLocal)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("gsrsub sent from same cell, so adding all (public/private/remote) subscriptions: " + cGBridgeGSRSubscriptionMsg.getSubscriptions().size()));
            }
            linkedList.addAll(cGBridgeGSRSubscriptionMsg.getSubscriptions());
            if (cGBridgeGSRSubscriptionMsg.getRemoteSubscriptions().size() > 0) {
                Iterator iterator = cGBridgeGSRSubscriptionMsg.getRemoteSubscriptions().values().iterator();
                while (iterator.hasNext()) {
                    Set set = (Set)iterator.next();
                    if (set == null || set.size() <= 0) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding " + set.size() + " remote subscriptions for cell"));
                    }
                    linkedList.addAll(set);
                }
            }
        } else {
            Set set;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("gsrsub sent from different cell, so only adding all remote subscriptions for cell: " + this.cellNameLocal));
            }
            if (cGBridgeGSRSubscriptionMsg.getRemoteSubscriptions().size() > 0 && (set = (Set)cGBridgeGSRSubscriptionMsg.getRemoteSubscriptions().get(this.cellNameLocal)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("adding " + set.size() + " remote subscriptions targeted for this cell: " + this.cellNameLocal));
                }
                linkedList.addAll(set);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubscriptionsScopedForThisCoreGroup");
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleGSRSubscribe(CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg, GroupMemberId groupMemberId, String string) {
        GSRSubProcessor gSRSubProcessor;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleGSRSubscribe-" + cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName()));
        }
        if (tc.isDebugEnabled()) {
            if (cGBridgeGSRSubscriptionMsg.getRemoteSubscriptions() != null) {
                Tr.debug((TraceComponent)tc, (String)("CGBGSRSubscriptionMsg has " + cGBridgeGSRSubscriptionMsg.getRemoteSubscriptions().size() + " remote subs "));
            }
            if (cGBridgeGSRSubscriptionMsg.getSubscriptions() != null) {
                Tr.debug((TraceComponent)tc, (String)("CGBGSRSubscriptionMsg has " + cGBridgeGSRSubscriptionMsg.getSubscriptions().size() + " public/private subs"));
            }
        }
        if (!this.isInterAndLocalPMGBridgesMatched() || !this.getLocalPMGEvents().isSubscriptionProcessingState()) {
            this.addCachedSubscription(new StoredGSRSub(this, cGBridgeGSRSubscriptionMsg, groupMemberId, string));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleGSRSubscribe - gsrSub stored");
            }
            return false;
        }
        List list = this.getSubscriptionsScopedForThisCoreGroup(cGBridgeGSRSubscriptionMsg);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(list.size() + " subs to send"));
        }
        if (list.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleGSRSubscribe - no subs");
            }
            return true;
        }
        GSRSubProcessor gSRSubProcessor2 = new GSRSubProcessor(this, cGBridgeGSRSubscriptionMsg, groupMemberId, string);
        boolean bl = false;
        Map map = this.gsrSubProcessorMap;
        synchronized (map) {
            gSRSubProcessor = (GSRSubProcessor)this.gsrSubProcessorMap.get(CGBridgeUtils.getFullServerName(groupMemberId));
            if (gSRSubProcessor != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("new gsr sub view id=" + cGBridgeGSRSubscriptionMsg.getBridgeViewChangeID() + ", current gsr sub view id=" + gSRSubProcessor.gsrSubs.getBridgeViewChangeID()));
                Tr.debug((TraceComponent)tc, (String)("new bridge start time=" + cGBridgeGSRSubscriptionMsg.getBridgeStartTime() + ", current bridge start time=" + gSRSubProcessor.gsrSubs.getBridgeStartTime()));
            }
            if (gSRSubProcessor == null || gSRSubProcessor.gsrSubs.getBridgeStartTime() < gSRSubProcessor2.gsrSubs.getBridgeStartTime() || gSRSubProcessor.gsrSubs.getBridgeStartTime() == gSRSubProcessor2.gsrSubs.getBridgeStartTime() && gSRSubProcessor2.gsrSubs.getBridgeViewChangeID() >= gSRSubProcessor.gsrSubs.getBridgeViewChangeID()) {
                gSRSubProcessor = this.gsrSubProcessorMap.put(CGBridgeUtils.getFullServerName(groupMemberId), gSRSubProcessor2);
                bl = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("do not process gsrsub from: " + cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName()));
            }
        }
        boolean bl2 = false;
        if (bl) {
            if (gSRSubProcessor != null && !gSRSubProcessor.isCanceled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"contained old gsrSubProcess...will cancel and clean up");
                }
                gSRSubProcessor.cancelProcessing();
            }
            bl2 = gSRSubProcessor2.processGSRSubMsg(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("handleGSRSubscribe-" + bl2));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelGSRSubProcessors() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelGSRSubProcessors");
        }
        Map map = this.gsrSubProcessorMap;
        synchronized (map) {
            Iterator iterator = this.gsrSubProcessorMap.values().iterator();
            while (iterator.hasNext()) {
                GSRSubProcessor gSRSubProcessor = (GSRSubProcessor)iterator.next();
                if (gSRSubProcessor.isCanceled()) continue;
                gSRSubProcessor.cancelProcessing();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Cancelled GSR sub processing for: " + gSRSubProcessor.sendingServerName));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelGSRSubProcessors");
        }
    }

    void handleCoreGroupPost() {
    }

    boolean handlePost(GroupMemberId groupMemberId, CGBridgeBBPostMsg cGBridgeBBPostMsg, String string) {
        boolean bl;
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handlePost");
        }
        if ((bl = this.cgb.processCGBridgeMsg(cGBridgeBBPostMsg, this.accessPointGroupName, groupMemberId, null, null, false, string, null, false)) && cGBridgeBBPostMsg.isInitialUpdate()) {
            this.cgb.getReachableCoreGroups().addCoreGroup(CGBridgeUtils.generateCGKey(cGBridgeBBPostMsg.getCellName(), cGBridgeBBPostMsg.getCoreGroupName()), string, null);
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("handlePost-" + bl));
        }
        return bl;
    }

    boolean processRemovedCoreGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processRemovedCoreGroup-" + string));
        }
        boolean bl = false;
        Set set = this.getCGBridge().getReachableCoreGroups().removeCoreGroup(string);
        if (set.size() > 0) {
            bl = true;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removing state for cg: " + string2));
                }
                if (this.getLocalAPGTopology().isSendCGBStatusMsg()) {
                    this.forwardMessage(new CGBridgeStatusMsg(string2, this.getAccessPointGroupName(), CGBridgeStatusMsg.STATE_UNAVAILABLE, 0L, this.cgbConfig.getFullServerName()), string);
                }
                this.getCGBridge().removePeerCoregroupState(string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processRemovedCoreGroup" + bl));
        }
        return bl;
    }

    boolean handleSubscribe(GroupMemberId groupMemberId, CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, String string, String string2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleSubscribe");
        }
        if (this.getBridgeVersion().isSeamlessFailoverEnabled() && !cGBridgeBBRemoteSubscriptionMsg.isSubscribe()) {
            LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry;
            String string3 = CGBridgeUtils.getFullServerName(groupMemberId);
            BridgeServerUpdateRegistry bridgeServerUpdateRegistry = this.getUpdateRegistry(string3);
            if (bridgeServerUpdateRegistry != null && bridgeServerUpdateRegistry.removeUpdateTracking(cGBridgeBBRemoteSubscriptionMsg, cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData())) {
                this.bridgeUpdateProcessingComplete(bridgeServerUpdateRegistry.getBridgeWaitingForUpdates(), bridgeServerUpdateRegistry.getBridgeViewChangeID(), bridgeServerUpdateRegistry.getFullyQualifiedServerName());
            }
            if ((localBridgeServerUpdateRegistry = this.getLocalUpdateRegistry()) != null && localBridgeServerUpdateRegistry.isActiveForProcessing() && localBridgeServerUpdateRegistry.removeUpdateTrackingLocal(cGBridgeBBRemoteSubscriptionMsg, cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData(), CGBridgeUtils.getFullCoregroupName(groupMemberId))) {
                this.processLastUpdateForLocalUpdateRegistry(localBridgeServerUpdateRegistry);
            }
        }
        if (this.getLocalAPGTopology().isSetProxyCoreGroup() && cGBridgeBBRemoteSubscriptionMsg.getProxyCoreGroup() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("origin cg=" + cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup()));
            }
            if (string.equals(cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set proxy core group name to: " + this.cgbConfig.getFullCoreGroupName()));
                }
                cGBridgeBBRemoteSubscriptionMsg.setProxyCoreGroup(this.cgbConfig.getFullCoreGroupName());
            }
        }
        if ((bl = this.cgb.processCGBridgeMsg(cGBridgeBBRemoteSubscriptionMsg, this.accessPointGroupName, groupMemberId, this.getLocalAPGTopology(), null, false, string, null, false)) || cGBridgeBBRemoteSubscriptionMsg.getProxyCoreGroup() != null) {
            this.cgb.getReachableCoreGroups().addCoreGroup(cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup(), string, cGBridgeBBRemoteSubscriptionMsg.getProxyCoreGroup());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("handleSubscribe-" + bl));
        }
        return bl;
    }

    private CoreStack createICGBCoreStack(CoreStackFactory coreStackFactory, String string) throws HAException, UnknownHostException, CGBInternalErrorException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createIGWCoreStack");
        }
        Vector vector = this.apgrouplocal.getAllEndPoints();
        int n2 = vector.size();
        CoreStackMemberInfo[] coreStackMemberInfoArray = new CoreStackMemberInfo[n2];
        int n3 = coreStackMemberInfoArray.length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("total corestackmemberinfo size: " + n3));
        }
        CGBridgeEndPoint cGBridgeEndPoint = null;
        for (n = 0; n < n3; ++n) {
            CGBridgeEndPoint cGBridgeEndPoint2 = (CGBridgeEndPoint)vector.get(n);
            String string2 = cGBridgeEndPoint2.getMemberName();
            if (cGBridgeEndPoint2.isOnLocalServer()) {
                this.localPMGServerName = cGBridgeEndPoint2.getMemberName();
                cGBridgeEndPoint = cGBridgeEndPoint2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("firewall ispassivemember: " + cGBridgeEndPoint2.isFW_PASSIVE_MEMBER()));
            }
            coreStackMemberInfoArray[n] = coreStackFactory.createCoreStackMemberInfo();
            coreStackMemberInfoArray[n].setServerName(string2);
            coreStackMemberInfoArray[n].setIPIdentifier(cGBridgeEndPoint2.getHostName());
            coreStackMemberInfoArray[n].setPort(cGBridgeEndPoint2.getPort());
            coreStackMemberInfoArray[n].setPassiveDiscovery(cGBridgeEndPoint2.isFW_PASSIVE_MEMBER());
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Member/Cellname/coregroupname/islocal..." + string2 + "/" + cGBridgeEndPoint2.getCellName() + "/" + cGBridgeEndPoint2.getCoreGroupName() + "/" + cGBridgeEndPoint2.isOnLocalServer()));
            }
            if (cGBridgeEndPoint2.getCellName().equals(this.cellNameLocal) && cGBridgeEndPoint2.getCoreGroupName().equals(this.coreGroupNameLocal)) {
                this.localCoregroupMembers.add(string2);
            } else {
                this.remoteCellMembers.add(string2);
            }
            String string3 = CGBridgeUtils.generateCGKey(cGBridgeEndPoint2.getCellName(), cGBridgeEndPoint2.getCoreGroupName());
            if (this.coreGroupList.contains(string3)) continue;
            this.coreGroupList.add(string3);
        }
        if (tc.isEntryEnabled()) {
            for (n = 0; n < coreStackMemberInfoArray.length; ++n) {
                Tr.debug((TraceComponent)tc, (String)("Member #" + n + " servername: " + coreStackMemberInfoArray[n].getServerName()));
            }
        }
        if (this.remoteCellMembers.size() == 0) {
            Tr.warning((TraceComponent)tc, (String)"CWRCB0203", (Object)new Object[]{string});
        }
        HashMap hashMap = new HashMap();
        if (null != cGBridgeEndPoint) {
            String string4 = cGBridgeEndPoint.getMemberName();
            CoreStackInfo coreStackInfo = coreStackFactory.createCoreStackInfo();
            coreStackInfo.setName(string);
            coreStackInfo.setChannelChainName(cGBridgeEndPoint.getChainName());
            coreStackInfo.setServerName(string4);
            this.setCoreStackParms(coreStackInfo, cGBridgeEndPoint.getProperties());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createIGWCoreStack");
            }
            return coreStackFactory.createCoreStack(coreStackInfo, coreStackMemberInfoArray, (CoreStackListener)this, hashMap);
        }
        throw new CGBInternalErrorException(" No local endpoint defined for this bridge.");
    }

    private GroupMemberId[] filterlocalCGBridges(GroupMemberId[] groupMemberIdArray) {
        int n = groupMemberIdArray.length;
        TreeSet<GroupMemberId> treeSet = new TreeSet<GroupMemberId>(InterBridgeGroupMemberIdComparator.getInstance());
        for (int i = 0; i < n; ++i) {
            if (this.localCoregroupMembers.contains(groupMemberIdArray[i].getServerName())) continue;
            treeSet.add(groupMemberIdArray[i]);
        }
        GroupMemberId[] groupMemberIdArray2 = treeSet.toArray(new GroupMemberId[treeSet.size()]);
        return groupMemberIdArray2;
    }

    private String[] filterForCG(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterForCG");
        }
        Vector vector = this.apgrouplocal.getAllEndPoints();
        int n = vector.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            CGBridgeEndPoint cGBridgeEndPoint = (CGBridgeEndPoint)vector.get(i);
            if (!cGBridgeEndPoint.getCellName().equals(string) || !cGBridgeEndPoint.getCoreGroupName().equals(string2)) continue;
            arrayList.add(cGBridgeEndPoint.getMemberName());
            if (!tc.isEntryEnabled()) continue;
            Tr.exit((TraceComponent)tc, (String)"adding [", (Object)(cGBridgeEndPoint.getMemberName() + "]"));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filterForCG", arrayList);
        }
        return stringArray;
    }

    void removeSubscrSubjectPost(int n, int n2) {
        this.cgb.removeSubscrSubjectPost(n, n2);
    }

    BulletinBoardScope determineScope(CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData) {
        if (cGBridgeBulletinBoardScopeData.getCGBridgeScopeType() == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"private scope type");
            }
            return this.cgbridgeService.getPrivateScope();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"public scope type");
        }
        return this.cgbridgeService.getPublicScope();
    }

    void processReceivedUnsubscribes(SubscriptionCache subscriptionCache, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processReceivedUnsubscribes");
        }
        Map map = subscriptionCache.removeStoredUnsubscribeSubjects();
        Iterator iterator = map.entrySet().iterator();
        CGBridgeHAStateMsg cGBridgeHAStateMsg = null;
        GroupMemberId groupMemberId = null;
        while (iterator.hasNext() && localBridgeServerUpdateRegistry.isActiveForProcessing()) {
            try {
                Map.Entry entry = iterator.next();
                groupMemberId = (GroupMemberId)entry.getKey();
                String string = CGBridgeUtils.getFullCoregroupName(groupMemberId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processing unsubscribes for: " + CGBridgeUtils.getFullServerName(groupMemberId)));
                }
                Set set = (Set)entry.getValue();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext() && localBridgeServerUpdateRegistry.isActiveForProcessing()) {
                    cGBridgeHAStateMsg = (CGBridgeHAStateMsg)iterator2.next();
                    UnsubscribeSubscriptionRebuildWork unsubscribeSubscriptionRebuildWork = new UnsubscribeSubscriptionRebuildWork(cGBridgeHAStateMsg.getRemoteSubscription(), cGBridgeHAStateMsg.getGroupMemberId(), string, localBridgeServerUpdateRegistry);
                    this.cgbridgeService.getWorkDispatcher().addWork(unsubscribeSubscriptionRebuildWork);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("problems hanlding unsubscribe for " + groupMemberId + ": " + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processReceivedUnsubscribes");
        }
    }

    void processReceivedSubscribes(SubscriptionCache subscriptionCache, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processReceivedSubscribes");
        }
        Iterator iterator = subscriptionCache.getStoredUnsubscribeSubjects().entrySet().iterator();
        CGBridgeHAStateMsg cGBridgeHAStateMsg = null;
        GroupMemberId groupMemberId = null;
        Map map = subscriptionCache.removeStoredSubjects();
        iterator = map.entrySet().iterator();
        while (iterator.hasNext() && localBridgeServerUpdateRegistry.isActiveForProcessing()) {
            try {
                Map.Entry entry = iterator.next();
                groupMemberId = (GroupMemberId)entry.getKey();
                String string = CGBridgeUtils.getFullCoregroupName(groupMemberId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processing subscribes for: " + CGBridgeUtils.getFullServerName(groupMemberId)));
                }
                Set set = (Set)entry.getValue();
                Iterator iterator2 = set.iterator();
                localBridgeServerUpdateRegistry.setReadyToProcessUpdates(true);
                while (iterator2.hasNext() && localBridgeServerUpdateRegistry.isActiveForProcessing()) {
                    SubscribeSubscriptionRebuildWork subscribeSubscriptionRebuildWork;
                    cGBridgeHAStateMsg = (CGBridgeHAStateMsg)iterator2.next();
                    if (!iterator.hasNext() && !iterator2.hasNext()) {
                        subscribeSubscriptionRebuildWork = new SubscribeSubscriptionRebuildWork(localBridgeServerUpdateRegistry, string, cGBridgeHAStateMsg, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("setting last piece of work: " + subscribeSubscriptionRebuildWork));
                        }
                        this.cgbridgeService.getWorkDispatcher().addWorkWithPrereqwork(subscribeSubscriptionRebuildWork, this.lastSubscribePrereqWork);
                        continue;
                    }
                    subscribeSubscriptionRebuildWork = new SubscribeSubscriptionRebuildWork(localBridgeServerUpdateRegistry, string, cGBridgeHAStateMsg, false);
                    this.cgbridgeService.getWorkDispatcher().addWork(subscribeSubscriptionRebuildWork);
                }
                if (localBridgeServerUpdateRegistry.isActiveForProcessing() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"local reg not active");
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("problems hanlding subscription for " + groupMemberId + ": " + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processReceivedSubscribes");
        }
    }

    void mergeServerStateSubCache(GroupMemberId groupMemberId, ArrayList arrayList, int n, GroupMemberId[] groupMemberIdArray, SubscriptionCache subscriptionCache, boolean bl, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("mergeServerStateSubCache-" + CGBridgeUtils.getFullServerName(groupMemberId)), (Object)new Object[]{subscriptionCache});
            }
            try {
                if (tc.isDebugEnabled() && groupMemberIdArray != null) {
                    for (int i = 0; i < groupMemberIdArray.length; ++i) {
                        Tr.debug((TraceComponent)tc, (String)CGBridgeUtils.getFullServerName(groupMemberIdArray[i]));
                    }
                }
                if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
                    String string = CGBridgeUtils.getFullCoregroupName(groupMemberId);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        CGBridgeHAStateMsg cGBridgeHAStateMsg = (CGBridgeHAStateMsg)arrayList.get(i);
                        CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = cGBridgeHAStateMsg.getRemoteSubscription();
                        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("bbname/subjname: " + cGBridgeBBRemoteSubscriptionMsg.getBBName() + "/" + cGBridgeBBRemoteSubscriptionMsg.getSubject() + " SubjectHashCode=" + cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode()));
                        }
                        GroupMemberId groupMemberId2 = cGBridgeHAStateMsg.getGroupMemberId();
                        this.processSubCacheMergeServerStateSub(groupMemberId2, cGBridgeHAStateMsg, subscriptionCache, groupMemberId, cGBridgeBBRemoteSubscriptionMsg, n, groupMemberIdArray, bl, string, localBridgeServerUpdateRegistry);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("exception: " + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mergeServerStateSubCache-" + CGBridgeUtils.getFullServerName(groupMemberId)));
        }
    }

    void mergeServerState(GroupMemberId groupMemberId, byte[] byArray, int n, GroupMemberId[] groupMemberIdArray, boolean bl, String string) {
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"mergeServerState", (Object)new Object[]{groupMemberId});
            }
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                ArrayList arrayList = (ArrayList)objectInputStream.readObject();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InterBridgeCoreGroup mergeServerState");
                    if (groupMemberIdArray != null) {
                        for (int i = 0; i < groupMemberIdArray.length; ++i) {
                            Tr.debug((TraceComponent)tc, (String)groupMemberIdArray[i].getServerName());
                        }
                    }
                }
                if (groupMemberIdArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("list.size()=" + arrayList.size()));
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        CGBridgeHAStateMsg cGBridgeHAStateMsg = (CGBridgeHAStateMsg)arrayList.get(i);
                        CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = cGBridgeHAStateMsg.getRemoteSubscription();
                        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("gbbsReadyMerge bbname/subjname: " + cGBridgeBBRemoteSubscriptionMsg.getBBName() + "/" + cGBridgeBBRemoteSubscriptionMsg.getSubject() + " SubjectHashCode=" + cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode()));
                        }
                        GroupMemberId groupMemberId2 = cGBridgeHAStateMsg.getGroupMemberId();
                        if (this.isTargetedForLocalCoreGroup(cGBridgeHAStateMsg)) {
                            if (groupMemberId2 != null) {
                                int n2 = CGBridgeUtils.determineMembertoSend(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), groupMemberIdArray.length);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Selected serverindex: " + n2 + "length=" + groupMemberIdArray.length));
                                }
                                if (n2 == n) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Message added to listener");
                                    }
                                    this.cgb.processCGBridgeMsg(cGBridgeHAStateMsg.getRemoteSubscription(), this.accessPointGroupName, cGBridgeHAStateMsg.getGroupMemberId(), null, null, false, string, null, false);
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"This message isn't for us, remove");
                                }
                                this.cgb.unsubscribeLocal(cGBridgeBBRemoteSubscriptionMsg, groupMemberId2);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"CGB version sent or server was not found when trying to merge state - gmidReturn == null");
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"processing gatewaymessage & not subscribing locally");
                        }
                        this.cgb.processCGBridgeMsg(cGBridgeBBRemoteSubscriptionMsg, cGBridgeHAStateMsg.getAccessPointName(), cGBridgeHAStateMsg.getGroupMemberId(), null, null, false, string, null, false);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug((TraceComponent)tc, (String)("exception: " + exception));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeServerState");
        }
    }

    private boolean isTargetedForLocalCoreGroup(CGBridgeHAStateMsg cGBridgeHAStateMsg) {
        return cGBridgeHAStateMsg.getRemoteSubscription().getCGBScopeData().getCellName().equals(this.cellNameLocal) || this.bCrossCell && cGBridgeHAStateMsg.getRemoteSubscription().getCGBScopeData().getCGBridgeScopeType() == 3 || !this.bCrossCell && cGBridgeHAStateMsg.getRemoteSubscription().getCGBScopeData().getCGBridgeScopeType() == 1 || !this.bCrossCell && cGBridgeHAStateMsg.getRemoteSubscription().getCGBScopeData().getCGBridgeScopeType() == 2;
    }

    private void processSubCacheMergeServerStateSub(GroupMemberId groupMemberId, CGBridgeHAStateMsg cGBridgeHAStateMsg, SubscriptionCache subscriptionCache, GroupMemberId groupMemberId2, CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, int n, GroupMemberId[] groupMemberIdArray, boolean bl, String string, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        if (groupMemberId != null) {
            int n2 = CGBridgeUtils.determineMembertoSend(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode(), groupMemberIdArray.length);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Selected sindex: " + n2 + ", cIndex=" + n + ", length=" + groupMemberIdArray.length));
            }
            if (n2 == n) {
                subscriptionCache.addSubscribeSubject(cGBridgeHAStateMsg.getGroupMemberId(), cGBridgeHAStateMsg);
                if (bl && localBridgeServerUpdateRegistry != null && cGBridgeHAStateMsg.getRemoteSubscription().isSubscribe()) {
                    localBridgeServerUpdateRegistry.registerForUpdateTrackingLocal(cGBridgeHAStateMsg.getRemoteSubscription(), cGBridgeHAStateMsg.getRemoteSubscription().getCGBScopeData(), string);
                }
            } else {
                subscriptionCache.addUnsubscribeSubject(cGBridgeHAStateMsg.getGroupMemberId(), cGBridgeHAStateMsg);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CGB version sent or server was not found when trying to merge state - gmidReturn == null");
        }
    }

    protected void initGlobalState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initGlobalState");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initGlobalState");
        }
    }

    public void viewAboutToChange() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CSL:viewAboutToChange");
        }
    }

    public void viewChangeCompleted(String[] stringArray) {
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("CSL:viewChangeCompleted members[" + i + "]=[" + stringArray[i] + "]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inconsistentDefinedMembers(String[] stringArray, String[] stringArray2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inconsistentDefinedMembers synched on startup_Mutex");
        }
        if (null != stringArray && null != stringArray2) {
            if (tc.isDebugEnabled()) {
                int n;
                for (n = 0; n < stringArray.length; ++n) {
                    Tr.debug((TraceComponent)tc, (String)("CSL:inconsistentDefinedMembers localSet[" + n + "]=[" + stringArray[n] + "]"));
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    Tr.debug((TraceComponent)tc, (String)("CSL:inconsistentDefinedMembers remoteSet[" + n + "]=[" + stringArray2[n] + "]"));
                }
            }
            try {
                Object object;
                int n;
                HashSet<String> hashSet = new HashSet<String>(stringArray2.length);
                HashSet<String> hashSet2 = new HashSet<String>(stringArray.length);
                for (n = 0; n < stringArray2.length; ++n) {
                    hashSet.add(stringArray2[n]);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    hashSet2.add(stringArray[n]);
                }
                hashSet.removeAll(hashSet2);
                HashSet<String> hashSet3 = hashSet;
                boolean bl = false;
                Iterator iterator = hashSet3.iterator();
                StringBuffer stringBuffer = new StringBuffer(20);
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    object = CGBridgeEndPoint.extractMemberData(string);
                    if (object == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("newMemberData==null - invalid endPoint specified:" + string));
                        }
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append(string);
                            continue;
                        }
                        stringBuffer.append(", ").append(string);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CSL:inconsistentDefinedMembers newMemberData=[" + object + "]"));
                    }
                    bl |= this.cgbConfig.handleNewMember((MemberData)object, this.apgrouplocal);
                }
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("New CGBConfig:\n" + this.cgbConfig.toString()));
                    }
                    object = this.pmgStabilityLock;
                    synchronized (object) {
                        this.setStablePrimaryGroup(false);
                        this.reInitCoreGroup = true;
                        this.shutDownCoreStack();
                    }
                }
                if (stringBuffer.length() > 0) {
                    throw new CGBInvalidParameterException("invalid endPoint(s) specified: " + stringBuffer.toString() + " CGB communication will not function correctly until endpoint is corrected or added as a peer port in this bridge's cell.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "<inconsistentDefinedMembers>"), (String)"64", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("inconsistentDefinedMembers caught [" + exception + "]"));
                    exception.printStackTrace();
                }
                Object object = this.pmgStabilityLock;
                synchronized (object) {
                    this.setStablePrimaryGroup(true);
                    this.doStablePrimaryGroupWork(false);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inconsistentDefinedMembers complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undefinedMember(String string, InetAddress inetAddress, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CSL:undefinedMember newMemberName=[" + string + "]"));
        }
        if (null == this.apgrouplocal.getProperties().get("CGB_ENABLE_602_FEATURES")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"undefinedMember ignored.  Dynamic Bridges not Enabled");
            }
        } else {
            boolean bl;
            block19: {
                bl = true;
                try {
                    MemberData memberData = CGBridgeEndPoint.extractMemberData(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("undefinedMember newMemberData=[" + memberData + "]"));
                    }
                    if (this.cgbConfig.handleNewMember(memberData, this.apgrouplocal)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("New CGBConfig:\n" + this.cgbConfig.toString()));
                        }
                        Object object = this.pmgStabilityLock;
                        synchronized (object) {
                            this.setStablePrimaryGroup(false);
                            this.shutDownCoreStack();
                            this.reInitCoreGroup = true;
                            break block19;
                        }
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "undefinedMember"), (String)"60", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("undefinedMember caught: " + exception.getMessage()));
                    }
                    Object object = this.pmgStabilityLock;
                    synchronized (object) {
                        this.setStablePrimaryGroup(true);
                        this.doStablePrimaryGroupWork(false);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)("undefinedMember added newMemberName [" + string + "]"));
                } else {
                    Tr.debug((TraceComponent)tc, (String)("undefinedMember FAILED TO ADD newMemberName [" + string + "]"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminated(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CSL:terminated, type=" + n + ", reInitCoreGroup=" + this.reInitCoreGroup));
        }
        Object object = this.pmgStabilityLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"terminated synched on startup_Mutex");
            }
            if (n == 0 && this.reInitCoreGroup) {
                block11: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"terminated calling initCoreGroup");
                    }
                    try {
                        this.initCoreGroup();
                        this.reInitCoreGroup = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)" terminated posting remote Scopes");
                        }
                        this.cgbConfig.postBridgeInfo();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "<terminated>"), (String)"61", (Object)this);
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)("terminated caught [" + exception + "]"));
                        exception.printStackTrace();
                    }
                }
                this.setStablePrimaryGroup(true);
                this.doStablePrimaryGroupWork(false);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"terminated complete");
        }
    }

    public void changeDefinedCompleted(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CSL:changeDefinedCompleted context: " + n));
        }
    }

    public void inconsistentMember(String string, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CSL:inconsistentMember name: " + string + " definedIP: " + inetAddress.getHostAddress() + " defined port: " + n + " actual ip: " + inetAddress2.getHostAddress() + " Actual Port: " + n2));
        }
    }

    public String getServerProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerProperty");
        }
        String string3 = "";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerProperty");
        }
        return string3;
    }

    public String getCoreGroupProperty(String string) {
        String string2 = new String();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupMemberId getLocalServerId() {
        Object object = this.pmgStabilityLock;
        synchronized (object) {
            return this.localGroupMember;
        }
    }

    String getAccessPointGroupName() {
        return this.accessPointGroupName;
    }

    protected String getCellName() {
        return this.cellNameLocal;
    }

    public AccessPointGroup getAccessPointGroup() {
        return this.apgrouplocal;
    }

    public AccessPointGroupTopology getLocalAPGTopology() {
        return this.localAPGTopology;
    }

    protected boolean isCrossCell() {
        return this.bCrossCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean sendCachedMsgs() {
        if (this.isMsgCacheEnabled) {
            LinkedList linkedList = null;
            boolean bl = false;
            ProcessedCacheEntryResult processedCacheEntryResult = null;
            boolean bl2 = false;
            while (!bl) {
                List list = this.msgCache;
                synchronized (list) {
                    if (!this.msgCache.isEmpty()) {
                        if (processedCacheEntryResult != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("pcer.remainingEntries=" + processedCacheEntryResult.numRemainingEntries));
                            }
                            if (processedCacheEntryResult.numRemainingEntries == this.msgCache.size()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"same # of entries that failed to process..exiting");
                                }
                                break;
                            }
                        }
                        linkedList = new LinkedList(this.msgCache);
                        this.msgCache.clear();
                        if (linkedList.size() >= 100) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Sending cached msgs - size=" + linkedList.size()));
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Sending cached msgs inside lock - size=" + linkedList.size()));
                            }
                            bl = true;
                            processedCacheEntryResult = this.processCachedMsgs(linkedList);
                            if (!processedCacheEntryResult.rc) {
                                return false;
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"msgCache is empty");
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    processedCacheEntryResult = this.processCachedMsgs(linkedList);
                    if (processedCacheEntryResult.rc) continue;
                    return false;
                }
                if (bl2) continue;
                bl2 = true;
                this.setCachedMsgsSent(true);
                bl = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
        this.setCachedMsgsSent(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessedCacheEntryResult processCachedMsgs(List list) {
        if (list != null && list.size() > 0) {
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && bl) {
                CachedMsg cachedMsg = (CachedMsg)iterator.next();
                bl = this.sendMessage(cachedMsg.getGmId(), cachedMsg.getData(), true, true);
                if (!bl) {
                    if (!this.isPrimaryMgdGroupStable()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processCachedMsgs: continue processing since PMG is still stable");
                    }
                    bl = true;
                    continue;
                }
                iterator.remove();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processCachedMsgs: temp msg queue size=" + list.size()));
            }
            if (list.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processCachedMsgs: add remaining msgs to beginning stored msg list to maintain order: " + list.size()));
                }
                List list2 = this.msgCache;
                synchronized (list2) {
                    this.msgCache.addAll(0, list);
                }
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processCachedMsgs: stopped sending due to pmg not being stable: " + this.getAccessPointGroupName()));
                }
                return new ProcessedCacheEntryResult(false, list.size());
            }
        }
        return new ProcessedCacheEntryResult(true, list == null ? 0 : list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean sendCachedPosts() {
        if (this.isPostMsgCacheEnabled) {
            LinkedList linkedList = null;
            boolean bl = false;
            boolean bl2 = false;
            ProcessedCacheEntryResult processedCacheEntryResult = null;
            while (!bl) {
                List list = this.postMsgCache;
                synchronized (list) {
                    if (!this.postMsgCache.isEmpty()) {
                        if (processedCacheEntryResult != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("sendCachedPosts: pcer.remainingEntries=" + processedCacheEntryResult.numRemainingEntries));
                            }
                            if (processedCacheEntryResult.numRemainingEntries == this.postMsgCache.size()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"sendCachedPosts: same # of entries that failed to process..exiting");
                                }
                                break;
                            }
                        }
                        linkedList = new LinkedList(this.postMsgCache);
                        this.postMsgCache.clear();
                        if (linkedList.size() >= 100) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("send cached posts outside lock: " + linkedList.size()));
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("send cached posts inside lock: " + linkedList.size()));
                            }
                            bl = true;
                            processedCacheEntryResult = this.processCachedPosts(linkedList);
                            if (!processedCacheEntryResult.rc) {
                                return false;
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"postMsgCache is empty");
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    processedCacheEntryResult = this.processCachedPosts(linkedList);
                    if (processedCacheEntryResult.rc) continue;
                    return false;
                }
                if (bl2) continue;
                bl2 = true;
                this.setCachedPostsSent(true);
                bl = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
        this.setCachedPostsSent(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessedCacheEntryResult processCachedPosts(List list) {
        if (list != null && list.size() > 0) {
            boolean bl = true;
            boolean bl2 = true;
            Iterator iterator = list.iterator();
            while (bl && iterator.hasNext()) {
                CachedPost cachedPost = (CachedPost)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sending cached post: bb=" + cachedPost.getCgbPost().getBBName() + ", subj=" + cachedPost.getCgbPost().getSubject() + ", targetserver=" + CGBridgeUtils.getFullServerName(cachedPost.getGmidtosend())));
                }
                if (!this.getBridgeVersion().isSeamlessFailoverEnabled() || this.isMessageForThisBridge(cachedPost.getCgbPost().getSubjectHashCode())) {
                    try {
                        if (!bl2) continue;
                        bl = this.forwardUpdateDirectly(cachedPost.getCgbPost(), cachedPost.getGmidtosend(), cachedPost.getFullyQualiedCoreGroupName(), cachedPost.isFromLocalCell(), cachedPost.getInboundAPG(), true, cachedPost.getCgbPost().marshallData());
                        if (!bl) {
                            if (this.isPrimaryMgdGroupStable()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"set isMsgSentSuccessfully to true, since PMG is still stable");
                                }
                                bl = true;
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        iterator.remove();
                    }
                    catch (IOException iOException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("problems sending post: " + cachedPost.getCgbPost()));
                        }
                        FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".processCachedPosts"), (String)"2336", (Object)this);
                    }
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"post no longer hashes to this bridge, so do not send");
                }
                iterator.remove();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("temp post queue size=" + list.size()));
            }
            if (list.size() > 0) {
                List list2 = this.postMsgCache;
                synchronized (list2) {
                    this.postMsgCache.addAll(0, list);
                }
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processCachedPosts: stopped sending due to pmg not being stable: " + this.getAccessPointGroupName()));
                }
                new ProcessedCacheEntryResult(false, list.size());
            }
        }
        return new ProcessedCacheEntryResult(true, list == null ? 0 : list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStablePrimaryGroup(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setStablePrimaryGroup-" + bl));
        }
        Object object = this.pmgStabilityLock;
        synchronized (object) {
            this.isPrimaryMgdGroupStable = bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStablePrimaryGroup");
        }
    }

    void doStablePrimaryGroupWork(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doStablePrimaryGroupWork");
        }
        if (!this.sendCachedMsgs()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doStablePrimaryGroupWork...stopped sendCachedMsgs processing");
            }
            return;
        }
        if (!this.sendCachedPosts()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doStablePrimaryGroupWork...stopped sendCachedPosts processing");
            }
            return;
        }
        if (bl && !this.resendSubscriptions()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doStablePrimaryGroupWork...stopped resendSubscriptions processing");
            }
            return;
        }
        if (this.cgbConfig.getLocalBridgeCGBVersion().isSeamlessFailoverEnabled()) {
            this.getCGBridge().processRebuildState(false, CGBridge.CACHED_LOCAL_STATE_NONE, null, null, null, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doStablePrimaryGroupWork");
        }
    }

    void updateAvailableCoreGroups(InterCGBridgePMGEvents interCGBridgePMGEvents, String string, GroupMemberId[] groupMemberIdArray, boolean bl) {
        if (interCGBridgePMGEvents == this.localPMGEvents) {
            this.updateAvailableCoreGroups(true, string, groupMemberIdArray, bl);
        } else {
            this.updateAvailableCoreGroups(false, string, groupMemberIdArray, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAvailableCoreGroups(boolean bl, String string, GroupMemberId[] groupMemberIdArray, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateAvailableCoreGroups-" + string), (Object)new Object[]{new Boolean(bl2)});
        }
        Map map = this.availableCGBServersMap;
        synchronized (map) {
            try {
                int n;
                boolean bl3 = false;
                boolean bl4 = false;
                GroupMemberId[] groupMemberIdArray2 = (GroupMemberId[])this.availableCGBServersMap.get(string);
                int n2 = groupMemberIdArray2 == null ? 0 : groupMemberIdArray2.length;
                int n3 = n = groupMemberIdArray == null ? 0 : groupMemberIdArray.length;
                if (groupMemberIdArray2 == groupMemberIdArray || n2 == 0 && n == 0) {
                    bl3 = false;
                } else if (n2 != n) {
                    bl3 = true;
                } else {
                    int n4;
                    HashSet<String> hashSet = new HashSet<String>();
                    HashSet<String> hashSet2 = new HashSet<String>();
                    for (n4 = 0; n4 < groupMemberIdArray.length; ++n4) {
                        hashSet2.add(groupMemberIdArray[n4].getServerName());
                    }
                    for (n4 = 0; n4 < groupMemberIdArray2.length; ++n4) {
                        hashSet.add(groupMemberIdArray2[n4].getServerName());
                    }
                    bl3 = !hashSet2.containsAll(hashSet);
                }
                this.availableCGBServersMap.put(string, groupMemberIdArray);
                if (bl) {
                    if (this.isLocalAPGAvailable != bl2) {
                        bl4 = true;
                    }
                    this.isLocalAPGAvailable = bl2;
                }
                if (this.isLocalAPGAvailable && bl3 || bl4) {
                    this.cgb.updateAPGStatus(this.localPMGServerName, this.accessPointGroupName, this.availableCGBServersMap, this.isLocalAPGAvailable);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isLocalPMGStatusChanged=" + bl4 + ", isBridgeMembershipChanged=" + bl3 + ". Do not update APG status if it has not changed"));
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Problems printing CGB PMG status: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".updateAvailableCoreGroups"), (String)"2188", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateAvailableCoreGroups");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getPeerSubscriptionsStored(String string, String string2, CGBridgeHAStateMsg cGBridgeHAStateMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerSubscriptionsStored", (Object)new Object[]{string, string2});
        }
        HashMap<Integer, CGBridgeBBRemoteSubscriptionMsg> hashMap = new HashMap<Integer, CGBridgeBBRemoteSubscriptionMsg>();
        HashMap hashMap2 = this.peerSubscriptions;
        synchronized (hashMap2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getPeerSubscriptionsStored number of subs: " + this.peerSubscriptions.size()));
            }
            if (cGBridgeHAStateMsg != null) {
                --this.getPeerSubscriptionsStoredIndex;
                cGBridgeHAStateMsg.setExpectedViewChangeID(this.getPeerSubscriptionsStoredIndex);
            }
            Iterator iterator = this.peerSubscriptions.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                CGBridgeStoredSubscription cGBridgeStoredSubscription = (CGBridgeStoredSubscription)this.peerSubscriptions.get(n);
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = cGBridgeStoredSubscription.getSubscriptionmsg();
                String string3 = cGBridgeStoredSubscription.getCellname();
                if (string.equals(this.cgbConfig.getCellName())) {
                    hashMap.put(n, cGBridgeBBRemoteSubscriptionMsg);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("sub added: " + cGBridgeBBRemoteSubscriptionMsg));
                    continue;
                }
                if (string.equals(string3)) {
                    hashMap.put(n, cGBridgeBBRemoteSubscriptionMsg);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("remote sub added: " + cGBridgeBBRemoteSubscriptionMsg));
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("sub not added: " + cGBridgeBBRemoteSubscriptionMsg));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPeerSubscriptionsStored-" + hashMap.size()));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDownCoreStack() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("shutDownCoreStack-" + this.getAccessPointGroupName()));
        }
        Object object = this.pmgStabilityLock;
        synchronized (object) {
            block7: {
                try {
                    this.pmg.stop();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("caught exception shutting down pmg: " + exception));
                }
            }
            this.localCoregroupMembers.clear();
            this.remoteCellMembers.clear();
            this.coreGroupList.clear();
            this.interCGBCoreStack.shutdown();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("shutDownCoreStack-" + this.getAccessPointGroupName()));
        }
    }

    private void setCoreStackParms(CoreStackInfo coreStackInfo, HashMap hashMap) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCoreStackParms argProps=[" + CGBridgeConfig.propertiesToString(hashMap) + "]"));
        }
        String string = null;
        String string2 = null;
        try {
            int n;
            string = "IBM_CS_FD_PERIOD_SECS";
            string2 = (String)hashMap.get(string);
            if (string2 != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setFailureDetectorTransmissionInterval(n * 1000);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_FD_CONSECUTIVE_MISSED")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setFailureDetectorTimeout(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_CACHE_PERIOD_MILLIS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 250 || n > 30000) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setCachedUpdateFrequency(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_MAX_TRANSPORT_MEG")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setMaximumTransportMemorySize(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_LS_DATASTACK_MEG")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                    coreStackInfo.setDataStackMemory(100);
                } else {
                    coreStackInfo.setDataStackMemory(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set data stack memory to a default of 100");
                }
                coreStackInfo.setDataStackMemory(100);
            }
            string = "IBM_CS_USE_POOLED_MEMORY";
            string2 = (String)hashMap.get(string);
            if (string2 != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfo.setUsePooledMemory(n != 0);
                this.setCoreStackParmsSuccess(string, string2 + "==>)" + (n != 0));
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_MESSAGE_SIZE")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1024) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setExpectedMessageSize(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_BRINGUP_TIME_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setMemberBringupTimeSecs(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_COMPLETENESS_VS_SPEED")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1 || n > 5) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setCompletenessVsSpeed(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_UNICAST_DISCOVERY_INTERVAL_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setDiscoveryIntervalSecs(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_FIREWALL_UNICAST_DISCOVERY_INTERVAL_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setFirewallDiscoveryIntervalSecs(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_SS_MAX_TOKEN_BYTES")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1024) {
                    this.setCoreStackParmsFailure(string, string2);
                } else {
                    coreStackInfo.setSharedSecretTokenSize(n);
                    this.setCoreStackParmsSuccess(string, string2);
                }
            }
            if ((string2 = (String)hashMap.get(string = "IBM_CS_DCS_DIAGNOSTICS")) != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfo.setEnableTransportDiagnostics(n != 0);
                this.setCoreStackParmsSuccess(string, string2 + "==>)" + (n != 0));
            }
        }
        catch (Throwable throwable) {
            this.setCoreStackParmsFailure(string, string2);
            String string3 = this.getClass().getName() + " setCoreStackParms FAILED to set propName=[" + string + "] spropValue=[" + string2 + "]";
            FFDCFilter.processException((Throwable)throwable, (String)string3, (String)"50", (Object)this);
        }
    }

    private void setCoreStackParmsSuccess(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCoreStackParms SUCCESS propName=[" + string + "] spropValue=[" + string2 + "]"));
        }
    }

    private void setCoreStackParmsFailure(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCoreStackParms FAILED to set propName=[" + string + "] spropValue=[" + string2 + "]"));
        }
    }

    boolean isGroupMembersEqual(GroupMemberId[] groupMemberIdArray) {
        if (this.localPMGEvents == null || this.localPMGEvents.getGmidsCurrent() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"localPMGEvents or getGmidsCurrent==null");
            }
            return false;
        }
        GroupMemberId[] groupMemberIdArray2 = this.localPMGEvents.getGmidsCurrent();
        if (groupMemberIdArray != null && groupMemberIdArray.length == groupMemberIdArray2.length) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                int n;
                boolean bl = false;
                for (n = 0; n < groupMemberIdArray2.length; ++n) {
                    if (!groupMemberIdArray[i].getServerName().equals(CGBridgeUtils.getFullServerName(groupMemberIdArray2[n]))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("couldn't find match for: " + groupMemberIdArray[i].getServerName() + "   " + CGBridgeUtils.getFullServerName(groupMemberIdArray2[n])));
                }
                return false;
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inter and intra lengths do not match");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPrimaryMgdGroupStable() {
        Object object = this.pmgStabilityLock;
        synchronized (object) {
            return this.isPrimaryMgdGroupStable;
        }
    }

    CGBVersion getBridgeVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetNonSeamlessBridges() {
        Set set = this.nonSeamlessBridges;
        synchronized (set) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.getAccessPointGroupName() + "-resetNonSeamlessBridges: nonSeamlessBridges=" + this.nonSeamlessBridges));
            }
            this.nonSeamlessBridges.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNonSeamlessBridges(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeNonSeamlessBridges-" + string));
        }
        Set set = this.nonSeamlessBridges;
        synchronized (set) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.getAccessPointGroupName() + "-removeNonSeamlessBridges: nonSeamlessBridges=" + this.nonSeamlessBridges));
            }
            if (bl = this.nonSeamlessBridges.remove(string)) {
                this.setBridgeVersion();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeNonSeamlessBridges-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBridgeVersion() {
        Set set = this.nonSeamlessBridges;
        synchronized (set) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.getAccessPointGroupName() + "-nonSeamlessBridges=" + this.nonSeamlessBridges));
            }
            if (this.nonSeamlessBridges.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"set to v2");
                }
                this.version = CGBVersion.VERSION2;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"set to v1");
                }
                this.version = CGBVersion.VERSION1;
            }
        }
    }

    CGBridge getCGBridge() {
        return this.cgb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBridgeUpdateRegistry(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeBridgeUpdateRegistry", (Object)new Object[]{string, new Integer(n)});
        }
        Map map = this.updateRegisterMap;
        synchronized (map) {
            BridgeServerUpdateRegistry bridgeServerUpdateRegistry = (BridgeServerUpdateRegistry)this.updateRegisterMap.get(string);
            if (bridgeServerUpdateRegistry != null && bridgeServerUpdateRegistry.getBridgeViewChangeID() == n) {
                this.updateRegisterMap.remove(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removed updateRegisterMap entry");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeBridgeUpdateRegistry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAllBridgeUpdateRegistries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelAllBridgeUpdateRegistries");
        }
        Map map = this.updateRegisterMap;
        synchronized (map) {
            Iterator iterator = this.updateRegisterMap.values().iterator();
            while (iterator.hasNext()) {
                BridgeServerUpdateRegistry bridgeServerUpdateRegistry = (BridgeServerUpdateRegistry)iterator.next();
                bridgeServerUpdateRegistry.cancelAlarm();
                bridgeServerUpdateRegistry.setInactive();
            }
            this.updateRegisterMap.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelAllBridgeUpdateRegistries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BridgeServerUpdateRegistry getUpdateRegistry(String string) {
        Map map = this.updateRegisterMap;
        synchronized (map) {
            return (BridgeServerUpdateRegistry)this.updateRegisterMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyUpdateRegistry(CGBridgeBBPost cGBridgeBBPost, GroupMemberId groupMemberId, String string, boolean bl) {
        BridgeServerUpdateRegistry bridgeServerUpdateRegistry;
        String string2 = CGBridgeUtils.getFullServerName(groupMemberId);
        if (!this.getBridgeVersion().isSeamlessFailoverEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"modifyUpdateRegistry-seamless disabled");
            }
            return;
        }
        Object object = this.updateRegisterMap;
        synchronized (object) {
            bridgeServerUpdateRegistry = (BridgeServerUpdateRegistry)this.updateRegisterMap.get(string2);
        }
        if (bridgeServerUpdateRegistry != null && cGBridgeBBPost.isInitialUpdate() && bridgeServerUpdateRegistry.updateReceived(cGBridgeBBPost, cGBridgeBBPost.getCGBScopeData().getCGBridgeScopeType(), cGBridgeBBPost.getCellName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateRegistry ref =  " + bridgeServerUpdateRegistry));
            }
            this.sendStateCompleteMsg(bridgeServerUpdateRegistry.getBridgeWaitingForUpdates(), bridgeServerUpdateRegistry.getBridgeViewChangeID(), bl);
            this.removeBridgeUpdateRegistry(bridgeServerUpdateRegistry.getFullyQualifiedServerName(), bridgeServerUpdateRegistry.getBridgeViewChangeID());
        }
        if (!((LocalBridgeServerUpdateRegistry)(object = this.getLocalUpdateRegistry())).isStateCompleteMsgSent() && ((LocalBridgeServerUpdateRegistry)object).updateReceivedLocal(cGBridgeBBPost, cGBridgeBBPost.getCGBScopeData().getCGBridgeScopeType(), cGBridgeBBPost.getCellName(), string) && ((LocalBridgeServerUpdateRegistry)object).isLastSubscriptonProcessed()) {
            this.processLastUpdateForLocalUpdateRegistry((LocalBridgeServerUpdateRegistry)object);
        }
    }

    synchronized void processLastUpdateForLocalUpdateRegistry(LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLastUpdateForLocalUpdateRegistry");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isActive=" + localBridgeServerUpdateRegistry.isActiveForProcessing() + ", isStateCompleteMsgSent=" + localBridgeServerUpdateRegistry.isStateCompleteMsgSent()));
        }
        if (localBridgeServerUpdateRegistry.isActiveForProcessing() && !localBridgeServerUpdateRegistry.isStateCompleteMsgSent()) {
            this.sendLocalViewChangeStateCompleteMsgs(localBridgeServerUpdateRegistry.getFullyQualifiedServerName(), localBridgeServerUpdateRegistry.getBridgeViewChangeID());
            localBridgeServerUpdateRegistry.setStateCompleteMsgSent(true);
            localBridgeServerUpdateRegistry.setReadyToProcessUpdates(false);
            localBridgeServerUpdateRegistry.setLastSubscriptonProcessed(false);
            localBridgeServerUpdateRegistry.setActive(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLastUpdateForLocalUpdateRegistry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeBridgeUpdateRegistry(String string, BridgeServerUpdateRegistry bridgeServerUpdateRegistry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("storeBridgeUpdateRegistry-" + string), (Object)new Object[]{bridgeServerUpdateRegistry});
        }
        Map map = this.updateRegisterMap;
        synchronized (map) {
            BridgeServerUpdateRegistry bridgeServerUpdateRegistry2 = (BridgeServerUpdateRegistry)this.updateRegisterMap.get(string);
            if (bridgeServerUpdateRegistry2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"existingRegistry!=null");
                }
                bridgeServerUpdateRegistry2.cancelAlarm();
                bridgeServerUpdateRegistry2.setInactive();
            }
            this.updateRegisterMap.put(string, bridgeServerUpdateRegistry);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeBridgeUpdateRegistry");
        }
    }

    public void bridgeUpdateProcessingComplete(GroupMemberId groupMemberId, int n, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bridgeUpdateProcessingComplete", (Object)new Object[]{groupMemberId, new Integer(n), string, this});
        }
        if (groupMemberId == null) {
            this.sendLocalViewChangeStateCompleteMsgs(string, n);
        } else {
            this.sendStateCompleteMsg(groupMemberId, n, false);
            this.removeBridgeUpdateRegistry(string, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeUpdateProcessingComplete");
        }
    }

    public void bridgeUpdateTimerExpired(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bridgeServerUpdateTimerExpired", (Object)new Object[]{string, new Integer(n), this});
        }
        this.removeBridgeUpdateRegistry(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bridgeServerUpdateTimerExpired");
        }
    }

    LocalBridgeServerUpdateRegistry getLocalUpdateRegistry() {
        return this.localUpdateRegistry;
    }

    void resetLocalUpdateRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetLocalUpdateRegistry");
        }
        if (this.localUpdateRegistry.isActiveForProcessing()) {
            this.localUpdateRegistry.setActive(false);
            this.localUpdateRegistry.setReadyToProcessUpdates(false);
            this.localUpdateRegistry.setLastSubscriptonProcessed(false);
            this.localUpdateRegistry.setStateCompleteMsgSent(false);
        }
        this.createLocalUpdateRegistry();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetLocalUpdateRegistry");
        }
    }

    void createLocalUpdateRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLocalUpdateRegistry");
        }
        ++this.localViewChangeCount;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("localViewChangeCount=" + this.localViewChangeCount));
        }
        this.localUpdateRegistry = new LocalBridgeServerUpdateRegistry(this.cgbConfig.getFullServerName(), this.localViewChangeCount, 1L, this, this.cgbConfig.getFullCoreGroupName(), this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createLocalUpdateRegistry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getRemoteCellCoreGroupMembers() {
        HashMap hashMap = this.remoteCellCoreGroupMembers;
        synchronized (hashMap) {
            return new HashMap(this.remoteCellCoreGroupMembers);
        }
    }

    InterCGBridgePMGEvents getLocalPMGEvents() {
        return this.localPMGEvents;
    }

    public String toString() {
        return this.getAccessPointGroupName();
    }

    public void resendMessages(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resendMessages");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("# msgs = " + list.size()));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                CachedMsg cachedMsg = (CachedMsg)iterator.next();
                if (cachedMsg.getType() != null && cachedMsg.getType().equals(MSG_PROCESSOR_FORWARD_UPDATE_DIRECTLY)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"resendMessages-ForwardUpdate");
                    }
                    Object[] objectArray = (Object[])cachedMsg.getObject();
                    CGBridgeBBPost cGBridgeBBPost = (CGBridgeBBPost)objectArray[0];
                    String string = (String)objectArray[1];
                    boolean bl = (Boolean)objectArray[2];
                    String string2 = (String)objectArray[3];
                    this.forwardUpdateDirectly(cGBridgeBBPost, cachedMsg.getGmId(), string, bl, string2, false, cachedMsg.getData());
                    continue;
                }
                this.sendMessage(cachedMsg.getGmId(), cachedMsg.getData(), true, false);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("problem resending message: " + exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resendMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachedSubscription(CachedSubscription cachedSubscription) {
        Set set = this.cachedSubscriptions;
        synchronized (set) {
            this.cachedSubscriptions.add(cachedSubscription);
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.getAccessPointGroupName() + "-addCachedSubscription size=" + this.cachedSubscriptions.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachedGSRSubFromServer(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeCachedGSRSubFromServer-" + string));
        }
        Set set = this.cachedSubscriptions;
        synchronized (set) {
            Iterator iterator = this.cachedSubscriptions.iterator();
            while (iterator.hasNext()) {
                CachedSubscription cachedSubscription = (CachedSubscription)iterator.next();
                if (!cachedSubscription.isGSRSub()) continue;
                StoredGSRSub storedGSRSub = (StoredGSRSub)cachedSubscription;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cache gsr sub from: " + storedGSRSub.gsrSubs.getFullyQualifiedServerName() + ", server to remove: " + string));
                }
                if (!storedGSRSub.gsrSubs.getFullyQualifiedServerName().equals(string)) continue;
                iterator.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCachedGSRSubFromServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCachedNotifySubscriptions(Set set) {
        LinkedHashSet linkedHashSet = null;
        Object object = this.cachedSubscriptions;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.getAccessPointGroupName() + " processCachedSubscriptions size=" + this.cachedSubscriptions.size()));
            }
            linkedHashSet = new LinkedHashSet(this.cachedSubscriptions);
            this.cachedSubscriptions.clear();
        }
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            object = (CachedSubscription)iterator.next();
            CachedSubscriptionWork cachedSubscriptionWork = new CachedSubscriptionWork((CachedSubscription)object);
            if (set != null) {
                cachedSubscriptionWork.setPrereqWork(set);
            }
            CGBridgeService.getInstance().getWorkDispatcher().addWork(cachedSubscriptionWork);
        }
    }

    boolean isLocalUpdateRegistryActive(LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        if (localBridgeServerUpdateRegistry == null) {
            return true;
        }
        return localBridgeServerUpdateRegistry.isActiveForProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCachedMsgsSent() {
        List list = this.msgCache;
        synchronized (list) {
            return this.isCachedMsgsSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCachedMsgsSent(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCachedMsgsSent=" + bl));
        }
        List list = this.msgCache;
        synchronized (list) {
            this.isCachedMsgsSent = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCachedPostsSent() {
        List list = this.postMsgCache;
        synchronized (list) {
            return this.isCachedPostsSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCachedPostsSent(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCachedPostsSent=" + bl));
        }
        List list = this.postMsgCache;
        synchronized (list) {
            this.isCachedPostsSent = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCachedSubscriptionsSent() {
        Map map = this.storedSubsTable;
        synchronized (map) {
            return this.isCachedSubscriptionsSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCachedSubscriptionsSent(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCachedSubscriptionsSent=" + bl));
        }
        Map map = this.storedSubsTable;
        synchronized (map) {
            this.isCachedSubscriptionsSent = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean storeReceivedSubscription(Work work, GroupMemberId groupMemberId) {
        Map map = this.storedReceivedSubscriptions;
        synchronized (map) {
            if (!this.isPMGSubsProcessed()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("stored received sub: " + work));
                }
                this.storedReceivedSubscriptions.put(work, groupMemberId.getServerName());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStoredSubscriptionsToWorkQueue() {
        Map map = this.storedReceivedSubscriptions;
        synchronized (map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding " + this.storedReceivedSubscriptions.size() + " stored subscriptions to WorkQueue"));
            }
            Iterator iterator = this.storedReceivedSubscriptions.keySet().iterator();
            while (iterator.hasNext()) {
                Work work = (Work)iterator.next();
                CGBridgeService.getInstance().getWorkDispatcher().addWork(work);
            }
            this.storedReceivedSubscriptions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStoredOnMessageWorkSubs(GroupMemberId groupMemberId) {
        int n = 0;
        Map map = this.storedReceivedSubscriptions;
        synchronized (map) {
            Iterator iterator = this.storedReceivedSubscriptions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!groupMemberId.getServerName().equals(entry.getValue())) continue;
                iterator.remove();
                ++n;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removed " + n + " stored work items for " + CGBridgeUtils.getFullServerName(groupMemberId)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPMGSubsProcessed() {
        Map map = this.storedReceivedSubscriptions;
        synchronized (map) {
            return this.isPMGSubsProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPMGSubsProcessed(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isPMGSubsProcessed=" + bl));
        }
        Map map = this.storedReceivedSubscriptions;
        synchronized (map) {
            this.isPMGSubsProcessed = bl;
        }
    }

    boolean isUpdateSentProcessor(SubjectInfo subjectInfo, CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId) {
        boolean bl = true;
        if (subjectInfo != null) {
            try {
                bl = this.getCGBridge().getSubscriptionTracker().isUpdateSent(subjectInfo, cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup(), groupMemberId);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Could not check if update was sent for: " + cGBridgeBBRemoteSubscriptionMsg + ", error=" + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".isUpdateSent"), (String)"4826", (Object)this);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isUpdateSentProcessor rc=" + bl + ", subjInfo=" + subjectInfo));
        }
        return bl;
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ibcg alarm");
        }
        try {
            if (!this.sendCachedMsgs()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IBCG...stopped sendCachedMsgs processing");
                }
                return;
            }
            if (!this.sendCachedPosts()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IBCG...stopped sendCachedPosts processing");
                }
                return;
            }
            if (!this.resendSubscriptions()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IBCG...stopped resendSubscriptions processing");
                }
                return;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".alarm"), (String)"7749", (Object)this);
        }
        AlarmManager.createNonDeferrable((long)60000L, (AlarmListener)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ibcg alarm");
        }
    }

    class CachedSubscriptionWork
    extends Work {
        CachedSubscription sub;

        public CachedSubscriptionWork(CachedSubscription cachedSubscription) throws IllegalArgumentException {
            super(1, true, CACHED_SUBSCRIPTION_WORK);
            this.sub = cachedSubscription;
        }

        public void doWork() {
            block4: {
                if (this.sub.isGSRSub()) {
                    ((StoredGSRSub)this.sub).process();
                } else {
                    try {
                        ((IBCGCachedSubscription)this.sub).process();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "CachedSubscriptionWork.doWork()"), (String)"222", (Object)this);
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug((TraceComponent)tc, (String)("error process sub: " + exception.getMessage()));
                    }
                }
            }
        }
    }

    class ProcessedCacheEntryResult {
        boolean rc;
        int numRemainingEntries;

        ProcessedCacheEntryResult(boolean bl, int n) {
            this.rc = bl;
            this.numRemainingEntries = n;
        }
    }

    class GSRSubMsgSubscriptionWork
    extends Work {
        CGBridgeBBRemoteSubscriptionMsg sub;
        GSRSubProcessor subProcessor;

        public GSRSubMsgSubscriptionWork(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GSRSubProcessor gSRSubProcessor) throws IllegalArgumentException {
            super(1, false, InterBridgeCoreGroup.this.gsrSubMsgSubscriptionWork);
            this.sub = cGBridgeBBRemoteSubscriptionMsg;
            this.subProcessor = gSRSubProcessor;
        }

        public void doWork() {
            if (!this.subProcessor.isCanceled()) {
                StoredValues storedValues = new StoredValues();
                if (!InterBridgeCoreGroup.this.cgb.processCGBridgeMsg(this.sub, InterBridgeCoreGroup.this.accessPointGroupName, this.subProcessor.sender, InterBridgeCoreGroup.this.getLocalAPGTopology(), null, false, this.subProcessor.originCoreGroup, this.subProcessor.gsrSubs.getAllAvailableCoreGroups(), true, storedValues)) {
                    try {
                        if (!this.sub.isSubscribe() || !this.sub.getOriginCoreGroup().equals(this.subProcessor.originCoreGroup) || this.sub.isSubscribe() && InterBridgeCoreGroup.this.isUpdateSentProcessor(storedValues.si, this.sub, this.subProcessor.sender)) {
                            BridgeServerUpdateRegistry bridgeServerUpdateRegistry;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"sub must already be subscribed...removing as one that we expect an update from");
                            }
                            if ((bridgeServerUpdateRegistry = this.subProcessor.updateRegistry).removeUpdateTracking(this.sub, this.sub.getCGBScopeData())) {
                                InterBridgeCoreGroup.this.bridgeUpdateProcessingComplete(bridgeServerUpdateRegistry.getBridgeWaitingForUpdates(), bridgeServerUpdateRegistry.getBridgeViewChangeID(), bridgeServerUpdateRegistry.getFullyQualifiedServerName());
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("GSRSub: prevented premature removal: " + this.sub));
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("problems doing gsrsub work: " + exception.getMessage()));
                        }
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".doWork"), (String)"55489", (Object)this);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processing of gsr subs msg work cancelled");
                }
            }
        }
    }

    class UnsubscribeSubscriptionRebuildWork
    extends Work {
        CGBridgeBBRemoteSubscriptionMsg sub;
        GroupMemberId gmid;
        String sendingCGName;
        LocalBridgeServerUpdateRegistry localReg;

        public UnsubscribeSubscriptionRebuildWork(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, String string, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) throws IllegalArgumentException {
            super(1, false, InterBridgeCoreGroup.this.unsubscribeSubscriptionRebuildWork);
            this.sub = cGBridgeBBRemoteSubscriptionMsg;
            this.gmid = groupMemberId;
            this.sendingCGName = string;
            this.localReg = localBridgeServerUpdateRegistry;
        }

        public void doWork() {
            if (this.localReg.isActiveForProcessing()) {
                this.sub.setSubscribe(false);
                InterBridgeCoreGroup.this.cgb.processCGBridgeMsg(this.sub, InterBridgeCoreGroup.this.accessPointGroupName, this.gmid, null, null, true, this.sendingCGName, null, false);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("LocalBridgeServerUpdateRegistry inactive to process unsubscribe: " + this.sub));
            }
        }
    }

    class SubscribeSubscriptionRebuildWork
    extends Work {
        LocalBridgeServerUpdateRegistry lUpdateRegistry;
        String sendingCGName;
        CGBridgeHAStateMsg cgbStateMessage;
        boolean isLastPieceOfWorkForLocalUpdateRegistry;

        public SubscribeSubscriptionRebuildWork(LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry, String string, CGBridgeHAStateMsg cGBridgeHAStateMsg, boolean bl) throws IllegalArgumentException {
            super(1, false, InterBridgeCoreGroup.this.subscribeSubscriptionRebuildWork);
            this.lUpdateRegistry = localBridgeServerUpdateRegistry;
            this.sendingCGName = string;
            this.cgbStateMessage = cGBridgeHAStateMsg;
            this.isLastPieceOfWorkForLocalUpdateRegistry = bl;
        }

        public void doWork() {
            boolean bl = false;
            if (this.lUpdateRegistry.isActiveForProcessing()) {
                block18: {
                    if (this.isLastPieceOfWorkForLocalUpdateRegistry) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processing last subscription work: " + this));
                            }
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug((TraceComponent)tc, (String)("random thread exception: " + interruptedException.getLocalizedMessage()));
                        }
                    }
                }
                StoredValues storedValues = new StoredValues();
                boolean bl2 = InterBridgeCoreGroup.this.cgb.processCGBridgeMsg(this.cgbStateMessage.getRemoteSubscription(), InterBridgeCoreGroup.this.accessPointGroupName, this.cgbStateMessage.getGroupMemberId(), null, null, false, this.sendingCGName, null, false, storedValues);
                if (!bl2) {
                    try {
                        if (!this.sendingCGName.equals(this.cgbStateMessage.getRemoteSubscription().getOriginCoreGroup()) || InterBridgeCoreGroup.this.isUpdateSentProcessor(storedValues.si, this.cgbStateMessage.getRemoteSubscription(), this.cgbStateMessage.getGroupMemberId())) {
                            if (this.lUpdateRegistry.removeUpdateTrackingLocal(this.cgbStateMessage.getRemoteSubscription(), this.cgbStateMessage.getRemoteSubscription().getCGBScopeData(), this.cgbStateMessage.getRemoteSubscription().getOriginCoreGroup())) {
                                InterBridgeCoreGroup.this.processLastUpdateForLocalUpdateRegistry(this.lUpdateRegistry);
                                bl = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("SubSubRebWk: prevented premature removal: " + this.cgbStateMessage.getRemoteSubscription()));
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("problems doing subsub work: " + exception.getMessage()));
                        }
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".doWork"), (String)"57489", (Object)this);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("LocalBridgeServerUpdateRegistry inactive to process: " + this.cgbStateMessage.getRemoteSubscription()));
            }
            if (!bl && this.isLastPieceOfWorkForLocalUpdateRegistry) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setting last sub processed flag: " + this));
                }
                if (this.lUpdateRegistry.setLastSubscriptonProcessed(true)) {
                    InterBridgeCoreGroup.this.processLastUpdateForLocalUpdateRegistry(this.lUpdateRegistry);
                }
            }
        }
    }

    class StoredValues {
        SubjectInfo si;

        StoredValues() {
        }
    }

    class GSRSubProcessor {
        CGBridgeGSRSubscriptionMsg gsrSubs;
        GroupMemberId sender;
        String originCoreGroup;
        InterBridgeCoreGroup ibcg;
        boolean isCanceled;
        BridgeServerUpdateRegistry updateRegistry;
        String sendingServerName;

        GSRSubProcessor(InterBridgeCoreGroup interBridgeCoreGroup2, CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg, GroupMemberId groupMemberId, String string) {
            this.gsrSubs = cGBridgeGSRSubscriptionMsg;
            this.sender = groupMemberId;
            this.originCoreGroup = string;
            this.ibcg = interBridgeCoreGroup2;
            this.isCanceled = false;
            this.sendingServerName = CGBridgeUtils.getFullServerName(groupMemberId);
        }

        synchronized void cancelProcessing() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("cancelProcessing-" + this.sendingServerName));
            }
            if (!this.isCanceled) {
                this.isCanceled = true;
                if (this.updateRegistry != null) {
                    this.updateRegistry.cancelAlarm();
                    this.updateRegistry.setInactive();
                    InterBridgeCoreGroup.this.removeBridgeUpdateRegistry(this.updateRegistry.getFullyQualifiedServerName(), this.updateRegistry.getBridgeViewChangeID());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("cancelProcessing-" + this.sendingServerName));
            }
        }

        private void processGSRSubMsgSubscriptions(List list) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("processGSRSubMsgSubscriptions-" + this.sendingServerName), (Object)new Object[]{list, this.sender});
            }
            Iterator iterator = list.iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("available core groups: " + this.gsrSubs.getAllAvailableCoreGroups()));
            }
            while (iterator.hasNext() && !this.isCanceled()) {
                if (!this.isCanceled()) {
                    CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                    CGBridgeService.getInstance().getWorkDispatcher().addWork(new GSRSubMsgSubscriptionWork(cGBridgeBBRemoteSubscriptionMsg, this));
                    continue;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"processing of subs cancelled");
                break;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("processGSRSubMsgSubscriptions-" + this.sendingServerName));
            }
        }

        boolean processGSRSubMsg(List list) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("processGSRSubMsg-" + CGBridgeUtils.getFullServerName(this.sender)), (Object)new Object[]{this.gsrSubs, new Integer(this.gsrSubs.getBridgeViewChangeID())});
            }
            String string = CGBridgeUtils.generateCGKey(this.gsrSubs.getOriginCellName(), this.gsrSubs.getOriginCoreGroup());
            this.updateRegistry = new BridgeServerUpdateRegistry(CGBridgeUtils.getFullServerName(this.sender), this.gsrSubs.getBridgeViewChangeID(), this.gsrSubs.getNumOfMSecsToWaitForUpdates(), this.ibcg, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateRegistry ref =  " + this.updateRegistry));
            }
            this.updateRegistry.setBridgeWaitingForUpdates(this.sender);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !this.isCanceled()) {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)iterator.next();
                if (InterBridgeCoreGroup.this.isMessageForThisBridge(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode())) {
                    this.updateRegistry.registerForUpdateTracking(cGBridgeBBRemoteSubscriptionMsg, cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData());
                    continue;
                }
                iterator.remove();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("remove subscription that does not match this bridge: " + cGBridgeBBRemoteSubscriptionMsg));
            }
            if (this.updateRegistry.getExpectedUpdates().size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"processGSRSubMsg - no update entries");
                }
                return true;
            }
            if (!this.isCanceled()) {
                this.updateRegistry.startAlarmTimer();
            }
            if (!this.isCanceled()) {
                InterBridgeCoreGroup.this.storeBridgeUpdateRegistry(this.gsrSubs.getFullyQualifiedServerName(), this.updateRegistry);
            } else {
                this.updateRegistry.cancelAlarm();
            }
            if (!this.isCanceled()) {
                this.processGSRSubMsgSubscriptions(list);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processGSRSubMsg-false");
            }
            return false;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }

    class CachedGSRSubMsg {
        byte[] msg;
        int storedGSRSubMsgRebuildID;
        Collection targetGSRSubMsgGMIDs;

        CachedGSRSubMsg() {
            this.reset();
        }

        CachedGSRSubMsg(byte[] byArray, int n) {
            this.msg = byArray;
            this.storedGSRSubMsgRebuildID = n;
            this.targetGSRSubMsgGMIDs = new HashSet();
        }

        void reset() {
            this.msg = null;
            this.storedGSRSubMsgRebuildID = -1;
            this.targetGSRSubMsgGMIDs = new HashSet();
        }

        public byte[] getMsg() {
            return this.msg;
        }

        public void setMsg(byte[] byArray) {
            this.msg = byArray;
        }

        public int getStoredGSRSubMsgRebuildID() {
            return this.storedGSRSubMsgRebuildID;
        }

        public void setStoredGSRSubMsgRebuildID(int n) {
            this.storedGSRSubMsgRebuildID = n;
        }

        public Collection getTargetGSRSubMsgGMIDs() {
            return this.targetGSRSubMsgGMIDs;
        }

        public void setTargetGSRSubMsgGMIDs(Collection collection) {
            this.targetGSRSubMsgGMIDs = collection;
        }
    }

    final class CachedPost {
        private CGBridgeBBPost cgbPost;
        private GroupMemberId gmidtosend;
        private String fullyQualiedCoreGroupName;
        private boolean isFromLocalCell;
        private String inboundAPG;

        CachedPost(CGBridgeBBPost cGBridgeBBPost, GroupMemberId groupMemberId, String string, boolean bl, String string2) {
            this.cgbPost = cGBridgeBBPost;
            this.gmidtosend = groupMemberId;
            this.fullyQualiedCoreGroupName = string;
            this.isFromLocalCell = bl;
            this.inboundAPG = string2;
        }

        public CGBridgeBBPost getCgbPost() {
            return this.cgbPost;
        }

        public String getInboundAPG() {
            return this.inboundAPG;
        }

        public boolean isFromLocalCell() {
            return this.isFromLocalCell;
        }

        public String getFullyQualiedCoreGroupName() {
            return this.fullyQualiedCoreGroupName;
        }

        public GroupMemberId getGmidtosend() {
            return this.gmidtosend;
        }
    }

    public static interface CoreGroupCustomPropertyNames {
        public static final String IBM_CS_FD_PERIOD_SECS = "IBM_CS_FD_PERIOD_SECS";
        public static final String IBM_CS_FD_CONSECUTIVE_MISSED = "IBM_CS_FD_CONSECUTIVE_MISSED";
        public static final String IBM_CS_MCAST_TTL = "IBM_CS_MCAST_TTL";
        public static final String IBM_CS_CACHE_PERIOD_MILLIS = "IBM_CS_CACHE_PERIOD_MILLIS";
        public static final String IBM_CS_DATASTACK_MEG = "IBM_CS_LS_DATASTACK_MEG";
        public static final String IBM_CS_MAX_TRANSPORT_MEG = "IBM_CS_MAX_TRANSPORT_MEG";
        public static final String IBM_CS_USE_POOLED_MEMORY = "IBM_CS_USE_POOLED_MEMORY";
        public static final String IBM_CS_MESSAGE_SIZE = "IBM_CS_MESSAGE_SIZE";
        public static final String IBM_CS_BRINGUP_TIMES_SECS = "IBM_CS_BRINGUP_TIME_SECS";
        public static final String IBM_CS_COMPLETENESS_VS_SPEED = "IBM_CS_COMPLETENESS_VS_SPEED";
        public static final String IBM_CS_UNICAST_DISCOVERY_INTERVAL_SECS = "IBM_CS_UNICAST_DISCOVERY_INTERVAL_SECS";
        public static final String IBM_CS_FIREWALL_UNICAST_DISCOVERY_INTERVAL_SECS = "IBM_CS_FIREWALL_UNICAST_DISCOVERY_INTERVAL_SECS";
        public static final String IBM_CS_JMX_CMD_TIMEOUT = "IBM_CS_JMX_CMD_TIMEOUT";
        public static final String IBM_CS_DCS_DIAGNOSTICS = "IBM_CS_DCS_DIAGNOSTICS";
        public static final String IBM_CS_THREAD_SCHED_DETECT_PERIOD = "IBM_CS_THREAD_SCHED_DETECT_PERIOD";
        public static final String IBM_CS_THREAD_SCHED_DETECT_ERROR = "IBM_CS_THREAD_SCHED_DETECT_ERROR";
        public static final String IBM_CS_SS_MAX_TOKEN_BYTES = "IBM_CS_SS_MAX_TOKEN_BYTES";
        public static final String IBM_CS_HW_SERVER_POWER_CONTROLLER = "IBM_CS_HW_SERVER_POWER_CONTROLLER";
    }
}

