/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.core.CGBridgeBBPost;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.impl.BridgeViewChangeRegister;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.CachedRemoteSubscription;
import com.ibm.ws.cgbridge.core.impl.IBCGCachedSubscription;
import com.ibm.ws.cgbridge.core.impl.InterBridgeCoreGroup;
import com.ibm.ws.cgbridge.core.impl.LocalBridgeServerUpdateRegistry;
import com.ibm.ws.cgbridge.core.impl.StoredGSRSub;
import com.ibm.ws.cgbridge.core.impl.Work;
import com.ibm.ws.cgbridge.core.impl.WorkType;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.msg.CGBridgeBBMsgHandler;
import com.ibm.ws.cgbridge.msg.CGBridgeBBPostMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeHAStateMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.msg.CGBridgeStateCompleteMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeStatusMsg;
import com.ibm.ws.cgbridge.msg.CoreGroupPostsMsg;
import com.ibm.ws.cgbridge.util.CGBGroupMemberIdLookUpTable;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.cgbridge.util.EnumType;
import com.ibm.ws.cgbridge.util.InterBridgeGroupMemberIdComparator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupCallback;
import com.ibm.wsspi.hamanager.partitionedmanager.MemberStateEnum;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InterCGBridgePMGEvents
implements ManagedGroupCallback {
    static final TraceComponent tc = Tr.register((Class)InterCGBridgePMGEvents.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    static final int POST_RECONCILE_DELAY = 5;
    static final WorkType ON_MESSAGE_WORK = new WorkType("ON_MESSAGE_WORK");
    static final WorkType STABILIZED_PREREQ_WORK = new WorkType("STABILIZED_PREREQ_WORK");
    static final WorkType STABLE_PRIMARY_GROUP_WORK = new WorkType("STABLE_PRIMARY_GROUP_WORK");
    static final WorkType REMOVE_DEAD_SERVERS = new WorkType("REMOVE_DEAD_SERVERS");
    static final WorkType[] PREREQ_STABLE_PRIMARY_GROUP_WORK = new WorkType[]{STABLE_PRIMARY_GROUP_WORK, REMOVE_DEAD_SERVERS};
    WorkType postOnMessageWorkType = new WorkType("POST_ON_MESSAGE_WORK");
    static final WorkType POST_WORK_TYPE_CHAIN = new WorkType("POST_ON_MESSAGE_WORK_CHAIN");
    WorkType[] postPrereqWorkTypes = new WorkType[]{this.postOnMessageWorkType};
    static final EnumType PMG_STATE_MAY_UNSTABILIZE = new EnumType("May Unstabilize", 0);
    static final EnumType PMG_STATE_NEW_SERVERS_ONLINE = new EnumType("New Servers Online", 15);
    static final EnumType PMG_STATE_ELECTED_AS_MANAGER_END = new EnumType("Elected As Manager End", 20);
    static final EnumType PMG_STATE_STABILIZED = new EnumType("Stabilized", 30);
    static final EnumType PMG_STATE_COMPLETE = new EnumType("COMPLETE", 100);
    private GroupMemberId[] gmidsCurrent;
    private GroupMemberId[] gmidsOld;
    private Boolean isManagersChanged;
    InterBridgeCoreGroup icbCoreGroup;
    private int localIndexCurrent;
    boolean bisManager;
    String cellAndCGName;
    private boolean bPrimaryGroup;
    private Map newPeerCGBStateMap;
    private String cellname;
    private String coregroupname;
    private static Set adjacentCoregroups = new HashSet();
    private CGBridgeConfig config;
    EnumType localPMGCallbackState;
    Object localPMGCallbackStateLock = new Object();
    Map bridgeStateIDMap;
    Map storedGSRSubs;
    private Object gmidLock = new Object();
    Set cachedSubscriptions;
    List serverState;
    int rebuildID;
    boolean isBridgeRebuild;
    Set missingCoreGroupState;
    boolean isNewCoreGroupStateReceived;
    private CGBGroupMemberIdLookUpTable gmidLookupTable;
    Map currentNonManagerGMIDNames;
    Set managerNames;
    boolean isManagerRebuildRemoveDeadServers;

    public InterCGBridgePMGEvents(InterBridgeCoreGroup interBridgeCoreGroup, String string, boolean bl) {
        if (!bl) {
            adjacentCoregroups.add(string);
        }
        this.missingCoreGroupState = new HashSet(interBridgeCoreGroup.getAccessPointGroup().getCoreGroups());
        this.isNewCoreGroupStateReceived = false;
        this.isManagerRebuildRemoveDeadServers = false;
        this.managerNames = new HashSet();
        this.currentNonManagerGMIDNames = new HashMap();
        this.isBridgeRebuild = false;
        this.serverState = new LinkedList();
        this.rebuildID = 0;
        this.cachedSubscriptions = new LinkedHashSet();
        this.localPMGCallbackState = PMG_STATE_COMPLETE;
        this.storedGSRSubs = new HashMap();
        this.bridgeStateIDMap = new HashMap();
        this.icbCoreGroup = interBridgeCoreGroup;
        this.cellAndCGName = string;
        this.bPrimaryGroup = bl;
        this.newPeerCGBStateMap = new HashMap();
        this.isManagersChanged = Boolean.FALSE;
        int n = this.cellAndCGName.indexOf(":");
        this.cellname = this.cellAndCGName.substring(0, n);
        this.coregroupname = this.cellAndCGName.substring(n + 1, this.cellAndCGName.length());
        this.config = CGBridgeService.getInstance().getCGBridgeConfig();
        this.gmidLookupTable = new CGBGroupMemberIdLookUpTable("igcgeventsGmidLookup-" + this.cellAndCGName);
        if (this.icbCoreGroup.getCGBridge().getAPGTopology().isInterCellUpdatesForwarded() || this.icbCoreGroup.getCGBridge().getAPGTopology().isIntraCellUpdatesForwarded()) {
            this.postOnMessageWorkType = POST_WORK_TYPE_CHAIN;
            WorkType[] workTypeArray = new WorkType[]{POST_WORK_TYPE_CHAIN};
            this.postPrereqWorkTypes = workTypeArray;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"is chain topology so use a single work type for posts");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("InterCGBridgePMGEvents constructed with coregroup: " + this.coregroupname + " " + bl));
        }
    }

    boolean isActiveBridgeSetChanged(GroupMemberId[] groupMemberIdArray, GroupMemberId[] groupMemberIdArray2) {
        boolean bl;
        block4: {
            block5: {
                block3: {
                    bl = false;
                    if (groupMemberIdArray != null && groupMemberIdArray.length != 0 || groupMemberIdArray2 != null && groupMemberIdArray2.length != 0) break block3;
                    bl = false;
                    break block4;
                }
                if (!(groupMemberIdArray == null && groupMemberIdArray2 != null || groupMemberIdArray != null && groupMemberIdArray2 == null) && groupMemberIdArray.length == groupMemberIdArray2.length) break block5;
                bl = true;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + " different lengths"));
                break block4;
            }
            bl = true;
            for (int i = 0; i < groupMemberIdArray2.length; ++i) {
                boolean bl2 = false;
                for (int j = 0; j < groupMemberIdArray.length; ++j) {
                    if (!groupMemberIdArray2[i].getServerName().equals(groupMemberIdArray[j].getServerName())) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                bl = false;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-couldn't find matching bridge for: " + CGBridgeUtils.getFullServerName(groupMemberIdArray2[i])));
                break;
            }
        }
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-" + this.cellAndCGName + "-isActiveBridgeSetChanged-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSubscriptionProcessingState() {
        boolean bl = false;
        Object object = this.localPMGCallbackStateLock;
        synchronized (object) {
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("localPMGCallbackState=" + this.localPMGCallbackState));
            }
            if (this.localPMGCallbackState.equals(PMG_STATE_COMPLETE) || this.localPMGCallbackState.equals(PMG_STATE_STABILIZED)) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachedSubscription(CachedRemoteSubscription cachedRemoteSubscription) {
        Set set = this.cachedSubscriptions;
        synchronized (set) {
            this.cachedSubscriptions.add(cachedRemoteSubscription);
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-addCachedSubscription-" + this.cellAndCGName + " = " + this.cachedSubscriptions.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckStateAndStoreGSRSub(CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg, GroupMemberId groupMemberId, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCheckStateAndStoreGSRSub", (Object)new Object[]{cGBridgeGSRSubscriptionMsg, groupMemberId, string});
        }
        boolean bl = false;
        Object object = this.localPMGCallbackStateLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("localPMGCallbackState=" + this.localPMGCallbackState));
            }
            if (!this.localPMGCallbackState.equals(PMG_STATE_COMPLETE) && !this.localPMGCallbackState.equals(PMG_STATE_STABILIZED) || !this.icbCoreGroup.isInterAndLocalPMGBridgesMatched()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"unstable local state");
                }
                this.storeGSRSub(cGBridgeGSRSubscriptionMsg, groupMemberId, string);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCheckStateAndStoreGSRSub", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeGSRSub(CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg, GroupMemberId groupMemberId, String string) {
        Map map = this.storedGSRSubs;
        synchronized (map) {
            this.storedGSRSubs.put(cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName(), new StoredGSRSub(this.icbCoreGroup, cGBridgeGSRSubscriptionMsg, groupMemberId, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalPMGCallbackState(EnumType enumType) {
        Object object = this.localPMGCallbackStateLock;
        synchronized (object) {
            this.localPMGCallbackState = enumType;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + " set pmg state to: " + enumType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeBridgeStateID(String string, int n) {
        Map map = this.bridgeStateIDMap;
        synchronized (map) {
            this.bridgeStateIDMap.put(string, new Integer(n));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stored bridge state id " + n + " for " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBridgeStateIDNewer(String string, int n) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isBridgeStateIDNewer-" + string), (Object)new Object[]{new Integer(n)});
        }
        Map map = this.bridgeStateIDMap;
        synchronized (map) {
            Integer n2 = (Integer)this.bridgeStateIDMap.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("storedID=" + n2));
            }
            if (n2 == null || n > n2) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isBridgeStateIDNewer-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBridgeStateIDMap() {
        Map map = this.bridgeStateIDMap;
        synchronized (map) {
            this.bridgeStateIDMap = new HashMap();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"resetBridgeStateIDMap");
        }
    }

    static Set getAdjacentCoregroups() {
        return adjacentCoregroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void electedAsManagerBegin() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-electedAsManagerBegin-" + this.cellAndCGName));
        }
        if (this.bPrimaryGroup) {
            this.isBridgeRebuild = true;
            if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                this.isManagerRebuildRemoveDeadServers = true;
                this.icbCoreGroup.setPMGSubsProcessed(false);
                List list = this.serverState;
                synchronized (list) {
                    this.serverState.clear();
                }
                this.icbCoreGroup.cancelGSRSubProcessors();
                this.resetBridgeStateIDMap();
                this.icbCoreGroup.cancelAllBridgeUpdateRegistries();
                this.icbCoreGroup.getCGBridge().removeStoreGSRSubsMsgs(this.icbCoreGroup);
                this.icbCoreGroup.resetLocalUpdateRegistry();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-electedAsManagerBegin-" + this.cellAndCGName));
        }
    }

    private void checkForCGState(Map map) {
        Iterator iterator = map.keySet().iterator();
        GroupMemberId[] groupMemberIdArray = new GroupMemberId[map.size()];
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            groupMemberIdArray[n] = (GroupMemberId)iterator.next();
            if (this.missingCoreGroupState.size() <= 0 || !this.missingCoreGroupState.contains(string = CGBridgeUtils.getFullCoregroupName(groupMemberIdArray[n]))) continue;
            this.missingCoreGroupState.remove(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("received state from new core group: " + string + " remaining core groups = " + this.missingCoreGroupState));
            }
            this.isNewCoreGroupStateReceived = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processReceivedBridgeState(Map map, boolean bl) {
        Object object;
        Object object2;
        int n;
        GroupMemberId groupMemberId;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-processReceivedBridgeState"), (Object)new Object[]{map, new Boolean(bl)});
        }
        Iterator iterator = map.keySet().iterator();
        if (CGBridgeService.getInstance().getCGBridgeConfig().getLocalBridgeCGBVersion().isOptimizedSubscriptionHandling()) {
            object3 = new GroupMemberId[map.size()];
            groupMemberId = new ArrayList[map.size()];
            n = 0;
            boolean bl2 = true;
            String string = null;
            while (iterator.hasNext()) {
                try {
                    bl2 = true;
                    object3[n] = (GroupMemberId)iterator.next();
                    string = CGBridgeUtils.getFullServerName(object3[n]);
                    object2 = new ByteArrayInputStream((byte[])map.get(object3[n]));
                    object = new ObjectInputStream((InputStream)object2);
                    groupMemberId[n] = (ArrayList)((ObjectInputStream)object).readObject();
                    if (groupMemberId[n].size() > 0) {
                        CGBridgeHAStateMsg cGBridgeHAStateMsg = (CGBridgeHAStateMsg)groupMemberId[n].get(0);
                        if (cGBridgeHAStateMsg.getBridgeVersion() != null) {
                            this.storeBridgeStateID(string, cGBridgeHAStateMsg.getExpectedViewChangeID());
                            if (!cGBridgeHAStateMsg.getBridgeVersion().isOptimizedSubscriptionHandling() || !cGBridgeHAStateMsg.getBridgeVersion().isSeamlessFailoverEnabled()) {
                                bl2 = false;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(string + " has sub handling or seamless failover disabled."));
                                }
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(string + " has null state at entry 0 "));
                            }
                            bl2 = false;
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(CGBridgeUtils.getFullServerName(object3[n]) + " sent no state...list size ==0"));
                        }
                        bl2 = false;
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems processing state: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".processReceivedBridgeState"), (String)"1282", (Object)this);
                }
                if (!bl2) {
                    this.icbCoreGroup.addNonSeamlessBridge(string);
                }
                ++n;
                string = null;
            }
            this.icbCoreGroup.setBridgeVersion();
            if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                GroupMemberId[] groupMemberIdArray;
                int n2;
                Object object4 = this.gmidLock;
                synchronized (object4) {
                    n2 = this.localIndexCurrent;
                    groupMemberIdArray = this.gmidsCurrent;
                }
                for (n = 0; n < ((GroupMemberId[])object3).length; ++n) {
                    object4 = this.serverState;
                    synchronized (object4) {
                        this.serverState.add(new RebuildServerState(object3[n], (ArrayList)groupMemberId[n], groupMemberIdArray, n2, this.icbCoreGroup.getLocalUpdateRegistry()));
                        continue;
                    }
                }
            }
        }
        if (!this.icbCoreGroup.getBridgeVersion().isOptimizedSubscriptionHandling()) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                groupMemberId = (GroupMemberId)iterator.next();
                object3 = CGBridgeUtils.getFullCoregroupName(groupMemberId);
                object = this.gmidLock;
                synchronized (object) {
                    n = this.localIndexCurrent;
                    object2 = this.gmidsCurrent;
                }
                this.icbCoreGroup.mergeServerState(groupMemberId, (byte[])map.get(groupMemberId), n, (GroupMemberId[])object2, bl, (String)object3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-processReceivedBridgeState"));
        }
    }

    private void processMembershipChange(Map map) {
        HashMap hashMap = new HashMap(this.getCurrentNonManagerGMIDNames());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("old list=" + hashMap.keySet()));
            Tr.debug((TraceComponent)tc, (String)("new list=" + map.keySet()));
        }
        hashMap.keySet().removeAll(map.keySet());
        hashMap.keySet().removeAll(this.getManagerNames());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bridges to remove = " + hashMap.keySet()));
        }
        if (hashMap.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"synthesize call to removeDeadServers");
            }
            this.removeDeadServers(hashMap.values().toArray(new GroupMemberId[hashMap.size()]));
        }
        this.setCurrentNonManagerGMIDNames(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void electedAsManagerEnd(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-electedAsManagerEnd-" + this.cellAndCGName));
        }
        this.setLocalPMGCallbackState(PMG_STATE_ELECTED_AS_MANAGER_END);
        if (this.bPrimaryGroup) {
            if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                this.processMembershipChange(this.extractBridgeMap(map));
            }
            if (!this.icbCoreGroup.getBridgeVersion().isOptimizedSubscriptionHandling()) {
                GroupMemberId[] groupMemberIdArray;
                int n;
                Object object = this.gmidLock;
                synchronized (object) {
                    n = this.localIndexCurrent;
                    groupMemberIdArray = this.gmidsCurrent;
                }
                if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
                    this.icbCoreGroup.removeSubscrSubjectPost(n, groupMemberIdArray.length);
                }
            } else {
                this.checkForCGState(map);
            }
            this.icbCoreGroup.resetNonSeamlessBridges();
            this.processReceivedBridgeState(map, true);
            this.bisManager = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-electedAsManagerEnd-" + this.cellAndCGName));
        }
    }

    private CGBridgeHAStateMsg getBridgeInfoMsg() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBridgeInfoMsg");
        }
        try {
            CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData;
            SubjectInfo subjectInfo;
            if (this.icbCoreGroup.isCrossCell()) {
                subjectInfo = this.icbCoreGroup.cgb.createSubjectInfo(this.icbCoreGroup.cgb.createBulletinBoard("CGB"), "cgb.debug.subject", CGBridgeService.DUMMY_REMOTE_SCOPE);
                cGBridgeBulletinBoardScopeData = (CGBridgeBulletinBoardScopeData)CGBridgeService.DUMMY_REMOTE_SCOPE.getData();
            } else {
                subjectInfo = this.icbCoreGroup.cgb.createSubjectInfo(this.icbCoreGroup.cgb.createBulletinBoard("CGB"), "cgb.debug.subject", CGBridgeService.getInstance().getPublicScope());
                cGBridgeBulletinBoardScopeData = (CGBridgeBulletinBoardScopeData)CGBridgeService.getInstance().getPublicScope().getData();
            }
            CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = new CGBridgeBBRemoteSubscriptionMsg(subjectInfo, true, -1, cGBridgeBulletinBoardScopeData, this.cellAndCGName);
            CGBridgeHAStateMsg cGBridgeHAStateMsg = new CGBridgeHAStateMsg(cGBridgeBBRemoteSubscriptionMsg, null, this.icbCoreGroup.getAccessPointGroupName());
            cGBridgeHAStateMsg.setBridgeVersion(CGBridgeService.getInstance().getCGBridgeConfig().getLocalBridgeCGBVersion());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getBridgeInfoMsg", (Object)cGBridgeHAStateMsg);
            }
            return cGBridgeHAStateMsg;
        }
        catch (CGBInternalErrorException cGBInternalErrorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Problems creating dummy subscription: " + cGBInternalErrorException.getMessage()));
            }
            FFDCFilter.processException((Throwable)cGBInternalErrorException, (String)(this.getClass().getName() + ".getBridgeInfoMsg"), (String)"1", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getBridgeInfoMsg-null");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getLocalState(GroupMemberId[] groupMemberIdArray) {
        Object object;
        block31: {
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-getLocalState-" + this.cellAndCGName));
            }
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Object> arrayList = this.gmidLock;
            synchronized (arrayList) {
                int n;
                object2 = new GroupMemberId[groupMemberIdArray.length];
                for (n = 0; n < groupMemberIdArray.length; ++n) {
                    object2[n] = groupMemberIdArray[n];
                }
                Arrays.sort(object2, InterBridgeGroupMemberIdComparator.getInstance());
                if (this.isActiveBridgeSetChanged(this.gmidsCurrent, (GroupMemberId[])object2)) {
                    ++this.rebuildID;
                }
                this.gmidsCurrent = object2;
                for (n = 0; n < this.gmidsCurrent.length; ++n) {
                    if (!this.gmidsCurrent[n].getServerName().equals(this.icbCoreGroup.getLocalServerId().getServerName())) continue;
                    this.localIndexCurrent = n;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Getlocalstate member index: " + n));
                    break;
                }
                if (tc.isDebugEnabled()) {
                    for (n = 0; n < this.gmidsCurrent.length; ++n) {
                        Tr.debug((TraceComponent)tc, (String)("managerlist: " + CGBridgeUtils.getFullServerName(this.gmidsCurrent[n])));
                    }
                }
                object = new LinkedList<GroupMemberId>();
                if (this.gmidsOld != null) {
                    for (int i = 0; i < this.gmidsOld.length; ++i) {
                        bl = true;
                        boolean bl3 = false;
                        for (int j = 0; j < this.gmidsCurrent.length; ++j) {
                            if (!this.gmidsOld[i].getServerName().equals(this.gmidsCurrent[j].getServerName())) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("found priorserver: " + this.gmidsOld[i].getServerName()));
                            }
                            object.add(this.gmidsCurrent[j]);
                            bl3 = true;
                            break;
                        }
                        if (bl3) continue;
                        bl = false;
                        break;
                    }
                }
                if (this.gmidsOld == null || !bl || this.gmidsOld.length != this.gmidsCurrent.length) {
                    bl2 = true;
                }
                this.gmidsOld = this.gmidsCurrent;
            }
            arrayList = new ArrayList<Object>();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Were all old servers found? " + bl + ", isManagersChanged=" + bl2));
            }
            object2 = null;
            object2 = this.getBridgeInfoMsg();
            if (object2 != null) {
                arrayList.add(0, object2);
            }
            if (bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"manager set has changed, resorting");
                }
                this.setIsManagersChanged(true);
                if (!this.bisManager) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Send local bb subscriptions out");
                        Tr.debug((TraceComponent)tc, (String)("cellname taken from longcoregroupname: " + this.cellname + "/" + this.coregroupname));
                    }
                    object = (HashMap)this.icbCoreGroup.getPeerSubscriptionsStored(this.cellname, this.coregroupname, (CGBridgeHAStateMsg)object2);
                    Iterator iterator = ((HashMap)object).keySet().iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)((HashMap)object).get(n);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getLocalState sub: " + cGBridgeBBRemoteSubscriptionMsg));
                        }
                        CGBridgeHAStateMsg cGBridgeHAStateMsg = new CGBridgeHAStateMsg(cGBridgeBBRemoteSubscriptionMsg, this.icbCoreGroup.getLocalServerId(), this.icbCoreGroup.getAccessPointGroupName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("constructed state additional properties " + cGBridgeHAStateMsg.getAccessPointName() + "/" + CGBridgeUtils.getFullServerName(cGBridgeHAStateMsg.getGroupMemberId())));
                        }
                        arrayList.add(cGBridgeHAStateMsg);
                    }
                    if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled() && this.icbCoreGroup.getCGBridge().getBridgeViewChangeRegister() != null) {
                        this.icbCoreGroup.getCGBridge().getBridgeViewChangeRegister().reconcileBridges(this.cellAndCGName, this.gmidsCurrent, ((CGBridgeHAStateMsg)object2).getExpectedViewChangeID());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"manager list is not the same and this bridge is a manager");
                }
            } else {
                this.setIsManagersChanged(false);
            }
            object = new byte[groupMemberIdArray.length][];
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(arrayList);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    object[i] = byArray;
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block31;
                Tr.debug((TraceComponent)tc, (String)("io exception" + iOException.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-getLocalState-" + this.cellAndCGName));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newServersOnline(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-newServersOnline-" + this.cellAndCGName));
        }
        this.setLocalPMGCallbackState(PMG_STATE_NEW_SERVERS_ONLINE);
        if (this.bPrimaryGroup) {
            Map map2 = this.newPeerCGBStateMap;
            synchronized (map2) {
                this.newPeerCGBStateMap.putAll(map);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Storing new server Map for processing later");
            }
            if (this.icbCoreGroup.getBridgeVersion().isOptimizedSubscriptionHandling()) {
                this.checkForCGState(map);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-newServersOnline-" + this.cellAndCGName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStoredMGDGSRSubsMsgs() {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStoredMGDGSRSubsMsgs");
        }
        Object object = this.storedGSRSubs;
        synchronized (object) {
            map = this.storedGSRSubs;
            this.storedGSRSubs = new HashMap();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("gsrSubMsgs.size=" + map.size()));
        }
        if (map.size() > 0) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                object = (StoredGSRSub)iterator.next();
                ((StoredGSRSub)object).process();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStoredMGDGSRSubsMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notElectedAsManager(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-notElectedAsManager-" + this.cellAndCGName));
        }
        this.bisManager = false;
        if (groupMemberIdArray.length == 0) {
            Object object = this.gmidLock;
            synchronized (object) {
                if (this.gmidsOld != null && this.gmidsOld.length > 0) {
                    this.setIsManagersChanged(true);
                }
                this.gmidsOld = groupMemberIdArray;
                if (this.isActiveBridgeSetChanged(this.gmidsCurrent, groupMemberIdArray)) {
                    ++this.rebuildID;
                }
                this.gmidsCurrent = groupMemberIdArray;
            }
            this.icbCoreGroup.removeCoreGroup(this.cellAndCGName);
            this.icbCoreGroup.processRemovedCoreGroup(this.cellAndCGName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No bridges exist for coregroup " + this.cellAndCGName));
            }
            if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                if (this.icbCoreGroup.getCGBridge().getBridgeViewChangeRegister() != null) {
                    this.icbCoreGroup.getCGBridge().getBridgeViewChangeRegister().removeCoreGroup(this.cellAndCGName);
                }
                if ((object = this.icbCoreGroup.getLocalUpdateRegistry()) != null && ((LocalBridgeServerUpdateRegistry)object).isActiveForProcessing() && this.icbCoreGroup.getLocalUpdateRegistry().removeUpdateTrackingForCoreGroup(this.cellAndCGName)) {
                    this.icbCoreGroup.processLastUpdateForLocalUpdateRegistry((LocalBridgeServerUpdateRegistry)object);
                }
            }
            this.icbCoreGroup.updateAvailableCoreGroups(this, this.cellAndCGName, this.gmidsCurrent, false);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-notElectedAsManager-" + this.cellAndCGName));
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-notElectedAsManager-" + CGBridgeUtils.getFullServerName(groupMemberIdArray[i])));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-notElectedAsManager-" + this.cellAndCGName));
        }
    }

    public void removeDeadServers(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-removeDeadServers-" + this.cellAndCGName));
        }
        if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
            return;
        }
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
                CGBridgeService.getInstance().getWorkDispatcher().addWork(new RemoveDeadServersWork(groupMemberIdArray, this.icbCoreGroup.getLocalUpdateRegistry()));
            }
        } else if (groupMemberIdArray != null) {
            int n;
            for (n = 0; n < groupMemberIdArray.length; ++n) {
                this.icbCoreGroup.removeNonSeamlessBridges(CGBridgeUtils.getFullServerName(groupMemberIdArray[n]));
            }
            if (!this.icbCoreGroup.getBridgeVersion().isOptimizedSubscriptionHandling()) {
                this.icbCoreGroup.getCGBridge().unsubscribe(groupMemberIdArray, this.icbCoreGroup);
            } else {
                this.icbCoreGroup.getCGBridge().getSubscriptionTracker().removeSubscriptions(groupMemberIdArray);
                this.icbCoreGroup.removeStoredMessages(groupMemberIdArray);
            }
            if (tc.isDebugEnabled()) {
                for (n = 0; n < groupMemberIdArray.length; ++n) {
                    Tr.debug((TraceComponent)tc, (String)("Removed: " + CGBridgeUtils.getFullServerName(groupMemberIdArray[n])));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-removeDeadServers-" + this.cellAndCGName));
        }
    }

    public void waitingForNewServers() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-waitingForNewServers-" + this.cellAndCGName));
        }
    }

    public boolean isAlive(GroupName groupName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-isAlive" + this.cellAndCGName));
        }
        return true;
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-memberDeactivate-" + this.cellAndCGName));
        }
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-memberIsActivated-" + this.cellAndCGName));
        }
    }

    public void memberMayActivate(GroupName groupName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-memberMayActiveate-" + this.cellAndCGName));
        }
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-memberMayActiveateCancelled-" + this.cellAndCGName));
        }
    }

    private Map extractBridgeMap(GroupMemberId[] groupMemberIdArray) {
        HashMap<String, GroupMemberId> hashMap = new HashMap<String, GroupMemberId>();
        if (groupMemberIdArray == null) {
            return hashMap;
        }
        if (groupMemberIdArray.length > 0) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                hashMap.put(groupMemberIdArray[i].getServerName(), groupMemberIdArray[i]);
            }
        }
        return hashMap;
    }

    private Map extractBridgeMap(Map map) {
        HashMap<String, GroupMemberId> hashMap = new HashMap<String, GroupMemberId>();
        if (map == null) {
            return hashMap;
        }
        if (map.size() > 0) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                GroupMemberId groupMemberId = (GroupMemberId)iterator.next();
                hashMap.put(groupMemberId.getServerName(), groupMemberId);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-membershipChanged-" + this.cellAndCGName));
        }
        for (n = 0; n < groupMemberIdArray.length; ++n) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-membershipchanged: " + CGBridgeUtils.getFullServerName(groupMemberIdArray[n])));
        }
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            if (this.isManagerRebuildRemoveDeadServers) {
                this.isManagerRebuildRemoveDeadServers = false;
                this.processMembershipChange(this.extractBridgeMap(groupMemberIdArray));
            } else {
                this.setCurrentNonManagerGMIDNames(this.extractBridgeMap(groupMemberIdArray));
            }
        }
        if (this.bPrimaryGroup) {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                String string = CGBridgeUtils.getFullCoregroupName(groupMemberIdArray[i]);
                if (!hashMap.containsKey(string)) {
                    object = new ArrayList();
                    ((ArrayList)object).add(groupMemberIdArray[i]);
                    hashMap.put(string, object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("adding member name " + groupMemberIdArray[i].getServerName() + " to: " + string));
                    continue;
                }
                object = (ArrayList)hashMap.get(string);
                ((ArrayList)object).add(groupMemberIdArray[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("existing member, adding member name " + groupMemberIdArray[i].getServerName() + " to: " + string));
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                ArrayList arrayList = (ArrayList)hashMap.get(object);
                GroupMemberId[] groupMemberIdArray2 = new GroupMemberId[arrayList.size()];
                groupMemberIdArray2 = arrayList.toArray(new GroupMemberId[arrayList.size()]);
                this.icbCoreGroup.updateMemberList((String)object, groupMemberIdArray2);
            }
        } else {
            n = 0;
            Boolean bl = this.isManagersChanged;
            synchronized (bl) {
                if (this.isManagersChanged.booleanValue()) {
                    if (!this.icbCoreGroup.getBridgeVersion().isOptimizedSubscriptionHandling()) {
                        n = 1;
                    }
                    this.setIsManagersChanged(false);
                }
            }
            if (n != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"requesting updates for all posts");
                }
                this.icbCoreGroup.reinitializeManagerSubscriptions(this.gmidsCurrent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-membershipChanged-" + this.cellAndCGName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMessageSub(CGBridgeMsg cGBridgeMsg, GroupMemberId groupMemberId, int n) throws Exception {
        CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = (CGBridgeBBRemoteSubscriptionMsg)cGBridgeMsg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sub from core group " + this.cellAndCGName + " and server " + CGBridgeUtils.getFullServerName(groupMemberId) + " for (BB:Subj) " + cGBridgeBBRemoteSubscriptionMsg));
        }
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            Object object = this.gmidLock;
            synchronized (object) {
                if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("subBridgeRebuildID=" + n + ", rebuildID=" + this.rebuildID));
                }
                if (n != this.rebuildID) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"subBridgeRebuildID!=rebuildID");
                    }
                    return false;
                }
            }
            if (!this.icbCoreGroup.isInterAndLocalPMGBridgesMatched() || !this.icbCoreGroup.getLocalPMGEvents().isSubscriptionProcessingState()) {
                this.icbCoreGroup.addCachedSubscription(new IBCGCachedSubscription(cGBridgeBBRemoteSubscriptionMsg, this.icbCoreGroup.getAccessPointGroupName(), groupMemberId, null, null, n, this));
                return false;
            }
        }
        if (!this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled() || this.icbCoreGroup.isMessageForThisBridge(cGBridgeBBRemoteSubscriptionMsg.getSubjectHashCode())) {
            this.icbCoreGroup.handleSubscribe(groupMemberId, cGBridgeBBRemoteSubscriptionMsg, this.cellAndCGName, this.cellname);
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("message not intended for this bridge: (BB:Subj) " + cGBridgeBBRemoteSubscriptionMsg.getBBName() + ":" + cGBridgeBBRemoteSubscriptionMsg.getSubject()));
        }
        return false;
    }

    public void onMessageCoreGroupPost(CGBridgeMsg cGBridgeMsg, GroupMemberId groupMemberId) throws Exception {
        CoreGroupPostsMsg coreGroupPostsMsg = (CoreGroupPostsMsg)cGBridgeMsg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("core group post set from core group " + this.cellAndCGName + " and server " + CGBridgeUtils.getFullServerName(groupMemberId) + " for (BB:Subj) " + coreGroupPostsMsg.getBBName() + ":" + coreGroupPostsMsg.getSubject()));
        }
        if (this.icbCoreGroup.getCGBridge().isMessageForLocalPMG(coreGroupPostsMsg.getSubjectHashCode())) {
            if (coreGroupPostsMsg.getCGBSubjectPosts().size() > 0) {
                SubjectInfo subjectInfo;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("# of core group posts: " + coreGroupPostsMsg.getCGBSubjectPosts().size()));
                }
                Iterator iterator = coreGroupPostsMsg.getCGBSubjectPosts().entrySet().iterator();
                BulletinBoard bulletinBoard = this.icbCoreGroup.getCGBridge().createBulletinBoard(coreGroupPostsMsg.getBBName());
                BulletinBoardScope bulletinBoardScope = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("received from cell -" + coreGroupPostsMsg.getLocalCellName() + "-, local cell -" + this.config.getCellName() + "-"));
                    Tr.debug((TraceComponent)tc, (String)(" scope data=" + coreGroupPostsMsg.getCGBScopeData()));
                }
                try {
                    if (this.config.getCellName().equals(coreGroupPostsMsg.getLocalCellName())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"local cell");
                        }
                        bulletinBoardScope = this.icbCoreGroup.getCGBridge().determineScope(coreGroupPostsMsg.getCGBScopeData());
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"from remote cell");
                        }
                        subjectInfo = new HashMap();
                        subjectInfo.put("cellName", coreGroupPostsMsg.getLocalCellName());
                        bulletinBoardScope = CGBridgeService.getInstance().getRemoteScope((Map)subjectInfo);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("scope=" + bulletinBoardScope));
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("could not obtain scope for cell: " + coreGroupPostsMsg.getLocalCellName() + " " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".onMessageCoreGroupPost"), (String)"5440", (Object)this);
                }
                if (bulletinBoardScope != null) {
                    subjectInfo = this.icbCoreGroup.getCGBridge().createSubjectInfo(bulletinBoard, coreGroupPostsMsg.getSubject(), bulletinBoardScope);
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string = (String)entry.getKey();
                        Set set = (Set)entry.getValue();
                        this.icbCoreGroup.getCGBridge().postLocalCoreGroup(set, groupMemberId, bulletinBoard, subjectInfo, string, bulletinBoardScope);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find a PAP/cell to post CoreGroupPostsMsg data to.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"core group post not intended for this bridge");
        }
    }

    public void onMessagePost(CGBridgeMsg cGBridgeMsg, GroupMemberId groupMemberId) throws Exception {
        CGBridgeBBPostMsg cGBridgeBBPostMsg = (CGBridgeBBPostMsg)cGBridgeMsg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("post from core group " + this.cellAndCGName + " and server " + CGBridgeUtils.getFullServerName(groupMemberId) + " for (BB:Subj) " + cGBridgeBBPostMsg.getBBName() + ":" + cGBridgeBBPostMsg.getSubject() + " isInitial=" + cGBridgeBBPostMsg.isInitialUpdate() + " version=" + cGBridgeBBPostMsg.getMsgVersion() + " cgbpostid=" + cGBridgeBBPostMsg.getCGBPostIdentifier()));
        }
        this.processPost(groupMemberId, cGBridgeBBPostMsg, true);
    }

    void processPost(GroupMemberId groupMemberId, CGBridgeBBPostMsg cGBridgeBBPostMsg, boolean bl) {
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            while (this.icbCoreGroup.getCGBridge().isReconcilingSubjects()) {
                try {
                    Thread.sleep(5L);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"reconciling subjects...delay post processing: 5");
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("problems putting post thread to sleep: " + exception.getMessage()));
                }
            }
        }
        boolean bl2 = this.icbCoreGroup.getCGBridge().isMessageForLocalPMG(cGBridgeBBPostMsg.getSubjectHashCode());
        if (cGBridgeBBPostMsg.getMsgVersion().equals(CGBridgeMsgVersion.VERSION1) || bl2) {
            if (this.icbCoreGroup.getCGBridge().isNewCGBPost(cGBridgeBBPostMsg, groupMemberId) && this.icbCoreGroup.handlePost(groupMemberId, cGBridgeBBPostMsg, this.cellAndCGName)) {
                this.icbCoreGroup.getCGBridge().storeCGBPost(cGBridgeBBPostMsg, groupMemberId);
            }
        } else if (!bl2 && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"post not intended for this bridge");
        }
    }

    public void onMessageGSRSub(CGBridgeMsg cGBridgeMsg, GroupMemberId groupMemberId) throws Exception {
        if (!this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: received CGBGSRSubscriptionMsg when isSeamlessFailoverEnabled==false");
            }
            RuntimeException runtimeException = new RuntimeException("Received CGBGSRSubscriptionMsg when isSeamlessFailoverEnabled==false");
            FFDCFilter.processException((Throwable)runtimeException, (String)(this.getClass().getName() + ".onMessageGSRSub"), (String)"1717", (Object)this);
        } else {
            CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg = (CGBridgeGSRSubscriptionMsg)cGBridgeMsg;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received CGBGSRSubscriptionMsg from server: " + cGBridgeGSRSubscriptionMsg.getFullyQualifiedServerName()));
            }
            EnumType enumType = this.icbCoreGroup.getLocalPMGEvents().getLocalPMGCallbackState();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("pmgState=" + enumType));
            }
            if (this.icbCoreGroup.handleGSRSubscribe(cGBridgeGSRSubscriptionMsg, groupMemberId, this.cellAndCGName)) {
                this.icbCoreGroup.sendStateCompleteMsg(groupMemberId, cGBridgeGSRSubscriptionMsg.getBridgeViewChangeID(), false);
            }
        }
    }

    public void onMessageStateComplete(CGBridgeMsg cGBridgeMsg, GroupMemberId groupMemberId) throws Exception {
        if (!this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: received CGBridgeStateCompleteMsg when isSeamlessFailoverEnabled==false");
            }
        } else {
            BridgeViewChangeRegister bridgeViewChangeRegister;
            CGBridgeStateCompleteMsg cGBridgeStateCompleteMsg = (CGBridgeStateCompleteMsg)cGBridgeMsg;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received CGBridgeStateCompleteMsg from server: " + cGBridgeStateCompleteMsg.getCellQualifiedServername() + "for cg: " + this.cellAndCGName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received CGBridgeStateCompleteMsg from server: " + cGBridgeStateCompleteMsg.getCellQualifiedServername() + "for cg: " + this.cellAndCGName + "isViewChangeComplete=" + cGBridgeStateCompleteMsg.isViewChangeComplete() + " view ID=" + cGBridgeStateCompleteMsg.getBridgeViewChangeID()));
            }
            if ((bridgeViewChangeRegister = this.icbCoreGroup.getCGBridge().getBridgeViewChangeRegister()) != null && !bridgeViewChangeRegister.isTerminated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isTerminated=" + bridgeViewChangeRegister.isTerminated()));
                }
                if (cGBridgeStateCompleteMsg.isViewChangeComplete()) {
                    Map map = cGBridgeStateCompleteMsg.getBridgeStateIDs();
                    int n = 0;
                    if (map != null) {
                        Integer n2 = (Integer)map.get(this.config.getFullServerName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("full server name=" + this.config.getFullServerName() + ", stateID=" + n2 + ", bridgeStateMap=" + map));
                        }
                        if (n2 != null) {
                            n = n2;
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"bridge state map==null");
                    }
                    bridgeViewChangeRegister.stateCompleteReceived(this.cellAndCGName, cGBridgeStateCompleteMsg.getCellQualifiedServername(), n);
                } else {
                    bridgeViewChangeRegister.stateCompleteReceived(this.cellAndCGName, cGBridgeStateCompleteMsg.getCellQualifiedServername(), cGBridgeStateCompleteMsg.getBridgeViewChangeID());
                }
            }
            this.icbCoreGroup.getCGBridge().getSynchronizedCoreGroups().addBridge(this.icbCoreGroup.getAccessPointGroupName(), this.cellAndCGName, groupMemberId);
        }
    }

    public void onMessageCGStatus(CGBridgeMsg cGBridgeMsg, GroupMemberId groupMemberId) throws Exception {
        CGBridgeStatusMsg cGBridgeStatusMsg = (CGBridgeStatusMsg)cGBridgeMsg;
        if (cGBridgeStatusMsg.getState().equals(CGBridgeStatusMsg.STATE_UNAVAILABLE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received STATE_UNAVAILABLE CGBridgeStatusMsg for " + cGBridgeStatusMsg.getFullyQualifiedCGName()));
            }
            this.icbCoreGroup.processRemovedCoreGroup(cGBridgeStatusMsg.getFullyQualifiedCGName());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unhandled status msg: " + cGBridgeStatusMsg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-onMessage-" + this.cellAndCGName));
        }
        GroupMemberId groupMemberId2 = this.gmidLookupTable.lookupGroupMemberId(groupMemberId);
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            try {
                CGBridgeMsg cGBridgeMsg = CGBridgeBBMsgHandler.processCGBridgeMsg(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received message from: " + CGBridgeUtils.getFullServerName(groupMemberId2) + " of type: " + cGBridgeMsg.getMessageType()));
                }
                if (cGBridgeMsg == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Unable to process msg");
                    }
                    return;
                }
                switch (cGBridgeMsg.getMessageType()) {
                    case 1: {
                        OnMessageWork onMessageWork;
                        Object object = this.gmidLock;
                        synchronized (object) {
                            onMessageWork = new OnMessageWork(groupMemberId2, cGBridgeMsg, this.rebuildID, ON_MESSAGE_WORK);
                        }
                        if (!this.icbCoreGroup.storeReceivedSubscription(onMessageWork, groupMemberId2)) {
                            CGBridgeService.getInstance().getWorkDispatcher().addWork(onMessageWork);
                        }
                        break;
                    }
                    case 3: 
                    case 9: {
                        OnMessageWork onMessageWork;
                        Object object = this.gmidLock;
                        synchronized (object) {
                            onMessageWork = new OnMessageWork(groupMemberId2, cGBridgeMsg, this.rebuildID, ON_MESSAGE_WORK);
                        }
                        CGBridgeService.getInstance().getWorkDispatcher().addWork(onMessageWork);
                        break;
                    }
                    case 10: {
                        OnMessageWork onMessageWork;
                        Object object = this.gmidLock;
                        synchronized (object) {
                            onMessageWork = new OnMessageWork(groupMemberId2, cGBridgeMsg, this.rebuildID, ON_MESSAGE_WORK);
                        }
                        CGBridgeService.getInstance().getWorkDispatcher().addWorkWithPrereqwork(onMessageWork, this.postPrereqWorkTypes);
                        break;
                    }
                    case 2: 
                    case 11: {
                        OnMessagePostWork onMessagePostWork;
                        Object object = this.gmidLock;
                        synchronized (object) {
                            onMessagePostWork = new OnMessagePostWork(groupMemberId2, cGBridgeMsg, this.rebuildID, this.postOnMessageWorkType);
                        }
                        CGBridgeService.getInstance().getWorkDispatcher().addWork(onMessagePostWork);
                        break;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"unable to process inbound message, cannot determine message type");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error processing message: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".onMessage"), (String)"1", (Object)this);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received message from: " + CGBridgeUtils.getFullServerName(groupMemberId2)));
            }
            if (!CGBridgeService.getInstance().isServiceRunning()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"onMessage-service stopped");
                }
                return;
            }
            try {
                CGBridgeMsg cGBridgeMsg = CGBridgeBBMsgHandler.processCGBridgeMsg(byArray);
                if (cGBridgeMsg == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Unable to process msg");
                    }
                    return;
                }
                switch (cGBridgeMsg.getMessageType()) {
                    case 1: {
                        this.onMessageSub(cGBridgeMsg, groupMemberId2, 0);
                        break;
                    }
                    case 2: {
                        this.onMessagePost(cGBridgeMsg, groupMemberId2);
                        break;
                    }
                    case 9: {
                        this.onMessageGSRSub(cGBridgeMsg, groupMemberId2);
                        break;
                    }
                    case 10: {
                        this.onMessageStateComplete(cGBridgeMsg, groupMemberId2);
                        break;
                    }
                    case 11: {
                        this.onMessageCoreGroupPost(cGBridgeMsg, groupMemberId2);
                        break;
                    }
                    case 3: {
                        this.onMessageCGStatus(cGBridgeMsg, groupMemberId2);
                        break;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"unable to process inbound message, cannot determine message type");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error processing message: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".onMessage"), (String)"1", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-onMessage-" + this.cellAndCGName));
        }
    }

    public void mayUnstabilize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-mayUnstabilize-" + this.cellAndCGName));
        }
        this.setLocalPMGCallbackState(PMG_STATE_MAY_UNSTABILIZE);
        if (this.bPrimaryGroup) {
            this.icbCoreGroup.setStablePrimaryGroup(false);
            if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
                this.icbCoreGroup.setCachedMsgsSent(false);
                this.icbCoreGroup.setCachedPostsSent(false);
                this.icbCoreGroup.setCachedSubscriptionsSent(false);
            }
        }
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            this.isNewCoreGroupStateReceived = false;
        }
        this.icbCoreGroup.updateAvailableCoreGroups(this, this.cellAndCGName, this.gmidsCurrent, false);
        this.icbCoreGroup.getCGBridge().getSynchronizedCoreGroups().removeCoreGroup(this.icbCoreGroup.getAccessPointGroupName(), this.cellAndCGName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-mayUnstabilize-" + this.cellAndCGName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stabilized(MemberStateEnum memberStateEnum) {
        this.setLocalPMGCallbackState(PMG_STATE_STABILIZED);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-stabilized-" + this.cellAndCGName));
        }
        if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled()) {
            if (this.bPrimaryGroup) {
                LinkedList linkedList;
                this.icbCoreGroup.updateInterAndLocalPMGBridgesMatched(this.icbCoreGroup.getCGBridge().getIntraCellManagers());
                HashMap hashMap = null;
                boolean bl = false;
                Object object = this.newPeerCGBStateMap;
                synchronized (object) {
                    if (!this.newPeerCGBStateMap.isEmpty()) {
                        hashMap = new HashMap(this.newPeerCGBStateMap);
                        this.newPeerCGBStateMap.clear();
                    }
                }
                if (hashMap != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Processing new server Map...size=" + hashMap.size()));
                    }
                    if (this.isBridgeRebuild) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"new bridges online...manager change");
                        }
                        this.handleNewServersOnline(hashMap);
                    } else if (this.isNewCoreGroupStateReceived) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"process state received from a core group that just joined this bridges view");
                        }
                        this.handleNewServersOnline(hashMap);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"new bridges online...no manager change");
                        }
                        bl = true;
                    }
                }
                object = new StabilizedPrereqWork();
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(object);
                if (this.icbCoreGroup.getBridgeVersion().isSeamlessFailoverEnabled() && this.icbCoreGroup.isInterAndLocalPMGBridgesMatched()) {
                    this.icbCoreGroup.processCachedNotifySubscriptions(hashSet);
                }
                Object object2 = this.serverState;
                synchronized (object2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("rebuild state size=" + this.serverState.size()));
                    }
                    linkedList = new LinkedList(this.serverState);
                    this.serverState.clear();
                }
                Object object3 = this.gmidLock;
                synchronized (object3) {
                    object2 = new StablePrimaryGroupWork(linkedList, this.rebuildID, this.isBridgeRebuild, this.icbCoreGroup.getLocalUpdateRegistry(), hashMap, bl, this.isNewCoreGroupStateReceived);
                }
                ((Work)object2).setPrereqWork(hashSet);
                CGBridgeService.getInstance().getWorkDispatcher().addWorkWithPrereqwork((Work)object2, PREREQ_STABLE_PRIMARY_GROUP_WORK);
                this.icbCoreGroup.setStablePrimaryGroup(true);
                ((Work)object).setWorkComplete();
            }
        } else if (this.bPrimaryGroup) {
            HashMap hashMap = null;
            Map map = this.newPeerCGBStateMap;
            synchronized (map) {
                if (!this.newPeerCGBStateMap.isEmpty()) {
                    hashMap = new HashMap(this.newPeerCGBStateMap);
                    this.newPeerCGBStateMap.clear();
                }
            }
            if (hashMap != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing new server Map...size=" + hashMap.size()));
                }
                this.handleNewServersOnline(hashMap);
            }
            this.icbCoreGroup.setStablePrimaryGroup(true);
            this.icbCoreGroup.doStablePrimaryGroupWork(true);
        }
        this.isBridgeRebuild = false;
        this.icbCoreGroup.updateAvailableCoreGroups(this, this.cellAndCGName, this.gmidsCurrent, this.gmidsCurrent != null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-stabilized-" + this.cellAndCGName));
        }
    }

    void handleNewServersOnline(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-handleNewServersOnline"));
        }
        this.processReceivedBridgeState(map, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-handleNewServersOnline"));
        }
    }

    public void forcedToLeaveHAGroup(String string, String string2, Throwable throwable) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.icbCoreGroup.getAccessPointGroupName() + "-forcedToLeaveHAGroup"), (Object)new Object[]{string, string2, throwable});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMessageForThisBridge(int n) {
        Object object = this.gmidLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("gmidsCurrent length=" + this.gmidsCurrent.length));
            }
            return this.localIndexCurrent == CGBridgeUtils.determineMembertoSend(n, this.gmidsCurrent.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSenderActive(GroupMemberId groupMemberId) {
        Object object = this.gmidLock;
        synchronized (object) {
            if (this.gmidsCurrent == null || this.gmidsCurrent.length == 0 || groupMemberId == null) {
                return false;
            }
            for (int i = 0; i < this.gmidsCurrent.length; ++i) {
                if (!this.gmidsCurrent[i].getServerName().equals(groupMemberId.getServerName())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupMemberId[] getGmidsCurrent() {
        Object object = this.gmidLock;
        synchronized (object) {
            return this.gmidsCurrent;
        }
    }

    String getCellAndCGName() {
        return this.cellAndCGName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsManagersChanged(boolean bl) {
        Boolean bl2 = this.isManagersChanged;
        synchronized (bl2) {
            this.isManagersChanged = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public EnumType getLocalPMGCallbackState() {
        return this.localPMGCallbackState;
    }

    public Map getBridgeStateIDMap() {
        return this.bridgeStateIDMap;
    }

    void removeLocalUpdateRegistryState(Set set, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeLocalUpdateRegistryState");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing following cg from local update registry: " + string));
            }
            if (localBridgeServerUpdateRegistry.isActiveForProcessing()) {
                if (!localBridgeServerUpdateRegistry.removeUpdateTrackingForCoreGroup(string)) continue;
                this.icbCoreGroup.processLastUpdateForLocalUpdateRegistry(localBridgeServerUpdateRegistry);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("localUpdateRegistry no longer active for processing: " + localBridgeServerUpdateRegistry.getBridgeViewChangeID()));
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeLocalUpdateRegistryState");
        }
    }

    private Map getCurrentNonManagerGMIDNames() {
        return this.currentNonManagerGMIDNames;
    }

    private void setCurrentNonManagerGMIDNames(Map map) {
        this.currentNonManagerGMIDNames = map;
    }

    Set getManagerNames() {
        return this.managerNames;
    }

    void setManagerNames(Set set) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("managerNames=" + set));
        }
        this.managerNames = set;
    }

    class StabilizedPrereqWork
    extends Work {
        public StabilizedPrereqWork() throws IllegalArgumentException {
            super(1, false, STABILIZED_PREREQ_WORK);
        }

        public void doWork() {
        }
    }

    class RemoveDeadServersWork
    extends Work {
        GroupMemberId[] groupMembers;
        LocalBridgeServerUpdateRegistry localUpdateRegistry;

        public RemoveDeadServersWork(GroupMemberId[] groupMemberIdArray, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) throws IllegalArgumentException {
            super(10, true, REMOVE_DEAD_SERVERS);
            this.groupMembers = groupMemberIdArray;
            this.localUpdateRegistry = localBridgeServerUpdateRegistry;
        }

        public void doWork() {
            int n;
            for (n = 0; n < this.groupMembers.length; ++n) {
                InterCGBridgePMGEvents.this.icbCoreGroup.removeNonSeamlessBridges(CGBridgeUtils.getFullServerName(this.groupMembers[n]));
            }
            if (!InterCGBridgePMGEvents.this.icbCoreGroup.getBridgeVersion().isOptimizedSubscriptionHandling()) {
                InterCGBridgePMGEvents.this.icbCoreGroup.getCGBridge().unsubscribe(this.groupMembers, InterCGBridgePMGEvents.this.icbCoreGroup);
            } else {
                if (this.localUpdateRegistry != null && this.localUpdateRegistry.isActiveForProcessing()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (n = 0; n < this.groupMembers.length; ++n) {
                        hashSet.add(CGBridgeUtils.getFullCoregroupName(this.groupMembers[n]));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Removing cgs: " + hashSet));
                    }
                    InterCGBridgePMGEvents.this.removeLocalUpdateRegistryState(hashSet, this.localUpdateRegistry);
                }
                InterCGBridgePMGEvents.this.icbCoreGroup.getCGBridge().getSubscriptionTracker().removeSubscriptions(this.groupMembers);
                InterCGBridgePMGEvents.this.icbCoreGroup.removeStoredMessages(this.groupMembers);
            }
            if (tc.isDebugEnabled()) {
                for (n = 0; n < this.groupMembers.length; ++n) {
                    Tr.debug((TraceComponent)tc, (String)("Removed: " + CGBridgeUtils.getFullServerName(this.groupMembers[n])));
                }
            }
        }
    }

    class StablePrimaryGroupWork
    extends Work {
        List rebuildServerState;
        boolean isBridgeRebuildOccurred;
        LocalBridgeServerUpdateRegistry localUpdateRegistry;
        Map newServersOnlineState;
        boolean isRemoveCGState;
        int workRebuildID;
        boolean isNewCoreGroupState;

        public StablePrimaryGroupWork(List list, int n, boolean bl, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry, Map map, boolean bl2, boolean bl3) throws IllegalArgumentException {
            super(7, true, STABLE_PRIMARY_GROUP_WORK);
            this.rebuildServerState = list;
            this.workRebuildID = n;
            this.isBridgeRebuildOccurred = bl;
            this.localUpdateRegistry = localBridgeServerUpdateRegistry;
            this.newServersOnlineState = map;
            this.isRemoveCGState = bl2;
            this.isNewCoreGroupState = bl3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWork() {
            RebuildServerState rebuildServerState;
            Iterator<Object> iterator = InterCGBridgePMGEvents.this.gmidLock;
            synchronized (iterator) {
                if (this.workRebuildID != InterCGBridgePMGEvents.this.rebuildID) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("workRebuildID=" + this.workRebuildID + ", rebuildID=" + InterCGBridgePMGEvents.this.rebuildID));
                    }
                    return;
                }
            }
            if (this.isRemoveCGState && this.newServersOnlineState != null && this.localUpdateRegistry.isActiveForProcessing()) {
                iterator = this.newServersOnlineState.keySet().iterator();
                HashSet<String> hashSet = new HashSet<String>();
                while (iterator.hasNext()) {
                    rebuildServerState = (GroupMemberId)iterator.next();
                    hashSet.add(CGBridgeUtils.getFullCoregroupName((GroupMemberId)rebuildServerState));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("newserversonline: Removing following cgs: " + hashSet));
                }
                InterCGBridgePMGEvents.this.removeLocalUpdateRegistryState(hashSet, this.localUpdateRegistry);
            }
            if (this.isBridgeRebuildOccurred || this.isNewCoreGroupState) {
                iterator = this.rebuildServerState.iterator();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"start storing subs in subscription cache");
                }
                while (iterator.hasNext()) {
                    rebuildServerState = (RebuildServerState)iterator.next();
                    rebuildServerState.processState();
                }
                InterCGBridgePMGEvents.this.icbCoreGroup.getCGBridge().addStoredLocalUpdateRegistry(this.localUpdateRegistry);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"finish storing subs in subscription cache");
                }
            }
            InterCGBridgePMGEvents.this.icbCoreGroup.doStablePrimaryGroupWork(true);
        }
    }

    class RebuildServerState {
        GroupMemberId sendingBridge;
        ArrayList serverState;
        GroupMemberId[] currentGmids;
        int localBridgeIndex;
        LocalBridgeServerUpdateRegistry localReg;

        public RebuildServerState(GroupMemberId groupMemberId, ArrayList arrayList, GroupMemberId[] groupMemberIdArray, int n, LocalBridgeServerUpdateRegistry localBridgeServerUpdateRegistry) {
            this.sendingBridge = groupMemberId;
            this.serverState = arrayList;
            this.currentGmids = groupMemberIdArray;
            this.localBridgeIndex = n;
            this.localReg = localBridgeServerUpdateRegistry;
        }

        public void processState() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"processState RebuildServerState");
            }
            InterCGBridgePMGEvents.this.icbCoreGroup.mergeServerStateSubCache(this.sendingBridge, this.serverState, this.localBridgeIndex, this.currentGmids, this.localReg.getSubscriptionCache(), true, this.localReg);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processState RebuildServerState");
            }
        }
    }

    class OnMessagePostWork
    extends OnMessageWork {
        CGBridgeBBPost cgbPost;

        public OnMessagePostWork(GroupMemberId groupMemberId, CGBridgeMsg cGBridgeMsg, int n, WorkType workType) throws IllegalArgumentException {
            super(groupMemberId, cGBridgeMsg, n, workType);
            this.isPrereqByHashCode = true;
            this.cgbPost = (CGBridgeBBPost)((Object)cGBridgeMsg);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OnMessagePostWork)) {
                return false;
            }
            return object.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return this.cgbPost.getSubjectHashCode();
        }
    }

    class OnMessageWork
    extends Work {
        private GroupMemberId sender;
        CGBridgeMsg cgbridgeBaseMsg;
        int storedBridgeRebuildID;

        public OnMessageWork(GroupMemberId groupMemberId, CGBridgeMsg cGBridgeMsg, int n, WorkType workType) throws IllegalArgumentException {
            super(1, false, workType);
            this.sender = groupMemberId;
            this.cgbridgeBaseMsg = cGBridgeMsg;
            this.storedBridgeRebuildID = n;
        }

        public void doWork() {
            if (!CGBridgeService.getInstance().isServiceRunning()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"onMessage-service stopped");
                }
                return;
            }
            if (!InterCGBridgePMGEvents.this.isSenderActive(this.sender)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sending server not active: " + CGBridgeUtils.getFullServerName(this.sender)));
                }
                return;
            }
            try {
                switch (this.cgbridgeBaseMsg.getMessageType()) {
                    case 1: {
                        InterCGBridgePMGEvents.this.onMessageSub(this.cgbridgeBaseMsg, this.sender, this.storedBridgeRebuildID);
                        break;
                    }
                    case 2: {
                        InterCGBridgePMGEvents.this.onMessagePost(this.cgbridgeBaseMsg, this.sender);
                        break;
                    }
                    case 9: {
                        InterCGBridgePMGEvents.this.onMessageGSRSub(this.cgbridgeBaseMsg, this.sender);
                        break;
                    }
                    case 10: {
                        InterCGBridgePMGEvents.this.onMessageStateComplete(this.cgbridgeBaseMsg, this.sender);
                        break;
                    }
                    case 11: {
                        InterCGBridgePMGEvents.this.onMessageCoreGroupPost(this.cgbridgeBaseMsg, this.sender);
                        break;
                    }
                    case 3: {
                        InterCGBridgePMGEvents.this.onMessageCGStatus(this.cgbridgeBaseMsg, this.sender);
                        break;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"unable to process inbound message, cannot determine message type");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error processing message: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".doWork()"), (String)"1", (Object)this);
            }
        }
    }
}

