/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.BridgeServerUpdateRegistryCallback;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.impl.InterBridgeCoreGroup;
import com.ibm.ws.cgbridge.core.impl.SubscriptionCache;
import com.ibm.ws.cgbridge.msg.CGBridgeRemoteData;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LocalBridgeServerUpdateRegistry {
    private static final TraceComponent tc = Tr.register((Class)LocalBridgeServerUpdateRegistry.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    String fullyQualifiedServerName;
    Map expectedUpdates;
    int bridgeViewChangeID;
    long waitTime;
    BridgeServerUpdateRegistryCallback callback;
    boolean isActiveForProcessing;
    String originCG;
    String apgName;
    SubscriptionCache subscriptionCache;
    InterBridgeCoreGroup icbCoreGroup;
    boolean isReadyToProcessUpdates;
    boolean isLastSubscriptonProcessed;
    boolean isStateCompleteMsgSent;

    public LocalBridgeServerUpdateRegistry(String string, int n, long l, BridgeServerUpdateRegistryCallback bridgeServerUpdateRegistryCallback, String string2, InterBridgeCoreGroup interBridgeCoreGroup) {
        this.fullyQualifiedServerName = string;
        this.expectedUpdates = new HashMap();
        this.bridgeViewChangeID = n;
        this.waitTime = l;
        this.callback = bridgeServerUpdateRegistryCallback;
        this.isActiveForProcessing = true;
        this.isReadyToProcessUpdates = false;
        this.isLastSubscriptonProcessed = false;
        this.isStateCompleteMsgSent = false;
        this.originCG = string2;
        this.icbCoreGroup = interBridgeCoreGroup;
        this.apgName = interBridgeCoreGroup.getAccessPointGroupName();
        this.subscriptionCache = new SubscriptionCache(interBridgeCoreGroup.getAccessPointGroupName(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean bl) {
        Map map = this.expectedUpdates;
        synchronized (map) {
            this.isActiveForProcessing = bl;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isActiveForProcessing=" + this.isActiveForProcessing));
            }
        }
    }

    public boolean processSubCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processSubCache");
        }
        boolean bl = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bridgeViewChangeID=" + this.bridgeViewChangeID + ", currentIBCGID=" + this.icbCoreGroup.getLocalUpdateRegistry().getBridgeViewChangeID()));
        }
        if (this.bridgeViewChangeID == this.icbCoreGroup.getLocalUpdateRegistry().getBridgeViewChangeID()) {
            if (this.icbCoreGroup.isInterAndLocalPMGBridgesMatched()) {
                if (this.subscriptionCache.getStoredUnsubscribeSubjects().size() > 0) {
                    this.icbCoreGroup.processReceivedUnsubscribes(this.subscriptionCache, this);
                }
                if (this.subscriptionCache.getStoredSubjects().size() > 0) {
                    this.icbCoreGroup.processReceivedSubscribes(this.subscriptionCache, this);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No updates to wait for");
                    }
                    this.setLastSubscriptonProcessed(true);
                    this.icbCoreGroup.processLastUpdateForLocalUpdateRegistry(this);
                }
                this.icbCoreGroup.setPMGSubsProcessed(true);
                this.icbCoreGroup.addStoredSubscriptionsToWorkQueue();
            } else {
                bl = false;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"does not match current ID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processSubCache-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForUpdateTrackingLocal(CGBridgeRemoteData cGBridgeRemoteData, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerForUpdateTrackingLocal-" + this.apgName), (Object)new Object[]{cGBridgeBulletinBoardScopeData, string});
        }
        Map map = this.expectedUpdates;
        synchronized (map) {
            if (this.isActiveForProcessing) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("local scopeData.getCellName()=" + cGBridgeBulletinBoardScopeData.getCellName()));
                }
                Integer n = CGBridgeUtils.getCellScopedLookUpKey(cGBridgeRemoteData, cGBridgeBulletinBoardScopeData);
                this.addKey(string, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.apgName + " now waiting for trace from the following key: " + n));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("registerForUpdateTrackingLocal-" + this.apgName));
        }
    }

    private void addKey(String string, Object object) {
        HashSet<Object> hashSet = (HashSet<Object>)this.expectedUpdates.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            this.expectedUpdates.put(string, hashSet);
        }
        hashSet.add(object);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(hashSet.size() + " local update elements exist for cg: " + string + " and apg " + this.apgName));
        }
    }

    private boolean removeKey(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeKey-" + object));
        }
        Set set = (Set)this.expectedUpdates.get(string);
        boolean bl = false;
        if (set != null) {
            bl = set.remove(object);
            if (set.size() == 0) {
                this.expectedUpdates.remove(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("0 local update elements remain for cg: " + string + " and apg " + this.apgName + ".  Remaining core groups are: " + this.expectedUpdates.keySet()));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(set.size() + " local update elements remain for cg: " + string + " and apg " + this.apgName));
                if (set.size() < 6) {
                    Tr.debug((TraceComponent)tc, (String)("cgSet=" + set));
                } else {
                    Tr.debug((TraceComponent)tc, (String)("cgSet subset (5)=" + CGBridgeUtils.getSubset(set, 5)));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeKey-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateReceivedLocal(CGBridgeRemoteData cGBridgeRemoteData, byte by, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateReceivedLocal-" + this.apgName), (Object)new Object[]{new Byte(by), string});
        }
        Map map = this.expectedUpdates;
        synchronized (map) {
            boolean bl = false;
            if (this.isActiveForProcessing && this.isReadyToProcessUpdates) {
                this.removeKey(string2, CGBridgeUtils.getLookUpKey(cGBridgeRemoteData, by, string));
                bl = this.isComplete();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("not ready: active =" + this.isActiveForProcessing + "initialized=" + this.isReadyToProcessUpdates));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("updateReceivedLocal-" + this.apgName + "-" + bl));
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUpdateTrackingForCoreGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeUpdateTrackingForCoreGroup-" + this.apgName), (Object)string);
        }
        boolean bl = false;
        Map map = this.expectedUpdates;
        synchronized (map) {
            Set set;
            if (this.isActiveForProcessing && (set = (Set)this.expectedUpdates.remove(string)) != null) {
                bl = this.isComplete();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeUpdateTrackingForCoreGroup-" + this.apgName + "-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUpdateTrackingLocal(CGBridgeRemoteData cGBridgeRemoteData, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeUpdateTrackingLocal-" + this.apgName), (Object)new Object[]{cGBridgeBulletinBoardScopeData, string});
        }
        Map map = this.expectedUpdates;
        synchronized (map) {
            if (this.isActiveForProcessing) {
                if (tc.isDebugEnabled() && cGBridgeBulletinBoardScopeData.getCellName() != null) {
                    Tr.debug((TraceComponent)tc, (String)("local scopeData.getCellName()=" + cGBridgeBulletinBoardScopeData.getCellName()));
                }
                Integer n = CGBridgeUtils.getCellScopedLookUpKey(cGBridgeRemoteData, cGBridgeBulletinBoardScopeData);
                this.removeKey(string, n);
                bl = this.isComplete();
            } else {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeUpdateTrackingLocal-" + this.apgName + "-" + bl));
        }
        return bl;
    }

    private boolean isComplete() {
        boolean bl = false;
        if (this.expectedUpdates.size() == 0) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isComplete-" + this.apgName + "-" + bl));
        }
        return bl;
    }

    public int getBridgeViewChangeID() {
        return this.bridgeViewChangeID;
    }

    public String getFullyQualifiedServerName() {
        return this.fullyQualifiedServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveForProcessing() {
        Map map = this.expectedUpdates;
        synchronized (map) {
            return this.isActiveForProcessing;
        }
    }

    public Map getExpectedUpdates() {
        return this.expectedUpdates;
    }

    public String getOriginCG() {
        return this.originCG;
    }

    SubscriptionCache getSubscriptionCache() {
        return this.subscriptionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadyToProcessUpdates() {
        Map map = this.expectedUpdates;
        synchronized (map) {
            return this.isReadyToProcessUpdates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadyToProcessUpdates(boolean bl) {
        Map map = this.expectedUpdates;
        synchronized (map) {
            this.isReadyToProcessUpdates = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastSubscriptonProcessed() {
        Map map = this.expectedUpdates;
        synchronized (map) {
            return this.isLastSubscriptonProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLastSubscriptonProcessed(boolean bl) {
        Map map = this.expectedUpdates;
        synchronized (map) {
            this.isLastSubscriptonProcessed = bl;
            return this.isComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isStateCompleteMsgSent() {
        Map map = this.expectedUpdates;
        synchronized (map) {
            return this.isStateCompleteMsgSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateCompleteMsgSent(boolean bl) {
        Map map = this.expectedUpdates;
        synchronized (map) {
            this.isStateCompleteMsgSent = bl;
        }
    }
}

