/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.impl.CGBSubjectPost;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.InterBridgeCoreGroup;
import com.ibm.ws.cgbridge.msg.CGBridgeBBMsgHandler;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CoreGroupPostsMsg;
import com.ibm.ws.cgbridge.util.CGBGroupMemberIdLookUpTable;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.cgbridge.util.CoreGroup;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

final class SubjectPostCache {
    private static final TraceComponent tc = Tr.register((Class)SubjectPostCache.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    Map cgToSubjectPostMap;
    Map cgMap;
    String debugSubject;
    String debugBB;
    private CGBGroupMemberIdLookUpTable gmidLookupTable = new CGBGroupMemberIdLookUpTable("SubjectPostCache");
    CGBridgeConfig config;
    CGBridge cgbridge;

    SubjectPostCache(CGBridgeConfig cGBridgeConfig, CGBridge cGBridge) {
        this.config = cGBridgeConfig;
        this.cgbridge = cGBridge;
        this.cgToSubjectPostMap = new HashMap();
        this.cgMap = new HashMap();
        this.debugBB = cGBridgeConfig.getDebugBB();
        this.debugSubject = cGBridgeConfig.getDebugSubject();
    }

    public void addCoreGroupMember(GroupMemberId groupMemberId, String string) {
        GroupMemberId groupMemberId2 = this.gmidLookupTable.lookupGroupMemberId(groupMemberId);
        CoreGroup coreGroup = (CoreGroup)this.cgMap.get(string);
        if (coreGroup == null) {
            coreGroup = new CoreGroup(groupMemberId2, string);
            this.cgMap.put(string, coreGroup);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("New core group added: " + coreGroup));
            }
        } else if (coreGroup.add(groupMemberId2) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New core group member added: " + coreGroup));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string, CGBSubjectPost cGBSubjectPost, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put");
        }
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            HashMap<String, CGBSubjectPost> hashMap;
            HashMap hashMap2;
            Object v = this.cgToSubjectPostMap.get(string2);
            if (v == null) {
                hashMap2 = new HashMap();
                this.cgToSubjectPostMap.put(string2, hashMap2);
            } else {
                hashMap2 = (HashMap)v;
            }
            v = hashMap2.get(subjectInfo);
            if (v == null) {
                hashMap = new HashMap<String, CGBSubjectPost>();
                hashMap2.put(subjectInfo, hashMap);
            } else {
                hashMap = (HashMap<String, CGBSubjectPost>)v;
            }
            hashMap.put(string, cGBSubjectPost);
            this.printSubjPostCache();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSubjectPosts(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeSubjectPosts", (Object)new Object[]{new Integer(n), new Integer(n2)});
        }
        if (n2 > 1) {
            Map map = this.cgToSubjectPostMap;
            synchronized (map) {
                Iterator iterator = this.cgToSubjectPostMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    Map.Entry entry = iterator.next();
                    Object v = entry.getValue();
                    String string = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("fullCoreGroupName=" + string));
                    }
                    if (v == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SubjectPostCache contains SubjectInfoMap for coregroup: " + string));
                    }
                    Map map2 = (Map)v;
                    Iterator iterator2 = map2.keySet().iterator();
                    LinkedList<SubjectInfo> linkedList = new LinkedList<SubjectInfo>();
                    while (iterator2.hasNext()) {
                        SubjectInfo subjectInfo = (SubjectInfo)iterator2.next();
                        int n3 = CGBridgeMsg.generateHashCode(CGBridgeBBMsgHandler.createSubjectKey(subjectInfo.getBoardName(), subjectInfo.getSubjectName()));
                        int n4 = CGBridgeUtils.determineMembertoSend(n3, n2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Determining if " + subjectInfo + " hashes"));
                        }
                        if (n4 == n) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Does not hash to specified bridge; removing corresponding SubjectPost's");
                        }
                        object2 = (Map)map2.get(subjectInfo);
                        linkedList.add(subjectInfo);
                        if (object2 == null) continue;
                        object = object2.entrySet().iterator();
                        while (object.hasNext()) {
                            Map.Entry entry2 = (Map.Entry)object.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("closing post for " + entry2.getKey() + " for subjectInfo " + subjectInfo));
                            }
                            this.closeSubjectPost((CGBSubjectPost)entry2.getValue(), (String)entry2.getKey());
                        }
                    }
                    object2 = linkedList.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Removing subjectInfo: " + object + " from " + string));
                        }
                        map2.remove(object);
                    }
                }
                this.printSubjPostCache();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"number of managers <=1, so there's not need to execute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeSubjectPosts");
        }
    }

    private void closeSubjectPost(CGBSubjectPost cGBSubjectPost, String string) {
        block3: {
            try {
                cGBSubjectPost.getSubjectPost().close();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closed cgbSP for server: " + string));
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Problems closing post: " + exception.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CGBSubjectPost get(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get");
        }
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Map map2;
            CGBSubjectPost cGBSubjectPost = null;
            Object v = this.cgToSubjectPostMap.get(string2);
            if (v != null && (v = (map2 = (Map)v).get(subjectInfo)) != null) {
                map2 = (Map)v;
                if ((v = map2.get(string)) != null) {
                    cGBSubjectPost = (CGBSubjectPost)v;
                    cGBSubjectPost.setStale(false);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"get");
                }
                return cGBSubjectPost;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get - null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove");
        }
        boolean bl = false;
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Map map2;
            CGBSubjectPost cGBSubjectPost = null;
            Object v = this.cgToSubjectPostMap.get(string2);
            if (v != null && (v = (map2 = (Map)v).get(subjectInfo)) != null && (v = (map2 = (Map)v).remove(string)) != null) {
                cGBSubjectPost = (CGBSubjectPost)v;
                this.closeSubjectPost(cGBSubjectPost, string);
                bl = true;
                this.printSubjPostCache();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("remove-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStale(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setStale for cg: " + string));
        }
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Map map2;
            CGBSubjectPost cGBSubjectPost = null;
            Object v = this.cgToSubjectPostMap.get(string);
            if (v != null && (v = (map2 = (Map)v).get(subjectInfo)) != null) {
                Map map3 = (Map)v;
                Iterator iterator = map3.values().iterator();
                while (iterator.hasNext()) {
                    cGBSubjectPost = (CGBSubjectPost)iterator.next();
                    if (cGBSubjectPost == null) continue;
                    cGBSubjectPost.setStale(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeStale(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string) {
        boolean bl = false;
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            CGBSubjectPost cGBSubjectPost = null;
            Object v = this.cgToSubjectPostMap.get(string);
            if (v != null) {
                Map map2 = (Map)v;
                if ((v = map2.get(subjectInfo)) != null) {
                    Map map3 = (Map)v;
                    Iterator iterator = map3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        cGBSubjectPost = (CGBSubjectPost)entry.getValue();
                        String string2 = (String)entry.getKey();
                        if (!cGBSubjectPost.isStale()) continue;
                        this.closeSubjectPost(cGBSubjectPost, string2);
                        iterator.remove();
                        bl = true;
                    }
                } else if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"subject info not in post cache");
                }
                this.printSubjPostCache();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeStale-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendAllLocalPosts(SubjectInfo subjectInfo, Set set, String string, InterBridgeCoreGroup interBridgeCoreGroup) {
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendAllLocalPosts", (Object)new Object[]{subjectInfo, set, string});
        }
        boolean bl = false;
        int n = 0;
        int n2 = this.cgbridge.getMaxCoreGroupPostMsgSize();
        CoreGroupPostsMsg coreGroupPostsMsg = null;
        boolean bl2 = false;
        String string2 = CGBridgeUtils.getCellName(string);
        if (string2.equals(this.config.getCellName())) {
            bl2 = true;
        }
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Iterator iterator = this.cgToSubjectPostMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                if (!set.contains(string3)) {
                    Object v = entry.getValue();
                    if (v != null) {
                        Map map2 = (Map)v;
                        if ((v = map2.get(subjectInfo)) != null) {
                            String string4 = CGBridgeUtils.getCellName(string3);
                            Collection collection = ((Map)v).values();
                            Iterator iterator2 = collection.iterator();
                            while (iterator2.hasNext()) {
                                CGBSubjectPost cGBSubjectPost = (CGBSubjectPost)iterator2.next();
                                if (coreGroupPostsMsg == null) {
                                    coreGroupPostsMsg = this.createCGPostMsg(subjectInfo, string4, bl2);
                                    n = 0;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("fullCoreGroupName=" + string3 + ", totalSize=" + n + ", limit=" + n2 + ", post.getPostSize()=" + cGBSubjectPost.getPostSize()));
                                }
                                if (!string4.equals(coreGroupPostsMsg.getPostCellName()) || n > 0 && n + cGBSubjectPost.getPostSize() > n2) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"sending maxed out posts");
                                    }
                                    if (interBridgeCoreGroup.sendCoreGroupPostsMsg(coreGroupPostsMsg, string)) {
                                        bl = true;
                                    }
                                    coreGroupPostsMsg = this.createCGPostMsg(subjectInfo, string4, bl2);
                                    n = 0;
                                }
                                coreGroupPostsMsg.addCGBSubjectPost(string3, cGBSubjectPost);
                                n += cGBSubjectPost.getPostSize();
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("no subjectPosts for " + subjectInfo + " and the core group: " + string3));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("no Map for core group: " + string3));
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("excluding cg " + string3));
            }
            if (coreGroupPostsMsg != null && coreGroupPostsMsg.getCGBSubjectPosts().size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sending remaining posts");
                }
                if (interBridgeCoreGroup.sendCoreGroupPostsMsg(coreGroupPostsMsg, string)) {
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendAllLocalPosts");
        }
        return bl;
    }

    private CoreGroupPostsMsg createCGPostMsg(SubjectInfo subjectInfo, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCGPostMsg", (Object)new Object[]{subjectInfo, string, new Boolean(bl)});
        }
        CoreGroupPostsMsg coreGroupPostsMsg = new CoreGroupPostsMsg(subjectInfo.getBoardName(), subjectInfo.getSubjectName(), (CGBridgeBulletinBoardScopeData)subjectInfo.getScope().getData());
        coreGroupPostsMsg.setPostCellName(string);
        coreGroupPostsMsg.setSubInfo(subjectInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cg post msg postCellName=" + string));
        }
        if (bl) {
            String string2 = (String)this.cgbridge.getCGBridgeService().getCellNameToPAPNameMap().get(string);
            coreGroupPostsMsg.setPAPForPostCellName(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cg post msg papName=" + string2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCGPostMsg");
        }
        return coreGroupPostsMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove-siAndcg", (Object)new Object[]{subjectInfo, string});
        }
        boolean bl = false;
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Map map2;
            CGBSubjectPost cGBSubjectPost = null;
            Object v = this.cgToSubjectPostMap.get(string);
            if (v != null && (v = (map2 = (Map)v).remove(subjectInfo)) != null) {
                Map map3 = (Map)v;
                Iterator iterator = map3.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    cGBSubjectPost = (CGBSubjectPost)entry.getValue();
                    String string2 = (String)entry.getKey();
                    if (cGBSubjectPost == null) continue;
                    this.closeSubjectPost(cGBSubjectPost, string2);
                    bl = true;
                }
                this.printSubjPostCache();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("remove-siAndcg-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SubjectInfo subjectInfo) {
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("remove-si-" + subjectInfo));
        }
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            CGBSubjectPost cGBSubjectPost = null;
            Iterator iterator = this.cgToSubjectPostMap.values().iterator();
            while (iterator.hasNext()) {
                Map map2;
                Object v = iterator.next();
                if (v == null || (v = (map2 = (Map)v).remove(subjectInfo)) == null) continue;
                Map map3 = (Map)v;
                Iterator iterator2 = map3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    cGBSubjectPost = (CGBSubjectPost)entry.getValue();
                    String string = (String)entry.getKey();
                    if (cGBSubjectPost == null) continue;
                    this.closeSubjectPost(cGBSubjectPost, string);
                    if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("closed subject post for si: " + subjectInfo + ", server: " + map3));
                }
            }
            this.printSubjPostCache();
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove-si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getPostingCoreGroups(SubjectInfo subjectInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPostingCoreGroups-" + subjectInfo));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Iterator iterator = this.cgToSubjectPostMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map2;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map3 = (Map)entry.getValue();
                if (map3 == null || (map2 = (Map)map3.get(subjectInfo)) == null || map2.size() <= 0) continue;
                hashSet.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPostingCoreGroups-" + hashSet));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsSubject(String string, SubjectInfo subjectInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"containsSubject", (Object)new Object[]{string, subjectInfo});
        }
        boolean bl = false;
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Map map2;
            Map map3;
            Object v = this.cgToSubjectPostMap.get(string);
            if (v != null && (map3 = (Map)(map2 = (Map)v).get(subjectInfo)) != null && map3.size() > 0) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("containsSubject-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCoreGroupServers(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove-cg");
        }
        boolean bl = false;
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Object v = this.cgToSubjectPostMap.remove(string);
            if (v != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removing all SubjectPosts for " + string));
                }
                Map map2 = (Map)v;
                Iterator iterator = map2.values().iterator();
                while (iterator.hasNext()) {
                    Map map3 = (Map)iterator.next();
                    Iterator iterator2 = map3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        bl = true;
                        Map.Entry entry = iterator2.next();
                        CGBSubjectPost cGBSubjectPost = (CGBSubjectPost)entry.getValue();
                        String string2 = (String)entry.getKey();
                        this.closeSubjectPost(cGBSubjectPost, string2);
                        iterator2.remove();
                    }
                }
                this.printSubjPostCache();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("remove-cg-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(GroupMemberId[] groupMemberIdArray, InterBridgeCoreGroup interBridgeCoreGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove - GroupMemberId []");
        }
        if (groupMemberIdArray != null) {
            Map map = this.cgToSubjectPostMap;
            synchronized (map) {
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    CoreGroup coreGroup;
                    boolean bl = true;
                    String string = CGBridgeUtils.getFullCoregroupName(groupMemberIdArray[i]);
                    GroupMemberId[] groupMemberIdArray2 = (GroupMemberId[])interBridgeCoreGroup.getRemoteCellCoreGroupMembers().get(string);
                    if (groupMemberIdArray2 == null || groupMemberIdArray2.length == 0) {
                        bl = false;
                    }
                    if ((coreGroup = (CoreGroup)this.cgMap.get(string)) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Removing " + groupMemberIdArray[i].getServerName() + " from " + coreGroup));
                    }
                    coreGroup.remove(groupMemberIdArray[i]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Remaining coregroup members =: " + coreGroup));
                    }
                    if (coreGroup.isEmpty() && !bl) {
                        this.removeCoreGroupServers(string);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"cg not empty, so no posts to remove");
                }
                this.printSubjPostCache();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"members==null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove-GroupMemberId []");
        }
    }

    private void printSubjPostCache() {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostCacheEnabled()) {
            Object object;
            int n = 0;
            Iterator iterator = this.cgToSubjectPostMap.entrySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map = (Map)entry.getValue();
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    Map map2 = (Map)entry2.getValue();
                    n += map2.size();
                    Iterator iterator3 = map2.values().iterator();
                    while (iterator3.hasNext()) {
                        object = (CGBSubjectPost)iterator3.next();
                        n2 += ((CGBSubjectPost)object).getPostSize();
                    }
                }
            }
            Tr.debug((TraceComponent)tc, (String)("SubjectPostCache contains " + n + " SubjectPosts and total post size of " + n2));
            iterator = this.cgMap.values().iterator();
            while (iterator.hasNext()) {
                object = (CoreGroup)((Object)iterator.next());
                Tr.debug((TraceComponent)tc, (String)((CoreGroup)object).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubjectPostCacheSize() {
        int n = 0;
        int n2 = 0;
        Map map = this.cgToSubjectPostMap;
        synchronized (map) {
            Iterator iterator = this.cgToSubjectPostMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map2 = (Map)entry.getValue();
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    Map map3 = (Map)entry2.getValue();
                    n += map3.size();
                    Iterator iterator3 = map3.values().iterator();
                    while (iterator3.hasNext()) {
                        CGBSubjectPost cGBSubjectPost = (CGBSubjectPost)iterator3.next();
                        n2 += cGBSubjectPost.getPostSize();
                    }
                }
            }
        }
        return n2;
    }
}

