/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBBEventsHandler;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.InitialSubjectSubscriptionEventCallback;
import com.ibm.ws.cgbridge.core.impl.SubscribeStatus;
import com.ibm.ws.cgbridge.util.CGBGroupMemberIdLookUpTable;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectProxySubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionProxyEvents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class SubscriptionTracker {
    static final TraceComponent tc = Tr.register((Class)SubscriptionTracker.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private Map outstandingSubscriptions;
    private Map updatedCallbacks;
    private GroupMemberIDSubscriptions subscriptionsPerBridge;
    private CGBGroupMemberIdLookUpTable gmidLookupTable = new CGBGroupMemberIdLookUpTable("SubscriptionTracker");

    SubscriptionTracker(CGBridgeConfig cGBridgeConfig, CGBridge cGBridge) {
        this.outstandingSubscriptions = new HashMap();
        this.subscriptionsPerBridge = new GroupMemberIDSubscriptions("normal");
        this.updatedCallbacks = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubjectSubscription subscribeInitial(BulletinBoard bulletinBoard, SubjectInfo subjectInfo, SubjectSubscriptionProxyEvents subjectSubscriptionProxyEvents, GroupMemberId groupMemberId) throws Exception {
        SubjectProxySubscription subjectProxySubscription = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"subscribeInitial");
        }
        GroupMemberId groupMemberId2 = this.gmidLookupTable.lookupGroupMemberId(groupMemberId);
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Subscription subscription = (Subscription)this.outstandingSubscriptions.get(subjectInfo);
            if (subscription != null && !subscription.containsInitialSubscription(groupMemberId2)) {
                subjectProxySubscription = bulletinBoard.subscribeProxy(subjectInfo, subjectSubscriptionProxyEvents);
                subscription.addInitialSubscription(groupMemberId2, (SubjectSubscription)subjectProxySubscription);
                this.printInitialSubscriptions();
            }
            return subjectProxySubscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribeStatus subscribe(BulletinBoard bulletinBoard, SubjectInfo subjectInfo, SubjectSubscriptionProxyEvents subjectSubscriptionProxyEvents, GroupMemberId groupMemberId, String string) throws Exception {
        SubscribeStatus subscribeStatus;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("subjectInfo=" + subjectInfo.toString()));
        }
        GroupMemberId groupMemberId2 = this.gmidLookupTable.lookupGroupMemberId(groupMemberId);
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Object v = this.outstandingSubscriptions.get(subjectInfo);
            if (v != null) {
                SubjectSubscription subjectSubscription;
                Subscription subscription;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"subscription already exists...will addListener for subscribing coregroup");
                }
                subscribeStatus = this.addListener(subscription = (Subscription)v, groupMemberId2, subjectSubscription = subscription.getSubjectSubscription(), string) ? SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID : SubscribeStatus.SUBSCRIPTION_ALREADY_EXISTS_FOR_GMID_ON_COREGROUP;
            } else {
                SubjectProxySubscription subjectProxySubscription = bulletinBoard.subscribeProxy(subjectInfo, subjectSubscriptionProxyEvents);
                this.outstandingSubscriptions.put(subjectInfo, new Subscription((SubjectSubscription)subjectProxySubscription, string, groupMemberId2));
                subscribeStatus = SubscribeStatus.FIRST_SUBSCRIPTION;
                this.subscriptionsPerBridge.associateSubWithBridge(groupMemberId2, (SubjectSubscription)subjectProxySubscription, string);
            }
            this.printSubscriptions();
        }
        return subscribeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUpdatedCallbackFired(SubjectInfo subjectInfo) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isUpdatedCallbackFired-" + subjectInfo));
        }
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = (InitialSubjectSubscriptionEventCallback)this.updatedCallbacks.get(subjectInfo);
            if (initialSubjectSubscriptionEventCallback != null && initialSubjectSubscriptionEventCallback.isInitialUpdateCalled()) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isUpdatedCallbackFired-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribeStatus subscribeWithPerformance(BulletinBoard bulletinBoard, SubjectInfo subjectInfo, CGBridgeBBEventsHandler cGBridgeBBEventsHandler, GroupMemberId groupMemberId, String string, String string2, boolean bl) throws Exception {
        SubscribeStatus subscribeStatus;
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"subscribeWithPerformance", (Object)new Object[]{subjectInfo, CGBridgeUtils.getFullServerName(groupMemberId), string, string2});
        }
        GroupMemberId groupMemberId2 = this.gmidLookupTable.lookupGroupMemberId(groupMemberId);
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Object v = this.outstandingSubscriptions.get(subjectInfo);
            if (v != null) {
                SubjectProxySubscription subjectProxySubscription;
                Subscription subscription;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"subscription already exists...will addListener for subscribing coregroup");
                }
                if (this.addListener(subscription = (Subscription)v, groupMemberId2, (SubjectSubscription)(subjectProxySubscription = subscription.getSubjectProxySubscription()), string) || bl) {
                    InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = (InitialSubjectSubscriptionEventCallback)this.updatedCallbacks.get(subjectInfo);
                    if (initialSubjectSubscriptionEventCallback.isInitialUpdateCalled()) {
                        subscribeStatus = new SubscribeStatus(SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID_NEED_CURRENT_STATE, subjectProxySubscription);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Waiting for updated callback for: " + subjectInfo));
                        }
                        subscribeStatus = SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID_WAIT_FOR_UPDATED_CALLBACK;
                    }
                    subscription.resetUpdateFlag(string);
                } else {
                    subscribeStatus = SubscribeStatus.SUBSCRIPTION_ALREADY_EXISTS_FOR_GMID_ON_COREGROUP;
                }
            } else {
                InitialSubjectSubscriptionEventCallback initialSubjectSubscriptionEventCallback = new InitialSubjectSubscriptionEventCallback(string2, string, this.gmidLookupTable.lookupGroupMemberId(groupMemberId), cGBridgeBBEventsHandler, true);
                this.updatedCallbacks.put(subjectInfo, initialSubjectSubscriptionEventCallback);
                SubjectProxySubscription subjectProxySubscription = bulletinBoard.subscribeProxy(subjectInfo, (SubjectSubscriptionProxyEvents)initialSubjectSubscriptionEventCallback);
                this.outstandingSubscriptions.put(subjectInfo, new Subscription((SubjectSubscription)subjectProxySubscription, string, groupMemberId2));
                this.subscriptionsPerBridge.associateSubWithBridge(groupMemberId2, (SubjectSubscription)subjectProxySubscription, string);
                subscribeStatus = SubscribeStatus.FIRST_SUBSCRIPTION;
            }
            this.printSubscriptions();
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"subscribeWithPerformance", (Object)subscribeStatus);
        }
        return subscribeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscriptions(GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSubscriptions");
        }
        if (groupMemberIdArray != null) {
            Map map = this.outstandingSubscriptions;
            synchronized (map) {
                for (int i = 0; i < groupMemberIdArray.length; ++i) {
                    Map map2 = this.subscriptionsPerBridge.remove(groupMemberIdArray[i]);
                    if (map2 == null) continue;
                    Iterator iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string = (String)entry.getKey();
                        Map map3 = (Map)entry.getValue();
                        if (string == null || map3 == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("cgName=" + string));
                        }
                        HashSet hashSet = new HashSet(map3.values());
                        Iterator iterator2 = hashSet.iterator();
                        while (iterator2.hasNext()) {
                            SubjectSubscription subjectSubscription = (SubjectSubscription)iterator2.next();
                            try {
                                this.removeSubscription(subjectSubscription.getSubject(), groupMemberIdArray[i], true, string);
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Problems closing subscription " + exception.getMessage()));
                            }
                        }
                        this.printSubscriptions();
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"members==null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getSubscriptions(GroupMemberId groupMemberId, String string) {
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            this.printSubscriptions();
            return this.subscriptionsPerBridge.get(this.gmidLookupTable.lookupGroupMemberId(groupMemberId), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeListener(SubjectInfo subjectInfo, GroupMemberId groupMemberId, String string) {
        boolean bl = this.removeSubscription(subjectInfo, groupMemberId, false, string);
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            this.printSubscriptions();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSubscription(SubjectInfo subjectInfo, GroupMemberId groupMemberId, boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSubscription", (Object)new Object[]{subjectInfo, groupMemberId});
        }
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Subscription subscription = (Subscription)this.outstandingSubscriptions.get(subjectInfo);
            if (subscription != null && groupMemberId != null) {
                if (!bl) {
                    this.subscriptionsPerBridge.remove(groupMemberId, subscription.getSubjectSubscription(), string);
                }
                subscription.closeInitialSubscription(groupMemberId);
                boolean bl2 = subscription.removeListener(groupMemberId, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isRemoved=" + bl2));
                }
                if (bl2) {
                    if (subscription.getSubscribingCoreGroupsMap().size() == 0) {
                        try {
                            this.unsubscribe(subjectInfo, true);
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Problems closing subscription " + subscription.getSubjectSubscription().toString()));
                            }
                            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".removeSubscription"), (String)"303", (Object)this);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"removeSubscription", (Object)Boolean.TRUE);
                    }
                    return true;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to remove listener");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeSubscription", (Object)Boolean.FALSE);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubjectSubscription getSubscription(SubjectInfo subjectInfo) {
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Subscription subscription = (Subscription)this.outstandingSubscriptions.get(subjectInfo);
            if (subscription != null) {
                return subscription.getSubjectSubscription();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsSubscription(GroupMemberId groupMemberId, SubjectInfo subjectInfo, String string) {
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Subscription subscription;
            Object v = this.outstandingSubscriptions.get(subjectInfo);
            return v != null && (subscription = (Subscription)v).containsListener(string, groupMemberId) == SubscribeStatus.SUBSCRIPTION_ALREADY_EXISTS_FOR_GMID_ON_COREGROUP;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUpdateSent(SubjectInfo subjectInfo, String string, GroupMemberId groupMemberId) {
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Object v = this.outstandingSubscriptions.get(subjectInfo);
            boolean bl = false;
            if (v != null) {
                Subscription subscription = (Subscription)v;
                bl = subscription.isUpdateSent(string, groupMemberId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isUpdateSent:" + string));
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUpdateSent(SubjectInfo subjectInfo, String string) {
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Object v = this.outstandingSubscriptions.get(subjectInfo);
            if (v != null) {
                Subscription subscription = (Subscription)v;
                subscription.setUpdateSent(string);
            }
        }
    }

    private boolean addListener(Subscription subscription, GroupMemberId groupMemberId, SubjectSubscription subjectSubscription, String string) {
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addListener");
        }
        boolean bl = false;
        GroupMemberId groupMemberId2 = this.gmidLookupTable.lookupGroupMemberId(groupMemberId);
        if (subscription != null) {
            SubscribeStatus subscribeStatus = subscription.containsListener(string, groupMemberId2);
            if (subscribeStatus == SubscribeStatus.SUBSCRIPTION_ALREADY_EXISTS_FOR_GMID_ON_COREGROUP) {
                if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(groupMemberId2.getServerName() + " is already a listener for coregroup: " + string));
                }
            } else {
                GroupMemberId groupMemberId3 = subscription.getSubscribingBridge(string, groupMemberId2);
                if (groupMemberId3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remove sub from owning bridge: " + groupMemberId3));
                    }
                    this.subscriptionsPerBridge.remove(groupMemberId3, subjectSubscription, string);
                }
                this.subscriptionsPerBridge.associateSubWithBridge(groupMemberId2, subjectSubscription, string);
                subscription.setOwningBridge(string, groupMemberId2);
                bl = true;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"s SHOULD NOT be null here...there's a problem!");
            }
            throw new IllegalStateException("Subscription s should not be null");
        }
        if (tc.isEntryEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addListener", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void printInitialSubscriptions() {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            if (this.outstandingSubscriptions.isEmpty()) {
                Tr.debug((TraceComponent)tc, (String)"No initial subscriptions is empty");
            } else {
                Iterator iterator = this.outstandingSubscriptions.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Subscription subscription = (Subscription)iterator.next();
                    if (subscription == null) continue;
                    n += subscription.getNumberInitialSubscriptions();
                }
                Tr.debug((TraceComponent)tc, (String)("initial subscriptions=" + n));
            }
        }
    }

    private void printSubscriptions() {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isSubscriptionsEnabled()) {
            if (this.outstandingSubscriptions.isEmpty()) {
                Tr.debug((TraceComponent)tc, (String)"outstandingSubscriptions is empty");
            } else {
                Tr.debug((TraceComponent)tc, (String)("outstandingSubscriptions list size=" + this.outstandingSubscriptions.size()));
                this.subscriptionsPerBridge.printSubscriptions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribeInitial(SubjectSubscription subjectSubscription, GroupMemberId groupMemberId) throws SubjectSubscriptionClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsubscribeInitial", (Object)new Object[]{subjectSubscription, groupMemberId});
        }
        if (subjectSubscription != null) {
            Map map = this.outstandingSubscriptions;
            synchronized (map) {
                try {
                    Subscription subscription = (Subscription)this.outstandingSubscriptions.get(subjectSubscription.getSubject());
                    if (subscription != null) {
                        if (subscription.removeInitialSubscription(groupMemberId) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"initial subscription removed");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"initial subscription not removed");
                        }
                    }
                    subjectSubscription.close();
                }
                catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isInitialUpdate subscription is already closed");
                    }
                    throw subjectSubscriptionClosedException;
                }
                this.printInitialSubscriptions();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsubscribeInitial");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOutstandingSubscriptionsKeys() {
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            return new HashSet(this.outstandingSubscriptions.keySet());
        }
    }

    boolean getPutReturnValue(Object object) {
        return object == null;
    }

    boolean getRemoveReturnValue(Object object) {
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCoreGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeCoreGroup", (Object)new Object[]{string});
        }
        boolean bl = false;
        Map map = this.outstandingSubscriptions;
        synchronized (map) {
            Iterator iterator = this.outstandingSubscriptions.values().iterator();
            while (iterator.hasNext()) {
                Subscription subscription = (Subscription)iterator.next();
                if (!subscription.removeCoreGroup(string)) continue;
                bl = true;
                if (subscription.getSubscribingCoreGroupsMap().size() != 0) continue;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("will remove subject: " + subscription.getSubjectSubscription()));
                    }
                    iterator.remove();
                    this.closeSubscription(subscription, subscription.getSubjectSubscription().getSubject());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problems closing subscription: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".removeCoreGroup"), (String)"476", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeCoreGroup-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(SubjectInfo subjectInfo, boolean bl) {
        if (tc.isEntryEnabled() && bl) {
            Tr.entry((TraceComponent)tc, (String)("unsubscribe-" + subjectInfo));
        }
        boolean bl2 = false;
        if (subjectInfo != null) {
            Map map = this.outstandingSubscriptions;
            synchronized (map) {
                block12: {
                    try {
                        Subscription subscription = (Subscription)this.outstandingSubscriptions.remove(subjectInfo);
                        if (subscription == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"subscription not in Map!");
                            }
                        } else {
                            bl2 = this.closeSubscription(subscription, subjectInfo);
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)("subscription is already closed: " + exception.getMessage()));
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"si==null");
        }
        if (tc.isEntryEnabled() && bl) {
            Tr.exit((TraceComponent)tc, (String)("unsubscribe-" + bl2));
        }
        return bl2;
    }

    boolean closeSubscription(Subscription subscription, SubjectInfo subjectInfo) throws Exception {
        boolean bl = false;
        SubjectSubscription subjectSubscription = subscription.getSubjectSubscription();
        if (subjectSubscription != null) {
            this.subscriptionsPerBridge.remove(subjectInfo);
            subjectSubscription.close();
            subscription.closeInitialSubscriptions();
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("closeSubscription-" + bl));
        }
        return bl;
    }

    final class GroupMemberIDSubscriptions {
        Map groupMemberSubscriptionMap;
        private String name;

        public GroupMemberIDSubscriptions(String string) {
            this.name = string;
            this.groupMemberSubscriptionMap = new HashMap();
        }

        boolean associateSubWithBridge(GroupMemberId groupMemberId, SubjectSubscription subjectSubscription, String string) {
            HashMap<SubjectInfo, SubjectSubscription> hashMap;
            HashMap hashMap2 = (HashMap)this.groupMemberSubscriptionMap.get(groupMemberId);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this.groupMemberSubscriptionMap.put(groupMemberId, hashMap2);
            }
            if ((hashMap = (HashMap<SubjectInfo, SubjectSubscription>)hashMap2.get(string)) == null) {
                hashMap = new HashMap<SubjectInfo, SubjectSubscription>();
                hashMap2.put(string, hashMap);
            }
            SubjectSubscription subjectSubscription2 = null;
            try {
                subjectSubscription2 = hashMap.put(subjectSubscription.getSubject(), subjectSubscription);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("problem access subjectInfo: " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".associateSubWithBridge"), (String)"555", (Object)this);
            }
            return SubscriptionTracker.this.getPutReturnValue(subjectSubscription2);
        }

        boolean remove(GroupMemberId groupMemberId, SubjectSubscription subjectSubscription, String string) {
            Map map;
            Map map2 = (Map)this.groupMemberSubscriptionMap.get(groupMemberId);
            if (map2 != null && (map = (Map)map2.get(string)) != null) {
                try {
                    return SubscriptionTracker.this.getRemoveReturnValue(map.remove(subjectSubscription.getSubject()));
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problem accessing subjectInfo: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".remove"), (String)"556", (Object)this);
                }
            }
            return false;
        }

        boolean contains(GroupMemberId groupMemberId, SubjectSubscription subjectSubscription, String string) {
            Map map;
            Map map2 = (Map)this.groupMemberSubscriptionMap.get(groupMemberId);
            if (map2 != null && (map = (Map)map2.get(string)) != null) {
                try {
                    return map.containsKey(subjectSubscription.getSubject());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("problem accessing subjectInfo: " + exception.getMessage()));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".contains"), (String)"557", (Object)this);
                }
            }
            return false;
        }

        void remove(SubjectInfo subjectInfo) {
            Iterator iterator = this.groupMemberSubscriptionMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                Iterator iterator2 = map.values().iterator();
                while (iterator2.hasNext()) {
                    Map map2 = (Map)iterator2.next();
                    map2.remove(subjectInfo);
                }
            }
        }

        Map remove(GroupMemberId groupMemberId) {
            return (Map)this.groupMemberSubscriptionMap.remove(groupMemberId);
        }

        Set get(GroupMemberId groupMemberId, String string) {
            Map map;
            Map map2 = (Map)this.groupMemberSubscriptionMap.get(groupMemberId);
            if (map2 != null && (map = (Map)map2.get(string)) != null) {
                return new HashSet(map.values());
            }
            return null;
        }

        void printSubscriptions() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("gmid printSubscriptions - " + this.name));
                Iterator iterator = this.groupMemberSubscriptionMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int n = 0;
                    GroupMemberId groupMemberId = (GroupMemberId)iterator.next();
                    Map map = (Map)this.groupMemberSubscriptionMap.get(groupMemberId);
                    Iterator iterator2 = map.values().iterator();
                    while (iterator2.hasNext()) {
                        Map map2 = (Map)iterator2.next();
                        n += map2.size();
                    }
                    Tr.debug((TraceComponent)tc, (String)(CGBridgeUtils.getFullServerName(groupMemberId) + " has " + n + " subscriptions."));
                }
            }
        }
    }

    final class Subscription {
        private SubjectSubscription ss;
        Map coregroupToGMIDMap;
        Map updateSentMap;
        Map initialSubscriptions;

        Subscription(SubjectSubscription subjectSubscription) {
            this.ss = subjectSubscription;
            this.coregroupToGMIDMap = new HashMap();
            this.initialSubscriptions = new HashMap();
            this.updateSentMap = new HashMap();
        }

        Subscription(SubjectSubscription subjectSubscription, String string, GroupMemberId groupMemberId) {
            this.ss = subjectSubscription;
            this.coregroupToGMIDMap = new HashMap();
            this.initialSubscriptions = new HashMap();
            this.updateSentMap = new HashMap();
            this.setOwningBridge(string, groupMemberId);
        }

        void resetUpdateFlag(String string) {
            this.updateSentMap.remove(string);
        }

        void setUpdateSent(String string) {
            this.updateSentMap.put(string, Boolean.TRUE);
        }

        boolean isUpdateSent(String string, GroupMemberId groupMemberId) {
            GroupMemberId groupMemberId2 = (GroupMemberId)this.coregroupToGMIDMap.get(string);
            if (groupMemberId2 != null && groupMemberId.getServerName().equals(groupMemberId2.getServerName())) {
                return this.updateSentMap.containsKey(string);
            }
            return true;
        }

        Object setOwningBridge(String string, GroupMemberId groupMemberId) {
            return this.coregroupToGMIDMap.put(string, groupMemberId);
        }

        Map getSubscribingCoreGroupsMap() {
            return this.coregroupToGMIDMap;
        }

        boolean removeCoreGroup(String string) {
            return SubscriptionTracker.this.getRemoveReturnValue(this.coregroupToGMIDMap.remove(string));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.ss.getSubject());
                stringBuffer.append("   Coregroups=");
                Iterator iterator = this.coregroupToGMIDMap.keySet().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next()).append(",");
                }
                stringBuffer.append("   initialSubscriptions count=").append(this.initialSubscriptions.size());
            }
            catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                stringBuffer.append("Error in SubscriptionTracker.Subscription getting subject");
            }
            return stringBuffer.toString();
        }

        Object addInitialSubscription(GroupMemberId groupMemberId, SubjectSubscription subjectSubscription) {
            return this.initialSubscriptions.put(groupMemberId, subjectSubscription);
        }

        boolean containsInitialSubscription(GroupMemberId groupMemberId) {
            return this.initialSubscriptions.containsKey(groupMemberId);
        }

        SubjectSubscription removeInitialSubscription(GroupMemberId groupMemberId) {
            return (SubjectSubscription)this.initialSubscriptions.remove(groupMemberId);
        }

        void closeInitialSubscription(GroupMemberId groupMemberId) {
            block3: {
                try {
                    SubjectSubscription subjectSubscription = this.removeInitialSubscription(groupMemberId);
                    if (subjectSubscription != null) {
                        subjectSubscription.close();
                    }
                }
                catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"cis: initial subscription is already closed for");
                }
            }
        }

        void closeInitialSubscriptions() {
            Iterator iterator = this.initialSubscriptions.values().iterator();
            while (iterator.hasNext()) {
                SubjectSubscription subjectSubscription = (SubjectSubscription)iterator.next();
                try {
                    if (subjectSubscription == null) continue;
                    subjectSubscription.close();
                }
                catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"ciss: initial subscription is already closed");
                }
            }
            this.initialSubscriptions.clear();
        }

        int getNumberInitialSubscriptions() {
            return this.initialSubscriptions.size();
        }

        SubscribeStatus containsListener(String string, GroupMemberId groupMemberId) {
            Object v = this.coregroupToGMIDMap.get(string);
            if (v != null) {
                if (v.equals(groupMemberId)) {
                    return SubscribeStatus.SUBSCRIPTION_ALREADY_EXISTS_FOR_GMID_ON_COREGROUP;
                }
                return SubscribeStatus.FIRST_SUBSCRIPTION_FOR_COREGROUP_BY_GMID;
            }
            return SubscribeStatus.FIRST_SUBSCRIPTION;
        }

        GroupMemberId getSubscribingBridge(String string, GroupMemberId groupMemberId) {
            return (GroupMemberId)this.coregroupToGMIDMap.get(string);
        }

        boolean removeListener(GroupMemberId groupMemberId, String string) {
            GroupMemberId groupMemberId2 = (GroupMemberId)this.coregroupToGMIDMap.get(string);
            if (groupMemberId2 != null && groupMemberId2.equals(groupMemberId) && this.coregroupToGMIDMap.remove(string) != null) {
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to find coregroup/gmid mapping to remove");
            }
            return false;
        }

        SubjectSubscription getSubjectSubscription() {
            return this.ss;
        }

        public SubjectProxySubscription getSubjectProxySubscription() {
            return (SubjectProxySubscription)this.ss;
        }
    }
}

