/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.impl.CGBridge;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.InterBridgeCoreGroup;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SynchronizedCoreGroups {
    private static final TraceComponent tc = Tr.register((Class)SynchronizedCoreGroups.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    Map apgMap;
    CGBridge cgbridge;
    CGBridgeService cgbService;
    int postCacheSize;
    Object postCacheSizeLock = new Object();

    public SynchronizedCoreGroups(CGBridge cGBridge) {
        this.apgMap = new HashMap();
        this.cgbService = CGBridgeService.getInstance();
        this.cgbridge = cGBridge;
        this.postCacheSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBridge(String string, String string2, GroupMemberId groupMemberId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addBridge", (Object)new Object[]{string2, groupMemberId});
        }
        boolean bl = false;
        Map map = this.apgMap;
        synchronized (map) {
            HashSet<GroupMemberId> hashSet;
            HashMap<String, HashSet<GroupMemberId>> hashMap = (HashMap<String, HashSet<GroupMemberId>>)this.apgMap.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, HashSet<GroupMemberId>>();
                this.apgMap.put(string, hashMap);
            }
            if ((hashSet = (HashSet<GroupMemberId>)hashMap.get(string2)) == null) {
                hashSet = new HashSet<GroupMemberId>();
                hashMap.put(string2, hashSet);
            }
            bl = hashSet.add(groupMemberId);
        }
        if (bl) {
            this.notifyListeners(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addBridge-" + bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCoreGroup(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeCoreGroup", (Object)new Object[]{string2});
        }
        Object var3_3 = null;
        Map map = this.apgMap;
        synchronized (map) {
            Map map2 = (Map)this.apgMap.get(string);
            if (map2 != null) {
                var3_3 = map2.remove(string2);
            }
        }
        if (var3_3 != null) {
            this.notifyListeners(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCoreGroup", var3_3);
        }
    }

    private boolean compareGMIDs(GroupMemberId[] groupMemberIdArray, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compareGMIDs");
        }
        boolean bl = false;
        if (groupMemberIdArray != null && set != null && groupMemberIdArray.length == set.size()) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                if (set.contains(groupMemberIdArray[i])) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("compareGMIDs-" + groupMemberIdArray[i]));
                }
                return bl;
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("compareGMIDs-" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set calculateAvailableCoreGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"calculateAvailableCoreGroups");
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.cgbService.getLocalCoreGroupName());
        Map map = this.cgbridge.getInterCGBridgeCoreGroups();
        Map map2 = this.apgMap;
        synchronized (map2) {
            Iterator iterator = this.apgMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map3 = (Map)entry.getValue();
                Iterator iterator2 = map3.entrySet().iterator();
                InterBridgeCoreGroup interBridgeCoreGroup = (InterBridgeCoreGroup)map.get(string);
                if (interBridgeCoreGroup != null) {
                    while (iterator2.hasNext()) {
                        Set set;
                        Map.Entry entry2 = iterator2.next();
                        String string2 = (String)entry2.getKey();
                        GroupMemberId[] groupMemberIdArray = (GroupMemberId[])interBridgeCoreGroup.getRemoteCellCoreGroupMembers().get(string2);
                        if (!this.compareGMIDs(groupMemberIdArray, set = (Set)entry2.getValue())) continue;
                        hashSet.add(string2);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("ibcg likely not yet created for access point group: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"calculateAvailableCoreGroups", hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printPostCacheSize() {
        int n = this.cgbridge.getSubjectPostCache().getSubjectPostCacheSize();
        Object object = this.postCacheSizeLock;
        synchronized (object) {
            if (n != this.postCacheSize) {
                this.postCacheSize = n;
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"CWRCB0124", (Object)new Integer(this.postCacheSize));
                }
            }
        }
    }

    void notifyListeners(boolean bl) {
        this.cgbService.notifyAvailableCoreGroupListeners(this.calculateAvailableCoreGroups(), this.cgbService.getAllCoreGroups(), bl);
        this.printPostCacheSize();
    }
}

