/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.impl.WorkType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Work {
    static final TraceComponent tc = Tr.register((Class)Work.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    boolean isHighPriorityWork;
    protected int priority;
    Set prereqWork;
    boolean isWorkComplete;
    WorkType workType;
    boolean isPrereqByHashCode;

    public Work(int n, boolean bl, WorkType workType) throws IllegalArgumentException {
        this(n, bl, workType, false);
    }

    public Work(int n, boolean bl, WorkType workType, boolean bl2) throws IllegalArgumentException {
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException("illegal priority used: " + n);
        }
        this.isPrereqByHashCode = bl2;
        this.priority = n;
        this.isHighPriorityWork = bl;
        this.isWorkComplete = false;
        this.workType = workType;
    }

    public int getPriority() {
        return this.priority;
    }

    public abstract void doWork();

    public boolean isHighPriorityWork() {
        return this.isHighPriorityWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPrereqWorkSet() {
        Work work = this;
        synchronized (work) {
            return this.prereqWork != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPrereqWork() {
        Work work = this;
        synchronized (work) {
            return new HashSet(this.prereqWork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAllPreworkComplete() {
        Work work = this;
        synchronized (work) {
            if (this.prereqWork == null) {
                return true;
            }
            Iterator iterator = this.prereqWork.iterator();
            while (iterator.hasNext()) {
                Work work2 = (Work)iterator.next();
                if (work2.isWorkComplete()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("work complete is false..." + work2));
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrereqWork(Set set) {
        if (set != null) {
            Work work = this;
            synchronized (work) {
                this.prereqWork = new HashSet(set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPrereqWork(Set set) {
        if (set != null) {
            Work work = this;
            synchronized (work) {
                if (this.prereqWork == null) {
                    this.prereqWork = new HashSet(set);
                } else {
                    this.prereqWork.addAll(set);
                }
            }
        }
    }

    public boolean isWorkComplete() {
        return this.isWorkComplete;
    }

    void setWorkComplete() {
        this.isWorkComplete = true;
    }

    public WorkType getWorkType() {
        return this.workType;
    }

    public boolean isPrereqByHashCode() {
        return this.isPrereqByHashCode;
    }
}

