/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.core.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.core.impl.Work;
import com.ibm.ws.cgbridge.core.impl.WorkType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkDispatcher
implements Runnable,
ThreadPoolListener {
    static final TraceComponent tc = Tr.register((Class)WorkDispatcher.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int INTER_PMG_STABILIZED_PRIORITY = 7;
    public static final int GSR_STABILIZED_PRIORITY = 6;
    public static final int GSR_ONMESSAGE_PRIORITY = 5;
    public static final int WORK_DELAY = 5;
    ThreadPool threadPool;
    Object threadPoolLock = new Object();
    List workQueue;
    List highPriorityWorkQueue;
    int numWorkQueueItems;
    int numHighPriorityWorkQueueItems;
    int activeThreads = 0;
    Object activeThreadsLock = new Object();
    Map lastWorkRef;
    Map prereqByTypeMap;

    public WorkDispatcher(ThreadPool threadPool) {
        this.workQueue = new LinkedList();
        this.highPriorityWorkQueue = new LinkedList();
        this.threadPool = threadPool;
        this.lastWorkRef = new HashMap();
        this.prereqByTypeMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePrereqByHashCodeWork(Work work) {
        Map map = this.prereqByTypeMap;
        synchronized (map) {
            Work work2;
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.prereqByTypeMap.get(work.getWorkType());
            if (linkedHashMap != null && (work2 = (Work)linkedHashMap.get(work)) != null && work2 == work) {
                linkedHashMap.remove(work2);
                if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(work.getWorkType() + " has the following # of prereq by hash work items stored: " + linkedHashMap.size()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeWork(Work work, WorkType[] workTypeArray) {
        Object object;
        Object object2;
        Object object3;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("storeWork-" + work + " " + workTypeArray));
        }
        if (work.isPrereqByHashCode()) {
            object3 = this.prereqByTypeMap;
            synchronized (object3) {
                object2 = (LinkedHashMap<Work, Work>)this.prereqByTypeMap.get(work.getWorkType());
                if (object2 != null) {
                    object = (Work)((LinkedHashMap)object2).get(work);
                    if (object != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("matching prereq work exists: " + object));
                        }
                        HashSet<Object> hashSet = new HashSet<Object>();
                        hashSet.add(object);
                        work.addPrereqWork(hashSet);
                    }
                } else {
                    object2 = new LinkedHashMap<Work, Work>();
                    this.prereqByTypeMap.put(work.getWorkType(), object2);
                }
                ((HashMap)object2).put(work, work);
                if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(work.getWorkType() + " has the following # of prereq by hash work items stored: " + ((HashMap)object2).size()));
                }
            }
        }
        object3 = this.lastWorkRef;
        synchronized (object3) {
            if (workTypeArray != null) {
                object = new HashSet();
                for (int i = 0; i < workTypeArray.length; ++i) {
                    object2 = (Work)this.lastWorkRef.get(workTypeArray[i]);
                    if (object2 == null) continue;
                    object.add(object2);
                    if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added prereq work: " + object2));
                }
                if (object.size() > 0) {
                    work.addPrereqWork((Set)object);
                }
            }
            this.lastWorkRef.put(work.getWorkType(), work);
        }
        if (work.isHighPriorityWork()) {
            object3 = this.highPriorityWorkQueue;
            synchronized (object3) {
                if (work.getPriority() == 1 || this.highPriorityWorkQueue.size() == 0) {
                    this.highPriorityWorkQueue.add(work);
                } else {
                    object2 = this.highPriorityWorkQueue.iterator();
                    int n = 0;
                    while (object2.hasNext()) {
                        object = (Work)object2.next();
                        if (work.getPriority() > ((Work)object).getPriority()) break;
                        ++n;
                    }
                    if (n >= this.highPriorityWorkQueue.size()) {
                        this.highPriorityWorkQueue.add(work);
                    } else {
                        this.highPriorityWorkQueue.add(n, work);
                        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("adding high Priority work at index: " + n));
                        }
                    }
                }
                if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("storework highPriorityWorkQueue size=" + this.highPriorityWorkQueue.size()));
                }
                this.numHighPriorityWorkQueueItems = this.highPriorityWorkQueue.size();
            }
        }
        object3 = this.workQueue;
        synchronized (object3) {
            this.workQueue.add(work);
            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("storework workQueue size=" + this.workQueue.size()));
            }
            this.numWorkQueueItems = this.workQueue.size();
        }
    }

    public void addWorkWithPrereqwork(Work work, WorkType[] workTypeArray) {
        this.storeWork(work, workTypeArray);
        this.processWork();
    }

    public void addWork(Work work) {
        this.storeWork(work, null);
        this.processWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processWork() {
        block12: {
            try {
                Object object = this.activeThreadsLock;
                synchronized (object) {
                    block11: {
                        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("# active threads = " + this.activeThreads + ", total work=" + this.getTotalWork()));
                        }
                        if (this.activeThreads >= this.threadPool.getMaximumPoolSize()) {
                            if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"max # of threads already deployed");
                            }
                        } else {
                            try {
                                this.threadPool.execute((Runnable)this, 1);
                                ++this.activeThreads;
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block11;
                                Tr.debug((TraceComponent)tc, (String)("unable to put work on thread...must be full" + exception.getMessage()));
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)("couldn't execute work: " + exception.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMoreWork() {
        List list = this.highPriorityWorkQueue;
        synchronized (list) {
            if (this.highPriorityWorkQueue.size() > 0) {
                return true;
            }
        }
        list = this.workQueue;
        synchronized (list) {
            if (this.workQueue.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Work getWork() {
        Work work = null;
        List list = this.highPriorityWorkQueue;
        synchronized (list) {
            if (this.highPriorityWorkQueue.size() > 0) {
                work = (Work)this.highPriorityWorkQueue.remove(0);
                if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getWork highPriorityWorkQueue size=" + this.highPriorityWorkQueue.size()));
                }
                this.numHighPriorityWorkQueueItems = this.highPriorityWorkQueue.size();
            }
        }
        if (work == null) {
            list = this.workQueue;
            synchronized (list) {
                if (this.workQueue.size() > 0) {
                    work = (Work)this.workQueue.remove(0);
                    if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getWork workQueue size=" + this.workQueue.size()));
                    }
                    this.numWorkQueueItems = this.workQueue.size();
                }
            }
        }
        return work;
    }

    int getTotalWork() {
        return this.numHighPriorityWorkQueueItems + this.numWorkQueueItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Work work = this.getWork();
        while (work != null) {
            try {
                if (work.isPrereqWorkSet()) {
                    if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("prereq work is set: " + work.getPrereqWork()));
                    }
                    while (!work.isAllPreworkComplete()) {
                        Thread.sleep(5L);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("calling doWork()-" + work));
                }
                work.doWork();
                work.setWorkComplete();
                work.setPrereqWork(null);
                if (work.isPrereqByHashCode()) {
                    this.removePrereqByHashCodeWork(work);
                }
                if ((work = this.getWork()) != null || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"no more work");
            }
            catch (Exception exception) {
                if (work != null) {
                    work.setWorkComplete();
                    work.setPrereqWork(null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Problem doing work for" + work + ": " + exception.getMessage()));
                }
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".run()"), (String)"22", (Object)this);
            }
        }
        boolean bl = false;
        Object object = this.activeThreadsLock;
        synchronized (object) {
            --this.activeThreads;
            if (this.activeThreads == 0) {
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isLastThread=" + bl));
                }
            }
        }
        if (bl) {
            if (this.isMoreWork()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There is more work: " + this.getTotalWork()));
                }
                this.processWork();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no more work.");
            }
        }
    }

    public void threadCreated(ThreadPool threadPool, int n) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("created thread, size=: " + n));
        }
    }

    public void threadDestroyed(ThreadPool threadPool, int n) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyed thread, size=: " + n));
        }
    }

    public void threadPoolCreated(ThreadPool threadPool) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Thread pool created: " + threadPool.getName()));
        }
    }

    public void threadReturned(ThreadPool threadPool, int n, int n2) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("thread returned: # threads in use =" + n));
        }
    }

    public void threadStarted(ThreadPool threadPool, int n, int n2) {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isThreadingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("thread started: # threads in use =" + n));
        }
    }
}

