/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.msg.CGBridgeBBPostMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRLocalStateMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRStateRequestMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeGSRSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeStateCompleteMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeStatusMsg;
import com.ibm.ws.cgbridge.msg.CoreGroupPostsMsg;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;

public class CGBridgeBBMsgHandler {
    private static final TraceComponent tc = Tr.register((Class)CGBridgeBBMsgHandler.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    public static final byte BB_SUBSCRIPTION = 1;
    public static final byte BB_UPDATE = 2;
    public static final byte COREGROUP_STATUS = 3;
    public static final byte GSR_SUBS = 9;
    public static final byte STATE_COMPLETE = 10;
    public static final byte POST_SET = 11;
    public static final byte GSR_LOCAL_STATE = 12;
    public static final byte REQUEST_GSR_STATE = 13;

    public static CGBridgeMsg processCGBridgeMsg(byte[] byArray) throws Exception {
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cgbMsg.length==" + byArray.length));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CGBridgeMsg cGBridgeMsg = null;
        ObjectInputStream objectInputStream = null;
        objectInputStream = new ObjectInputStream(byteArrayInputStream);
        CGBridgeHashKey cGBridgeHashKey = CGBridgeBBMsgHandler.readCGBridgeHashKey(objectInputStream);
        byte by = CGBridgeBBMsgHandler.readCGBridgeMsgType(objectInputStream);
        switch (by) {
            case 2: {
                CGBridgeBBPostMsg cGBridgeBBPostMsg = new CGBridgeBBPostMsg(cGBridgeHashKey, byArray);
                cGBridgeBBPostMsg.readExternal(objectInputStream, false);
                cGBridgeMsg = cGBridgeBBPostMsg;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"BB_UPDATE");
                break;
            }
            case 1: {
                CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg = new CGBridgeBBRemoteSubscriptionMsg(cGBridgeHashKey, byArray);
                cGBridgeBBRemoteSubscriptionMsg.readExternal(objectInputStream, false);
                cGBridgeMsg = cGBridgeBBRemoteSubscriptionMsg;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"BB_SUBSCRIPTION");
                break;
            }
            case 3: {
                CGBridgeStatusMsg cGBridgeStatusMsg;
                cGBridgeMsg = cGBridgeStatusMsg = new CGBridgeStatusMsg(objectInputStream, cGBridgeHashKey);
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"COREGROUP_STATUS");
                break;
            }
            case 9: {
                CGBridgeGSRSubscriptionMsg cGBridgeGSRSubscriptionMsg = new CGBridgeGSRSubscriptionMsg(objectInputStream, cGBridgeHashKey);
                cGBridgeMsg = cGBridgeGSRSubscriptionMsg;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"GSR_SUB");
                break;
            }
            case 10: {
                CGBridgeStateCompleteMsg cGBridgeStateCompleteMsg = new CGBridgeStateCompleteMsg(objectInputStream, cGBridgeHashKey);
                cGBridgeMsg = cGBridgeStateCompleteMsg;
                if (!tc.isDebugEnabled() || !tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"STATE_COMPLETE");
                break;
            }
            case 11: {
                CoreGroupPostsMsg coreGroupPostsMsg = new CoreGroupPostsMsg(objectInputStream, cGBridgeHashKey);
                cGBridgeMsg = coreGroupPostsMsg;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"POST_SET");
                break;
            }
            case 12: {
                CGBridgeGSRLocalStateMsg cGBridgeGSRLocalStateMsg = new CGBridgeGSRLocalStateMsg(objectInputStream, cGBridgeHashKey);
                cGBridgeMsg = cGBridgeGSRLocalStateMsg;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"GSR_LOCAL_STATE");
                break;
            }
            case 13: {
                CGBridgeGSRStateRequestMsg cGBridgeGSRStateRequestMsg = new CGBridgeGSRStateRequestMsg(objectInputStream, cGBridgeHashKey);
                cGBridgeMsg = cGBridgeGSRStateRequestMsg;
                if (!tc.isDebugEnabled() || !CGBridgeService.getInstance().getTraceFilter().isMessagingEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"REQUEST_GSR_STATE");
            }
        }
        objectInputStream.close();
        return cGBridgeMsg;
    }

    protected static byte readCGBridgeMsgType(ObjectInput objectInput) throws IOException {
        return objectInput.readByte();
    }

    protected static CGBridgeHashKey readCGBridgeHashKey(ObjectInput objectInput) throws IOException {
        CGBridgeHashKey cGBridgeHashKey = new CGBridgeHashKey();
        cGBridgeHashKey.readExternal(objectInput);
        return cGBridgeHashKey;
    }

    public static final String createSubjectKey(String string, String string2) {
        return CGBridgeUtils.createKey(string, string2);
    }
}

