/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.CGBridgeBBPost;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBulletinBoardScopeDataImpl;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.msg.CGBridgeBBMsgHandler;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

public class CGBridgeBBPostMsg
extends CGBridgeMsg
implements CGBridgeBBPost {
    public static final CGBridgeMsgVersion CURRENT_POST_MSG_VERSION = CGBridgeMsgVersion.VERSION3;
    public static final String PAP_POST_FIELD = "ring";
    public static final int VERSION1_POST_IDENTIFIER = -1;
    private static final int CONSTANT_SERIALIZED_SIZE = 1000;
    private static final long serialVersionUID = 850418944143896503L;
    private static final TraceComponent tc = Tr.register((Class)CGBridgeBBPostMsg.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private static final String NO_HOST = "unknown";
    private String subject;
    private String bbName;
    private SubjectValue[] subVal;
    private Set removedServers;
    private boolean isInitialUpdate;
    private String cellName;
    private String coreGroup;
    private String originServer;
    private CGBridgeMsgVersion version;
    private CGBridgeBulletinBoardScopeData cgbBBScopeData;
    private int subjectHashCode;
    private long cgbPostIdentifier;
    private transient SubjectInfo subInfo;

    protected CGBridgeBBPostMsg(CGBridgeHashKey cGBridgeHashKey, byte[] byArray) {
        this.cgbHashKey = cGBridgeHashKey;
        this.byteMsg = byArray;
    }

    public CGBridgeBBPostMsg() {
    }

    public CGBridgeBBPostMsg(String string, String string2, SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray, Set set, boolean bl, boolean bl2) throws CGBInternalErrorException {
        this.version = CURRENT_POST_MSG_VERSION;
        this.originServer = CGBridgeService.getInstance().getCGBridgeConfig().getFullServerName();
        this.cgbPostIdentifier = bl2 ? CGBridgeUtils.getUniqueIdentifier() : QuickApproxTime.getRef().getApproxTime();
        this.cellName = string;
        this.coreGroup = string2;
        try {
            this.subVal = subjectValueArray;
            this.subject = subjectSubscription.getSubject().getSubjectName();
            this.bbName = subjectSubscription.getSubject().getBoardName();
            this.removedServers = set;
            this.isInitialUpdate = bl;
            CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData = (CGBridgeBulletinBoardScopeData)subjectSubscription.getSubject().getScope().getData();
            this.cgbBBScopeData = new CGBridgeBulletinBoardScopeDataImpl(PAP_POST_FIELD, this.cellName, cGBridgeBulletinBoardScopeData.getCGBridgeScopeType());
            this.cgbHashKey = new CGBridgeHashKey(subjectSubscription.hashCode());
            this.subjectHashCode = CGBridgeMsg.generateHashCode(CGBridgeBBMsgHandler.createSubjectKey(this.bbName, this.subject));
        }
        catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
            FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, (String)(this.getClass().getName() + "<init>"), (String)"1", (Object)this);
            throw new CGBInternalErrorException("Unable to initialize CGBridgeBBPostMsg", subjectSubscriptionClosedException);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.cgbBBScopeData.writeExternal(objectOutput);
        objectOutput.writeUTF(this.subject);
        objectOutput.writeUTF(this.bbName);
        objectOutput.writeUTF(this.cellName);
        objectOutput.writeUTF(this.coreGroup);
        objectOutput.writeInt(this.subVal.length);
        objectOutput.writeObject(this.subVal);
        this.version.writeExternal(objectOutput);
        objectOutput.writeObject(this.removedServers);
        objectOutput.writeBoolean(this.isInitialUpdate);
        objectOutput.writeLong(this.cgbPostIdentifier);
        objectOutput.writeUTF(this.originServer);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternal(objectInput, true);
    }

    public void readExternal(ObjectInput objectInput, boolean bl) throws IOException, ClassNotFoundException {
        if (bl) {
            super.readExternal(objectInput);
        }
        this.readBridgeData(objectInput);
        int n = objectInput.readInt();
        this.subVal = new SubjectValue[n];
        Object object = objectInput.readObject();
        if (object != null) {
            this.subVal = (SubjectValue[])object;
        }
        for (int i = 0; i < n; ++i) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("bbpost: subjectavalue attribues: " + this.subVal[i].getServerName()));
        }
        try {
            this.version = new CGBridgeMsgVersion();
            this.version.readExternal(objectInput);
            this.removedServers = (Set)objectInput.readObject();
            this.isInitialUpdate = objectInput.readBoolean();
            this.cgbPostIdentifier = objectInput.readLong();
            this.originServer = objectInput.readUTF();
        }
        catch (EOFException eOFException) {
            this.version = CGBridgeMsgVersion.VERSION1;
            this.removedServers = new HashSet(0);
            this.isInitialUpdate = false;
            this.cgbPostIdentifier = -1L;
            this.originServer = NO_HOST;
        }
        this.subjectHashCode = CGBridgeMsg.generateHashCode(CGBridgeBBMsgHandler.createSubjectKey(this.bbName, this.subject));
    }

    protected void readBridgeData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.cgbBBScopeData = new CGBridgeBulletinBoardScopeDataImpl();
        this.cgbBBScopeData.readExternal(objectInput);
        this.subject = objectInput.readUTF();
        this.bbName = objectInput.readUTF();
        this.cellName = objectInput.readUTF();
        this.coreGroup = objectInput.readUTF();
    }

    public byte getMessageType() {
        return 2;
    }

    public String getBBName() {
        return this.bbName;
    }

    public SubjectValue[] getValues() {
        return this.subVal;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getSubjectHashCode() {
        return this.subjectHashCode;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getCoreGroupName() {
        return this.coreGroup;
    }

    public CGBridgeBulletinBoardScopeData getCGBScopeData() {
        return this.cgbBBScopeData;
    }

    public Set getRemovedServers() {
        return this.removedServers;
    }

    public CGBridgeMsgVersion getMsgVersion() {
        return this.version;
    }

    public boolean isInitialUpdate() {
        return this.isInitialUpdate;
    }

    public long getCGBPostIdentifier() {
        return this.cgbPostIdentifier;
    }

    public String getOriginServer() {
        return this.originServer;
    }

    public byte[] marshallData() throws IOException {
        byte[] byArray = super.marshallData(1000);
        if (tc.isDebugEnabled() && CGBridgeService.getInstance().getTraceFilter().isPostsEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CGBPost origin coregroup=" + this.coreGroup + ", origin cell=" + this.cellName + ", bbName=" + this.bbName + ", subj name=" + this.subject + ", post size=" + byArray.length));
        }
        return byArray;
    }

    public String toString() {
        return this.bbName + "$" + this.subject;
    }

    public boolean isBatchPost() {
        return false;
    }

    public SubjectInfo getSubInfo() {
        return this.subInfo;
    }

    public void setSubInfo(SubjectInfo subjectInfo) {
        this.subInfo = subjectInfo;
    }
}

