/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.impl.CGBridgeBulletinBoardScopeDataImpl;
import com.ibm.ws.cgbridge.msg.CGBridgeBBMsgHandler;
import com.ibm.ws.cgbridge.msg.CGBridgeBBSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.msg.CGBridgeRemoteData;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

public class CGBridgeBBRemoteSubscriptionMsg
extends CGBridgeBBSubscriptionMsg
implements CGBridgeRemoteData {
    private static final long serialVersionUID = 3045779751448509498L;
    public static final CGBridgeMsgVersion CURRENT_SERIALIZATION_VERSION = CGBridgeMsgVersion.VERSION4;
    public static final Set EMPTY_SET = new HashSet(0);
    private static final String SEPARATOR = ":";
    private static final TraceComponent tc = Tr.register((Class)CGBridgeBBRemoteSubscriptionMsg.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    public static final int CONSTANT_SERIALIZED_SIZE = 450;
    private CGBridgeBulletinBoardScopeData cgbBBScopeData;
    private String originCoreGroup;
    private CGBridgeMsgVersion version;
    private String proxyCoreGroup;
    private Set adjacentCoreGroups;
    private Set postingCoreGroups = EMPTY_SET;

    protected CGBridgeBBRemoteSubscriptionMsg(CGBridgeHashKey cGBridgeHashKey, byte[] byArray) {
        this.version = CURRENT_SERIALIZATION_VERSION;
        this.cgbHashKey = this.version.getHashKey();
        this.byteMsg = byArray;
        this.boardName = null;
        this.subjectName = null;
        this.subjectHashCode = -1;
    }

    public CGBridgeBBRemoteSubscriptionMsg(SubjectInfo subjectInfo, boolean bl, int n, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData, String string) {
        super(subjectInfo, bl);
        this.originCoreGroup = string;
        this.cgbBBScopeData = cGBridgeBulletinBoardScopeData;
        this.version = CURRENT_SERIALIZATION_VERSION;
        this.cgbHashKey = this.version.getHashKey();
    }

    public CGBridgeBBRemoteSubscriptionMsg(String string, String string2, boolean bl, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData, String string3) {
        super(string, string2, bl);
        this.originCoreGroup = string3;
        this.cgbBBScopeData = cGBridgeBulletinBoardScopeData;
        this.version = CURRENT_SERIALIZATION_VERSION;
        this.cgbHashKey = this.version.getHashKey();
    }

    public CGBridgeBBRemoteSubscriptionMsg(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, boolean bl) {
        super(cGBridgeBBRemoteSubscriptionMsg.getBBName(), cGBridgeBBRemoteSubscriptionMsg.getSubject(), bl);
        this.cgbBBScopeData = cGBridgeBBRemoteSubscriptionMsg.getCGBScopeData();
        this.originCoreGroup = cGBridgeBBRemoteSubscriptionMsg.getOriginCoreGroup();
        this.version = cGBridgeBBRemoteSubscriptionMsg.getVersion();
        this.cgbHashKey = this.version.getHashKey();
    }

    public CGBridgeBBRemoteSubscriptionMsg() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.cgbBBScopeData.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.subscribe);
        objectOutput.writeInt(this.subjectHashCode);
        objectOutput.writeUTF(this.subjectName);
        objectOutput.writeUTF(this.boardName);
        objectOutput.writeUTF(this.originCoreGroup);
        objectOutput.writeObject(this.proxyCoreGroup);
        objectOutput.writeObject(this.adjacentCoreGroups);
        objectOutput.writeObject(this.postingCoreGroups);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternal(objectInput, true);
    }

    public void readExternal(ObjectInput objectInput, boolean bl) throws IOException, ClassNotFoundException {
        block5: {
            if (bl) {
                super.readExternal(objectInput);
            }
            this.readCGBridgeData(objectInput);
            this.subjectName = objectInput.readUTF();
            this.boardName = objectInput.readUTF();
            this.originCoreGroup = objectInput.readUTF();
            this.version = new CGBridgeMsgVersion((byte)this.cgbHashKey.getValue());
            if (this.version.getVersion() >= CGBridgeMsgVersion.VERSION3.getVersion()) {
                try {
                    this.proxyCoreGroup = (String)objectInput.readObject();
                    this.adjacentCoreGroups = (Set)objectInput.readObject();
                    if (this.version.getVersion() >= CGBridgeMsgVersion.VERSION4.getVersion()) {
                        this.postingCoreGroups = (Set)objectInput.readObject();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("problem reading proxyCoreGroup: " + iOException.getMessage()));
                }
            }
        }
    }

    protected void readCGBridgeData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.cgbBBScopeData = new CGBridgeBulletinBoardScopeDataImpl();
        this.cgbBBScopeData.readExternal(objectInput);
        this.subscribe = objectInput.readBoolean();
        this.subjectHashCode = objectInput.readInt();
    }

    public byte getMessageType() {
        return 1;
    }

    public CGBridgeBulletinBoardScopeData getCGBScopeData() {
        return this.cgbBBScopeData;
    }

    public String getOriginCoreGroup() {
        return this.originCoreGroup;
    }

    public byte[] marshallData() throws IOException {
        byte[] byArray = super.marshallData(450);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CGB subscription msg size=" + byArray.length));
        }
        return byArray;
    }

    public int hashCode() {
        int n = this.subjectHashCode == 0 ? CGBridgeMsg.generateHashCode(CGBridgeBBMsgHandler.createSubjectKey(this.boardName, this.subjectName)) : this.subjectHashCode;
        n = this.originCoreGroup == null ? n + this.getMessageType() + this.cgbBBScopeData.hashCode() : (n += this.getMessageType() + this.cgbBBScopeData.hashCode() + this.originCoreGroup.hashCode());
        return n;
    }

    public String toString() {
        return this.boardName + SEPARATOR + this.subjectName + SEPARATOR + this.subscribe + SEPARATOR + this.cgbBBScopeData + SEPARATOR + this.originCoreGroup;
    }

    CGBridgeMsgVersion getVersion() {
        return this.version;
    }

    public void setSubscribe(boolean bl) {
        this.subscribe = bl;
    }

    public String getProxyCoreGroup() {
        return this.proxyCoreGroup;
    }

    public void setProxyCoreGroup(String string) {
        this.proxyCoreGroup = string;
    }

    public boolean equals(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg) {
        return cGBridgeBBRemoteSubscriptionMsg.hashCode() == this.hashCode();
    }

    public Set getAdjacentCoreGroups() {
        return this.adjacentCoreGroups;
    }

    public void setAdjacentCoreGroups(Set set) {
        this.adjacentCoreGroups = set;
    }

    public Set getPostingCoreGroups() {
        return this.postingCoreGroups;
    }

    public void setPostingCoreGroups(Set set) {
        this.postingCoreGroups = set;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof CGBridgeBBRemoteSubscriptionMsg && object.hashCode() == this.hashCode();
    }
}

