/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.msg.MessageVersion;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;

public class CGBridgeGSRSubscriptionMsg
extends CGBridgeMsg
implements MessageVersion {
    private static final long serialVersionUID = -2892194643933266638L;
    public static final CGBridgeMsgVersion CURRENT_SERIALIZATION_VERSION = CGBridgeMsgVersion.VERSION3;
    private static final TraceComponent tc = Tr.register((Class)CGBridgeGSRSubscriptionMsg.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private static final int CONSTANT_SERIALIZED_SIZE = 20000;
    String fullyQualifiedServerName;
    String originCellName;
    String originCoreGroup;
    Set subscriptions;
    Map remoteSubscriptions;
    private int bridgeViewChangeID;
    private CGBridgeMsgVersion version;
    private long numOfMSecsToWaitForUpdates;
    private Set allAvailableCoreGroups;
    private boolean isForTunnel;
    private long bridgeStartTime;

    public CGBridgeGSRSubscriptionMsg(String string, Set set, Map map, int n, String string2, String string3, long l, Set set2, long l2) {
        this.fullyQualifiedServerName = string;
        this.cgbHashKey = CURRENT_SERIALIZATION_VERSION.getHashKey();
        this.version = CURRENT_SERIALIZATION_VERSION;
        this.subscriptions = set;
        this.bridgeViewChangeID = n;
        this.originCellName = string2;
        this.remoteSubscriptions = map;
        this.originCoreGroup = string3;
        this.numOfMSecsToWaitForUpdates = l;
        this.allAvailableCoreGroups = set2;
        this.bridgeStartTime = l2;
    }

    public CGBridgeGSRSubscriptionMsg(ObjectInput objectInput, CGBridgeHashKey cGBridgeHashKey) throws IOException, ClassNotFoundException {
        this.cgbHashKey = cGBridgeHashKey;
        this.readMsgData(objectInput);
    }

    public CGBridgeGSRSubscriptionMsg() {
    }

    public byte getMessageType() {
        return 9;
    }

    public void readMsgData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fullyQualifiedServerName = objectInput.readUTF();
        this.subscriptions = (Set)objectInput.readObject();
        this.bridgeViewChangeID = objectInput.readInt();
        this.originCellName = objectInput.readUTF();
        this.remoteSubscriptions = (Map)objectInput.readObject();
        this.numOfMSecsToWaitForUpdates = objectInput.readLong();
        this.originCoreGroup = objectInput.readUTF();
        this.allAvailableCoreGroups = (Set)objectInput.readObject();
        this.version = new CGBridgeMsgVersion((byte)this.cgbHashKey.getValue());
        if (this.version.getVersion() > CGBridgeMsgVersion.VERSION1.getVersion()) {
            this.isForTunnel = objectInput.readBoolean();
        }
        this.bridgeStartTime = this.version.getVersion() > CGBridgeMsgVersion.VERSION2.getVersion() ? objectInput.readLong() : 0L;
    }

    public void writeMsgData(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.fullyQualifiedServerName);
        objectOutput.writeObject(this.subscriptions);
        objectOutput.writeInt(this.bridgeViewChangeID);
        objectOutput.writeUTF(this.originCellName);
        objectOutput.writeObject(this.remoteSubscriptions);
        objectOutput.writeLong(this.numOfMSecsToWaitForUpdates);
        objectOutput.writeUTF(this.originCoreGroup);
        objectOutput.writeObject(this.allAvailableCoreGroups);
        objectOutput.writeBoolean(this.isForTunnel);
        objectOutput.writeLong(this.bridgeStartTime);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.readMsgData(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.writeMsgData(objectOutput);
    }

    public String getFullyQualifiedServerName() {
        return this.fullyQualifiedServerName;
    }

    public CGBridgeMsgVersion getVersion() {
        return this.version;
    }

    public Set getSubscriptions() {
        return this.subscriptions;
    }

    public int getBridgeViewChangeID() {
        return this.bridgeViewChangeID;
    }

    public String getOriginCellName() {
        return this.originCellName;
    }

    public Map getRemoteSubscriptions() {
        return this.remoteSubscriptions;
    }

    public long getNumOfMSecsToWaitForUpdates() {
        return this.numOfMSecsToWaitForUpdates;
    }

    public String getOriginCoreGroup() {
        return this.originCoreGroup;
    }

    public byte[] marshallData() throws IOException {
        byte[] byArray = super.marshallData(20000);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CGBGSRSub msg view id=" + this.bridgeViewChangeID + ", size=" + byArray.length));
        }
        return byArray;
    }

    public Set getAllAvailableCoreGroups() {
        return this.allAvailableCoreGroups;
    }

    public long getBridgeStartTime() {
        return this.bridgeStartTime;
    }
}

