/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cgbridge.config.CGBVersion;
import com.ibm.ws.cgbridge.msg.CGBridgeBBRemoteSubscriptionMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.msg.MessageVersion;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CGBridgeHAStateMsg
extends CGBridgeMsg
implements MessageVersion {
    private static final long serialVersionUID = 7222943412802964865L;
    private static final TraceComponent tc = Tr.register((Class)CGBridgeHAStateMsg.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private static final int UNDEFINED_BRIDGE_VERSION = 0;
    public static final long UNSET_TIMEOUT = -1L;
    private GroupMemberId groupMemberidLocal;
    private String bbName;
    private String subjName;
    private String accessPointGroupName;
    private int hashCode;
    private CGBridgeBBRemoteSubscriptionMsg gwbbRemoteSubs;
    CGBridgeMsgVersion msgVersion;
    CGBVersion bridgeVersion;
    long bridgeStateRebuildTimeLeft;
    int expectedViewChangeID;

    public CGBridgeHAStateMsg(CGBridgeBBRemoteSubscriptionMsg cGBridgeBBRemoteSubscriptionMsg, GroupMemberId groupMemberId, String string) {
        this.bbName = cGBridgeBBRemoteSubscriptionMsg.getBBName();
        this.subjName = cGBridgeBBRemoteSubscriptionMsg.getSubject();
        this.accessPointGroupName = string;
        this.hashCode = cGBridgeBBRemoteSubscriptionMsg.hashCode();
        this.groupMemberidLocal = groupMemberId;
        this.gwbbRemoteSubs = cGBridgeBBRemoteSubscriptionMsg;
        this.cgbHashKey = new CGBridgeHashKey(cGBridgeBBRemoteSubscriptionMsg.hashCode());
        this.msgVersion = CGBridgeMsgVersion.VERSION2;
        this.cgbHashKey = this.msgVersion.getHashKey();
    }

    public CGBridgeHAStateMsg() {
    }

    public byte getMessageType() {
        byte by = 0;
        return by;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        block3: {
            super.readExternal(objectInput);
            this.hashCode = objectInput.readInt();
            this.bbName = objectInput.readUTF();
            this.subjName = objectInput.readUTF();
            this.accessPointGroupName = objectInput.readUTF();
            this.groupMemberidLocal = (GroupMemberId)objectInput.readObject();
            this.gwbbRemoteSubs = (CGBridgeBBRemoteSubscriptionMsg)objectInput.readObject();
            this.msgVersion = new CGBridgeMsgVersion((byte)this.cgbHashKey.getValue());
            if (this.msgVersion.getVersion() == CGBridgeMsgVersion.VERSION2.getVersion()) {
                try {
                    int n = objectInput.readInt();
                    this.bridgeVersion = CGBVersion.getVersion(n);
                    this.bridgeStateRebuildTimeLeft = objectInput.readLong();
                    this.expectedViewChangeID = objectInput.readInt();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("problem reading topology: " + iOException.getMessage()));
                }
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.hashCode);
        objectOutput.writeUTF(this.bbName);
        objectOutput.writeUTF(this.subjName);
        objectOutput.writeUTF(this.accessPointGroupName);
        objectOutput.writeObject(this.groupMemberidLocal);
        objectOutput.writeObject(this.gwbbRemoteSubs);
        if (this.bridgeVersion != null) {
            objectOutput.writeInt(this.bridgeVersion.getOrdinal());
        } else {
            objectOutput.writeInt(0);
        }
        objectOutput.writeLong(this.bridgeStateRebuildTimeLeft);
        objectOutput.writeInt(this.expectedViewChangeID);
    }

    public GroupMemberId getGroupMemberId() {
        return this.groupMemberidLocal;
    }

    public String getbbName() {
        return this.bbName;
    }

    public String getSubjName() {
        return this.subjName;
    }

    public String getAccessPointName() {
        return this.accessPointGroupName;
    }

    public CGBridgeMsgVersion getVersion() {
        return this.msgVersion;
    }

    public CGBridgeBBRemoteSubscriptionMsg getRemoteSubscription() {
        return this.gwbbRemoteSubs;
    }

    public void setBridgeVersion(CGBVersion cGBVersion) {
        this.bridgeVersion = cGBVersion;
    }

    public CGBVersion getBridgeVersion() {
        return this.bridgeVersion;
    }

    public void setBridgeStateRebuildTimeLeft(long l) {
        this.bridgeStateRebuildTimeLeft = l;
    }

    public long getBridgeStateRebuildTimeLeft() {
        return this.bridgeStateRebuildTimeLeft;
    }

    public int getExpectedViewChangeID() {
        return this.expectedViewChangeID;
    }

    public void setExpectedViewChangeID(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set expected view id to: " + n));
        }
        this.expectedViewChangeID = n;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

