/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.msg.MessageVersion;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;

public class CGBridgeStateCompleteMsg
extends CGBridgeMsg
implements MessageVersion {
    private static final long serialVersionUID = 850418944143395037L;
    private String cellQualifiedServername;
    private int bridgeViewChangeID;
    private CGBridgeMsgVersion version;
    boolean isViewChangeComplete;
    Map bridgeStateIDs;
    Set availableBridges;

    public CGBridgeStateCompleteMsg(String string, int n, boolean bl, Set set) {
        this.cellQualifiedServername = string;
        this.cgbHashKey = CGBridgeMsgVersion.VERSION1.getHashKey();
        this.bridgeViewChangeID = n;
        this.isViewChangeComplete = bl;
        this.availableBridges = set;
    }

    public CGBridgeStateCompleteMsg(ObjectInput objectInput, CGBridgeHashKey cGBridgeHashKey) throws IOException, ClassNotFoundException {
        this.cgbHashKey = cGBridgeHashKey;
        this.readMsgData(objectInput);
    }

    public CGBridgeStateCompleteMsg() {
    }

    public byte getMessageType() {
        return 10;
    }

    public void readMsgData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.cellQualifiedServername = objectInput.readUTF();
        this.bridgeViewChangeID = objectInput.readInt();
        this.isViewChangeComplete = objectInput.readBoolean();
        this.availableBridges = (Set)objectInput.readObject();
        this.bridgeStateIDs = (Map)objectInput.readObject();
        this.version = new CGBridgeMsgVersion((byte)this.cgbHashKey.getValue());
    }

    public void writeMsgData(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.cellQualifiedServername);
        objectOutput.writeInt(this.bridgeViewChangeID);
        objectOutput.writeBoolean(this.isViewChangeComplete);
        objectOutput.writeObject(this.availableBridges);
        objectOutput.writeObject(this.bridgeStateIDs);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.readMsgData(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.writeMsgData(objectOutput);
    }

    public String getCellQualifiedServername() {
        return this.cellQualifiedServername;
    }

    public CGBridgeMsgVersion getVersion() {
        return this.version;
    }

    public int getBridgeViewChangeID() {
        return this.bridgeViewChangeID;
    }

    public boolean isViewChangeComplete() {
        return this.isViewChangeComplete;
    }

    public Set getAvailableBridges() {
        return this.availableBridges;
    }

    public Map getBridgeStateIDs() {
        return this.bridgeStateIDs;
    }

    public void setBridgeStateIDs(Map map) {
        this.bridgeStateIDs = map;
    }
}

