/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.msg;

import com.ibm.ws.cgbridge.msg.CGBridgeMsg;
import com.ibm.ws.cgbridge.msg.CGBridgeMsgVersion;
import com.ibm.ws.cgbridge.msg.CoregroupState;
import com.ibm.ws.cgbridge.util.CGBridgeHashKey;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class CGBridgeStatusMsg
extends CGBridgeMsg {
    public static final CoregroupState STATE_UNAVAILABLE = new CoregroupState(0, "UNAVAILABLE");
    public static final CGBridgeMsgVersion CGB_STATUS_MSG_VERSION1 = CGBridgeMsgVersion.VERSION1;
    public static final String KEY_TARGET_CORE_GROUP = "TARGET_CORE_GROUP";
    private static final long serialVersionUID = 55L;
    private CGBridgeMsgVersion version;
    private String fullyQualifiedCGName;
    private CoregroupState state;
    private String originAPG;
    private long uniqueID;
    private String sendingBridgeServer;
    private String targetCoreGroup;
    private Map properties;

    public CGBridgeStatusMsg() {
    }

    public CGBridgeStatusMsg(String string, String string2, CoregroupState coregroupState, long l, String string3) {
        this.fullyQualifiedCGName = string;
        this.originAPG = string2;
        this.state = coregroupState;
        this.version = CGB_STATUS_MSG_VERSION1;
        this.uniqueID = l;
        this.sendingBridgeServer = string3;
        this.properties = new HashMap(2);
    }

    public void setTargetCoreGroup(String string) {
        this.targetCoreGroup = string;
        this.properties.put(KEY_TARGET_CORE_GROUP, string);
    }

    public CGBridgeStatusMsg(ObjectInput objectInput, CGBridgeHashKey cGBridgeHashKey) throws IOException, ClassNotFoundException {
        this.cgbHashKey = cGBridgeHashKey;
        this.readMsgData(objectInput);
    }

    public byte getMessageType() {
        return 3;
    }

    public void readMsgData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.version = (CGBridgeMsgVersion)objectInput.readObject();
        this.fullyQualifiedCGName = objectInput.readUTF();
        this.originAPG = objectInput.readUTF();
        this.state = (CoregroupState)objectInput.readObject();
        if (this.version.getVersion() > CGBridgeMsgVersion.VERSION1.getVersion()) {
            this.uniqueID = objectInput.readLong();
            this.sendingBridgeServer = objectInput.readUTF();
            this.properties = (Map)objectInput.readObject();
            if (this.properties != null) {
                this.targetCoreGroup = (String)this.properties.get(KEY_TARGET_CORE_GROUP);
            }
        }
    }

    public void writeMsgData(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.version);
        objectOutput.writeUTF(this.fullyQualifiedCGName);
        objectOutput.writeUTF(this.originAPG);
        objectOutput.writeObject(this.state);
        objectOutput.writeLong(this.uniqueID);
        objectOutput.writeUTF(this.sendingBridgeServer);
        objectOutput.writeObject(this.properties);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.readMsgData(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.writeMsgData(objectOutput);
    }

    public String getFullyQualifiedCGName() {
        return this.fullyQualifiedCGName;
    }

    public String getOriginAPG() {
        return this.originAPG;
    }

    public CoregroupState getState() {
        return this.state;
    }

    public CGBridgeMsgVersion getVersion() {
        return this.version;
    }

    public long getUniqueID() {
        return this.uniqueID;
    }

    public String getSendingBridgeServer() {
        return this.sendingBridgeServer;
    }

    public String toString() {
        return this.sendingBridgeServer + ":" + this.fullyQualifiedCGName + ":" + this.originAPG + ":" + this.state.getName() + ":" + this.uniqueID;
    }

    public String getTargetCoreGroup() {
        return this.targetCoreGroup;
    }
}

