/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.util;

import com.ibm.ws.cgbridge.core.CGBridgeBulletinBoardScopeData;
import com.ibm.ws.cgbridge.core.impl.CGBridgeService;
import com.ibm.ws.cgbridge.msg.CGBridgeRemoteData;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CGBridgeUtils {
    private static long postID = 0L;
    private static Object postIDLock = new Object();
    public static final String DELIMITER = ":";
    public static final String HA_DELIMITER = "\\";

    public static String generateCGKey(String string, String string2) {
        return string + DELIMITER + string2;
    }

    public static int determineMembertoSend(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = Math.abs(n % n2);
        return n3;
    }

    public static String generateSubjPostSNHash(int n, String string) {
        return n + string;
    }

    public static String getFullCoregroupName(GroupMemberId groupMemberId) {
        String string = (String)groupMemberId.getMemberProperties().get("CELLNAME");
        String string2 = (String)groupMemberId.getMemberProperties().get("COREGROUPNAME");
        return CGBridgeUtils.generateCGKey(string, string2);
    }

    public static String getCellName(String string) {
        if (string == null) {
            return null;
        }
        return string.split(DELIMITER)[0];
    }

    public static String getFullServerName(GroupMemberId groupMemberId) {
        if (groupMemberId == null) {
            return null;
        }
        String string = (String)groupMemberId.getMemberProperties().get("CELLNAME");
        String string2 = (String)groupMemberId.getMemberProperties().get("NODENAME");
        String string3 = (String)groupMemberId.getMemberProperties().get("serverid");
        if (string == null || string2 == null || string3 == null) {
            return groupMemberId.getServerName();
        }
        StringBuffer stringBuffer = new StringBuffer().append(string).append(HA_DELIMITER).append(string2).append(HA_DELIMITER).append(string3);
        return stringBuffer.toString();
    }

    public static String getFullServerName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer().append(string).append(HA_DELIMITER).append(string2).append(HA_DELIMITER).append(string3);
        return stringBuffer.toString();
    }

    public static boolean isTrue(String string) {
        return string.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static boolean isFalse(String string) {
        return string.equalsIgnoreCase(Boolean.FALSE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void seedUniqueIdentifier(long l) {
        Object object = postIDLock;
        synchronized (object) {
            postID = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueIdentifier() {
        Object object = postIDLock;
        synchronized (object) {
        }
        return ++postID;
    }

    public static String getCaseInsensitiveCustomProperty(Map map, String string) {
        if (map == null || string == null) {
            return null;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (String)map.get(string2);
        }
        return null;
    }

    public static Set getServerNames(GroupMemberId[] groupMemberIdArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (groupMemberIdArray != null && groupMemberIdArray.length > 0) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                hashSet.add(CGBridgeUtils.getFullServerName(groupMemberIdArray[i]));
            }
        }
        return hashSet;
    }

    public static Set getSubset(Set set, int n) {
        HashSet hashSet;
        if (set != null) {
            hashSet = new HashSet();
            Iterator iterator = set.iterator();
            for (int i = 0; iterator.hasNext() && i < n; ++i) {
                hashSet.add(iterator.next());
            }
        } else {
            return null;
        }
        return hashSet;
    }

    public static final String createKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("$");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static Integer getCellScopedLookUpKey(CGBridgeRemoteData cGBridgeRemoteData, CGBridgeBulletinBoardScopeData cGBridgeBulletinBoardScopeData) {
        String string;
        byte by = cGBridgeBulletinBoardScopeData.getCGBridgeScopeType();
        if (cGBridgeBulletinBoardScopeData.getCellName().equals("null")) {
            string = CGBridgeService.getInstance().getCGBridgeConfig().getCellName();
        } else {
            if (cGBridgeBulletinBoardScopeData.getCellName().equals(CGBridgeService.getInstance().getCGBridgeConfig().getCellName())) {
                by = 1;
            }
            string = cGBridgeBulletinBoardScopeData.getCellName();
        }
        return CGBridgeUtils.getLookUpKey(cGBridgeRemoteData, by, string);
    }

    public static Integer getLookUpKey(CGBridgeRemoteData cGBridgeRemoteData, byte by, String string) {
        return new Integer(cGBridgeRemoteData.getSubjectHashCode() + by + string.hashCode());
    }
}

