/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public abstract class CGBCommand
extends AbstractAdminCommand {
    private static TraceComponent tc = CGBCommandUtils.register(CGBCommand.class);

    public CGBCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public CGBCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    protected ConfigService getConfigService() {
        return CommandMgr.getCommandMgr().getCommandProviderHelper().getConfigService();
    }

    protected String determineType(ObjectName objectName) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        Object object;
        String string = ConfigServiceHelper.getConfigDataType((ObjectName)objectName);
        if (string == null) {
            Session session;
            ObjectName[] objectNameArray;
            if (tc.isDebugEnabled()) {
                object = new StringBuffer();
                ((StringBuffer)object).append("could not get type information for ");
                ((StringBuffer)object).append(CGBCommand.convertON(objectName));
                ((StringBuffer)object).append(", attempting to resolve against ConfigService");
                Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
            }
            if ((objectNameArray = (object = this.getConfigService()).queryConfigObjects(session = this.getConfigSession(), null, objectName, null)) != null && objectNameArray.length == 1) {
                string = ConfigServiceHelper.getConfigDataType((ObjectName)objectNameArray[0]);
            }
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getting type information from attributes");
                }
                AttributeList attributeList = object.getAttributes(session, objectName, null, false);
                string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"_Websphere_Config_Data_Type");
            }
        }
        if (tc.isDebugEnabled()) {
            object = new StringBuffer();
            ((StringBuffer)object).append("type information for ");
            ((StringBuffer)object).append(CGBCommand.convertON(objectName));
            if (string == null) {
                ((StringBuffer)object).append(" could not be determined");
            } else {
                ((StringBuffer)object).append(" determined to be ");
                ((StringBuffer)object).append(string);
            }
            Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
        }
        return string;
    }

    protected boolean checkType(ObjectName objectName, String string, boolean bl) throws ConfigServiceException, AttributeNotFoundException, ConnectorException {
        return this.checkType(objectName, new String[]{string}, bl);
    }

    protected boolean checkType(ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException, AttributeNotFoundException, ConnectorException {
        String string = this.determineType(objectName);
        if (string == null) {
            return bl;
        }
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateType(ObjectName objectName, String string, String string2) throws InvalidParameterValueException {
        block5: {
            boolean bl = false;
            try {
                bl = this.checkType(objectName, string, false);
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                if (bl) break block5;
                throw new InvalidParameterValueException(this.getName(), string2, (Object)objectName);
            }
        }
    }

    protected static ObjectName createObjectName(String string) {
        ObjectName objectName = null;
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n > 0 && n2 > 0) {
            String string2 = string.substring(n + 1, n2);
            objectName = ConfigServiceHelper.createObjectName((ConfigDataId)new ConfigDataId(string2));
        }
        return objectName;
    }

    protected static String convertON(ObjectName objectName) {
        if (objectName == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
        String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Id");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append('(');
        stringBuffer.append(string2);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected static String convertONs(Collection collection) {
        if (null == collection) {
            return null;
        }
        Object var1_1 = null;
        ObjectName objectName = null;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        stringBuffer.append("{ ");
        while (iterator.hasNext()) {
            objectName = null;
            var1_1 = iterator.next();
            if (var1_1 instanceof AttributeList) {
                objectName = ConfigServiceHelper.createObjectName((AttributeList)var1_1);
                stringBuffer.append(CGBCommand.convertON(objectName) + " ");
                continue;
            }
            if (var1_1 instanceof ObjectName) {
                objectName = var1_1;
                stringBuffer.append(CGBCommand.convertON(objectName) + " ");
                continue;
            }
            stringBuffer.append(var1_1 + " ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected List getConfigDataIds(List list) {
        ArrayList<ConfigDataId> arrayList = new ArrayList<ConfigDataId>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            arrayList.add(ConfigServiceHelper.getConfigDataId((ObjectName)objectName));
        }
        return arrayList;
    }
}

