/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;

public class CGBCommandUtils {
    private static TraceComponent tc = CGBCommandUtils.register(CGBCommandUtils.class);

    public static TraceComponent register(Class clazz) {
        return Tr.register((Class)clazz, (String)"CoreGroupBridgeAdmin", (String)"com.ibm.ws.coregroup.bridge.resources.coregroupbridgeadmin");
    }

    public static Set getNames(ConfigService configService, Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        HashSet<Object> hashSet = new HashSet<Object>();
        List list = (List)configService.getAttribute(session, objectName, string, false);
        for (int i = 0; i < list.size(); ++i) {
            ObjectName objectName2 = (ObjectName)list.get(i);
            hashSet.add(configService.getAttribute(session, objectName2, "name"));
        }
        return hashSet;
    }

    public static boolean validateNameUniqueness(ConfigService configService, Session session, ObjectName objectName, String string, String string2) throws ConfigServiceException, ConnectorException {
        return !CGBCommandUtils.getNames(configService, session, objectName, string).contains(string2);
    }

    static ObjectName getDCSChannelChain(ConfigService configService, Session session, String string, String string2, String string3) throws ConfigServiceException, ConnectorException, CommandNotFoundException, CommandException, InvalidParameterValueException, InvalidParameterNameException {
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
        if (0 == objectNameArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"error.zero.Servers", (Object)new Object[]{string, string2});
            }
            return null;
        }
        if (1 < objectNameArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"error.multiple.Servers", (Object)new Object[]{string, string2});
            }
            return null;
        }
        ObjectName objectName = CGBCommandUtils.getTransportChannelServiceON(configService, session, objectNameArray[0]);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"Chain", (String)string3);
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[0], objectName2, null);
        if (objectNameArray2.length != 1 && tc.isDebugEnabled()) {
            Tr.error((TraceComponent)tc, (String)"error.resolve.ChannelChain", (Object)new Object[]{string3, string, string2});
        }
        return objectNameArray2[0];
    }

    static ObjectName getTransportChannelServiceON(ConfigService configService, Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"TransportChannelService");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        if (objectNameArray == null || objectNameArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"could not find any instances of TransportChannelService in {0}", (Object)CGBCommand.convertON(objectName));
            }
            return null;
        }
        if (objectNameArray.length > 1 && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"multiple instances of TransportChannelService discovered in {0}", (Object)CGBCommand.convertON(objectName));
        }
        return objectNameArray[0];
    }
}

