/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class CreateCoreGroupAccessPointCommand
extends CGBCommand {
    private static TraceComponent tc = CGBCommandUtils.register(CreateCoreGroupAccessPointCommand.class);

    public CreateCoreGroupAccessPointCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public CreateCoreGroupAccessPointCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        this.validateType(objectName, "CoreGroupBridgeSettings", "target");
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            AttributeList attributeList;
            this.validate();
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = (ObjectName)this.getTargetObject();
            String string = (String)this.getParameter("coreGroupName");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cgbridgeSettingsON:" + CreateCoreGroupAccessPointCommand.convertON(objectName)));
                Tr.debug((TraceComponent)tc, (String)("coreGroupName:" + string));
            }
            ObjectName objectName2 = this.findOrCreateDefaultAccessPointGroup(objectName, session, configService);
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = null;
            List list = (List)configService.getAttribute(session, objectName, "coreGroupAccessPoints");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                attributeList = (AttributeList)iterator.next();
                string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
                hashSet.add(string2);
            }
            while (hashSet.contains(string2 = this.getCandidateCGAPName(string2))) {
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating  CoreGroupAccessPoint:" + string2 + " with CoreGroup:" + string + " in the DefaultAccessPointGroup"));
            }
            attributeList = new AttributeList();
            attributeList.add(new Attribute("name", string2));
            attributeList.add(new Attribute("coreGroup", string));
            ObjectName objectName3 = configService.createConfigData(session, objectName, "coreGroupAccessPoints", "CoreGroupAccessPoint", attributeList);
            List list2 = (List)configService.getAttribute(session, objectName2, "coreGroupAccessPointRefs");
            list2.add(objectName3);
            AttributeList attributeList2 = new AttributeList();
            attributeList2.add(new Attribute("coreGroupAccessPointRefs", list2));
            configService.setAttributes(session, objectName2, attributeList2);
            if (tc.isDebugEnabled()) {
                list2 = (List)configService.getAttribute(session, objectName2, "coreGroupAccessPointRefs");
                Tr.debug((TraceComponent)tc, (String)("Modified List of CGAP references for the default APG" + CreateCoreGroupAccessPointCommand.convertONs(list2)));
            }
        }
        catch (CommandValidationException commandValidationException) {
            commandResultImpl.setException((Throwable)commandValidationException);
        }
        catch (ConnectorException connectorException) {
            commandResultImpl.setException((Throwable)connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            commandResultImpl.setException((Throwable)configServiceException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            commandResultImpl.setException((Throwable)attributeNotFoundException);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }

    private ObjectName findOrCreateDefaultAccessPointGroup(ObjectName objectName, Session session, ConfigService configService) throws ConnectorException, ConfigServiceException {
        AttributeList attributeList;
        ObjectName objectName2 = null;
        List list = (List)configService.getAttribute(session, objectName, "accessPointGroups");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            attributeList = (AttributeList)iterator.next();
            ObjectName objectName3 = ConfigServiceHelper.createObjectName((AttributeList)attributeList);
            String string = (String)configService.getAttribute(session, objectName3, "name");
            if (!string.toLowerCase().startsWith("default")) continue;
            objectName2 = objectName3;
            break;
        }
        if (null == objectName2) {
            attributeList = new AttributeList();
            attributeList.add(new Attribute("name", "DefaultAccessPointGroup"));
            objectName2 = configService.createConfigData(session, objectName, "accessPointGroups", "AccessPointGroup", attributeList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not find the DefaultAccessPointGroup. Created a new one:" + CreateCoreGroupAccessPointCommand.convertON(objectName2)));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DefaultAccessPointGroup:" + CreateCoreGroupAccessPointCommand.convertON(objectName2) + " already exists"));
        }
        return objectName2;
    }

    protected String getCandidateCGAPName(String string) {
        int n;
        String string2;
        if (string == null) {
            string2 = "Default_CGAP_1";
            n = 1;
        } else {
            int n2 = string.lastIndexOf(95);
            if (n2 < 0) {
                string2 = string;
                n = 1;
            } else {
                string2 = string.substring(0, n2);
                if (!string.endsWith("_")) {
                    try {
                        n = Integer.parseInt(string.substring(n2 + 1)) + 1;
                    }
                    catch (Exception exception) {
                        string2 = string;
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append('_');
        stringBuffer.append(n);
        return stringBuffer.toString();
    }
}

