/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class DeleteCoreGroupAccessPointsCommand
extends CGBCommand {
    private static TraceComponent tc = CGBCommandUtils.register(DeleteCoreGroupAccessPointsCommand.class);

    public DeleteCoreGroupAccessPointsCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public DeleteCoreGroupAccessPointsCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        this.validateType(objectName, "CoreGroupBridgeSettings", "target");
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = (ObjectName)this.getTargetObject();
            String string = (String)this.getParameter("coreGroupName");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cgbridgeSettingsON:" + DeleteCoreGroupAccessPointsCommand.convertON(objectName)));
                Tr.debug((TraceComponent)tc, (String)("coreGroupName:" + string));
            }
            String string2 = null;
            String string3 = null;
            List list = (List)configService.getAttribute(session, objectName, "coreGroupAccessPoints");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                ObjectName objectName2 = ConfigServiceHelper.createObjectName((AttributeList)attributeList);
                string3 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
                string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"coreGroup");
                if (!string2.equals(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Deleting CoreGroupAccessPoint:" + DeleteCoreGroupAccessPointsCommand.convertON(objectName2)));
                }
                configService.deleteConfigData(session, objectName2);
            }
        }
        catch (CommandValidationException commandValidationException) {
            commandResultImpl.setException((Throwable)commandValidationException);
        }
        catch (ConnectorException connectorException) {
            commandResultImpl.setException((Throwable)connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            commandResultImpl.setException((Throwable)configServiceException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            commandResultImpl.setException((Throwable)attributeNotFoundException);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }
}

