/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class GetNamedTCPEndPointCommand
extends CGBCommand {
    private static TraceComponent tc = CGBCommandUtils.register(GetNamedTCPEndPointCommand.class);

    public GetNamedTCPEndPointCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public GetNamedTCPEndPointCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        this.validateType(objectName, "BridgeInterface", "bridgeInterfaceName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = (ObjectName)this.getTargetObject();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BridgeInterface ObjectName:" + GetNamedTCPEndPointCommand.convertON(objectName)));
            }
            ObjectName objectName2 = GetNamedTCPEndPointCommand.getNamedEndPoint(session, configService, objectName);
            commandResultImpl.setResult((Object)objectName2);
        }
        catch (CommandValidationException commandValidationException) {
            commandResultImpl.setException((Throwable)commandValidationException);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            commandResultImpl.setException((Throwable)commandNotFoundException);
        }
        catch (CommandException commandException) {
            commandResultImpl.setException((Throwable)commandException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            commandResultImpl.setException((Throwable)malformedObjectNameException);
        }
        catch (ConfigServiceException configServiceException) {
            commandResultImpl.setException((Throwable)configServiceException);
        }
        catch (ConnectorException connectorException) {
            commandResultImpl.setException((Throwable)connectorException);
        }
        finally {
            this.setCommandResult((CommandResult)commandResultImpl);
        }
    }

    private static ObjectName getNamedEndPoint(Session session, ConfigService configService, ObjectName objectName) throws CommandNotFoundException, CommandException, InvalidParameterValueException, MalformedObjectNameException, ConfigServiceException, ConnectorException {
        ObjectName objectName2 = null;
        String string = (String)configService.getAttribute(session, objectName, "node");
        String string2 = (String)configService.getAttribute(session, objectName, "server");
        String string3 = (String)configService.getAttribute(session, objectName, "chain");
        AdminCommand adminCommand = CommandMgr.getCommandMgr().createCommand("getTCPEndPoint");
        ObjectName objectName3 = CGBCommandUtils.getDCSChannelChain(configService, session, string, string2, string3);
        if (null != objectName3) {
            adminCommand.setTargetObject((Object)objectName3);
            adminCommand.execute();
            if (adminCommand.getCommandResult().isSuccessful()) {
                objectName2 = (ObjectName)adminCommand.getCommandResult().getResult();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while listing TCPChannels Named EndPoints:" + adminCommand.getCommandResult().getException()));
            }
        }
        return objectName2;
    }
}

