/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListCoreGroupsCommand
extends CGBCommand {
    private static TraceComponent tc = CGBCommandUtils.register(ListCoreGroupsCommand.class);

    public ListCoreGroupsCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public ListCoreGroupsCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getParameter("cgBridgeSettings");
        this.validateType(objectName, "CoreGroupBridgeSettings", "cgBridgeSettings");
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            this.validate();
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            String string = (String)this.getTargetObject();
            ObjectName objectName = (ObjectName)this.getParameter("cgBridgeSettings");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("myCGName:" + string));
                Tr.debug((TraceComponent)tc, (String)("cgbridgeSettingsON:" + ListCoreGroupsCommand.convertON(objectName)));
            }
            List list = (List)configService.getAttribute(session, objectName, "accessPointGroups");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("allAccessPointGroups:" + ListCoreGroupsCommand.convertONs(list)));
            }
            HashSet hashSet = new HashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    this.displayConfigServiceAttributes((AttributeList)object3);
                }
                serializable = ConfigServiceHelper.createObjectName((AttributeList)object3);
                Tr.debug((TraceComponent)tc, (String)("Finding related AccessPoints in  in AccessPointGroup " + ListCoreGroupsCommand.convertON((ObjectName)serializable)));
                object2 = (List)configService.getAttribute(session, (ObjectName)serializable, "coreGroupAccessPointRefs");
                object = (List)configService.getAttribute(session, (ObjectName)serializable, "peerAccessPointRefs");
                this.addToAccessPointFamily(hashSet, string, (List)object2, (List)object, session, configService);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Related APs:" + ListCoreGroupsCommand.convertONs(hashSet)));
            }
            object3 = hashSet.iterator();
            serializable = new HashSet();
            while (object3.hasNext()) {
                object2 = (ObjectName)object3.next();
                object = (String)configService.getAttribute(session, (ObjectName)object2, "coreGroup");
                if (((String)object).equals(string)) continue;
                serializable.add(object);
            }
            commandResultImpl.setResult((Object)serializable);
        }
        catch (CommandValidationException commandValidationException) {
            commandResultImpl.setException((Throwable)commandValidationException);
        }
        catch (ConnectorException connectorException) {
            commandResultImpl.setException((Throwable)connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            commandResultImpl.setException((Throwable)configServiceException);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }

    private void addToAccessPointFamily(Set set, String string, List list, List list2, Session session, ConfigService configService) throws ConnectorException, ConfigServiceException {
        Object object;
        Object object2;
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (ObjectName)iterator.next();
            object = (String)configService.getAttribute(session, (ObjectName)object2, "coreGroup");
            if (!((String)object).equals(string)) continue;
            bl = true;
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("matched CG found with CGAP " + ListCoreGroupsCommand.convertON((ObjectName)object2)));
            break;
        }
        if (!bl) {
            object2 = list2.iterator();
            while (iterator.hasNext()) {
                object = (ObjectName)object2.next();
                String string2 = (String)configService.getAttribute(session, (ObjectName)object, "coreGroup");
                if (!string2.equals(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("matched CG found with PAP " + ListCoreGroupsCommand.convertON((ObjectName)object)));
                }
                bl = true;
                break;
            }
        }
        if (bl) {
            set.addAll(list);
            set.addAll(list2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("familyMember: " + bl));
        }
    }

    private void displayConfigServiceAttributes(AttributeList attributeList) {
        ConfigDataId configDataId = null;
        try {
            Tr.debug((TraceComponent)tc, (String)"displayConfigServiceAttributes() invokes methods called by ConfigServiceHelper.createObjectName for this Access Point Group:");
            Tr.debug((TraceComponent)tc, (String)"  SystemAttributes._WEBSPHERE_CONFIG_DATA_ID (_Websphere_Config_Data_Id)");
            configDataId = (ConfigDataId)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"_Websphere_Config_Data_Id");
            Tr.debug((TraceComponent)tc, (String)("    value = " + configDataId));
            Tr.debug((TraceComponent)tc, (String)"  SystemAttributes._WEBSPHERE_CONFIG_DATA_TYPE (_Websphere_Config_Data_Type)");
            String string = null;
            string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"_Websphere_Config_Data_Type");
            Tr.debug((TraceComponent)tc, (String)("    value = " + string));
            Tr.debug((TraceComponent)tc, (String)"  SystemAttributes._WEBSPHERE_CONFIG_DATA_DISPLAY_NAME (_Websphere_Config_Data_Display_Name)");
            String string2 = null;
            string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"_Websphere_Config_Data_Display_Name");
            Tr.debug((TraceComponent)tc, (String)("    value = " + string2));
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Caught exception using ConfigServiceHelper");
        }
    }
}

