/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import com.ibm.ws.coregroup.bridge.commands.exceptions.MultipleMatchingCoreGroupsException;
import com.ibm.ws.coregroup.bridge.commands.exceptions.NoMatchingCoreGroupException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ListEligibleBridgeInterfacesCommand
extends CGBCommand {
    private static TraceComponent tc = CGBCommandUtils.register(ListEligibleBridgeInterfacesCommand.class);

    public ListEligibleBridgeInterfacesCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public ListEligibleBridgeInterfacesCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        this.validateType(objectName, "CoreGroupAccessPoint", "coreGroupAccessPointName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            Collection<Object> collection;
            AdminCommand adminCommand = CommandMgr.getCommandMgr().createCommand("listChains");
            AdminCommand adminCommand2 = CommandMgr.getCommandMgr().createCommand("getTCPEndPoint");
            this.validate();
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            adminCommand.setConfigSession(session);
            ObjectName objectName = (ObjectName)this.getTargetObject();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("input cgapON:" + ListEligibleBridgeInterfacesCommand.convertON(objectName)));
            }
            String string = (String)configService.getAttribute(session, objectName, "coreGroup");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("coreGroup:" + string));
            }
            ObjectName[] objectNameArray = this.getCoreGroupON(configService, session, string);
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = (String)configService.getAttribute(session, objectNameArray[0], "channelChainName");
            List list = (List)configService.getAttribute(session, objectNameArray[0], "coreGroupServers");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                collection = (AttributeList)iterator.next();
                String string3 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)collection, (String)"nodeName");
                String string4 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)collection, (String)"serverName");
                List list2 = null;
                ObjectName objectName2 = configService.resolve(session, "Node=" + string3 + ":Server=" + string4)[0];
                ObjectName objectName3 = CGBCommandUtils.getTransportChannelServiceON(configService, session, objectName2);
                adminCommand.setTargetObject((Object)objectName3);
                adminCommand.setParameter("acceptorFilter", (Object)"DCSInboundChannel");
                adminCommand.execute();
                if (adminCommand.getCommandResult().isSuccessful()) {
                    list2 = (List)adminCommand.getCommandResult().getResult();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        ObjectName objectName4 = (ObjectName)iterator2.next();
                        String string5 = ListEligibleBridgeInterfacesCommand.convertON(objectName4);
                        String string6 = (String)configService.getAttribute(session, objectName4, "name");
                        if (!string6.equals(string2)) continue;
                        hashSet.add(string3 + " " + string4 + " " + string5);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Exception while listing DCS channel chains:" + adminCommand.getCommandResult().getException()));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("All CoreGroup BridgeInterfaces:" + hashSet));
            }
            if (this.isFirstBridgeInterfaceInCoreGroup(session, configService, string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No Bridge Interfaces in the CoreGroup. Returning all node/server/DCS channel chains in the CoreGroup");
                }
            } else {
                collection = this.getCGAPBridgeInterfaces(objectName, configService, session);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CGAP BridgeInterfaces:" + collection));
                }
                hashSet.removeAll(collection);
                this.removeBIsWithDifferentNamedEPs(session, configService, hashSet, (Set)collection, adminCommand2);
            }
            commandResultImpl.setResult(hashSet);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Eligible BridgeInterfaces:" + hashSet));
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            commandResultImpl.setException((Throwable)attributeNotFoundException);
        }
        catch (CommandValidationException commandValidationException) {
            commandResultImpl.setException((Throwable)commandValidationException);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            commandResultImpl.setException((Throwable)commandNotFoundException);
        }
        catch (CommandException commandException) {
            commandResultImpl.setException((Throwable)commandException);
        }
        catch (ConnectorException connectorException) {
            commandResultImpl.setException((Throwable)connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            commandResultImpl.setException((Throwable)configServiceException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            commandResultImpl.setException((Throwable)malformedObjectNameException);
        }
        catch (NoMatchingCoreGroupException noMatchingCoreGroupException) {
            commandResultImpl.setException((Throwable)noMatchingCoreGroupException);
        }
        catch (MultipleMatchingCoreGroupsException multipleMatchingCoreGroupsException) {
            commandResultImpl.setException((Throwable)multipleMatchingCoreGroupsException);
        }
        finally {
            this.setCommandResult((CommandResult)commandResultImpl);
        }
    }

    private Set getCGAPBridgeInterfaces(ObjectName objectName, ConfigService configService, Session session) throws AttributeNotFoundException, InvalidParameterValueException, InvalidParameterNameException, CommandNotFoundException, ConfigServiceException, CommandException, ConnectorException {
        HashSet<String> hashSet = new HashSet<String>();
        List list = (List)configService.getAttribute(session, objectName, "bridgeInterfaces");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList = (AttributeList)iterator.next();
            String string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"node");
            String string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"server");
            String string3 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"chain");
            ObjectName objectName2 = CGBCommandUtils.getDCSChannelChain(configService, session, string, string2, string3);
            hashSet.add(string + " " + string2 + " " + ListEligibleBridgeInterfacesCommand.convertON(objectName2));
        }
        return hashSet;
    }

    private ObjectName[] getCoreGroupON(ConfigService configService, Session session, String string) throws ConfigServiceException, ConnectorException, NoMatchingCoreGroupException, MultipleMatchingCoreGroupsException {
        ObjectName[] objectNameArray = configService.resolve(session, "CoreGroup=" + string);
        if (objectNameArray.length == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("coreGroupON:" + objectNameArray[0]));
            }
        } else {
            if (objectNameArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.zero.coreGroups", (Object)new Object[]{string});
                }
                throw new NoMatchingCoreGroupException("CoreGroup " + string + " was not found");
            }
            if (tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"error.multiple.coreGroups", (Object)new Object[]{string});
            }
            throw new MultipleMatchingCoreGroupsException("More than one CoreGroups with the same name " + string + " were found");
        }
        return objectNameArray;
    }

    private boolean isFirstBridgeInterfaceInCoreGroup(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException {
        boolean bl = true;
        ObjectName objectName = this.getCoreGroupBridgeSettingsON(session, configService);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CGBS ON:" + ListEligibleBridgeInterfacesCommand.convertON(objectName)));
        }
        List list = (List)configService.getAttribute(session, objectName, "coreGroupAccessPoints");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            AttributeList attributeList = (AttributeList)iterator.next();
            ObjectName objectName2 = ConfigServiceHelper.createObjectName((AttributeList)attributeList);
            String string2 = (String)configService.getAttribute(session, objectName2, "coreGroup");
            if (!string2.equals(string) || (list2 = (List)configService.getAttribute(session, objectName2, "bridgeInterfaces")).size() <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BridgeInterfaces found for CoreGroup:" + string));
            }
            bl = false;
            break;
        }
        return bl;
    }

    private void removeBIsWithDifferentNamedEPs(Session session, ConfigService configService, Set set, Set set2, AdminCommand adminCommand) throws InvalidParameterValueException, CommandNotFoundException, CommandException, MalformedObjectNameException, ConfigServiceException, ConnectorException {
        Object object;
        Object object2;
        Object object3;
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            object2 = this.getNamedEndPoint(session, configService, (String)object3, adminCommand);
            if (null == object2) continue;
            object = (String)configService.getAttribute(session, (ObjectName)object2, "endPointName");
            hashSet.add(object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CGAP Named Endpoints:" + hashSet));
        }
        object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = this.getNamedEndPoint(session, configService, (String)object2, adminCommand);
            if (null == object) continue;
            String string = (String)configService.getAttribute(session, (ObjectName)object, "endPointName");
            if (0 == hashSet.size() || hashSet.contains(string)) continue;
            set.remove(object2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Removed BridgeInterface" + (String)object2 + " because of differing NamedEndPoint" + string));
        }
    }

    private ObjectName getNamedEndPoint(Session session, ConfigService configService, String string, AdminCommand adminCommand) throws CommandNotFoundException, CommandException, ConnectorException, InvalidParameterValueException, MalformedObjectNameException {
        ObjectName objectName = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (null != string2) {
            ObjectName objectName2 = ListEligibleBridgeInterfacesCommand.createObjectName(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ChainON:" + ListEligibleBridgeInterfacesCommand.convertON(objectName2)));
            }
            if (null != objectName2) {
                adminCommand.setTargetObject((Object)ListEligibleBridgeInterfacesCommand.createObjectName(string2));
                adminCommand.execute();
                if (adminCommand.getCommandResult().isSuccessful()) {
                    objectName = (ObjectName)adminCommand.getCommandResult().getResult();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception while listing TCPChannels Named EndPoints:" + adminCommand.getCommandResult().getException()));
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Could not resolve namedEndPoint for the BridgeInterface:" + string));
        }
        return objectName;
    }

    private ObjectName getCoreGroupBridgeSettingsON(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, (String)"CoreGroupBridgeSettings");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray == null || objectNameArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"error.zero.coreGroupBridgeSettings");
            }
            return null;
        }
        return objectNameArray[0];
    }
}

