/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.coregroup.bridge.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.coregroup.bridge.commands.CGBCommand;
import com.ibm.ws.coregroup.bridge.commands.CGBCommandUtils;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class RemoveCoreGroupBridgeInterfaceCommand
extends CGBCommand {
    private static TraceComponent tc = CGBCommandUtils.register(RemoveCoreGroupBridgeInterfaceCommand.class);

    public RemoveCoreGroupBridgeInterfaceCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public RemoveCoreGroupBridgeInterfaceCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        this.validateType(objectName, "CoreGroupBridgeSettings", "target");
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = (ObjectName)this.getTargetObject();
            String string = (String)this.getParameter("coreGroupName");
            String string2 = (String)this.getParameter("nodeName");
            String string3 = (String)this.getParameter("serverName");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cgbridgeSettingsON:" + RemoveCoreGroupBridgeInterfaceCommand.convertON(objectName)));
                Tr.debug((TraceComponent)tc, (String)("coreGroupName:" + string));
                Tr.debug((TraceComponent)tc, (String)("nodeName:" + string2));
                Tr.debug((TraceComponent)tc, (String)("serverName:" + string3));
            }
            String string4 = null;
            List list = (List)configService.getAttribute(session, objectName, "coreGroupAccessPoints");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                string4 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"coreGroup");
                ObjectName objectName2 = ConfigServiceHelper.createObjectName((AttributeList)attributeList);
                if (!string4.equals(string)) continue;
                List list2 = (List)configService.getAttribute(session, objectName2, "bridgeInterfaces");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CGAP BridgeInterfaces:" + list2));
                }
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    AttributeList attributeList2 = (AttributeList)iterator2.next();
                    String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"node");
                    String string6 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"server");
                    if (!string2.equals(string5) || !string3.equals(string6)) continue;
                    ObjectName objectName3 = ConfigServiceHelper.createObjectName((AttributeList)attributeList2);
                    configService.deleteConfigData(session, objectName3);
                }
            }
        }
        catch (CommandValidationException commandValidationException) {
            commandResultImpl.setException((Throwable)commandValidationException);
        }
        catch (ConnectorException connectorException) {
            commandResultImpl.setException((Throwable)connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            commandResultImpl.setException((Throwable)configServiceException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            commandResultImpl.setException((Throwable)attributeNotFoundException);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }
}

