/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Hashtable list = new Hashtable();

    public ParameterList() {
    }

    public ParameterList(String s) throws ParseException {
        HeaderTokenizer h = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        while (true) {
            HeaderTokenizer.Token tk;
            int type;
            if ((type = (tk = h.next()).getType()) == -4) {
                return;
            }
            if ((char)type != ';') break;
            tk = h.next();
            if (tk.getType() == -4) {
                return;
            }
            if (tk.getType() != -1) {
                throw new ParseException();
            }
            String name = tk.getValue().toLowerCase();
            tk = h.next();
            if ((char)tk.getType() != '=') {
                throw new ParseException();
            }
            tk = h.next();
            type = tk.getType();
            if (type != -1 && type != -2) {
                throw new ParseException();
            }
            this.list.put(name, tk.getValue());
        }
        throw new ParseException();
    }

    public int size() {
        return this.list.size();
    }

    public String get(String name) {
        return (String)this.list.get(name.trim().toLowerCase());
    }

    public void set(String name, String value) {
        this.list.put(name.trim().toLowerCase(), value);
    }

    public void remove(String name) {
        this.list.remove(name.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.list.keys();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.list.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.quote((String)this.list.get(name));
            sb.append("; ");
            int len = name.length() + value.length() + 1;
            if ((used += 2) + len > 76) {
                sb.append("\r\n\t");
                used = 8;
            }
            sb.append(name).append('=');
            if ((used += name.length() + 1) + value.length() > 76) {
                String s = MimeUtility.fold(used, value);
                sb.append(s);
                int lastlf = s.lastIndexOf(10);
                if (lastlf >= 0) {
                    used += s.length() - lastlf - 1;
                    continue;
                }
                used += s.length();
                continue;
            }
            sb.append(value);
            used += value.length();
        }
        return sb.toString();
    }

    private String quote(String value) {
        return MimeUtility.quote(value, "()<>@,;:\\\"\t []/?=");
    }
}

