/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.commons.html.wrapper;

import com.ibm.watson.commons.html.parseutils.ParseCorrect;
import com.ibm.watson.commons.html.parseutils.ParseError;
import com.ibm.watson.commons.html.parseutils.ParseResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RobustHTMLParser {
    private static final String copyright = "Licensed Materials - Property of IBM\nIEHS-311\n(c) Copyright IBM Corporation 2006.\nAll rights reserved.\nUS Government Users Restricted Right - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with\nIBM Corporation.";

    private RobustHTMLParser() {
    }

    public static List parse(String s) {
        LinkedList<Object> result = new LinkedList<Object>();
        int c = 0;
        while (c < s.length()) {
            ParseResult parsedTag;
            int posOpenBracket = c;
            boolean first = true;
            do {
                posOpenBracket = s.indexOf(60, posOpenBracket + (first ? 0 : 1));
                first = false;
            } while (posOpenBracket >= 0 && posOpenBracket != s.length() - 1 && Character.isWhitespace(s.charAt(posOpenBracket + 1)));
            if (posOpenBracket < 0 || posOpenBracket == s.length() - 1) {
                result.add(new Text(s.substring(c)));
                c = s.length();
                continue;
            }
            if (posOpenBracket != c) {
                result.add(new Text(s.substring(c, posOpenBracket)));
            }
            if ((parsedTag = RobustHTMLParser.parseTag(s, posOpenBracket)) instanceof ParseError) {
                int recovery = parsedTag.getRemainderAsInt();
                if (recovery == -1) {
                    recovery = s.length();
                }
                result.add(new Text(s.substring(posOpenBracket, recovery - 1)));
                c = recovery;
                continue;
            }
            result.add(parsedTag.getParsedValue());
            c = parsedTag.getRemainderAsInt();
        }
        return result;
    }

    protected static ParseResult parseTag(String s, int bracketPos) {
        if (s.charAt(bracketPos + 1) == '/') {
            ParseResult newPos = RobustHTMLParser.consumeWhiteSpace(s, bracketPos + 2);
            ParseResult parsedName = RobustHTMLParser.parseName(s, newPos.getRemainderAsInt());
            if (parsedName instanceof ParseError) {
                return new ParseError("Bad name", parsedName.getRemainder());
            }
            ParseResult finalPos = RobustHTMLParser.consumeUntil(s, parsedName.getRemainderAsInt(), new Character[]{new Character('>')});
            if (parsedName instanceof ParseError) {
                return new ParseError("Tag '" + parsedName.getParsedValue() + "' without '>'", finalPos.getRemainder());
            }
            return new ParseCorrect(new CloseTag((String)parsedName.getParsedValue()), new Integer(finalPos.getRemainderAsInt() + 1));
        }
        if (s.charAt(bracketPos + 1) == '!') {
            ParseResult newPos = RobustHTMLParser.consumeWhiteSpace(s, bracketPos + 2);
            int c = newPos.getRemainderAsInt();
            if (s.charAt(c) == '-' && s.charAt(c + 1) == '-') {
                ParseResult dashesPos = RobustHTMLParser.consumeUntil(s, c += 2, new Character[]{new Character('-')});
                while (dashesPos instanceof ParseCorrect && dashesPos.getRemainderAsInt() < s.length() && s.charAt(dashesPos.getRemainderAsInt()) != '-') {
                    c = dashesPos.getRemainderAsInt() + 1;
                    dashesPos = RobustHTMLParser.consumeUntil(s, c, new Character[]{new Character('-')});
                }
                if (dashesPos instanceof ParseError || dashesPos.getRemainderAsInt() == s.length()) {
                    return new ParseError("Unfinished comment run past end of file.", new Integer(s.length()));
                }
                c = dashesPos.getRemainderAsInt() + 2;
            }
            ParseResult finalPos = RobustHTMLParser.consumeUntil(s, c, new Character[]{new Character('>')});
            return new ParseCorrect(new CommentTag("comment"), new Integer(finalPos.getRemainderAsInt() + 1));
        }
        ParseResult parsedName = RobustHTMLParser.parseName(s, bracketPos + 1);
        if (parsedName instanceof ParseError) {
            return new ParseError("Bad name", parsedName.getRemainder());
        }
        if ("script".equals(((String)parsedName.getParsedValue()).toLowerCase(Locale.ENGLISH))) {
            int endPos = s.indexOf("</", bracketPos);
            ParseResult finalPos = RobustHTMLParser.consumeUntil(s, endPos + 8, new Character[]{new Character('>')});
            return new ParseCorrect(new CloseTag((String)parsedName.getParsedValue()), new Integer(finalPos.getRemainderAsInt() + 1));
        }
        HashMap headers = new HashMap();
        int c = parsedName.getRemainderAsInt();
        ParseResult parsedArg = RobustHTMLParser.parseArg(s, c);
        while (parsedArg instanceof ParseCorrect) {
            headers.putAll((Map)parsedArg.getParsedValue());
            c = parsedArg.getRemainderAsInt();
            parsedArg = RobustHTMLParser.parseArg(s, c);
        }
        ParseResult finalPos = RobustHTMLParser.consumeUntil(s, c, new Character[]{new Character('>')});
        return new ParseCorrect(new OpenTag((String)parsedName.getParsedValue(), headers), new Integer(finalPos.getRemainderAsInt() + 1));
    }

    protected static ParseResult consumeWhiteSpace(String s, int pos) {
        while (pos < s.length() && Character.isWhitespace(s.charAt(pos))) {
            ++pos;
        }
        return new ParseCorrect(null, new Integer(pos));
    }

    protected static ParseResult parseName(String s, int pos) {
        int start = pos;
        while (pos < s.length() && !Character.isWhitespace(s.charAt(pos)) && s.charAt(pos) != '=' && s.charAt(pos) != '>' && s.charAt(pos) != '/') {
            ++pos;
        }
        if (start == pos) {
            return new ParseError("Empty name.", new Integer(pos + 1));
        }
        return new ParseCorrect(s.substring(start, pos), new Integer(pos));
    }

    protected static ParseResult consumeUntil(String s, int pos, Character[] delim) {
        HashSet<Character> delimSet = new HashSet<Character>(Arrays.asList(delim));
        while (pos < s.length() && !delimSet.contains(new Character(s.charAt(pos)))) {
            ++pos;
        }
        if (pos == s.length()) {
            return new ParseError(null, new Integer(s.length()));
        }
        return new ParseCorrect(null, new Integer(pos));
    }

    protected static ParseResult parseArg(String s, int pos) {
        ParseResult newPos = RobustHTMLParser.consumeWhiteSpace(s, pos);
        pos = newPos.getRemainderAsInt();
        ParseResult parsedName = RobustHTMLParser.parseName(s, newPos.getRemainderAsInt());
        if (parsedName instanceof ParseError) {
            return new ParseError(parsedName.getRemainder());
        }
        HashMap<Object, String> pair = new HashMap<Object, String>();
        Object key = parsedName.getParsedValue();
        if (key != null) {
            key = ((String)key).toLowerCase(Locale.ENGLISH);
        }
        pair.put(key, "");
        ParseResult equalPos = RobustHTMLParser.consumeWhiteSpace(s, parsedName.getRemainderAsInt());
        if (s.charAt(equalPos.getRemainderAsInt()) != '=') {
            return new ParseCorrect(pair, equalPos.getRemainder());
        }
        pos = equalPos.getRemainderAsInt() + 1;
        ParseResult valuePos = RobustHTMLParser.consumeWhiteSpace(s, pos);
        if (s.charAt(valuePos.getRemainderAsInt()) == '\"' || s.charAt(valuePos.getRemainderAsInt()) == '\'') {
            char delim = s.charAt(valuePos.getRemainderAsInt());
            ParseResult closeDelimPos = RobustHTMLParser.consumeUntil(s, valuePos.getRemainderAsInt() + 1, new Character[]{new Character(delim)});
            if (closeDelimPos instanceof ParseError) {
                return new ParseError("Attribute value delimiter '" + delim + "' not closed for attribute '" + parsedName.getParsedValue() + "'", closeDelimPos.getRemainder());
            }
            key = parsedName.getParsedValue();
            if (key != null) {
                key = ((String)key).toLowerCase(Locale.ENGLISH);
            }
            pair.put(key, s.substring(valuePos.getRemainderAsInt() + 1, closeDelimPos.getRemainderAsInt()));
            return new ParseCorrect(pair, new Integer(closeDelimPos.getRemainderAsInt() + 1));
        }
        ParseResult endValuePos = RobustHTMLParser.consumeUntil(s, valuePos.getRemainderAsInt(), new Character[]{new Character('>'), new Character(' '), new Character('\t'), new Character('\n')});
        if (endValuePos instanceof ParseError) {
            return new ParseError("Value not closed for attribute '" + parsedName.getParsedValue() + "'", endValuePos.getRemainder());
        }
        key = parsedName.getParsedValue();
        if (key != null) {
            key = ((String)key).toLowerCase(Locale.ENGLISH);
        }
        pair.put(key, s.substring(valuePos.getRemainderAsInt(), endValuePos.getRemainderAsInt()));
        return new ParseCorrect(pair, endValuePos.getRemainder());
    }

    public static class Chunk {
    }

    public static class Tag
    extends Chunk {
        protected String tag;

        public Tag(String tag) {
            this.tag = tag.toLowerCase(Locale.ENGLISH);
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static class OpenTag
    extends Tag {
        Map params;

        public OpenTag(String tag, Map params) {
            super(tag);
            this.params = params;
        }

        public Map getParams() {
            return this.params;
        }

        public void setParams(Map params) {
            this.params = params;
        }

        protected String getParamsAsString() {
            StringBuffer buffer = new StringBuffer();
            Set s = this.params.entrySet();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                buffer.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
            }
            return new String(buffer);
        }

        public String toString() {
            return "<" + this.tag + this.getParamsAsString() + ">";
        }
    }

    public static class CompleteTag
    extends OpenTag {
        public CompleteTag(String tag, Map params) {
            super(tag, params);
        }

        public String toString() {
            return "<" + this.tag + this.getParamsAsString() + "/>";
        }
    }

    public static class CloseTag
    extends Tag {
        public CloseTag(String tag) {
            super(tag);
        }

        public String toString() {
            return "</" + this.tag + ">";
        }
    }

    public static class CommentTag
    extends CloseTag {
        public CommentTag(String tag) {
            super(tag);
        }
    }

    public static class Text
    extends Chunk {
        String text;

        public Text(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

