/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ObjectName
implements Serializable {
    private static final long serialVersionUID = -5467795090068647408L;
    private String domain = null;
    private Hashtable propertyList = new Hashtable();
    private String propertyListString = null;
    private String canonicalName = null;
    private boolean pattern;
    private boolean propertyPattern;

    public ObjectName() {
    }

    public ObjectName(String string) {
        if (string == null || string.equals("")) {
            this.domain = "*";
            if (this.propertyList.get("*") == null) {
                this.propertyList.put("*", "");
            }
            this.propertyListString = "*";
            return;
        }
        Object var2_2 = null;
        int n = string.indexOf(":");
        if (n == 0) {
            this.setDefaultDomain();
        } else {
            String string2 = string.substring(0, n);
            this.insertDomainName(string2);
        }
        if (string.length() > n) {
            this.propertyList = this.convertStringToProperties(string.substring(n + 1));
        }
    }

    private Hashtable convertStringToProperties(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        while (stringBuffer2.length() > 0) {
            String string2 = this.parsePropertyKey(stringBuffer2);
            String string3 = null;
            string3 = "*".equals(string2) ? "*" : this.parsePropertyValue(stringBuffer2);
            string3 = this.fix50WSBug(string2, string3, false);
            String string4 = hashtable.put(string2, string3);
        }
        return hashtable;
    }

    private String parsePropertyKey(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        int n = string.indexOf(61);
        int n2 = string.indexOf(44);
        if (n < 0 && n2 < 0) {
            String string2 = string.trim();
            stringBuffer.setLength(0);
            return string2;
        }
        if (n2 >= 0 && n2 < n) {
            String string3 = string.substring(0, n2).trim();
            stringBuffer.delete(0, n2 + 1);
            return string3;
        }
        String string4 = string.substring(0, n);
        stringBuffer.delete(0, n + 1);
        return string4;
    }

    private String parsePropertyValue(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        if (string.trim().startsWith("\"")) {
            int n = string.indexOf(34) + 1;
            int n2 = -1;
            while ((n2 = string.indexOf(34, n)) >= 0) {
                int n3 = this.countBackslashesBackwards(string, n2);
                if (n3 % 2 != 0) {
                    n = n2 + 1;
                    continue;
                }
                String string2 = string.substring(0, n2 + 1).trim();
                stringBuffer.delete(0, n2 + 1);
                string = stringBuffer.toString();
                if (string.trim().startsWith(",")) {
                    int n4 = string.indexOf(44);
                    stringBuffer.delete(0, n4 + 1);
                    return string2;
                }
                if (string.trim().length() != 0) continue;
                stringBuffer.setLength(0);
                return string2;
            }
        } else {
            int n = string.indexOf(44);
            if (n >= 0) {
                String string3 = string.substring(0, n);
                stringBuffer.delete(0, n + 1);
                return string3;
            }
            String string4 = string;
            stringBuffer.setLength(0);
            return string4;
        }
        return null;
    }

    private int countBackslashesBackwards(String string, int n) {
        int n2 = 0;
        while (--n >= 0 && string.charAt(n) == '\\') {
            ++n2;
        }
        return n2;
    }

    public ObjectName(String string, Hashtable hashtable) {
        if (string == null) {
            string = "";
        }
        this.insertDomainName(string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("*")) {
                this.propertyList.put(string2, "*");
                continue;
            }
            String string3 = (String)hashtable.get(string2);
            string3 = this.fix50WSBug(string2, string3, false);
            this.propertyList.put(string2, string3);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.domain);
        stringBuffer.append(":");
        stringBuffer.append(this.getKeyPropertyListString());
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        boolean bl = false;
        if (this.domain == null) {
            if (objectName.domain != null) return false;
            bl = true;
        } else {
            if (objectName.domain == null) {
                return false;
            }
            bl = this.domain.equals(objectName.domain);
        }
        if (!bl) {
            return false;
        }
        if (this.propertyList == null) {
            return objectName.propertyList == null;
        }
        if (objectName.propertyList != null) return this.propertyList.equals(objectName.propertyList);
        return false;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCanonicalKeyPropertyListString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.propertyList.keys();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("*")) {
                stringBuffer.append("*");
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            String string2 = (String)this.propertyList.get(string);
            string2 = this.fix50WSBug(string, string2, true);
            stringBuffer.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String getCanonicalName() {
        this.canonicalName = this.domain + ":" + this.getCanonicalKeyPropertyListString();
        return this.canonicalName;
    }

    public String getKeyProperty(String string) {
        String string2 = null;
        if (string != null && string != "") {
            string2 = (String)this.propertyList.get(string);
            string2 = this.fix50WSBug(string, string2, true);
        }
        return string2;
    }

    public Hashtable getKeyPropertyList() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.propertyList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.propertyList.get(string);
            string2 = this.fix50WSBug(string, string2, true);
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    public String getKeyPropertyListString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.propertyListString != null) {
            stringBuffer.append(this.propertyListString);
        } else {
            Enumeration enumeration = this.propertyList.keys();
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equals("*")) {
                    stringBuffer.append("*");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                    continue;
                }
                stringBuffer.append(string);
                stringBuffer.append("=");
                String string2 = (String)this.propertyList.get(string);
                string2 = this.fix50WSBug(string, string2, true);
                stringBuffer.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isPattern() {
        String string = new String(this.toString());
        this.pattern = this.hasWildCards(string);
        return this.pattern;
    }

    public boolean isPropertyPattern() {
        String string = new String(this.getKeyPropertyListString());
        this.propertyPattern = this.hasWildCards(string);
        return this.propertyPattern;
    }

    private void setDomainName(String string) {
        this.domain = string;
    }

    private void setDefaultDomain() {
        this.domain = "";
    }

    private boolean invalidDomain(String string) {
        return string.indexOf(":") != -1 || string.indexOf(",") != -1 || string.indexOf("=") != -1;
    }

    private boolean hasWildCards(String string) {
        return string.indexOf("*") != -1 || string.indexOf("?") != -1;
    }

    private void insertKeyProperty(String string) {
        String string2 = null;
        String string3 = null;
        if (string != null) {
            if (string.equals("*")) {
                string = "*=";
            }
            int n = string.indexOf("=");
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            string3 = this.fix50WSBug(string2, string3, false);
            this.updatePropertyStringList(string2, string3);
            this.propertyList.put(string2, string3);
            return;
        }
    }

    private void updatePropertyStringList(String string, String string2) {
        if (string != null && string2 != null) {
            String string3 = null;
            string3 = string.equals("*") ? "*" : new String(string + "=" + string2);
            this.propertyListString = this.propertyList.size() > 0 ? this.propertyListString + "," + string3 : string3;
        }
    }

    private void insertDomainName(String string) {
        this.setDomainName(string);
    }

    private String fix50WSBug(String string, String string2, boolean bl) {
        String string3 = string2;
        if (string.equals("_Websphere_Config_Data_Id")) {
            string3 = bl ? string2.replace(':', '|') : string2.replace('|', ':');
        }
        return string3;
    }
}

