/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;

public class RoleInfo
implements Serializable {
    private static final long serialVersionUID = 7227256952085334351L;
    private String myDescription;
    private boolean myIsReadableFlg;
    private boolean myIsWritableFlg;
    private int myMaxDegree;
    private int myMinDegree;
    private String myName;
    private String myRefMBeanClassName;
    public static int ROLE_CARDINALITY_INFINITY = -1;

    public RoleInfo() {
    }

    public RoleInfo(String string, String string2, boolean bl, boolean bl2, int n, int n2, String string3) {
        this.myDescription = string3;
        this.myIsReadableFlg = bl;
        this.myIsWritableFlg = bl2;
        this.myMaxDegree = n2;
        this.myMinDegree = n;
        this.myName = string;
        this.myRefMBeanClassName = string2;
    }

    public RoleInfo(String string, String string2, boolean bl, boolean bl2) {
        this.myDescription = null;
        this.myMaxDegree = 1;
        this.myMinDegree = 1;
        this.myIsReadableFlg = this.myIsReadableFlg;
        this.myIsWritableFlg = bl2;
        this.myName = string;
        this.myRefMBeanClassName = string2;
    }

    public RoleInfo(String string, String string2) {
        this.myDescription = null;
        this.myIsReadableFlg = true;
        this.myIsWritableFlg = true;
        this.myMaxDegree = 1;
        this.myMinDegree = 1;
        this.myName = string;
        this.myRefMBeanClassName = string2;
    }

    public RoleInfo(RoleInfo roleInfo) {
        this.myName = roleInfo.myName;
        this.myRefMBeanClassName = roleInfo.myRefMBeanClassName;
        this.myDescription = roleInfo.myDescription;
        this.myIsWritableFlg = roleInfo.myIsWritableFlg;
        this.myIsReadableFlg = roleInfo.myIsReadableFlg;
        this.myMinDegree = roleInfo.myMinDegree;
        this.myMaxDegree = roleInfo.myMaxDegree;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isReadable() {
        return this.myIsReadableFlg;
    }

    public boolean isWritable() {
        return this.myIsWritableFlg;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int getMinDegree() {
        return this.myMinDegree;
    }

    public int getMaxDegree() {
        return this.myMaxDegree;
    }

    public String getRefMBeanClassName() {
        return this.myRefMBeanClassName;
    }

    public boolean checkMinDegree(int n) {
        return n >= this.myMinDegree;
    }

    public boolean checkMaxDegree(int n) {
        if (this.myMaxDegree == ROLE_CARDINALITY_INFINITY) {
            return true;
        }
        return n <= this.myMaxDegree;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{").append("Name = " + this.myName).append(", ").append("MBeanClassName = " + this.myRefMBeanClassName).append(", ").append("IsReadable = " + this.myIsReadableFlg).append(", ").append("IsWritable = " + this.myIsWritableFlg).append(", ").append("MinDegree = " + this.myMinDegree).append(", ").append("MaxDegree = " + this.myMaxDegree).append(", ").append("Description = " + this.myDescription).append("}");
        return stringBuffer.toString();
    }
}

