/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.PluginJavaInfo;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.PathEditor;
import com.sun.deploy.panel.PathRenderer;
import com.sun.deploy.panel.PluginTableModel;
import com.sun.deploy.panel.SpecialTableEditor;
import com.sun.deploy.panel.SpecialTableRenderer;
import com.sun.deploy.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PluginJreDialog
extends JDialog
implements ListSelectionListener {
    private JTable jresTable;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton addBtn;
    private JButton removeBtn;

    public PluginJreDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        Serializable serializable;
        this.setTitle(this.getMessage("jpi.jres.dialog.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PluginJreDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(this.getMessage("jpi.jres.dialog.border")));
        this.jresTable = new JTable(new PluginTableModel());
        this.jresTable.setBorder(new LineBorder(Color.black));
        this.jresTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.jresTable.getSelectionModel().addListSelectionListener(this);
        this.jresTable.getAccessibleContext().setAccessibleName(this.getMessage("jpi.jres.dialog.border"));
        this.jresTable.getAccessibleContext().setAccessibleDescription(this.getMessage("jpi.jres.dialog.border"));
        Enumeration<TableColumn> enumeration = this.jresTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            serializable.setCellEditor(new SpecialTableEditor());
            serializable.setCellRenderer(new SpecialTableRenderer());
        }
        this.jresTable.getColumnModel().getColumn(2).setCellRenderer(new PathRenderer());
        this.jresTable.getColumnModel().getColumn(2).setCellEditor(new PathEditor());
        serializable = new JScrollPane(this.jresTable);
        jPanel.add((Component)serializable, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.addBtn = new JButton(this.getMessage("common.add_btn"));
        this.addBtn.getAccessibleContext().setAccessibleDescription(this.getMessage("common.add_btn"));
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        this.addBtn.setToolTipText(this.getMessage("vm.options.add_btn.tooltip"));
        this.addBtn.setMnemonic(ResourceManager.getVKCode("common.add_btn.mnemonic"));
        this.removeBtn = new JButton(this.getMessage("common.remove_btn"));
        this.removeBtn.getAccessibleContext().setAccessibleDescription(this.getMessage("common.remove_btn"));
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.removeBtnActionPerformed(actionEvent);
            }
        });
        this.removeBtn.setMnemonic(ResourceManager.getVKCode("common.remove_btn.mnemonic"));
        this.removeBtn.setEnabled(false);
        this.removeBtn.setToolTipText(this.getMessage("vm.options.remove_btn.tooltip"));
        jPanel2.add(this.addBtn);
        jPanel2.add(this.removeBtn);
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            jPanel.add(Box.createGlue(), "South");
        } else {
            jPanel.add((Component)jPanel2, "South");
        }
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 10, 5));
        this.okBtn = new JButton(this.getMessage("common.ok_btn"));
        this.okBtn.getAccessibleContext().setAccessibleDescription(this.getMessage("common.ok_btn"));
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.okBtn.setMnemonic(ResourceManager.getVKCode("common.ok_btn.mnemonic"));
        jPanel3.add(this.okBtn);
        this.cancelBtn = new JButton(this.getMessage("common.cancel_btn"));
        this.cancelBtn.getAccessibleContext().setAccessibleDescription(this.getMessage("common.cancel_btn"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelBtn.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        this.cancelBtn.setMnemonic(ResourceManager.getVKCode("common.cancel_btn.mnemonic"));
        jPanel3.add(this.cancelBtn);
        this.getContentPane().add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(this.okBtn);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                PluginJreDialog.this.okBtn.requestFocusInWindow();
            }
        });
        this.pack();
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        PluginTableModel pluginTableModel = (PluginTableModel)this.jresTable.getModel();
        pluginTableModel.add(new PluginJavaInfo(null, null, false, ""), false, true);
        int n = pluginTableModel.getRowCount() - 1;
        this.jresTable.requestFocus();
        this.jresTable.setRowSelectionInterval(n, n);
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        ((PluginTableModel)this.jresTable.getModel()).remove(this.jresTable.getSelectedRows());
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        PluginTableModel pluginTableModel;
        if (this.jresTable.isEditing()) {
            this.jresTable.getCellEditor().stopCellEditing();
        }
        if ((pluginTableModel = (PluginTableModel)this.jresTable.getModel()).getRowCount() >= 0) {
            PluginJavaInfo.clear();
            for (int i = 0; i < pluginTableModel.getRowCount(); ++i) {
                PluginJavaInfo.addJRE((PluginJavaInfo)pluginTableModel.getJRE(i));
            }
        }
        ControlPanel.propertyHasChanged();
        this.setVisible(false);
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void setProductTableColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.getMessage("jpi.jre.string"));
        jComboBox.addItem(this.getMessage("jpi.jdk.string"));
        jComboBox.getAccessibleContext().setAccessibleName(this.getMessage("jpi.jres.dialog.product.tooltip"));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(this.getMessage("jpi.jres.dialog.product.tooltip"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void enableButtons() {
        int[] nArray = this.jresTable.getSelectedRows();
        PluginTableModel pluginTableModel = (PluginTableModel)this.jresTable.getModel();
        for (int i = 0; i < nArray.length; ++i) {
            if (pluginTableModel.getJRE(nArray[i]).isSystemJRE()) {
                this.removeBtn.setEnabled(false);
                break;
            }
            this.removeBtn.setEnabled(true);
        }
    }
}

