/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.util.DialogFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class AboutDialog
extends JDialog
implements DeploySIListener {
    private SingleInstanceImpl sil = null;
    private static String ABOUT_JAVA_ID = "com_sun_deploy_AboutJava-" + Config.getProperty("deployment.version");
    private String java_image = "com/sun/deploy/resources/image/about_java.png";

    public AboutDialog(JFrame jFrame, boolean bl, boolean bl2) {
        super((Frame)jFrame, bl);
        if (bl2) {
            this.initSIImpl();
        }
        this.initComponents();
    }

    public AboutDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    public AboutDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
    }

    private void initSIImpl() {
        this.sil = new SingleInstanceImpl();
        this.sil.addSingleInstanceListener(this, ABOUT_JAVA_ID);
    }

    public static boolean shouldStartNewInstance() {
        return !SingleInstanceManager.isServerRunning(ABOUT_JAVA_ID) || !SingleInstanceManager.connectToServer("");
    }

    private void initComponents() {
        this.setResizable(false);
        this.setTitle(this.getMessage("about.dialog.title"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AboutDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(Color.white);
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/ibmlogo.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.getAccessibleContext().setAccessibleName(this.getMessage("common.ibm.logo"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setForeground(Color.WHITE);
        jPanel2.setBackground(Color.WHITE);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add("North", jPanel2);
        int n = imageIcon.getIconWidth() - 20;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 9, 9, 11));
        jPanel3.setForeground(Color.WHITE);
        jPanel3.setBackground(Color.WHITE);
        String string = new StringBuffer(this.getMessage("about.product.name")).append("\n\n").append(this.getMessage("about.license.note")).append('\n').append(this.getMessage("about.sun.copyright")).append('\n').append(this.getMessage("about.copyright")).append("\n\n").append(this.getMessage("about.legal.note")).toString();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        Font font = jTextArea.getFont();
        float f = font.getSize2D();
        f = Math.max((float)((double)f - 1.0), 11.0f);
        Font font2 = font.deriveFont(f);
        jTextArea.setFont(font2);
        jTextArea.setText(string);
        FontMetrics fontMetrics = jTextArea.getFontMetrics(font2);
        int n2 = fontMetrics.stringWidth(this.getMessage("about.legal.note"));
        int n3 = (n2 + n - 1) / n + 2;
        jTextArea.setRows(n3);
        jTextArea.setCaretPosition(0);
        jTextArea.getAccessibleContext().setAccessibleName(jTextArea.getText());
        jTextArea.getAccessibleContext().setAccessibleDescription(jTextArea.getText());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel3.add((Component)jScrollPane, "North");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(this.getMessage("about.option.close"));
        jButton.getAccessibleContext().setAccessibleDescription(this.getMessage("about.option.close"));
        jButton.setMnemonic(ResourceManager.getAcceleratorKey("about.option.close"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.okBtnActionPerformed(actionEvent);
            }
        };
        jButton.addActionListener(abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b');
        this.getRootPane().getInputMap(2).put(keyStroke, "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        jTextArea.getInputMap().put(keyStroke, "cancel");
        jTextArea.getActionMap().put("cancel", null);
        jPanel4.add(jButton);
        URL uRL2 = ClassLoader.getSystemResource("com/sun/deploy/resources/image/javalogo.gif");
        ImageIcon imageIcon2 = new ImageIcon(uRL2);
        JLabel jLabel2 = new JLabel(imageIcon2);
        jLabel2.getAccessibleContext().setAccessibleName(this.getMessage("common.java.logo"));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setForeground(Color.WHITE);
        jPanel5.setBackground(Color.WHITE);
        jPanel5.add((Component)jLabel2, "East");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add((Component)jPanel5, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel4, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        DialogFactory.positionDialog(this);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void newActivation(String[] stringArray) {
        Window window = this;
        while ((window = window.getOwner()) != null && !(window instanceof JFrame)) {
        }
        if (window != null) {
            ((JFrame)window).toFront();
        }
    }

    public Object getSingleInstanceListener() {
        return this;
    }
}

