/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    private ActionListener editorActionListener;

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        if (XPStyle.getXP() != null) {
            rectangle.x += 2;
            rectangle.y += 2;
            rectangle.width -= 3;
            rectangle.height -= 4;
        } else {
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
        }
        super.paintCurrentValue(graphics, rectangle, bl);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        dimension.width += 4;
        dimension.height += 2;
        if (XPStyle.getXP() != null) {
            dimension.height += 2;
        }
        return dimension;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (XPStyle.getXP() != null && WindowsComboBoxUI.this.arrowButton != null) {
                    Dimension dimension = container.getSize();
                    Insets insets = WindowsComboBoxUI.this.getInsets();
                    int n = ((WindowsComboBoxUI)WindowsComboBoxUI.this).arrowButton.getPreferredSize().width;
                    WindowsComboBoxUI.this.arrowButton.setBounds(WindowsUtils.isLeftToRight((JComboBox)container) ? dimension.width - insets.right - n : insets.left, insets.top, n, dimension.height - insets.top - insets.bottom);
                }
            }
        };
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.comboBox);
        if (actionMap != null) {
            // empty if block
        }
    }

    protected ComboPopup createPopup() {
        return new WindowsComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new NoSelectKeyHandler();
    }

    protected void selectNextPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            AccessibleContext accessibleContext;
            this.listBox.setSelectedIndex(n + 1);
            this.listBox.ensureIndexIsVisible(n + 1);
            if (this.comboBox instanceof Accessible && (accessibleContext = this.comboBox.getAccessibleContext()) != null) {
                Object object = this.listBox.getSelectedValue();
                accessibleContext.setAccessibleName(object.toString());
            }
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n > 0) {
            AccessibleContext accessibleContext;
            this.listBox.setSelectedIndex(n - 1);
            this.listBox.ensureIndexIsVisible(n - 1);
            if (this.comboBox instanceof Accessible && (accessibleContext = this.comboBox.getAccessibleContext()) != null) {
                Object object = this.listBox.getSelectedValue();
                accessibleContext.setAccessibleName(object.toString());
            }
            this.comboBox.repaint();
        }
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor();
    }

    public void configureEditor() {
        super.configureEditor();
        if (this.editorActionListener == null) {
            this.editorActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (WindowsComboBoxUI.this.isPopupVisible(WindowsComboBoxUI.this.comboBox)) {
                        WindowsComboBoxUI.this.comboBox.setSelectedIndex(WindowsComboBoxUI.this.listBox.getSelectedIndex());
                    }
                }
            };
            this.comboBox.getEditor().addActionListener(this.editorActionListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorActionListener != null) {
            this.comboBox.getEditor().removeActionListener(this.editorActionListener);
            this.editorActionListener = null;
        }
    }

    protected JButton createArrowButton() {
        if (XPStyle.getXP() != null) {
            return new XPComboBoxButton();
        }
        return super.createArrowButton();
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (jComboBox.isEditable() && !windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.setPopupVisible(jComboBox, true);
                } else {
                    windowsComboBoxUI.selectPreviousPossibleValue();
                }
            }
        }
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (jComboBox.isEditable() && !windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.setPopupVisible(jComboBox, true);
                } else {
                    windowsComboBoxUI.selectNextPossibleValue();
                }
            }
        }
    }

    public static class WindowsComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        public void setItem(Object object) {
            super.setItem(object);
            if (this.editor.hasFocus()) {
                this.editor.selectAll();
            }
        }
    }

    protected class WindowsComboPopup
    extends BasicComboPopup {
        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }
        }
    }

    private static class XPComboBoxButton
    extends XPStyle.GlyphButton {
        public XPComboBoxButton() {
            super("combobox.dropdownbutton");
            this.setRequestFocusEnabled(false);
        }

        public Dimension getPreferredSize() {
            return new Dimension(17, 20);
        }
    }

    private class NoSelectKeyHandler
    extends KeyAdapter {
        private NoSelectKeyHandler() {
        }

        private int selectionForKey(char c) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = WindowsComboBoxUI.this.listBox.getSelectedValue();
            ListModel listModel = WindowsComboBoxUI.this.listBox.getModel();
            if (object != null) {
                object = object.toString();
                n2 = listModel.getSize();
                for (n = 0; n < n2; ++n) {
                    if (!object.equals(listModel.getElementAt(n).toString())) continue;
                    n3 = n;
                    break;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = listModel.getSize();
            for (n = ++n3; n < n2; ++n) {
                if (listModel.getElementAt(n) == null || (string = listModel.getElementAt(n).toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            for (n = 0; n < n3; ++n) {
                if (listModel.getElementAt(n) == null || (string = listModel.getElementAt(n).toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            return -1;
        }

        private boolean selectWithKeyCharNoAction(char c) {
            int n = this.selectionForKey(c);
            if (n != -1) {
                WindowsComboBoxUI.this.comboBox.setPopupVisible(true);
                WindowsComboBoxUI.this.listBox.setSelectedIndex(n);
                WindowsComboBoxUI.this.listBox.ensureIndexIsVisible(n);
                return true;
            }
            return false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (WindowsComboBoxUI.this.comboBox.isEnabled() && !WindowsComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent)) {
                if (WindowsComboBoxUI.this.comboBox.getKeySelectionManager() != null) {
                    if (WindowsComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                } else if (this.selectWithKeyCharNoAction(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }
        }

        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            Object object;
            WindowsComboBoxUI.this.hasFocus = true;
            WindowsComboBoxUI.this.comboBox.repaint();
            if (WindowsComboBoxUI.this.comboBox instanceof Accessible && (object = WindowsComboBoxUI.this.comboBox.getAccessibleContext()) != null) {
                ((AccessibleContext)object).firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
            if ((object = WindowsComboBoxUI.this.comboBox.getEditor()) != null) {
                object.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            AccessibleContext accessibleContext;
            WindowsComboBoxUI.this.hasFocus = false;
            int n = WindowsComboBoxUI.this.comboBox.getSelectedIndex();
            WindowsComboBoxUI.this.listBox.setSelectedIndex(n);
            if (!focusEvent.isTemporary() && WindowsComboBoxUI.this.comboBox.isLightWeightPopupEnabled()) {
                WindowsComboBoxUI.this.setPopupVisible(WindowsComboBoxUI.this.comboBox, false);
            }
            WindowsComboBoxUI.this.comboBox.repaint();
            if (WindowsComboBoxUI.this.comboBox instanceof Accessible && (accessibleContext = WindowsComboBoxUI.this.comboBox.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }
}

