/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.security.action.GetPropertyAction;

class XPStyle {
    private static XPStyle xp;
    private static Boolean themeActive;
    private HashMap map = new HashMap();
    private String styleFile;
    private String themeFile;

    static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
    }

    static synchronized XPStyle getXP() {
        if (themeActive == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(new GetPropertyAction("swing.noxp")) == null) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    synchronized String getString(String string) {
        return (String)this.map.get(string);
    }

    int getInt(String string, int n) {
        return this.parseInt(this.getString(string), n);
    }

    private int parseInt(String string, int n) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.abandonXP();
            }
        }
        return n;
    }

    synchronized Dimension getDimension(String string) {
        String string2;
        Dimension dimension = (Dimension)this.map.get("Dimension " + string);
        if (dimension == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            dimension = new Dimension(this.parseInt(stringTokenizer.nextToken(), 0), this.parseInt(stringTokenizer.nextToken(), 0));
            this.map.put("Dimension " + string, dimension);
        }
        return dimension;
    }

    synchronized Point getPoint(String string) {
        String string2;
        Point point = (Point)this.map.get("Point " + string);
        if (point == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            point = new Point(this.parseInt(stringTokenizer.nextToken(), 0), this.parseInt(stringTokenizer.nextToken(), 0));
            this.map.put("Point " + string, point);
        }
        return point;
    }

    synchronized Insets getMargin(String string) {
        String string2;
        Insets insets = (Insets)this.map.get("Margin " + string);
        if (insets == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            insets = new Insets(0, 0, 0, 0);
            insets.left = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.right = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.top = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.bottom = this.parseInt(stringTokenizer.nextToken(), 0);
            this.map.put("Margin " + string, insets);
        }
        return insets;
    }

    synchronized Color getColor(String string, Color color) {
        String string2;
        Color color2 = (Color)this.map.get("Color " + string);
        if (color2 == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            int n = this.parseInt(stringTokenizer.nextToken(), 0);
            int n2 = this.parseInt(stringTokenizer.nextToken(), 0);
            int n3 = this.parseInt(stringTokenizer.nextToken(), 0);
            if (n >= 0 && n2 >= 0 && n3 >= 0) {
                color2 = new Color(n, n2, n3);
                this.map.put("Color " + string, color2);
            }
        }
        return color2 != null ? color2 : color;
    }

    synchronized Border getBorder(String string) {
        Border border = (Border)this.map.get("Border " + string);
        if (border == null) {
            Insets insets;
            String string2 = this.getString(string + ".bgtype");
            if ("borderfill".equalsIgnoreCase(string2)) {
                int n = this.getInt(string + ".bordersize", 1);
                Color color = this.getColor(string + ".bordercolor", Color.black);
                border = new XPFillBorder(color, n);
            } else if ("imagefile".equalsIgnoreCase(string2) && (insets = this.getMargin(string + ".sizingmargins")) != null) {
                border = new XPEmptyBorder(insets);
            }
            if (border != null) {
                this.map.put("Border " + string, border);
            }
        }
        return border;
    }

    synchronized Skin getSkin(String string) {
        Skin skin = (Skin)this.map.get("Skin " + string);
        if (skin == null) {
            skin = new Skin(string);
            this.map.put("Skin " + string, skin);
        }
        return skin;
    }

    private XPStyle() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.styleFile = (String)toolkit.getDesktopProperty("win.xpstyle.dllName");
        if (this.styleFile != null) {
            String string = (String)toolkit.getDesktopProperty("win.xpstyle.sizeName");
            String string2 = (String)toolkit.getDesktopProperty("win.xpstyle.colorName");
            if (string != null && string2 != null) {
                String[] stringArray = this.splitTextResource(XPStyle.getTextResourceByInt(this.styleFile, 1, "SIZENAMES"));
                String[] stringArray2 = this.splitTextResource(XPStyle.getTextResourceByInt(this.styleFile, 1, "COLORNAMES"));
                String[] stringArray3 = this.splitTextResource(XPStyle.getTextResourceByInt(this.styleFile, 1, "FILERESNAMES"));
                if (stringArray != null && stringArray2 != null && stringArray3 != null) {
                    String string3;
                    this.themeFile = null;
                    block0: for (int i = 0; i < stringArray2.length; ++i) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (!string.equals(stringArray[j]) || !string2.equals(stringArray2[i]) || i * stringArray.length + j >= stringArray3.length) continue;
                            this.themeFile = stringArray3[i * stringArray.length + j];
                            continue block0;
                        }
                    }
                    if (this.themeFile != null && (string3 = XPStyle.getTextResourceByName(this.styleFile, this.themeFile, "TEXTFILE")) != null) {
                        this.merge(string3);
                    }
                }
            }
        }
    }

    private static native int[] getBitmapResource(String var0, String var1);

    private static native String getTextResourceByName(String var0, String var1, String var2);

    private static native String getTextResourceByInt(String var0, int var1, String var2);

    private void merge(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken().trim();
            char[] cArray = string3.toCharArray();
            int n = cArray.length;
            if (n <= 1) continue;
            if (cArray[0] == '[') {
                cArray[n - 1] = 46;
                this.toLowerCase(cArray, 1, n - 1);
                string2 = new String(cArray, 1, n - 1);
                continue;
            }
            int n2 = string3.indexOf(61);
            if (n2 < 0) continue;
            while (n2 > 0 && (cArray[n2 - 1] == ' ' || cArray[n2 - 1] == '\t')) {
                --n2;
            }
            this.toLowerCase(cArray, 0, n2);
            String string4 = string2 + new String(cArray, 0, n2);
            while (n2 < n && (cArray[n2] == ' ' || cArray[n2] == '\t' || cArray[n2] == '=')) {
                ++n2;
            }
            String string5 = new String(cArray, n2, n - n2);
            if ((n2 = string5.indexOf(59)) >= 0) {
                string5 = string5.substring(0, n2);
            }
            this.map.put(string4, string5.trim());
        }
    }

    private void toLowerCase(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            cArray[i] = Character.toLowerCase(cArray[i]);
        }
    }

    private synchronized Image getImage(String string, boolean bl) {
        Image image = null;
        String string2 = this.getString(string);
        if (string2 != null && (image = (Image)this.map.get("Image " + string2)) == null) {
            int n;
            String string3 = string2;
            while ((n = string3.indexOf("\\")) >= 0 || (n = string3.indexOf(".")) >= 0) {
                string3 = string3.substring(0, n) + "_" + string3.substring(n + 1);
            }
            int[] nArray = XPStyle.getBitmapResource(this.styleFile, string3 = string3.toUpperCase(Locale.ENGLISH));
            if (nArray != null) {
                int n2 = nArray[nArray.length - 2];
                int n3 = bl ? nArray[nArray.length - 1] : 1;
                int n4 = (nArray.length - 2) / n2;
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n2, n4, n3);
                bufferedImage.setRGB(0, 0, n2, n4, nArray, 0, n2);
                image = bufferedImage;
                this.map.put("Image " + string2, image);
            }
        }
        return image;
    }

    private boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string);
        return string2 == null ? bl : "true".equalsIgnoreCase(string2);
    }

    private void abandonXP() {
        if (AccessController.doPrivileged(new GetPropertyAction("swing.debug")) != null) {
            System.err.println("An error occured in XPStyle while reading resource " + this.themeFile + " in " + this.styleFile);
            new Exception().printStackTrace();
        }
        xp = null;
    }

    private String[] splitTextResource(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    static {
        themeActive = null;
        XPStyle.invalidateStyle();
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;
        private Image glyphImage;
        private boolean vertical;

        public GlyphButton(String string) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(string);
            this.glyphImage = xPStyle.getImage(string + ".glyphimagefile", xPStyle.getBoolean(string + ".glyphtransparent", true));
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintComponent(Graphics graphics) {
            int n = 0;
            if (!this.isEnabled()) {
                n = 3;
            } else if (this.getModel().isPressed()) {
                n = 2;
            } else if (this.getModel().isRollover()) {
                n = 1;
            }
            Dimension dimension = this.getSize();
            this.skin.paintSkin(graphics, 0, 0, dimension.width, dimension.height, n);
        }

        protected void paintBorder(Graphics graphics) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    class Skin {
        private Image image;
        private Insets contentMargin;
        private int w;
        private int h;
        private Image scaledImage;
        private Image glyphImage;
        private int frameCount;
        private Insets paintMargin;
        private boolean tile;
        private boolean sourceShrink;
        private boolean verticalFrames;

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (this.scaledImage != null) {
                return this.scaledImage;
            }
            return null;
        }

        Insets getContentMargin() {
            return this.contentMargin;
        }

        int getWidth() {
            return this.w;
        }

        int getHeight() {
            return this.h;
        }

        private Skin(String string) {
            XPStyle xPStyle2 = XPStyle.getXP();
            this.image = xPStyle2.getImage(string + ".imagefile", xPStyle2.getBoolean(string + ".transparent", true));
            int n = 0;
            while (xPStyle2.getString(string + ".imagefile" + (n + 1)) != null) {
                ++n;
            }
            if (n > 0) {
                int n2 = n / 2 + 1;
                if ("dpi".equalsIgnoreCase(XPStyle.this.getString(string + ".imageselecttype"))) {
                    int n3 = Toolkit.getDefaultToolkit().getScreenResolution();
                    n2 = 1;
                    for (int i = n; i >= 1; --i) {
                        int n4 = xPStyle2.getInt(string + ".mindpi" + i, -1);
                        if (n4 <= 0 || n3 < n4) continue;
                        n2 = i;
                        break;
                    }
                }
                this.scaledImage = xPStyle2.getImage(string + ".imagefile" + n2, xPStyle2.getBoolean(string + ".transparent", false) || xPStyle2.getBoolean(string + ".glyphtransparent", false));
            }
            this.frameCount = XPStyle.this.getInt(string + ".imagecount", 1);
            this.paintMargin = XPStyle.this.getMargin(string + ".sizingmargins");
            this.contentMargin = XPStyle.this.getMargin(string + ".contentmargins");
            this.tile = "tile".equalsIgnoreCase(XPStyle.this.getString(string + ".sizingtype"));
            this.sourceShrink = XPStyle.this.getBoolean(string + ".sourceshrink", false);
            this.verticalFrames = "vertical".equalsIgnoreCase(XPStyle.this.getString(string + ".imagelayout"));
            this.glyphImage = xPStyle2.getImage(string + ".glyphimagefile", xPStyle2.getBoolean(string + ".glyphtransparent", false));
            Image image = this.image;
            if (image == null && this.scaledImage != null) {
                image = this.scaledImage;
            }
            if (image != null) {
                if (this.frameCount < 1) {
                    XPStyle.this.abandonXP();
                }
                this.w = image.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
                this.h = image.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
            }
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3) {
            this.paintSkin(graphics, n, n2, this.w, this.h, n3);
        }

        void paintSkin(Graphics graphics, Rectangle rectangle, int n) {
            this.paintSkin(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            int n6;
            if (!(this.image == null && this.scaledImage == null && this.glyphImage == null || n5 >= 0 && n5 < this.frameCount)) {
                XPStyle.this.abandonXP();
            }
            if (this.image != null) {
                n6 = 0;
                if (this.h - (this.paintMargin != null ? this.paintMargin.top + this.paintMargin.bottom : 0) > n4 && this.tile && !this.sourceShrink) {
                    n6 = this.h - n4;
                }
                this.paint9(graphics, this.image, n, n2, n3, n4, this.verticalFrames ? 0 : n5 * this.w, (this.verticalFrames ? n5 * this.h : 0) + n6, this.w, this.h, this.paintMargin, this.tile, this.sourceShrink);
            }
            if (this.scaledImage != null) {
                Image image = this.scaledImage;
                int n7 = image.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
                int n8 = image.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
                int n9 = this.verticalFrames ? 0 : n5 * n7;
                int n10 = this.verticalFrames ? n5 * n8 : 0;
                graphics.drawImage(image, n += (this.w - n7) / 2, n2 += (this.h - n8) / 2, n + n7, n2 + n8, n9, n10, n9 + n7, n10 + n8, null);
            } else if (this.glyphImage != null) {
                n6 = this.glyphImage.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
                int n11 = this.glyphImage.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
                if ((n += (n3 - n6) / 2) >= 0 && (n2 += (n4 - n11) / 2) >= 0) {
                    int n12 = 0;
                    int n13 = 0;
                    if (this.verticalFrames) {
                        n13 = n5 * n11;
                    } else {
                        n12 = n5 * n6;
                    }
                    graphics.drawImage(this.glyphImage, n, n2, n + n6, n2 + n11, n12, n13, n12 + n6, n13 + n11, null);
                }
            }
        }

        private void paint9(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Insets insets, boolean bl, boolean bl2) {
            int n9;
            int n10;
            int n11;
            int n12;
            if (insets != null) {
                n12 = insets.top;
                n11 = insets.bottom;
                n10 = insets.left;
                n9 = insets.right;
            } else {
                n9 = 0;
                n10 = 0;
                n11 = 0;
                n12 = 0;
            }
            if (bl) {
                this.paintTile(graphics, image, n + n10, n2 + n12, n3 - n10 - n9, n4 - n12 - n11, n5 + n10, n6 + n12, n7 - n10 - n9, n8 - n12 - n11, bl2);
                this.paintTile(graphics, image, n, n2 + n12, n10, n4 - n12 - n11, n5, n6 + n12, n10, n8 - n12 - n11, bl2);
                this.paintTile(graphics, image, n + n3 - n9, n2 + n12, n9, n4 - n12 - n11, n5 + n7 - n9, n6 + n12, n9, n8 - n12 - n11, bl2);
                this.paintTile(graphics, image, n + n10, n2, n3 - n10 - n9, n12, n5 + n10, n6, n7 - n10 - n9, n12, bl2);
                this.paintTile(graphics, image, n + n10, n2 + n4 - n11, n3 - n10 - n9, n11, n5 + n10, n6 + n8 - n11, n7 - n10 - n9, n11, bl2);
            } else {
                graphics.drawImage(image, n + n10, n2 + n12, n + n3 - n9, n2 + n4 - n11, n5 + n10, n6 + n12, n5 + n7 - n9, n6 + n8 - n11, null);
                graphics.drawImage(image, n, n2 + n12, n + n10, n2 + n4 - n11, n5, n6 + n12, n5 + n10, n6 + n8 - n11, null);
                graphics.drawImage(image, n + n3 - n9, n2 + n12, n + n3, n2 + n4 - n11, n5 + n7 - n9, n6 + n12, n5 + n7, n6 + n8 - n11, null);
                graphics.drawImage(image, n + n10, n2, n + n3 - n9, n2 + n12, n5 + n10, n6, n5 + n7 - n9, n6 + n12, null);
                graphics.drawImage(image, n + n10, n2 + n4 - n11, n + n3 - n9, n2 + n4, n5 + n10, n6 + n8 - n11, n5 + n7 - n9, n6 + n8, null);
            }
            graphics.drawImage(image, n, n2, n + n10, n2 + n12, n5, n6, n5 + n10, n6 + n12, null);
            graphics.drawImage(image, n + n3 - n9, n2, n + n3, n2 + n12, n5 + n7 - n9, n6, n5 + n7, n6 + n12, null);
            graphics.drawImage(image, n, n2 + n4 - n11, n + n10, n2 + n4, n5, n6 + n8 - n11, n5 + n10, n6 + n8, null);
            graphics.drawImage(image, n + n3 - n9, n2 + n4 - n11, n + n3, n2 + n4, n5 + n7 - n9, n6 + n8 - n11, n5 + n7, n6 + n8, null);
        }

        private void paintTile(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
            if (n3 <= 0 || n4 <= 0 || n7 <= 0 || n8 <= 0) {
                return;
            }
            if (bl && (n7 > n3 || n8 > n4)) {
                if (n7 > n3 && n8 > n4) {
                    graphics.drawImage(image, n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, null);
                } else if (n8 > n4) {
                    int n9;
                    BufferedImage bufferedImage = new BufferedImage(n7, n4, 2);
                    Graphics graphics2 = bufferedImage.getGraphics();
                    graphics2.drawImage(image, 0, 0, n7, n4, n5, n6, n5 + n7, n6 + n8, null);
                    for (int i = n; i < n + n3; i += n9) {
                        n9 = Math.min(n7, n + n3 - i);
                        graphics.drawImage(bufferedImage, i, n2, i + n9, n2 + n4, 0, 0, n9, n4, null);
                    }
                    graphics2.dispose();
                } else {
                    BufferedImage bufferedImage = new BufferedImage(n3, n8, 2);
                    Graphics graphics3 = bufferedImage.getGraphics();
                    graphics3.drawImage(image, 0, 0, n3, n8, n5, n6, n5 + n7, n6 + n8, null);
                    for (int i = n2; i < n2 + n4; i += n8) {
                        n8 = Math.min(n8, n2 + n4 - i);
                        graphics.drawImage(bufferedImage, n, i, n + n3, i + n8, 0, 0, n3, n8, null);
                    }
                    graphics3.dispose();
                }
            } else {
                for (int i = n2; i < n2 + n4; i += n8) {
                    int n10;
                    n8 = Math.min(n8, n2 + n4 - i);
                    for (int j = n; j < n + n3; j += n10) {
                        n10 = Math.min(n7, n + n3 - j);
                        graphics.drawImage(image, j, i, j + n10, i + n8, n5, n6, n5 + n10, n6 + n8, null);
                    }
                }
            }
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets insets) {
            super(insets.top + 2, insets.left + 2, insets.bottom + 2, insets.right + 2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, this.getBorderInsets());
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 != null) {
                insets.top = insets2.top + 2;
                insets.left = insets2.left + 2;
                insets.bottom = insets2.bottom + 2;
                insets.right = insets2.right + 2;
            }
            return insets;
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int n) {
            super(color, n);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + this.thickness;
            insets.left = (insets2 != null ? insets2.left : 0) + this.thickness;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + this.thickness;
            insets.right = (insets2 != null ? insets2.right : 0) + this.thickness;
            return insets;
        }
    }
}

