/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.peer.DialogPeer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;
import sun.awt.NativeLibLoader;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean undecorated = false;
    boolean modal;
    String title;
    private transient boolean keepBlocking = false;
    private static final String base = "dialog";
    private static int nameCounter;
    private boolean parentnotified = false;
    private static final long serialVersionUID = 5920926903803293709L;
    private transient AppContext showAppContext;

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame);
        this.title = string;
        this.modal = bl;
        this.setFocusTraversalPolicy(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy());
    }

    public Dialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, graphicsConfiguration);
        this.title = string;
        this.modal = bl;
        this.setFocusTraversalPolicy(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy());
    }

    public Dialog(Dialog dialog) {
        this(dialog, "", false);
    }

    public Dialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public Dialog(Dialog dialog, String string, boolean bl) {
        super(dialog);
        this.title = string;
        this.modal = bl;
        this.setFocusTraversalPolicy(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy());
    }

    public Dialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, graphicsConfiguration);
        this.title = string;
        this.modal = bl;
        this.setFocusTraversalPolicy(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
                this.parentnotified = true;
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            if (this.parent != null && this.parentnotified) {
                this.parent.removeNotify();
                this.parentnotified = false;
            }
        }
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String string) {
        String string2 = this.title;
        Dialog dialog = this;
        synchronized (dialog) {
            this.title = string;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setTitle(string);
            }
        }
        this.firePropertyChange("title", string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean conditionalShow() {
        boolean bl;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
            if (this.visible) {
                this.toFront();
                bl = false;
            } else {
                bl = true;
                this.visible = true;
                this.peer.show();
                this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
            }
            if (bl && (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L))) {
                ComponentEvent componentEvent = new ComponentEvent(this, 102);
                Toolkit.getEventQueue().postEvent(componentEvent);
            }
        }
        if (bl && (this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        this.beforeFirstShow = false;
        if (!this.isModal()) {
            this.conditionalShow();
        } else {
            this.keepBlocking = true;
            this.showAppContext = AppContext.getAppContext();
            if (this.conditionalShow()) {
                Toolkit.getEventQueue();
                long l = EventQueue.getMostRecentEventTime();
                Component component = this.getMostRecentFocusOwner();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().enqueueKeyEvents(l, component);
                Runnable runnable = new Runnable(){

                    public void run() {
                        EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                        eventDispatchThread.pumpEventsForHierarchy(new Conditional(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public boolean evaluate() {
                                return Dialog.access$100(1.access$000(this.this$1)) && 1.access$000(this.this$1).windowClosingException == null;
                            }
                        }, Dialog.this);
                    }

                    static /* synthetic */ Dialog access$000(1 var0) {
                        return var0.Dialog.this;
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    SequencedEvent sequencedEvent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentSequencedEvent();
                    if (sequencedEvent != null) {
                        sequencedEvent.dispose();
                    }
                    runnable.run();
                } else {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        Toolkit.getEventQueue().postEvent(new PeerEvent(this, runnable, 1L));
                        while (this.keepBlocking && this.windowClosingException == null) {
                            try {
                                this.getTreeLock().wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                                break;
                            }
                        }
                    }
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().dequeueKeyEvents(l, component);
                if (this.windowClosingException != null) {
                    this.windowClosingException.fillInStackTrace();
                    throw this.windowClosingException;
                }
            }
        }
    }

    void interruptBlocking() {
        if (this.modal) {
            this.disposeImpl();
        } else if (this.windowClosingException != null) {
            this.windowClosingException.fillInStackTrace();
            this.windowClosingException.printStackTrace();
            this.windowClosingException = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideAndDisposeHandler() {
        if (this.keepBlocking) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.keepBlocking = false;
                if (this.showAppContext != null) {
                    SunToolkit.postEvent(this.showAppContext, new PeerEvent(this, new WakingRunnable(), 1L));
                    this.showAppContext = null;
                }
                EventQueue.invokeLater(new WakingRunnable());
                this.getTreeLock().notifyAll();
            }
        }
    }

    public void hide() {
        super.hide();
        this.hideAndDisposeHandler();
    }

    public void dispose() {
        this.disposeImpl();
    }

    private void disposeImpl() {
        super.dispose();
        this.hideAndDisposeHandler();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResizable(boolean bl) {
        boolean bl2 = false;
        Dialog dialog = this;
        synchronized (dialog) {
            this.resizable = bl;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setResizable(bl);
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUndecorated(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisplayable()) {
                throw new IllegalComponentStateException("The dialog is displayable.");
            }
            this.undecorated = bl;
        }
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    protected String paramString() {
        String string = super.paramString() + (this.modal ? ",modal" : ",modeless");
        if (this.title != null) {
            string = string + ",title=" + this.title;
        }
        return string;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTDialog();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ boolean access$100(Dialog dialog) {
        return dialog.keepBlocking;
    }

    static {
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Dialog.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTDialog
    extends Window.AccessibleAWTWindow {
        protected AccessibleAWTDialog() {
            super(Dialog.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIALOG;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Dialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (Dialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            if (Dialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            return accessibleStateSet;
        }
    }

    static final class WakingRunnable
    implements Runnable {
        WakingRunnable() {
        }

        public void run() {
        }
    }
}

