/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Enumeration;
import java.util.Vector;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    RenderableImage rdblImage;
    RenderContext rc;
    Vector ics = new Vector();

    public RenderableImageProducer(RenderableImage renderableImage, RenderContext renderContext) {
        this.rdblImage = renderableImage;
        this.rc = renderContext;
    }

    public synchronized void setRenderContext(RenderContext renderContext) {
        this.rc = renderContext;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (!this.ics.contains(imageConsumer)) {
            this.ics.addElement(imageConsumer);
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ics.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.ics.removeElement(imageConsumer);
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        Thread thread = new Thread((Runnable)this, "RenderableImageProducer Thread");
        thread.start();
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void run() {
        ImageConsumer imageConsumer;
        RenderedImage renderedImage = this.rc != null ? this.rdblImage.createRendering(this.rc) : this.rdblImage.createDefaultRendering();
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = renderedImage.getData();
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        Enumeration enumeration = this.ics.elements();
        while (enumeration.hasMoreElements()) {
            imageConsumer = (ImageConsumer)enumeration.nextElement();
            imageConsumer.setDimensions(n3, n4);
            imageConsumer.setHints(30);
        }
        int[] nArray = new int[n3];
        int n5 = sampleModel.getNumBands();
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                sampleModel.getPixel(j, i, nArray2, dataBuffer);
                nArray[j] = colorModel.getDataElement(nArray2, 0);
            }
            enumeration = this.ics.elements();
            while (enumeration.hasMoreElements()) {
                imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setPixels(0, i, n3, 1, colorModel, nArray, 0, n3);
            }
        }
        enumeration = this.ics.elements();
        while (enumeration.hasMoreElements()) {
            imageConsumer = (ImageConsumer)enumeration.nextElement();
            imageConsumer.imageComplete(3);
        }
    }
}

