/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.FilterIterator;
import javax.imageio.spi.SubRegistry;
import sun.misc.Service;

public class ServiceRegistry {
    private Map categoryMap = new HashMap();

    public ServiceRegistry(Iterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("categories == null!");
        }
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            SubRegistry subRegistry = new SubRegistry(this, clazz);
            this.categoryMap.put(clazz, subRegistry);
        }
    }

    public static Iterator lookupProviders(Class clazz, ClassLoader classLoader) {
        if (clazz == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return Service.providers((Class)clazz, (ClassLoader)classLoader);
    }

    public static Iterator lookupProviders(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return Service.providers((Class)clazz);
    }

    public Iterator getCategories() {
        Set set = this.categoryMap.keySet();
        return set.iterator();
    }

    private Iterator getSubRegistries(Object object) {
        ArrayList<SubRegistry> arrayList = new ArrayList<SubRegistry>();
        Iterator iterator = this.categoryMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            arrayList.add((SubRegistry)this.categoryMap.get(clazz));
        }
        return arrayList.iterator();
    }

    public boolean registerServiceProvider(Object object, Class clazz) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ClassCastException();
        }
        return subRegistry.registerServiceProvider(object);
    }

    public void registerServiceProvider(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator iterator = this.getSubRegistries(object);
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            subRegistry.registerServiceProvider(object);
        }
    }

    public void registerServiceProviders(Iterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        while (iterator.hasNext()) {
            this.registerServiceProvider(iterator.next());
        }
    }

    public boolean deregisterServiceProvider(Object object, Class clazz) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ClassCastException();
        }
        return subRegistry.deregisterServiceProvider(object);
    }

    public void deregisterServiceProvider(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator iterator = this.getSubRegistries(object);
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            subRegistry.deregisterServiceProvider(object);
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator iterator = this.getSubRegistries(object);
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            if (!subRegistry.contains(object)) continue;
            return true;
        }
        return false;
    }

    public Iterator getServiceProviders(Class clazz, boolean bl) {
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        return subRegistry.getServiceProviders(bl);
    }

    public Iterator getServiceProviders(Class clazz, Filter filter, boolean bl) {
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        Iterator iterator = this.getServiceProviders(clazz, bl);
        return new FilterIterator(iterator, filter);
    }

    public Object getServiceProviderByClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        Iterator iterator = this.categoryMap.keySet().iterator();
        while (iterator.hasNext()) {
            SubRegistry subRegistry;
            Object object;
            Class clazz2 = (Class)iterator.next();
            if (!clazz2.isAssignableFrom(clazz) || (object = (subRegistry = (SubRegistry)this.categoryMap.get(clazz2)).getServiceProviderByClass(clazz)) == null) continue;
            return object;
        }
        return null;
    }

    public boolean setOrdering(Class clazz, Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (object == object2) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (subRegistry.contains(object) && subRegistry.contains(object2)) {
            return subRegistry.setOrdering(object, object2);
        }
        return false;
    }

    public boolean unsetOrdering(Class clazz, Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (object == object2) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (subRegistry.contains(object) && subRegistry.contains(object2)) {
            return subRegistry.unsetOrdering(object, object2);
        }
        return false;
    }

    public void deregisterAll(Class clazz) {
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        subRegistry.clear();
    }

    public void deregisterAll() {
        Iterator iterator = this.categoryMap.values().iterator();
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            subRegistry.clear();
        }
        this.categoryMap.clear();
    }

    public void finalize() throws Throwable {
        this.deregisterAll();
        super.finalize();
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

