/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class JPasswordField
extends JTextField {
    private static final String uiClassID = "PasswordFieldUI";
    private char echoChar = (char)42;

    public JPasswordField() {
        this(null, null, 0);
    }

    public JPasswordField(String string) {
        this(null, string, 0);
    }

    public JPasswordField(int n) {
        this(null, null, n);
    }

    public JPasswordField(String string, int n) {
        this(null, string, n);
    }

    public JPasswordField(Document document, String string, int n) {
        super(document, string, n);
        this.enableInputMethods(false);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
        this.repaint();
        this.revalidate();
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public void cut() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public void copy() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public String getText() {
        return super.getText();
    }

    public String getText(int n, int n2) throws BadLocationException {
        return super.getText(n, n2);
    }

    public char[] getPassword() {
        Document document = this.getDocument();
        Segment segment = new Segment();
        try {
            document.getText(0, document.getLength(), segment);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        char[] cArray = new char[segment.count];
        System.arraycopy(segment.array, segment.offset, cArray, 0, segment.count);
        return cArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        return super.paramString() + ",echoChar=" + this.echoChar;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPasswordField();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJPasswordField
    extends JTextField.AccessibleJTextField {
        protected AccessibleJPasswordField() {
            super(JPasswordField.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PASSWORD_TEXT;
        }
    }
}

