/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.security.action.GetPropertyAction;

public class Popup {
    private Component component;
    static final boolean longMenus;

    protected Popup(Component component, Component component2, int n, int n2) {
        this();
        if (component2 == null) {
            throw new IllegalArgumentException("Contents must be non-null");
        }
        this.reset(component, component2, n, n2);
    }

    protected Popup() {
    }

    public void show() {
        Component component = this.getComponent();
        if (component != null) {
            component.show();
        }
    }

    public void hide() {
        Component component = this.getComponent();
        if (component instanceof JWindow) {
            component.hide();
            ((JWindow)component).getContentPane().removeAll();
        }
        this.dispose();
    }

    void dispose() {
        Component component = this.getComponent();
        if (component instanceof JWindow) {
            ((Window)component).dispose();
            component = null;
        }
    }

    void reset(Component component, Component component2, int n, int n2) {
        Component component3;
        if (this.getComponent() == null) {
            this.component = this.createComponent(component);
        }
        if ((component3 = this.getComponent()) instanceof JWindow) {
            JWindow jWindow = (JWindow)this.getComponent();
            jWindow.setLocation(n, n2);
            if (longMenus) {
                jWindow.getContentPane().add(component2, "Center");
                component2.invalidate();
                this.pack();
                return;
            }
            JComponent jComponent = (JComponent)jWindow.getContentPane();
            jComponent.setPreferredSize(component2.getPreferredSize());
            if (component2 instanceof JPopupMenu && ((JPopupMenu)component2).getInvoker() instanceof JMenu) {
                int n3;
                Cloneable cloneable;
                Dimension dimension;
                JPopupMenu jPopupMenu = (JPopupMenu)component2;
                Point point = new Point(n, n2);
                Insets insets = new Insets(0, 0, 0, 0);
                GraphicsConfiguration graphicsConfiguration = jWindow.getGraphicsConfiguration();
                if (graphicsConfiguration == null) {
                    dimension = jWindow.getToolkit().getScreenSize();
                } else {
                    cloneable = graphicsConfiguration.getBounds();
                    dimension = cloneable.getSize();
                    point.x -= cloneable.x;
                    point.y -= cloneable.y;
                    insets = jWindow.getToolkit().getScreenInsets(graphicsConfiguration);
                }
                cloneable = jPopupMenu.getInvoker().getLocationOnScreen();
                if (point.y + Math.max(Math.abs(UIManager.getInt("Menu.menuPopupOffsetY")), Math.abs(UIManager.getInt("Menu.submenuPopupOffsetY"))) < ((Point)cloneable).y) {
                    n3 = ((Point)cloneable).y - point.y;
                    n3 = jPopupMenu.getInvoker().getParent() instanceof JPopupMenu ? (n3 += jPopupMenu.getInvoker().getHeight() - UIManager.getInt("Menu.submenuPopupOffsetY")) : (n3 -= UIManager.getInt("Menu.menuPopupOffsetY"));
                    n3 = Math.min(n3, dimension.height - point.y - insets.bottom);
                } else {
                    n3 = dimension.height - point.y - insets.bottom;
                }
                Dimension dimension2 = component2.getPreferredSize();
                if (dimension2.height > n3) {
                    dimension2.height = n3;
                    jComponent.setPreferredSize(dimension2);
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add(component2, "Center");
                    JScrollPane jScrollPane = new JScrollPane(jPanel, 21, 31);
                    jComponent.setBorder(UIManager.getBorder("PopupMenu.border"));
                    jPopupMenu.setBorder(null);
                    jScrollPane.setBorder(null);
                    final PopupScrollButton popupScrollButton = new PopupScrollButton(1, jScrollPane, jPopupMenu);
                    final PopupScrollButton popupScrollButton2 = new PopupScrollButton(5, jScrollPane, jPopupMenu);
                    jScrollPane.getViewport().addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            JViewport jViewport = (JViewport)changeEvent.getSource();
                            Point point = jViewport.getViewPosition();
                            popupScrollButton.setEnabled(point.y != 0);
                            popupScrollButton2.setEnabled(point.y + jViewport.getExtentSize().height < jViewport.getViewSize().height);
                        }
                    });
                    jComponent.add((Component)popupScrollButton, "North");
                    jComponent.add((Component)jScrollPane, "Center");
                    jComponent.add((Component)popupScrollButton2, "South");
                } else {
                    if (jPopupMenu.getBorder() == null) {
                        jPopupMenu.setBorder(UIManager.getBorder("PopupMenu.border"));
                    }
                    jComponent.setBorder(null);
                    jComponent.add(component2, "Center");
                }
            } else {
                jWindow.getContentPane().add(component2, "Center");
            }
            component2.invalidate();
            this.pack();
        }
    }

    void pack() {
        Component component = this.getComponent();
        if (component instanceof Window) {
            ((Window)component).pack();
        }
    }

    private Window getParentWindow(Component component) {
        Window window = null;
        if (component instanceof Window) {
            window = (Window)component;
        } else if (component != null) {
            window = SwingUtilities.getWindowAncestor(component);
        }
        if (window == null) {
            window = new DefaultFrame();
        }
        return window;
    }

    Component createComponent(Component component) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return new HeavyWeightWindow(this.getParentWindow(component));
    }

    Component getComponent() {
        return this.component;
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction("ibm.swing.longMenu");
        String string = AccessController.doPrivileged(getPropertyAction);
        longMenus = string != null;
    }

    static class DefaultFrame
    extends Frame {
        DefaultFrame() {
        }
    }

    static class HeavyWeightWindow
    extends JWindow {
        HeavyWeightWindow(Window window) {
            super(window);
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void show() {
            super.show();
            this.pack();
        }
    }

    private class PopupScrollButton
    extends JButton {
        private int direction;
        private JScrollPane scroller;
        private JComponent contents;
        private Color shadow = null;
        private Color darkShadow = null;
        private Color highlight = null;
        private Color background = null;

        public PopupScrollButton(int n, JScrollPane jScrollPane, JComponent jComponent) {
            this.direction = n;
            this.scroller = jScrollPane;
            this.contents = jComponent;
            this.shadow = UIManager.getColor("controlShadow");
            this.darkShadow = UIManager.getColor("menuText");
            this.highlight = UIManager.getColor("controlLtHighlight");
            if (this.shadow == null) {
                this.shadow = Color.GRAY;
            }
            if (this.darkShadow == null) {
                this.darkShadow = Color.BLACK;
            }
            if (this.highlight == null) {
                this.highlight = Color.WHITE;
            }
            this.background = UIManager.getColor("menu");
            if (this.background == null) {
                this.background = Color.LIGHT_GRAY;
            }
            this.setBackground(this.background);
            this.addMouseListener(new PopupScrollAction());
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            Color color = graphics.getColor();
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.isEnabled();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            if (bl) {
                graphics.setColor(this.shadow);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
            } else {
                graphics.setColor(this.highlight);
                graphics.drawLine(0, 0, 0, n2);
            }
            if (n2 < 5 || n < 5) {
                graphics.setColor(color);
                return;
            }
            if (bl) {
                graphics.translate(1, 1);
            }
            int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
            n3 = Math.max(n3, 2);
            this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, bl2);
            if (bl) {
                graphics.translate(-1, -1);
            }
            graphics.setColor(color);
        }

        public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            Color color = graphics.getColor();
            int n5 = 0;
            n3 = Math.max(n3, 2);
            int n6 = n3 / 2 - 1;
            graphics.translate(n, n2);
            if (bl) {
                graphics.setColor(this.darkShadow);
            } else {
                graphics.setColor(this.shadow);
            }
            switch (n4) {
                case 1: {
                    int n7;
                    for (n7 = 0; n7 < n3; ++n7) {
                        graphics.drawLine(n6 - n7, n7, n6 + n7, n7);
                    }
                    if (bl) break;
                    graphics.setColor(this.highlight);
                    graphics.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                    break;
                }
                case 5: {
                    int n8;
                    if (!bl) {
                        graphics.translate(1, 1);
                        graphics.setColor(this.highlight);
                        for (n8 = n3 - 1; n8 >= 0; --n8) {
                            graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                            ++n5;
                        }
                        graphics.translate(-1, -1);
                        graphics.setColor(this.shadow);
                    }
                    n5 = 0;
                    for (n8 = n3 - 1; n8 >= 0; --n8) {
                        graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                        ++n5;
                    }
                    break;
                }
                case 7: {
                    int n9;
                    for (n9 = 0; n9 < n3; ++n9) {
                        graphics.drawLine(n9, n6 - n9, n9, n6 + n9);
                    }
                    if (bl) break;
                    graphics.setColor(this.highlight);
                    graphics.drawLine(n9, n6 - n9 + 2, n9, n6 + n9);
                    break;
                }
                case 3: {
                    int n10;
                    if (!bl) {
                        graphics.translate(1, 1);
                        graphics.setColor(this.highlight);
                        for (n10 = n3 - 1; n10 >= 0; --n10) {
                            graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                            ++n5;
                        }
                        graphics.translate(-1, -1);
                        graphics.setColor(this.shadow);
                    }
                    n5 = 0;
                    for (n10 = n3 - 1; n10 >= 0; --n10) {
                        graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                        ++n5;
                    }
                    break;
                }
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        private class PopupScrollAction
        extends MouseAdapter {
            private final int intialDelay = 500;
            private final int delay = 100;
            private Timer timer;
            private ActionListener task;
            private Component button;

            private PopupScrollAction() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.button = (Component)mouseEvent.getSource();
                if (!this.button.isEnabled()) {
                    return;
                }
                this.scrollAction();
                if (this.task == null) {
                    this.task = new ActionListener(this){
                        private final /* synthetic */ PopupScrollAction this$2;
                        {
                            this.this$2 = popupScrollAction;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (PopupScrollAction.access$100(this.this$2).isEnabled()) {
                                PopupScrollAction.access$200(this.this$2);
                            } else {
                                PopupScrollAction.access$300(this.this$2).stop();
                            }
                        }
                    };
                }
                if (this.timer == null) {
                    this.timer = new Timer(100, this.task);
                    this.timer.setInitialDelay(500);
                    this.timer.start();
                } else {
                    this.timer.restart();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.timer != null) {
                    this.timer.stop();
                }
            }

            private void scrollAction() {
                JViewport jViewport = PopupScrollButton.this.scroller.getViewport();
                Point point = jViewport.getViewPosition();
                Component component = PopupScrollButton.this.contents.findComponentAt(point);
                if (component == null) {
                    return;
                }
                point.y = PopupScrollButton.this.direction == 1 ? --point.y : (point.y += component.getSize().height);
                Component component2 = PopupScrollButton.this.contents.findComponentAt(point);
                if (component2 != null) {
                    jViewport.setViewPosition(component2.getLocation());
                }
            }

            static /* synthetic */ Component access$100(PopupScrollAction popupScrollAction) {
                return popupScrollAction.button;
            }

            static /* synthetic */ void access$200(PopupScrollAction popupScrollAction) {
                popupScrollAction.scrollAction();
            }

            static /* synthetic */ Timer access$300(PopupScrollAction popupScrollAction) {
                return popupScrollAction.timer;
            }
        }
    }
}

