/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;
import sun.reflect.misc.MethodUtil;

public class TransferHandler
implements Serializable {
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private static final int LINK = 0x40000000;
    private String propertyName;
    private static SwingDragGestureRecognizer recognizer = null;
    private static DropTargetListener dropLinkage = null;
    static final Action cutAction = new TransferAction("cut");
    static final Action copyAction = new TransferAction("copy");
    static final Action pasteAction = new TransferAction("paste");
    static /* synthetic */ Class class$java$awt$dnd$DropTargetListener;

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public TransferHandler(String string) {
        this.propertyName = string;
    }

    protected TransferHandler() {
        this(null);
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        int n3 = n2 & n;
        if (!(inputEvent instanceof MouseEvent)) {
            n3 = 0;
        }
        if (n3 != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(jComponent, (MouseEvent)inputEvent, n2, n3);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        boolean bl = false;
        Transferable transferable = null;
        int n2 = this.getSourceActions(jComponent) & n;
        if (n2 != 0 && (transferable = this.createTransferable(jComponent)) != null) {
            clipboard.setContents(transferable, null);
            bl = true;
        }
        if (bl) {
            this.exportDone(jComponent, transferable, n2);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                try {
                    Object object = transferable.getTransferData(dataFlavor);
                    Object[] objectArray = new Object[]{object};
                    MethodUtil.invoke(method, jComponent, objectArray);
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Invocation failed");
                }
            }
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], dataFlavorArray);
            if (dataFlavor != null) {
                return true;
            }
        }
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return 1;
        }
        return 0;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return null;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return new PropertyTransferable(propertyDescriptor, jComponent);
        }
        return null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    private PropertyDescriptor getPropertyDescriptor(JComponent jComponent) {
        BeanInfo beanInfo;
        if (this.propertyName == null) {
            return null;
        }
        Class<?> clazz = jComponent.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Class<?>[] classArray;
            Method method;
            if (!this.propertyName.equals(propertyDescriptorArray[i].getName()) || (method = propertyDescriptorArray[i].getReadMethod()) == null || (classArray = method.getParameterTypes()) != null && classArray.length != 0) continue;
            return propertyDescriptorArray[i];
        }
        return null;
    }

    private DataFlavor getPropertyDataFlavor(Class clazz, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (!"application".equals(dataFlavor.getPrimaryType()) || !"x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) || !clazz.isAssignableFrom(dataFlavor.getRepresentationClass())) continue;
            return dataFlavor;
        }
        return null;
    }

    private static DropTargetListener getDropTargetListener() {
        if (dropLinkage == null) {
            dropLinkage = new DropHandler();
        }
        return dropLinkage;
    }

    static class TransferAction
    extends AbstractAction
    implements UIResource {
        private boolean canAccessSystemClipboard = true;
        private static Object SandboxClipboardKey = new Object();

        TransferAction(String string) {
            super(string);
            this.canAccessSystemClipboard();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                TransferHandler transferHandler = jComponent.getTransferHandler();
                Clipboard clipboard = this.getClipboard(jComponent);
                String string = (String)this.getValue("Name");
                if (clipboard != null && transferHandler != null && string != null) {
                    Transferable transferable;
                    if ("cut".equals(string)) {
                        transferHandler.exportToClipboard(jComponent, clipboard, 2);
                    } else if ("copy".equals(string)) {
                        transferHandler.exportToClipboard(jComponent, clipboard, 1);
                    } else if ("paste".equals(string) && (transferable = clipboard.getContents(null)) != null) {
                        transferHandler.importData(jComponent, transferable);
                    }
                }
            }
        }

        private Clipboard getClipboard(JComponent jComponent) {
            if (this.canAccessSystemClipboard()) {
                return jComponent.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Sandboxed Component Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }

        private boolean canAccessSystemClipboard() {
            if (this.canAccessSystemClipboard) {
                if (GraphicsEnvironment.isHeadless()) {
                    this.canAccessSystemClipboard = false;
                    return false;
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkSystemClipboardAccess();
                        return true;
                    }
                    catch (SecurityException securityException) {
                        this.canAccessSystemClipboard = false;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            Transferable transferable = transferHandler.createTransferable(jComponent);
            if (transferable != null) {
                this.scrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    dragGestureEvent.startDrag(null, transferable, this);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    jComponent.setAutoscrolls(this.scrolls);
                }
            }
            transferHandler.exportDone(jComponent, null, 0);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            if (dragSourceDropEvent.getDropSuccess()) {
                jComponent.getTransferHandler().exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                jComponent.getTransferHandler().exportDone(jComponent, null, 0);
            }
            jComponent.setAutoscrolls(this.scrolls);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class DropHandler
    implements DropTargetListener,
    Serializable {
        private boolean canImport;

        private DropHandler() {
        }

        private boolean actionSupported(int n) {
            return (n & 0x40000003) != 0;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            JComponent jComponent = (JComponent)dropTargetDragEvent.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            this.canImport = transferHandler != null && transferHandler.canImport(jComponent, dataFlavorArray);
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = dropTargetDropEvent.getDropAction();
            JComponent jComponent = (JComponent)dropTargetDropEvent.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            if (this.canImport && transferHandler != null && this.actionSupported(n)) {
                dropTargetDropEvent.acceptDrop(n);
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    dropTargetDropEvent.dropComplete(transferHandler.importData(jComponent, transferable));
                }
                catch (RuntimeException runtimeException) {
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    static class SwingDropTarget
    extends DropTarget
    implements UIResource {
        private EventListenerList listenerList;

        SwingDropTarget(JComponent jComponent) {
            this.setComponent(jComponent);
            try {
                super.addDropTargetListener(TransferHandler.getDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$java$awt$dnd$DropTargetListener == null ? (class$java$awt$dnd$DropTargetListener = TransferHandler.class$("java.awt.dnd.DropTargetListener")) : class$java$awt$dnd$DropTargetListener, dropTargetListener);
        }

        public void removeDropTargetListener(DropTargetListener dropTargetListener) {
            if (this.listenerList != null) {
                this.listenerList.remove(class$java$awt$dnd$DropTargetListener == null ? (class$java$awt$dnd$DropTargetListener = TransferHandler.class$("java.awt.dnd.DropTargetListener")) : class$java$awt$dnd$DropTargetListener, dropTargetListener);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            super.dragEnter(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) continue;
                    ((DropTargetListener)objectArray[i + 1]).dragEnter(dropTargetDragEvent);
                }
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            super.dragOver(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) continue;
                    ((DropTargetListener)objectArray[i + 1]).dragOver(dropTargetDragEvent);
                }
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            super.dragExit(dropTargetEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) continue;
                    ((DropTargetListener)objectArray[i + 1]).dragExit(dropTargetEvent);
                }
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) continue;
                    ((DropTargetListener)objectArray[i + 1]).drop(dropTargetDropEvent);
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            super.dropActionChanged(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) continue;
                    ((DropTargetListener)objectArray[i + 1]).dropActionChanged(dropTargetDragEvent);
                }
            }
        }
    }

    static class PropertyTransferable
    implements Transferable {
        JComponent component;
        PropertyDescriptor property;

        PropertyTransferable(PropertyDescriptor propertyDescriptor, JComponent jComponent) {
            this.property = propertyDescriptor;
            this.component = jComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Class<?> clazz = this.property.getPropertyType();
            String string = "application/x-java-jvm-local-objectref;class=" + clazz.getName();
            try {
                dataFlavorArray[0] = new DataFlavor(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Class<?> clazz = this.property.getPropertyType();
            return "application".equals(dataFlavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) && dataFlavor.getRepresentationClass().isAssignableFrom(clazz);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            Method method = this.property.getReadMethod();
            Object object = null;
            try {
                object = MethodUtil.invoke(method, this.component, null);
            }
            catch (Exception exception) {
                throw new IOException("Property read failed: " + this.property.getName());
            }
            return object;
        }
    }
}

