/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.SmartGridLayout;
import javax.swing.colorchooser.SyntheticImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener,
HierarchyListener {
    private HSBImage palette;
    private HSBImage sliderPalette;
    private Image paletteImage;
    private Image sliderPaletteImage;
    private JSlider slider;
    private JSpinner hField;
    private JSpinner sField;
    private JSpinner bField;
    private JTextField redField;
    private JTextField greenField;
    private JTextField blueField;
    private boolean isAdjusting = false;
    private Point paletteSelection = new Point();
    private JLabel paletteLabel;
    private JLabel sliderPaletteLabel;
    private JRadioButton hRadio;
    private JRadioButton sRadio;
    private JRadioButton bRadio;
    private float[] HSB = new float[3];
    private static final int PALETTE_DIMENSION = 200;
    private static final int MAX_HUE_VALUE = 359;
    private static final int MAX_SATURATION_VALUE = 100;
    private static final int MAX_BRIGHTNESS_VALUE = 100;
    private int currentMode = 0;
    private static final int HUE_MODE = 0;
    private static final int SATURATION_MODE = 1;
    private static final int BRIGHTNESS_MODE = 2;
    private boolean palettesInitialized = false;

    private void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                float[] fArray = new float[3];
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(mouseEvent.getX(), mouseEvent.getY(), fArray);
                DefaultHSBChooserPanel.this.updateHSB(fArray[0], fArray[1], fArray[2]);
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = DefaultHSBChooserPanel.this.paletteLabel.getWidth();
                int n2 = DefaultHSBChooserPanel.this.paletteLabel.getHeight();
                int n3 = mouseEvent.getX();
                int n4 = mouseEvent.getY();
                n3 = Math.min(n3, n);
                n4 = Math.min(n4, n2);
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                float[] fArray = new float[3];
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(n3, n4, fArray);
                DefaultHSBChooserPanel.this.updateHSB(fArray[0], fArray[1], fArray[2]);
            }
        });
    }

    private void updatePalette(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        switch (this.currentMode) {
            case 0: {
                if (f != this.palette.getHue()) {
                    this.palette.setHue(f);
                    this.palette.nextFrame();
                }
                n = 200 - (int)(f2 * 200.0f);
                n2 = 200 - (int)(f3 * 200.0f);
                break;
            }
            case 1: {
                if (f2 != this.palette.getSaturation()) {
                    this.palette.setSaturation(f2);
                    this.palette.nextFrame();
                }
                n = (int)(f * 200.0f);
                n2 = 200 - (int)(f3 * 200.0f);
                break;
            }
            case 2: {
                if (f3 != this.palette.getBrightness()) {
                    this.palette.setBrightness(f3);
                    this.palette.nextFrame();
                }
                n = (int)(f * 200.0f);
                n2 = 200 - (int)(f2 * 200.0f);
            }
        }
        this.paletteSelection.setLocation(n, n2);
        this.paletteLabel.repaint();
    }

    private void updateSlider(float f, float f2, float f3) {
        if (this.currentMode != 0 && f != this.sliderPalette.getHue()) {
            this.sliderPalette.setHue(f);
            this.sliderPalette.nextFrame();
        }
        float f4 = 0.0f;
        switch (this.currentMode) {
            case 0: {
                f4 = f;
                break;
            }
            case 1: {
                f4 = f2;
                break;
            }
            case 2: {
                f4 = f3;
            }
        }
        this.slider.setValue(Math.round(f4 * (float)this.slider.getMaximum()));
    }

    private void updateHSBTextFields(float f, float f2, float f3) {
        int n = Math.round(f * 359.0f);
        int n2 = Math.round(f2 * 100.0f);
        int n3 = Math.round(f3 * 100.0f);
        if ((Integer)this.hField.getValue() != n) {
            this.hField.setValue(new Integer(n));
        }
        if ((Integer)this.sField.getValue() != n2) {
            this.sField.setValue(new Integer(n2));
        }
        if ((Integer)this.bField.getValue() != n3) {
            this.bField.setValue(new Integer(n3));
        }
    }

    private void updateRGBTextFields(Color color) {
        this.redField.setText(String.valueOf(color.getRed()));
        this.greenField.setText(String.valueOf(color.getGreen()));
        this.blueField.setText(String.valueOf(color.getBlue()));
    }

    private void updateHSB(float f, float f2, float f3) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.updatePalette(f, f2, f3);
            this.updateSlider(f, f2, f3);
            this.updateHSBTextFields(f, f2, f3);
            Color color = Color.getHSBColor(f, f2, f3);
            this.updateRGBTextFields(color);
            this.getColorSelectionModel().setSelectedColor(color);
            this.HSB[0] = f;
            this.HSB[1] = f2;
            this.HSB[2] = f3;
            this.isAdjusting = false;
        }
    }

    public void updateChooser() {
        if (!this.isAdjusting) {
            float[] fArray = this.getHSBColorFromModel();
            this.updateHSB(fArray[0], fArray[1], fArray[2]);
        }
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
        this.addHierarchyListener(this);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.cleanupPalettesIfNecessary();
        this.removeAll();
        this.removeHierarchyListener(this);
    }

    private float[] getHSBColorFromModel() {
        Color color = this.getColorFromModel();
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray;
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        JComponent jComponent = this.buildSliderPalettePanel();
        this.add((Component)jComponent, "Before");
        JPanel jPanel = new JPanel(new SmartGridLayout(1, 3));
        JComponent jComponent2 = this.buildHSBControls();
        jPanel.add(jComponent2);
        jPanel.add(new JLabel(" "));
        JComponent jComponent3 = this.buildRGBControls();
        jPanel.add(jComponent3);
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)jPanel, "Center");
    }

    private JComponent buildRGBControls() {
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        Color color = this.getColorFromModel();
        this.redField = new JTextField(String.valueOf(color.getRed()), 3);
        this.redField.setEditable(false);
        this.redField.setHorizontalAlignment(4);
        this.greenField = new JTextField(String.valueOf(color.getGreen()), 3);
        this.greenField.setEditable(false);
        this.greenField.setHorizontalAlignment(4);
        this.blueField = new JTextField(String.valueOf(color.getBlue()), 3);
        this.blueField.setEditable(false);
        this.blueField.setHorizontalAlignment(4);
        String string = UIManager.getString("ColorChooser.hsbRedText");
        String string2 = UIManager.getString("ColorChooser.hsbGreenText");
        String string3 = UIManager.getString("ColorChooser.hsbBlueText");
        this.redField.getAccessibleContext().setAccessibleName(string);
        this.greenField.getAccessibleContext().setAccessibleName(string2);
        this.blueField.getAccessibleContext().setAccessibleName(string3);
        jPanel.add(new JLabel(string));
        jPanel.add(this.redField);
        jPanel.add(new JLabel(string2));
        jPanel.add(this.greenField);
        jPanel.add(new JLabel(string3));
        jPanel.add(this.blueField);
        return jPanel;
    }

    private JComponent buildHSBControls() {
        String string = UIManager.getString("ColorChooser.hsbHueText");
        String string2 = UIManager.getString("ColorChooser.hsbSaturationText");
        String string3 = UIManager.getString("ColorChooser.hsbBrightnessText");
        RadioButtonHandler radioButtonHandler = new RadioButtonHandler();
        this.hRadio = new JRadioButton(string);
        this.hRadio.addActionListener(radioButtonHandler);
        this.hRadio.setSelected(true);
        this.sRadio = new JRadioButton(string2);
        this.sRadio.addActionListener(radioButtonHandler);
        this.bRadio = new JRadioButton(string3);
        this.bRadio.addActionListener(radioButtonHandler);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hRadio);
        buttonGroup.add(this.sRadio);
        buttonGroup.add(this.bRadio);
        float[] fArray = this.getHSBColorFromModel();
        this.hField = new JSpinner(new SpinnerNumberModel((int)(fArray[0] * 359.0f), 0, 359, 1));
        this.sField = new JSpinner(new SpinnerNumberModel((int)(fArray[1] * 100.0f), 0, 100, 1));
        this.bField = new JSpinner(new SpinnerNumberModel((int)(fArray[2] * 100.0f), 0, 100, 1));
        this.hField.getAccessibleContext().setAccessibleName(string);
        this.sField.getAccessibleContext().setAccessibleName(string2);
        this.bField.getAccessibleContext().setAccessibleName(string3);
        this.hField.addChangeListener(this);
        this.sField.addChangeListener(this);
        this.bField.addChangeListener(this);
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        jPanel.add(this.hRadio);
        jPanel.add(this.hField);
        jPanel.add(this.sRadio);
        jPanel.add(this.sField);
        jPanel.add(this.bRadio);
        jPanel.add(this.bField);
        return jPanel;
    }

    private void setMode(int n) {
        if (this.currentMode == n) {
            return;
        }
        this.isAdjusting = true;
        this.currentMode = n;
        switch (this.currentMode) {
            case 0: {
                this.slider.setInverted(true);
                this.slider.setMaximum(359);
                this.palette.setValues(0, this.HSB[0], 1.0f, 1.0f);
                this.sliderPalette.setValues(3, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.slider.setInverted(false);
                this.slider.setMaximum(100);
                this.palette.setValues(1, this.HSB[0], this.HSB[1], 1.0f);
                this.sliderPalette.setValues(4, this.HSB[0], 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.slider.setInverted(false);
                this.slider.setMaximum(100);
                this.palette.setValues(2, this.HSB[0], 1.0f, this.HSB[2]);
                this.sliderPalette.setValues(5, this.HSB[0], 1.0f, 1.0f);
            }
        }
        this.isAdjusting = false;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
    }

    protected JComponent buildSliderPalettePanel() {
        this.slider = new JSlider(1, 0, 359, 0);
        this.slider.setInverted(true);
        this.slider.setPaintTrack(false);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, 215));
        this.slider.addChangeListener(this);
        this.paletteLabel = this.createPaletteLabel();
        this.addPaletteListeners();
        this.sliderPaletteLabel = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.add(this.paletteLabel);
        jPanel.add(this.slider);
        jPanel.add(this.sliderPaletteLabel);
        this.initializePalettesIfNecessary();
        return jPanel;
    }

    private void initializePalettesIfNecessary() {
        if (this.palette != null) {
            return;
        }
        this.palettesInitialized = false;
        float[] fArray = this.getHSBColorFromModel();
        switch (this.currentMode) {
            case 0: {
                this.palette = new HSBImage(0, 200, 200, fArray[0], 1.0f, 1.0f);
                this.sliderPalette = new HSBImage(3, 16, 200, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.palette = new HSBImage(1, 200, 200, 1.0f, fArray[1], 1.0f);
                this.sliderPalette = new HSBImage(4, 16, 200, 1.0f, 0.0f, 1.0f);
                break;
            }
            case 2: {
                this.palette = new HSBImage(2, 200, 200, 1.0f, 1.0f, fArray[2]);
                this.sliderPalette = new HSBImage(5, 16, 200, 1.0f, 1.0f, 0.0f);
            }
        }
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderPaletteImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderPaletteImage));
        this.palettesInitialized = true;
    }

    private void cleanupPalettesIfNecessary() {
        if (this.palette == null) {
            return;
        }
        this.palette.aborted = true;
        this.sliderPalette.aborted = true;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.palette = null;
        this.sliderPalette = null;
        this.paletteImage = null;
        this.sliderPaletteImage = null;
        this.paletteLabel.setIcon(null);
        this.sliderPaletteLabel.setIcon(null);
    }

    protected JLabel createPaletteLabel() {
        return new JLabel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setColor(Color.white);
                graphics.drawOval(((DefaultHSBChooserPanel)DefaultHSBChooserPanel.this).paletteSelection.x - 4, ((DefaultHSBChooserPanel)DefaultHSBChooserPanel.this).paletteSelection.y - 4, 8, 8);
            }
        };
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.hsbNameText");
    }

    public int getMnemonic() {
        return DefaultHSBChooserPanel.getInt("ColorChooser.hsbMnemonic", -1);
    }

    public int getDisplayedMnemonicIndex() {
        return DefaultHSBChooserPanel.getInt("ColorChooser.hsbDisplayedMnemonicIndex", -1);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.slider) {
            boolean bl = this.slider.getModel().getValueIsAdjusting();
            if (!bl && !this.isAdjusting) {
                int n = this.slider.getValue();
                int n2 = this.slider.getMaximum();
                float f = (float)n / (float)n2;
                switch (this.currentMode) {
                    case 0: {
                        this.updateHSB(f, this.HSB[1], this.HSB[2]);
                        break;
                    }
                    case 1: {
                        this.updateHSB(this.HSB[0], f, this.HSB[2]);
                        break;
                    }
                    case 2: {
                        this.updateHSB(this.HSB[0], this.HSB[1], f);
                    }
                }
            }
        } else if (changeEvent.getSource() instanceof JSpinner) {
            float f = ((Integer)this.hField.getValue()).floatValue() / 359.0f;
            float f2 = ((Integer)this.sField.getValue()).floatValue() / 100.0f;
            float f3 = ((Integer)this.bField.getValue()).floatValue() / 100.0f;
            this.updateHSB(f, f2, f3);
        }
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 2L) != 0L) {
            if (this.isDisplayable()) {
                this.initializePalettesIfNecessary();
            } else {
                this.cleanupPalettesIfNecessary();
            }
        }
    }

    class HSBImage
    extends SyntheticImage {
        protected float h;
        protected float s;
        protected float b;
        protected float[] hsb;
        protected boolean isDirty;
        protected int cachedY;
        protected int cachedColor;
        protected int type;
        private static final int HSQUARE = 0;
        private static final int SSQUARE = 1;
        private static final int BSQUARE = 2;
        private static final int HSLIDER = 3;
        private static final int SSLIDER = 4;
        private static final int BSLIDER = 5;

        protected HSBImage(int n, int n2, int n3, float f, float f2, float f3) {
            super(n2, n3);
            this.h = 0.0f;
            this.s = 0.0f;
            this.b = 0.0f;
            this.hsb = new float[3];
            this.isDirty = true;
            this.setValues(n, f, f2, f3);
        }

        public void setValues(int n, float f, float f2, float f3) {
            this.type = n;
            this.cachedY = -1;
            this.cachedColor = 0;
            this.setHue(f);
            this.setSaturation(f2);
            this.setBrightness(f3);
        }

        public final void setHue(float f) {
            this.h = f;
        }

        public final void setSaturation(float f) {
            this.s = f;
        }

        public final void setBrightness(float f) {
            this.b = f;
        }

        public final float getHue() {
            return this.h;
        }

        public final float getSaturation() {
            return this.s;
        }

        public final float getBrightness() {
            return this.b;
        }

        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame() {
            this.isDirty = true;
            this.notifyAll();
        }

        public synchronized void addConsumer(ImageConsumer imageConsumer) {
            this.isDirty = true;
            super.addConsumer(imageConsumer);
        }

        private int getRGBForLocation(int n, int n2) {
            if (this.type >= 3 && n2 == this.cachedY) {
                return this.cachedColor;
            }
            this.getHSBForLocation(n, n2, this.hsb);
            this.cachedY = n2;
            this.cachedColor = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
            return this.cachedColor;
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            switch (this.type) {
                case 0: {
                    float f = (float)n / (float)this.width;
                    float f2 = (float)n2 / (float)this.height;
                    fArray[0] = this.h;
                    fArray[1] = this.s - f;
                    fArray[2] = this.b - f2;
                    break;
                }
                case 1: {
                    float f = (float)n2 / (float)this.height;
                    float f3 = 1.0f / (float)this.width;
                    fArray[0] = (float)n * f3;
                    fArray[1] = this.s;
                    fArray[2] = 1.0f - f;
                    break;
                }
                case 2: {
                    float f = (float)n2 / (float)this.height;
                    float f4 = 1.0f / (float)this.width;
                    fArray[0] = (float)n * f4;
                    fArray[1] = 1.0f - f;
                    fArray[2] = this.b;
                    break;
                }
                case 3: {
                    float f = 1.0f / (float)this.height;
                    fArray[0] = (float)n2 * f;
                    fArray[1] = this.s;
                    fArray[2] = this.b;
                    break;
                }
                case 4: {
                    float f = (float)n2 / (float)this.height;
                    fArray[0] = this.h;
                    fArray[1] = this.s - f;
                    fArray[2] = this.b;
                    break;
                }
                case 5: {
                    float f = (float)n2 / (float)this.height;
                    fArray[0] = this.h;
                    fArray[1] = this.s;
                    fArray[2] = this.b - f;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeRow(int n, int[] nArray) {
            if (n == 0) {
                HSBImage hSBImage = this;
                synchronized (hSBImage) {
                    try {
                        while (!this.isDirty && DefaultHSBChooserPanel.this.palettesInitialized) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isDirty = false;
                }
            }
            if (this.aborted) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.getRGBForLocation(i, n);
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                JRadioButton jRadioButton = (JRadioButton)object;
                if (jRadioButton == DefaultHSBChooserPanel.this.hRadio) {
                    DefaultHSBChooserPanel.this.setMode(0);
                } else if (jRadioButton == DefaultHSBChooserPanel.this.sRadio) {
                    DefaultHSBChooserPanel.this.setMode(1);
                } else if (jRadioButton == DefaultHSBChooserPanel.this.bRadio) {
                    DefaultHSBChooserPanel.this.setMode(2);
                }
            }
        }
    }
}

