/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.ibm.swing.IconUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import sun.awt.AppContext;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    private static final Object FRAMES_CACHE_KEY = new StringBuffer("BASIC_DESKTOP_PANE_UI.FRAMES_CACHE");
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    Vector framesCache = BasicDesktopPaneUI.getCurrentFramesCache();
    private NavigateAction nextAction;
    private boolean moving = false;
    private boolean resizing = false;
    private final int MOVE_RESIZE_INCREMENT = 10;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
            IconUtilities iconUtilities = new IconUtilities();
            iconUtilities.adjustIcons(this.desktop);
        }
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.desktop, actionMap);
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    InputMap getInputMap(int n) {
        if (n == 2) {
            return this.createInputMap(n);
        }
        if (n == 1) {
            return (InputMap)UIManager.get("Desktop.ancestorInputMap");
        }
        return null;
    }

    InputMap createInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("restore", new OpenAction());
        actionMapUIResource.put("close", new CloseAction());
        actionMapUIResource.put("toggleOpenOrClose", new ToggleOpenOrCloseAction());
        actionMapUIResource.put("move", new MoveResizeAction("move"));
        actionMapUIResource.put("resize", new MoveResizeAction("resize"));
        actionMapUIResource.put("left", new MoveResizeAction("left"));
        actionMapUIResource.put("shrinkLeft", new MoveResizeAction("shrinkLeft"));
        actionMapUIResource.put("right", new MoveResizeAction("right"));
        actionMapUIResource.put("shrinkRight", new MoveResizeAction("shrinkRight"));
        actionMapUIResource.put("up", new MoveResizeAction("up"));
        actionMapUIResource.put("shrinkUp", new MoveResizeAction("shrinkUp"));
        actionMapUIResource.put("down", new MoveResizeAction("down"));
        actionMapUIResource.put("shrinkDown", new MoveResizeAction("shrinkDown"));
        actionMapUIResource.put("escape", new MoveResizeAction("escape"));
        actionMapUIResource.put("minimize", new MinimizeAction());
        actionMapUIResource.put("maximize", new MaximizeAction());
        this.nextAction = new NavigateAction();
        actionMapUIResource.put("selectNextFrame", this.nextAction);
        actionMapUIResource.put("selectPreviousFrame", new PreviousAction());
        actionMapUIResource.put("navigateNext", new NavigateOutAction(true));
        actionMapUIResource.put("navigatePrevious", new NavigateOutAction(false));
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    private void verifyFramesCache() {
        Vector vector = BasicDesktopPaneUI.getCurrentFramesCache();
        boolean bl = false;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JInternalFrame jInternalFrame;
            JComponent jComponent;
            JComponent jComponent2 = (JComponent)vector.elementAt(i);
            if (jComponent2 instanceof JInternalFrame) {
                jComponent = (JInternalFrame)jComponent2;
                if (!((JInternalFrame)jComponent).isClosed()) continue;
                bl = true;
                break;
            }
            if (!(jComponent2 instanceof JInternalFrame.JDesktopIcon) || !(jInternalFrame = ((JInternalFrame.JDesktopIcon)(jComponent = (JInternalFrame.JDesktopIcon)jComponent2)).getInternalFrame()).isClosed()) continue;
            bl = true;
            break;
        }
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        if (bl || jInternalFrameArray.length != vector.size()) {
            int n2;
            vector.clear();
            int n3 = this.desktop.lowestLayer();
            for (int i = n2 = this.desktop.highestLayer(); i >= n3; --i) {
                Component[] componentArray = this.desktop.getComponentsInLayer(i);
                if (componentArray.length <= 0) continue;
                for (int j = 0; j < componentArray.length; ++j) {
                    vector.addElement(componentArray[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getCurrentFramesCache() {
        Class clazz = BasicDesktopPaneUI.class;
        synchronized (clazz) {
            AppContext appContext = AppContext.getAppContext();
            Vector vector = (Vector)appContext.get(FRAMES_CACHE_KEY);
            if (vector == null) {
                vector = new Vector();
                appContext.put(FRAMES_CACHE_KEY, vector);
            }
            return vector;
        }
    }

    private class NavigateOutAction
    extends AbstractAction {
        private boolean moveForward;

        public NavigateOutAction(boolean bl) {
            this.moveForward = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy;
            Container container = BasicDesktopPaneUI.this.desktop.getFocusCycleRootAncestor();
            if (container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && focusTraversalPolicy instanceof SortingFocusTraversalPolicy) {
                SortingFocusTraversalPolicy sortingFocusTraversalPolicy = (SortingFocusTraversalPolicy)focusTraversalPolicy;
                boolean bl = sortingFocusTraversalPolicy.getImplicitDownCycleTraversal();
                try {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(false);
                    if (this.moveForward) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(BasicDesktopPaneUI.this.desktop);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(BasicDesktopPaneUI.this.desktop);
                    }
                }
                finally {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n = 0;
            BasicDesktopPaneUI.this.verifyFramesCache();
            if (BasicDesktopPaneUI.this.framesCache.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n = BasicDesktopPaneUI.this.framesCache.indexOf(jInternalFrame);
            }
            if (n == -1 && (n = BasicDesktopPaneUI.this.framesCache.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (--n == -1) {
                n = BasicDesktopPaneUI.this.framesCache.size() - 1;
            }
            if ((jComponent = (JComponent)BasicDesktopPaneUI.this.framesCache.elementAt(n)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n = 0;
            BasicDesktopPaneUI.this.verifyFramesCache();
            if (BasicDesktopPaneUI.this.framesCache.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n = BasicDesktopPaneUI.this.framesCache.indexOf(jInternalFrame);
            }
            if (n == -1 && (n = BasicDesktopPaneUI.this.framesCache.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (++n == BasicDesktopPaneUI.this.framesCache.size()) {
                n = 0;
            }
            if ((jComponent = (JComponent)BasicDesktopPaneUI.this.framesCache.elementAt(n)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame((JInternalFrame)jComponent);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isMaximizable() && !jInternalFrame.isMaximum()) {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isIconifiable() && !jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class MoveResizeAction
    extends AbstractAction {
        private String command;

        public MoveResizeAction(String string) {
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if ("move".equals(this.command) || "resize".equals(this.command) || "escape".equals(this.command)) {
                int n = BasicDesktopPaneUI.this.desktop.getComponentCount();
                object = BasicDesktopPaneUI.this.desktop.getComponents();
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    JInternalFrame jInternalFrame2;
                    Container container;
                    if (!(object[i] instanceof JInternalFrame) || !((container = (jInternalFrame2 = (JInternalFrame)object[i]).getContentPane()) instanceof JScrollPane)) continue;
                    JScrollPane jScrollPane = (JScrollPane)container;
                    if (jScrollPane.getUI() instanceof BasicScrollPaneUI) {
                        object2 = (BasicScrollPaneUI)jScrollPane.getUI();
                        if ("move".equals(this.command) || "resize".equals(this.command)) {
                            ((BasicScrollPaneUI)object2).uninstallKeyboardActions(jScrollPane);
                        } else if ("escape".equals(this.command) && (BasicDesktopPaneUI.this.moving || BasicDesktopPaneUI.this.resizing)) {
                            ((BasicScrollPaneUI)object2).installKeyboardActions(jScrollPane);
                        }
                    }
                    object2 = jScrollPane.getHorizontalScrollBar();
                    for (int j = 0; j < 2; ++j) {
                        if (object2 != null && ((JScrollBar)object2).getUI() instanceof BasicScrollBarUI) {
                            BasicScrollBarUI basicScrollBarUI = (BasicScrollBarUI)((JScrollBar)object2).getUI();
                            if ("move".equals(this.command) || "resize".equals(this.command)) {
                                basicScrollBarUI.uninstallKeyboardActions();
                            } else if ("escape".equals(this.command) && (BasicDesktopPaneUI.this.moving || BasicDesktopPaneUI.this.resizing)) {
                                basicScrollBarUI.installKeyboardActions();
                            }
                        }
                        object2 = jScrollPane.getVerticalScrollBar();
                    }
                }
            }
            if ("move".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = true;
                BasicDesktopPaneUI.this.resizing = false;
                return;
            }
            if ("resize".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = false;
                BasicDesktopPaneUI.this.resizing = true;
                return;
            }
            if ("escape".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = (BasicDesktopPaneUI.this.resizing = false);
                return;
            }
            if (!BasicDesktopPaneUI.this.moving && !BasicDesktopPaneUI.this.resizing) {
                return;
            }
            Dimension dimension = jInternalFrame.getSize();
            object = jInternalFrame.getMinimumSize();
            Point point = jInternalFrame.getLocation();
            boolean bl = jInternalFrame.isResizable() & BasicDesktopPaneUI.this.resizing;
            if ("left".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                } else if (bl) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("right".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                } else if (bl) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("up".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                } else if (bl) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("down".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                } else if (bl) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("shrinkLeft".equals(this.command) && bl) {
                if (object.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setSize(object.width, dimension.height);
                }
            } else if ("shrinkRight".equals(this.command) && bl) {
                if (object.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setLocation(point.x - object.width + dimension.width, point.y);
                    jInternalFrame.setSize(object.width, dimension.height);
                }
            } else if ("shrinkUp".equals(this.command) && bl) {
                if (object.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setSize(dimension.width, object.height);
                }
            } else if ("shrinkDown".equals(this.command) && bl) {
                if (object.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setLocation(point.x, point.y - object.height + dimension.height);
                    jInternalFrame.setSize(dimension.width, object.height);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class ToggleOpenOrCloseAction
    extends AbstractAction {
        private ToggleOpenOrCloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(false);
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (jInternalFrame.isClosable()) {
                jInternalFrame.doDefaultCloseAction();
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isClosable()) {
                jInternalFrame.doDefaultCloseAction();
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            try {
                if (jInternalFrame.isIcon()) {
                    jInternalFrame.setIcon(false);
                } else if (jInternalFrame.isMaximum()) {
                    jInternalFrame.setMaximum(false);
                }
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

